/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.plugin.KubeRecoveryPlanPluginUtil;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.KubeCdrReplicationReverseMonitorProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.KubeCdrRoleReverseMonitorProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.KubeReverseMonitorProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class KubeRefactorCdrRelationProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = 9054162079585173929L;
    private static final Log LOGGER = LogFactory.getInstance(KubeRefactorCdrRelationProcessor.class);
    private static final String LISTEN_RE_PROTECT_JOB_WAIT_CONFIG = "kube.reprotect.job.max.wait";
    private static final long LISTEN_RE_PROTECT_JOB_WAIT = LegoBaseConfig.getInstance().getNumberWithMaxValue("kube.reprotect.job.max.wait", 5L, 30L);
    private boolean isProduct;
    private String jobName;

    @Override
    public boolean isProduct() {
        return this.isProduct;
    }

    public void setProduct(boolean isProduct) {
        this.isProduct = isProduct;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        super.updateProcessorData(oldProcess, newProcess);
        if (oldProcess instanceof KubeRefactorCdrRelationProcessor && newProcess instanceof KubeRefactorCdrRelationProcessor) {
            KubeRefactorCdrRelationProcessor oldProcessor = (KubeRefactorCdrRelationProcessor)oldProcess;
            KubeRefactorCdrRelationProcessor newProcessor = (KubeRefactorCdrRelationProcessor)newProcess;
            newProcessor.setJobName(oldProcessor.getJobName());
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isRefractSucceed = this.checkIfRefractSucceed();
        if (!isRefractSucceed) {
            LOGGER.info((Object)"Start Creating ProtectionJob, current processor has not executed successfully or never executed");
            if (!this.createReprotectionJob()) {
                return this.failure("ism.drm.recovery.k8s.reprotect.job.state.error", new String[]{this.jobName});
            }
        } else {
            LOGGER.info((Object)"Skip creating ProtectionJob, cause current processor has executed successfully");
        }
        ArrayList<BaseRecoveryProcessor> processors = new ArrayList<BaseRecoveryProcessor>();
        Consumer<KubeReverseMonitorProcessor> initializer = processor -> {
            String site = this.isProduct() ? "source" : "target";
            processor.setProcName(processor.getName() + "." + site);
            processor.setJobName(this.jobName);
            processor.setProduct(this.isProduct());
        };
        processors.add(this.createSubProcessor(KubeCdrReplicationReverseMonitorProcessor::new, initializer));
        processors.add(this.createSubProcessor(KubeCdrRoleReverseMonitorProcessor::new, initializer));
        this.saveSubProcessors(processors);
        boolean isSuccess = this.invoke(context);
        if (!isSuccess) {
            return this.failure();
        }
        if (isRefractSucceed) {
            return this.success();
        }
        KubeReverseMonitorProcessor processor2 = new KubeReverseMonitorProcessor();
        processor2.setStage("Finished");
        processor2.setIsNeedCreateDetail(false);
        processor2.setContextRef(context);
        initializer.accept(processor2);
        if (processor2.execute(context)) {
            return this.success();
        }
        return this.failure();
    }

    private boolean createReprotectionJob() {
        block3: {
            IKubeHandler kubeHandler = KubeRefactorCdrRelationProcessor.getKubeHandler();
            String cdrRecoveryPlanName = KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(this.getRecoveryPlan());
            String kubeSn = this.getDevSn();
            AtomicBoolean retry = new AtomicBoolean();
            while (true) {
                Optional<String> state;
                if (this.jobName == null) {
                    this.jobName = kubeHandler.createReprotectionJob(kubeSn, cdrRecoveryPlanName);
                }
                if (!(state = this.getReprotectionJobState(kubeHandler, kubeSn, this.jobName)).isPresent()) {
                    LOGGER.error((Object)"Query reProtection Job state failed, kubeSn: %s, jobName: %s.", new Object[]{kubeSn, this.jobName});
                    return false;
                }
                if (!"Failed".equals(state.get())) break block3;
                if (!retry.compareAndSet(false, true)) break;
                LOGGER.error((Object)"ReProtection Job executed failed, kubeSn: %s, jobName: %s, try again.", new Object[]{kubeSn, this.jobName});
                this.jobName = null;
            }
            LOGGER.error((Object)"ReProtection Job executed failed, kubeSn: %s, jobName: %s, exited.", new Object[]{kubeSn, this.jobName});
            return false;
        }
        return true;
    }

    private Optional<String> getReprotectionJobState(IKubeHandler kubeHandler, String kubeSn, String job) {
        long startTime = System.currentTimeMillis();
        String[] progress;
        while ((progress = kubeHandler.queryReprotectionJobProgress(kubeSn, job, null)) == null || progress[1] == null) {
            if (System.currentTimeMillis() - startTime > TimeUnit.MINUTES.toMillis(LISTEN_RE_PROTECT_JOB_WAIT)) {
                return Optional.empty();
            }
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        return Optional.of(progress[1]);
    }

    @Override
    protected List<Object> hashData() {
        List<Object> data = super.hashData();
        data.add(this.isProduct);
        return data;
    }
}

