/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.service.impl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.kube.discovery.process.RefreshKubernetesTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.HookBO;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.task.CreateResourceSetTask;
import com.huawei.ism.drm.kube.service.impl.task.RefreshResourceSetTask;
import com.huawei.ism.drm.kube.utils.KubeProviderUtil;
import com.huawei.ism.drm.kube.utils.KubeResourceUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

@Service(name="com.huawei.ism.drm.kube.service.IKubeService", desc="", interfaceClass=IKubeService.class)
public class KubeServiceImpl
extends BaseService
implements IKubeService {
    public static final Set<String> NOT_SUPPORT_NS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("xuanwu");
            this.add("kube-system");
        }
    });
    private static final Log LOGGER = LogFactory.getInstance(KubeServiceImpl.class);
    private static final int RETRY_TIMES = 5;
    private static final long DURATION = 1L;

    private IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getBundleService((String)"DRM-HW-CDR", (String)IKubeHandler.class.getName(), IKubeHandler.class);
    }

    public void saveKube(Kubernetes kubernetes) {
        LOGGER.info((Object)"[kubernetes]Save kubernetes start.");
        CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)kubernetes);
    }

    public boolean updateKube(String id, String config, String userName, String clusterName) {
        LOGGER.info((Object)"[kubernetes]Modify kubernetes start. resourceId: %s", new Object[]{id});
        Kubernetes kubernetes = this.getKubeById(id);
        if (VerifyUtil.isEmpty((Object)kubernetes)) {
            LOGGER.error((Object)"[kubernetes]Modify kubernetes error, cause target resource is not exist. resourceId: %s", new Object[]{id});
            return false;
        }
        kubernetes.setConfig(config);
        kubernetes.setName(clusterName);
        kubernetes.setUserName(userName);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)kubernetes);
        this.getKubeHandler().invalidCache();
        return true;
    }

    public Kubernetes getKubeById(String id) {
        return (Kubernetes)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Kubernetes.class, (Serializable)((Object)id));
    }

    public void updateKubeStatus(String id, int status) {
        LOGGER.info((Object)"[kubernetes]Modify kubernetes status start. resourceId: %s, new status: %s", new Object[]{id, status});
        Kubernetes kubernetes = this.getKubeById(id);
        if (VerifyUtil.isEmpty((Object)kubernetes)) {
            LOGGER.error((Object)"[kubernetes]Modify kubernetes status error, cause target resource is not exist. resourceId: %s", new Object[]{id});
            return;
        }
        kubernetes.setStatus(String.valueOf(status));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)kubernetes);
    }

    public void batchSaveOrUpdateResourceSet(List<ResourceSetInfo> resourceSets) {
        if (VerifyUtil.isEmpty(resourceSets)) {
            LOGGER.warn((Object)"[kubernetes]Batch save or update resource set canceled, cause targets are empty");
            return;
        }
        for (ResourceSetInfo resourceSet : resourceSets) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)resourceSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateResourceSet(ResourceSetInfo resourceSet) {
        if (VerifyUtil.isEmpty((Object)resourceSet)) {
            LOGGER.warn((Object)"[kubernetes]Save or update resource set canceled, cause resource set is empty.");
            return;
        }
        LOGGER.info((Object)"[kubernetes]Update or save resource set:%s, kube:%s", new Object[]{resourceSet.getName(), resourceSet.getKubeId()});
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)resourceSet);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Save or update resource set failed.", (long)-1L, (String[])new String[0], (Log)LOGGER);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public void batchSaveOrUpdateKubeStorage(List<KubeStorage> storages) {
        if (VerifyUtil.isEmpty(storages)) {
            LOGGER.warn((Object)"[kubernetes]Batch save or update kubernetes storages canceled, cause targets are empty");
            return;
        }
        for (KubeStorage storage : storages) {
            if (this.isErrorStorageBackend(storage)) {
                LOGGER.error((Object)"The storage is illegal, continue. name: %s", new Object[]{storage.getName()});
                continue;
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)storage);
        }
    }

    private boolean isErrorStorageBackend(KubeStorage storage) {
        if ("Pending".equals(storage.getStatus())) {
            LOGGER.error((Object)"Status is Pending.");
            return true;
        }
        if (VerifyUtil.isEmpty((String)storage.getDeviceSn())) {
            LOGGER.error((Object)"DeviceSn is error.");
            return true;
        }
        if (VerifyUtil.isEmpty((String)storage.getStorageType())) {
            LOGGER.error((Object)"The storageType is error.");
            return true;
        }
        return false;
    }

    public void refreshKubernetes(String id, String userName) {
        LOGGER.info((Object)"Refresh kubernetes id:%s,userName:%s", new Object[]{id, userName});
        if (VerifyUtil.isEmpty((String)id)) {
            LOGGER.error((Object)"Kube id is empty,and refresh Kubernetes failed");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes kubernetes = this.getKubeById(id);
        if (kubernetes == null) {
            LOGGER.error((Object)"Kubernetes id: %s dosen't exist.Failed to refresh.", new Object[]{id});
            throw new LegoCheckedException(1073947394L);
        }
        String devSn = kubernetes.getDeviceSn();
        if (!this.getKubeHandler().checkConnectionBySN(devSn)) {
            LOGGER.error((Object)"Connect to CDR/K8S failed, devSn: %s", new Object[]{devSn});
            throw new LegoCheckedException(1073947759L, new String[]{kubernetes.getIpAddress()});
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)kubernetes.getIpAddress(), (String)"ism.drm.app.kube.refresh.operationName", (String)userName, (String)"", null);
        RefreshKubernetesTask task = new RefreshKubernetesTask(userName, id, bt, true);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public List<Kubernetes> getKubernetesList(String siteId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Kubernetes.class);
        criteria.add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (!VerifyUtil.isEmpty((Collection)objects) && objects.get(0) instanceof Kubernetes) {
            return objects;
        }
        return Collections.emptyList();
    }

    public List<KubeStorage> getKuberStorages(String id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeStorage.class);
        criteria.add((Criterion)Restrictions.eq((String)"kubeId", (Object)id));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (!VerifyUtil.isEmpty((Collection)objects) && objects.get(0) instanceof KubeStorage) {
            return objects;
        }
        return Collections.emptyList();
    }

    public ResourceSetInfo getResourceSet(String kubeId, String resourceSetId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ResourceSetInfo.class);
        criteria.add((Criterion)Restrictions.eq((String)"kubeId", (Object)kubeId));
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)resourceSetId));
        List resourceSetInfos = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)resourceSetInfos)) {
            LOGGER.error((Object)"ResourceSetInfo id: %s kubeId: %s dosen't exist.Failed to query.", new Object[]{resourceSetId, kubeId});
            throw new LegoCheckedException(1073947394L);
        }
        return (ResourceSetInfo)resourceSetInfos.get(0);
    }

    public ResourceSetInfo getResourceSetByName(String kubeId, String resourceSetName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ResourceSetInfo.class);
        criteria.add((Criterion)Restrictions.eq((String)"kubeId", (Object)kubeId));
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)resourceSetName));
        List resourceSetInfos = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)resourceSetInfos)) {
            LOGGER.error((Object)"ResourceSetInfo resourceSetName: %s kubeId: %s doesn't exist.Failed to query.", new Object[]{resourceSetName, kubeId});
            throw new LegoCheckedException(1073947394L);
        }
        return (ResourceSetInfo)resourceSetInfos.get(0);
    }

    public List<ResourceSetInfo> getResourceSets(String id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ResourceSetInfo.class);
        criteria.add((Criterion)Restrictions.eq((String)"kubeId", (Object)id));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (!VerifyUtil.isEmpty((Collection)objects) && objects.get(0) instanceof ResourceSetInfo) {
            return objects;
        }
        return Collections.emptyList();
    }

    private void saveKubeResourceSet(ResourceSetInfo info) {
        LOGGER.info((Object)"Begin to saveOrUpdate resourceSetInfo with name: %s", new Object[]{info.getName()});
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)info);
    }

    public void removeLocalKubeResourceSets(List<ResourceSetInfo> resourceSets) {
        if (VerifyUtil.isEmpty(resourceSets)) {
            LOGGER.warn((Object)"ResourceSet has already been deleted.");
            return;
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(resourceSets);
    }

    public List<Kubernetes> getKubeByIp(String ip) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Kubernetes.class);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)ip));
        return CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
    }

    public void checkCDRStatusByConfig(String config) {
        this.getKubeHandler().checkConnectionByConfig(config);
    }

    public boolean checkCDRStatusBySN(String sn) {
        return this.getKubeHandler().checkConnectionBySN(sn);
    }

    public String getKubeNamespaces(String devSn) {
        try {
            List namespaces = this.getKubeHandler().getNamespaces(devSn);
            List tmpNs = namespaces.stream().filter(namespaceBO -> !NOT_SUPPORT_NS.contains(namespaceBO.getName())).collect(Collectors.toList());
            if (VerifyUtil.isEmpty(tmpNs)) {
                return "";
            }
            return JSONArray.fromObject(tmpNs).toString();
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(1073947740L, new String[]{"NAMESPACE"});
        }
        catch (KubernetesClientException e) {
            LOGGER.error((Object)"Get namespace error, errorCode: %s, errorMsg: %s", new Object[]{e.getCode(), e.getMessage()});
            throw new LegoCheckedException(1073947740L, new String[]{"NAMESPACE"});
        }
    }

    public String getKubeUsableLabels(String devSn) {
        try {
            List labels = this.getKubeHandler().queryKubeLabelsFromAll(devSn);
            return JSONArray.fromObject((Object)labels).toString();
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(1073947740L, new String[]{"LABELS"});
        }
        catch (KubernetesClientException e) {
            LOGGER.error((Object)"Get LABELS error, errorCode: %s, errorMsg: %s", new Object[]{e.getCode(), e.getMessage()});
            throw new LegoCheckedException(1073947740L, new String[]{"LABELS"});
        }
    }

    public String createKubeResourceSet(String devSn, ResourceSetInfo resourceSetInfo, String userName) {
        BackTask backTask = BackTaskUtil.buildBackTask((String)resourceSetInfo.getName(), (String)"ism.drm.app.kube.resourceset.create.operationName", (String)userName, (String)"", null);
        String taskId = UUIDGenerator.getUUID();
        CreateResourceSetTask task = new CreateResourceSetTask(taskId, devSn, resourceSetInfo, backTask);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return taskId;
    }

    public void deleteKubeResourceSet(String kubeId, String resourceSetId) {
        ResourceSetInfo info = this.getResourceSet(kubeId, resourceSetId);
        ArrayList<ResourceSetInfo> resourceSetList = new ArrayList<ResourceSetInfo>();
        resourceSetList.add(info);
        try {
            this.getKubeHandler().deleteKubeResourceSet(kubeId, resourceSetList);
            this.removeLocalKubeResourceSets(resourceSetList);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec delete kube resourceSet failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947739L);
        }
    }

    public void deleteKubeResourceSetByName(String kubeId, String resourceSetName) {
        ResourceSetInfo info = this.getResourceSetByName(kubeId, resourceSetName);
        ArrayList<ResourceSetInfo> resourceSetList = new ArrayList<ResourceSetInfo>();
        resourceSetList.add(info);
        try {
            this.getKubeHandler().deleteKubeResourceSet(kubeId, resourceSetList);
            this.removeLocalKubeResourceSets(resourceSetList);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec delete kube resourceSet failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947739L);
        }
    }

    public void removeLocalkubeStorage(List<KubeStorage> kubeStorages) {
        if (VerifyUtil.isEmpty(kubeStorages)) {
            LOGGER.warn((Object)"KubeStorage has already been deleted.");
            return;
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(kubeStorages);
    }

    public List<HookBO> getKubeHooks(String kubeId, String hookName) {
        List hooks = this.getKubeHandler().getHooks(kubeId);
        if (VerifyUtil.isEmpty((Collection)hooks)) {
            LOGGER.warn((Object)"The result of hooks from k8s is empty, device sn is %s", new Object[]{kubeId});
            return Collections.emptyList();
        }
        if (!VerifyUtil.isEmpty((String)hookName)) {
            hooks.removeIf(e -> !e.getName().contains(hookName));
        }
        return hooks;
    }

    public void deleteSchedulePolicy(String devSn, List<KubeSchedulePolicy> policies) {
        this.getKubeHandler().deleteSchedulePolicy(devSn, policies);
    }

    public Set<KubeSchedulePolicy> getPolicies(String devSn, List<String> names) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        HashSet<KubeSchedulePolicy> policies = new HashSet<KubeSchedulePolicy>();
        for (String name : names) {
            Optional kubeSchedulePolicy = kubeHandler.getKubeSchedulePolicy(devSn, name);
            kubeSchedulePolicy.ifPresent(policies::add);
        }
        return policies;
    }

    public void refreshResourceSet(String kubeId, String resourceSetName, String userName) {
        Optional resourceSetInfo = this.getKubeHandler().getResourceSetInfo(kubeId, resourceSetName);
        if (!resourceSetInfo.isPresent()) {
            String message = "ResourceSet is not exist. name: " + resourceSetName;
            throw new LegoCheckedException(201L, message);
        }
        BackTask backTask = BackTaskUtil.buildBackTask((String)resourceSetName, (String)"ism.drm.app.kube.resourceset.refresh.operationName", (String)userName, (String)"", null);
        String taskId = UUIDGenerator.getUUID();
        RefreshResourceSetTask task = new RefreshResourceSetTask(taskId, kubeId, resourceSetName, backTask);
        LOGGER.info((Object)"Refresh resource set task id is: %s", new Object[]{taskId});
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public KubeProtectionPlan getProtectionPlan(String devSn, String planName) {
        return (KubeProtectionPlan)this.getKubeHandler().getProtectionPlan(devSn, planName).orElseThrow(() -> new LegoCheckedException(2117645L, "ProtectPlan not exist."));
    }

    public BackupInstanceInfo getBackupInstance(String devSn, String instanceName) {
        return this.getKubeHandler().getBackupInstanceInfo(devSn, instanceName);
    }

    public void rebuildProtectionPlan(String devSn, KubeProtectionPlan plan) {
        this.getKubeHandler().rebuildProtectionPlan(devSn, plan);
    }

    public void rebuildBackupInstance(String devSn, BackupInstanceInfo info) {
        this.getKubeHandler().rebuildBackupInstance(devSn, info);
    }

    public List<KubeBackupJob> getBackupJobByInstance(String backupInstanceName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeBackupJob.class);
        criteria.add((Criterion)Restrictions.eq((String)"backupInstanceName", (Object)backupInstanceName));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (!VerifyUtil.isEmpty((Collection)objects) && objects.get(0) instanceof KubeBackupJob) {
            return objects;
        }
        return Collections.emptyList();
    }

    public void saveBackupJob(KubeBackupJob job) {
        CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)job);
    }

    public Set<String> getUsedResourceSetIds() {
        return new HashSet<String>(KubeProviderUtil.getProtectedObjectIds(20));
    }

    public String getClusterTime(String kubeId) {
        String namespaceName = KubeResourceNameGenerator.generate();
        this.createTempNamespace(kubeId, namespaceName);
        String clusterTime = this.getTempNamespaceCreateTime(kubeId, namespaceName);
        this.getKubeHandler().deleteNamespace(kubeId, namespaceName);
        return clusterTime;
    }

    private void createTempNamespace(String kubeId, String namespaceName) {
        NamespaceBO namespace = new NamespaceBO();
        namespace.setName(namespaceName);
        this.getKubeHandler().createNamespace(kubeId, namespace);
    }

    private String getTempNamespaceCreateTime(String kubeId, String namespaceName) {
        for (int retryTime = 0; retryTime < 5; ++retryTime) {
            NamespaceBO namespace;
            String createTime;
            Optional opt = this.getKubeHandler().getNamespace(kubeId, namespaceName);
            if (opt.isPresent() && StringUtils.isNotEmpty((CharSequence)(createTime = (namespace = (NamespaceBO)opt.get()).getCreateTime()))) {
                return KubeResourceUtil.transKubeTime(createTime);
            }
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        LOGGER.error((Object)"Could not get temp namespace create time after %s seconds of retries", new Object[]{String.valueOf(5)});
        throw new LegoCheckedException(0x300001L);
    }
}

