/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.utils;

import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class KubeRecoveryUtils {
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryUtils.class);
    private static final String INVALID_NAMESPACE_PROP = "cdr.invalid.namespace";
    private static final List<String> INVALID_NAMESPACE = new ArrayList<String>();
    private static final String PREFIX_FORMAT_DESC = "Please check the format of prefix, expect format:1. Start with a lowercase character; 2. Only lowercase character or '-' is permitted; 3. Max length is 31";
    private static final int MAX_PREFIX_LENGTH = 31;
    private static final int MAX_RESOURCE_NAME_LENGTH = 253;

    public static void checkNamespace(String clusterSn, String targetNamespace) {
        if (VerifyUtil.isEmpty((String)targetNamespace)) {
            LOGGER.error((Object)"Validate kubernetes parameter error, target post namespace is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (INVALID_NAMESPACE.contains(targetNamespace)) {
            LOGGER.error((Object)"Validate kubernetes parameter error, target namespace is invalid, namespace: %s", new Object[]{targetNamespace});
            throw new LegoCheckedException(1073947393L);
        }
        Optional namespaceOptional = KubeRecoveryUtils.getKubeHandler().getNamespace(clusterSn, targetNamespace);
        if (!namespaceOptional.isPresent()) {
            LOGGER.error((Object)"Validate kubernetes parameter error, target post namespace is not exist");
            throw new LegoCheckedException(2117645L);
        }
    }

    public static void checkHook(String clusterSn, String targetHook) {
        if (VerifyUtil.isEmpty((String)targetHook)) {
            return;
        }
        Optional hookOptional = KubeRecoveryUtils.getKubeHandler().getHook(clusterSn, targetHook);
        if (!hookOptional.isPresent()) {
            LOGGER.error((Object)"Validate kubernetes parameter error, target post hook is not exist");
            throw new LegoCheckedException(2117645L);
        }
    }

    public static void checkBoolSetting(Map<String, String> globalSettings, String settingKey, boolean isRequired) {
        String setting = globalSettings.get(settingKey);
        if (VerifyUtil.isEmpty((String)setting)) {
            if (isRequired) {
                LOGGER.error((Object)"Global setting [%s] is required", new Object[]{settingKey});
                throw new LegoCheckedException(1073947393L, "Global setting [" + settingKey + "] is required");
            }
            return;
        }
        if (!StringUtils.equals((CharSequence)setting, (CharSequence)"true") && !StringUtils.equals((CharSequence)setting, (CharSequence)"false")) {
            LOGGER.error((Object)"Global setting [%s] is invalid, [ true ] or [ false ] is expect", new Object[]{settingKey});
            throw new LegoCheckedException(1073947393L, "Global setting [" + settingKey + "] is invalid");
        }
    }

    public static void checkCdrStatus(String devSn) {
        if (!KubeRecoveryUtils.getKubeHandler().checkConnectionBySN(devSn)) {
            LOGGER.error((Object)"Connect to CDR failed, devSn: %s", new Object[]{devSn});
            throw new LegoCheckedException(1073947737L);
        }
    }

    public static void checkPrefix(String prefix) {
        if (VerifyUtil.isEmpty((String)prefix)) {
            return;
        }
        if (!Character.isLowerCase(prefix.charAt(0))) {
            LOGGER.error((Object)PREFIX_FORMAT_DESC);
            throw new LegoCheckedException(1073947393L);
        }
        int length = prefix.length();
        if (length > 31) {
            LOGGER.error((Object)PREFIX_FORMAT_DESC);
            throw new LegoCheckedException(1073947393L);
        }
        for (int index = 0; index < length; ++index) {
            if (Character.isLowerCase(prefix.charAt(index)) || prefix.charAt(index) == '-') continue;
            LOGGER.error((Object)PREFIX_FORMAT_DESC);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkResourceName(String resourceName, String prefix) {
        if (VerifyUtil.isEmpty((String)resourceName)) {
            LOGGER.error((Object)"Resource name is empty");
            throw new LegoCheckedException(1073947393L);
        }
        KubeRecoveryUtils.checkPrefix(prefix);
        int totalLength = 0;
        if (!VerifyUtil.isEmpty((String)prefix)) {
            totalLength += prefix.length();
        }
        if ((totalLength += resourceName.length()) > 253) {
            LOGGER.error((Object)"Resource name is invalid, cause the length of (prefix + name) is too long. prefix: %s,source name: %s", new Object[]{prefix, resourceName});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    public static void resetEnableStatusByLastStatus(RecoveryProcessor processor, DrmEnumDefine.RecoveryPlanExecuteTypeE disabledType, DrmEnumDefine.RecoveryPlanExecuteTypeE enabledType) {
        RecoveryLog log = (RecoveryLog)HibernateUtil.call(session -> (RecoveryLog)session.createQuery("from RecoveryLog where planId=:id and logStatus in(0,2) order by startTime desc", RecoveryLog.class).setParameter("id", (Object)processor.getPlanId()).setFirstResult(0).setMaxResults(1).uniqueResult());
        if (log == null) {
            return;
        }
        int lastSuccessExecuteType = log.getLogType();
        if (lastSuccessExecuteType == disabledType.getValue()) {
            processor.setIsEnabled(Boolean.valueOf(false));
            processor.setIsEditable(Boolean.valueOf(false));
        }
        if (lastSuccessExecuteType == enabledType.getValue()) {
            processor.setIsEnabled(Boolean.valueOf(true));
            processor.setIsEditable(Boolean.valueOf(true));
        }
    }

    public static void invalidProtectGroup(ProtectGroup protectGroup) {
        protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
    }

    static {
        String namespaceStr = LegoBaseConfig.getInstance().getKeyValue(INVALID_NAMESPACE_PROP);
        if (!VerifyUtil.isEmpty((String)namespaceStr)) {
            String[] namespaceArray = namespaceStr.split(",");
            INVALID_NAMESPACE.addAll(Arrays.asList(namespaceArray));
        }
    }
}

