/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.utils;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeBackup;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class KubeResourceBuildUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeResourceBuildUtil.class);

    public static List<StorageClassInfo> buildSCs(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<StorageClassInfo> storageClassInfos = new ArrayList<StorageClassInfo>(names.size());
        for (String name : names) {
            StorageClassInfo storageClassInfo = new StorageClassInfo();
            storageClassInfo.setName(name);
            storageClassInfos.add(storageClassInfo);
        }
        return storageClassInfos;
    }

    public static List<PersistentVolumeClaimInfo> buildPVCs(List<String> pvcNameWithNs, String devSn) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(pvcNameWithNs)) {
            return Collections.emptyList();
        }
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        ArrayList<PersistentVolumeClaimInfo> persistentVolumeClaimInfos = new ArrayList<PersistentVolumeClaimInfo>();
        pvcNameWithNs.forEach(item -> {
            String[] array = item.split("/");
            if (array.length != 2) {
                return;
            }
            PersistentVolumeClaimInfo persistentVolumeClaimInfo = new PersistentVolumeClaimInfo();
            persistentVolumeClaimInfo.setNameSpace(array[0]);
            persistentVolumeClaimInfo.setName(array[1]);
            Optional infoOpt = kubeHandler.getPersistentVolumeClaimInfo(devSn, array[1], array[0]);
            infoOpt.ifPresent(volumeClaimInfo -> persistentVolumeClaimInfo.setStorageClassName(volumeClaimInfo.getStorageClassName()));
            persistentVolumeClaimInfos.add(persistentVolumeClaimInfo);
        });
        return persistentVolumeClaimInfos;
    }

    public static List<BackupInstanceInfo> buildBackupInstance(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<BackupInstanceInfo> backupInstanceInfos = new ArrayList<BackupInstanceInfo>(names.size());
        for (String name : names) {
            BackupInstanceInfo backupInstanceInfo = new BackupInstanceInfo();
            backupInstanceInfo.setName(name);
            backupInstanceInfos.add(backupInstanceInfo);
        }
        return backupInstanceInfos;
    }

    public static List<BackupLocationInfo> buildBackLocations(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<BackupLocationInfo> backLocations = new ArrayList<BackupLocationInfo>(names.size());
        for (String name : names) {
            BackupLocationInfo backupLocationInfo = new BackupLocationInfo();
            backupLocationInfo.setName(name);
            backLocations.add(backupLocationInfo);
        }
        return backLocations;
    }

    public static List<KubeSchedulePolicy> buildKubePolicies(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<KubeSchedulePolicy> schedules = new ArrayList<KubeSchedulePolicy>();
        for (String name : names) {
            KubeSchedulePolicy policy = new KubeSchedulePolicy();
            policy.setName(name);
            schedules.add(policy);
        }
        return schedules;
    }

    public static List<ResourceSetInfo> buildResouceSets(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<ResourceSetInfo> resourceSetInfos = new ArrayList<ResourceSetInfo>();
        for (String name : names) {
            ResourceSetInfo resourceSetInfo = new ResourceSetInfo();
            resourceSetInfo.setName(name);
            resourceSetInfos.add(resourceSetInfo);
        }
        return resourceSetInfos;
    }

    public static List<KubeProtectionPlan> buildProtectionPlans(List<String> names) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        ArrayList<KubeProtectionPlan> plans = new ArrayList<KubeProtectionPlan>();
        for (String name : names) {
            KubeProtectionPlan kubeProtectionPlan = new KubeProtectionPlan();
            kubeProtectionPlan.setName(name);
            plans.add(kubeProtectionPlan);
        }
        return plans;
    }

    public static void buildPlanWithSchedule(Schedule schedule, KubeProtectionPlan protectionPlan) {
        List list;
        if (schedule.getExtParameters().containsKey("preHook")) {
            protectionPlan.setPreHook((String)schedule.getExtParameters().get("preHook"));
        }
        if (schedule.getExtParameters().containsKey("postHook")) {
            protectionPlan.setPostHook((String)schedule.getExtParameters().get("postHook"));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)(list = (List)JSONObject.toBean((String)schedule.getReplicationSpeedPolicyData(), List.class))) && ((Map)list.get(0)).get("syncRateLevel") != null) {
            protectionPlan.setVolumeSpeed(KubeEnumDefine.VolumeSpeed.getVolumeSpeed((int)Integer.parseInt(String.valueOf(((Map)list.get(0)).get("syncRateLevel")))));
        }
    }

    private static KubeStorage buildKubeStorage(ProtectGroup protectGroup, KubeProtectionPlan protectionPlan, ProtectObject protectObject) {
        KubeStorage storage;
        if (protectGroup.getTemplate().getType() == 55) {
            storage = KubeResourceBuildUtil.getPVCSBC(protectObject);
        } else {
            protectionPlan.setResourceSet(protectObject.getName());
            storage = KubeResourceBuildUtil.getSBC((ProtectObject)protectGroup.getPolist().iterator().next());
        }
        return storage;
    }

    public static KubeStorage getSBC(ProtectObject protectObject) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List kubeStorages = iKubeHandler.getStorageBackendClaims(protectObject.getProviderSN());
        List pvc = iKubeHandler.getResourceSetPVCs(protectObject.getProviderSN(), (String)protectObject.getProps().get("resourceDetailName"));
        String backendName = pvc.stream().map(KubeResourceSetPVC::getKubePV).filter(Objects::nonNull).map(KubePersistentVolume::getBackend).filter(Objects::nonNull).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        return kubeStorages.stream().filter(kubeStorage -> backendName.equals(kubeStorage.getName())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    public static KubeStorage getPVCSBC(ProtectObject protectObject) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional opt = iKubeHandler.getKubePersistentVolume(protectObject.getProviderSN(), (String)protectObject.getProps().get("kube_persistent_volume"));
        if (!opt.isPresent()) {
            throw new LegoCheckedException(1073947393L);
        }
        List kubeStorages = iKubeHandler.getStorageBackendClaims(protectObject.getProviderSN());
        return kubeStorages.stream().filter(kubeStorage -> Objects.equals(((KubePersistentVolume)opt.get()).getBackend(), kubeStorage.getName())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    public static Optional<KubeStorage> getTargetKubeStorage(Schedule schedule) {
        String backendName = KubeResourceBuildUtil.getTargetBackendName(schedule);
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeStorage.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)backendName));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects)) {
            return Optional.empty();
        }
        return objects.stream().filter(item -> item instanceof KubeStorage).map(item -> (KubeStorage)item).findAny();
    }

    private static String getTargetBackendName(Schedule schedule) {
        Map extParameters = schedule.getExtParameters();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)extParameters) || !extParameters.containsKey("kubeTargetStorage")) {
            LOGGER.error((Object)"Not find kubeTargetStorage info by schedule: %s.", new Object[]{schedule.getName()});
            throw new LegoCheckedException(2117645L);
        }
        return (String)extParameters.get("kubeTargetStorage");
    }

    public static ProtectGroupReplica buildBackupReplica(KubeBackup backup, ProtectGroup protectGroup, boolean isManual) {
        ProtectGroupReplica replica = new ProtectGroupReplica();
        replica.setId(backup.getName());
        replica.setName(backup.getName());
        replica.setPg(protectGroup);
        replica.setStatus(KubeEnumDefine.KubeBackupStatus.getBcmBackupStatus((String)backup.getStatus()).getValue());
        replica.setProtectLocation(DrmEnumDefine.ProtectLocation.A_A.getValue());
        replica.setRecoverySite(protectGroup.getProductSiteId());
        replica.setType(12);
        replica.setGeneration(Integer.valueOf(2));
        replica.setTimeStamp(String.valueOf(new Date().getTime()));
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        schedule.setTargetSn(schedule.getSourceSn());
        schedule.setTargetSiteId(schedule.getSourceSiteId());
        replica.setProductArray(schedule.getSourceSn());
        replica.setRecoveryArray(schedule.getTargetSn());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("isManual", String.valueOf(isManual));
        props.put("resourceSet", ((ProtectObject)protectGroup.getPolist().iterator().next()).getProperty("namespace"));
        replica.setProps(props);
        return replica;
    }

    public static List<String> buildPvcWithNamespace(ProtectGroup protectGroup) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (protectGroup.getPoType() == 21) {
            protectGroup.getPolist().forEach(po -> result.add((String)po.getProps().get("namespace") + "/" + po.getName()));
        } else {
            IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            List pvcList = iKubeHandler.getResourceSetPVCs(protectGroup.getPoProviderSN(), (String)((ProtectObject)protectGroup.getPolist().iterator().next()).getProps().get("resourceDetailName"));
            pvcList.forEach(item -> result.add(item.getNamespace() + "/" + item.getName()));
        }
        return result;
    }
}

