/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.kube.service;

import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.vo.HookVO;
import com.huawei.ism.drm.kube.sdk.model.vo.KubeStorageVO;
import com.huawei.ism.drm.kube.sdk.model.vo.KubernetesVO;
import com.huawei.ism.drm.kube.sdk.model.vo.ResourceSetVO;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

public interface IKubeRestService {
    @POST
    @Path(value="/{siteId}/action/create")
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    public Response registerKube(@PathParam(value="siteId") String var1, @Multipart(value="config", type="text/yaml") Attachment var2);

    @POST
    @Path(value="/{id}")
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    public Response updateKube(@PathParam(value="id") String var1, @Multipart(value="config", type="text/yaml") Attachment var2);

    @PUT
    @Path(value="/{id}/action/refresh")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response refreshKubernetes(@PathParam(value="id") String var1);

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<KubernetesVO> queryKubernetes(@QueryParam(value="siteId") String var1);

    @GET
    @Path(value="/{id}/storages")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<KubeStorageVO> queryStorages(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/resourceSets")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ResourceSetVO> queryResourceSets(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/resourceSets/{resourceSetId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ResourceSetVO queryResourceSetDetail(@PathParam(value="id") String var1, @PathParam(value="resourceSetId") String var2);

    @GET
    @Path(value="/{id}/namespaces")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getKubeNamespaces(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/labels")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getKubeLabels(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/resourceSets")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String createKubeResourceSets(@PathParam(value="id") String var1, ResourceSetInfo var2);

    @DELETE
    @Path(value="/{id}/resourceSets/{resourceSetId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteKubeResourceSets(@PathParam(value="id") String var1, @PathParam(value="resourceSetId") String var2);

    @GET
    @Path(value="/{id}/hooks")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<HookVO> getKubeHooks(@PathParam(value="id") String var1, @QueryParam(value="hookName") String var2);

    @PUT
    @Path(value="/{id}/resourceSets/{resourceSetName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response refreshResourceSet(@PathParam(value="id") String var1, @PathParam(value="resourceSetName") String var2);

    @GET
    @Path(value="/{id}/clusterTime")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getClusterTime(@PathParam(value="id") String var1);
}

