/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.kube.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.PodResource;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.HookBO;
import com.huawei.ism.drm.kube.sdk.model.vo.HookVO;
import com.huawei.ism.drm.kube.sdk.model.vo.KubeStorageVO;
import com.huawei.ism.drm.kube.sdk.model.vo.KubernetesVO;
import com.huawei.ism.drm.kube.sdk.model.vo.ResourceSetVO;
import com.huawei.ism.drm.kube.sdk.model.vo.ResourceVO;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.kube.model.CheckKubeConfigResult;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfig;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigCluster;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigClusterItem;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigContextUser;
import com.huawei.ism.drm.rest.service.framework.kube.service.IKubeRestService;
import com.huawei.ism.drm.rest.service.framework.kube.util.KubeCheckUtil;
import com.huawei.ism.drm.rest.service.framework.kube.util.StringUtilsX;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

public class KubeRestServiceImpl
extends AbstractRestService
implements IKubeRestService {
    private static final Log LOGGER = LogFactory.getInstance(KubeRestServiceImpl.class);
    private static final String TASK_ID = "taskId";
    private static final String CONTAINER_CLUSTER = "kubernetes";
    private static final String RESOURCE_SET_NAME = "resourceSetName";

    private IKubeService getService() {
        return (IKubeService)this.getBundleService("DRM_Kubernetes_Manager", IKubeService.class.getName(), IKubeService.class);
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, uuid={"$1"})
    @Logging(name="site_sendAddResourceCmd_operateName", ward=true)
    public Response registerKube(String siteId, Attachment file) {
        LOGGER.info((Object)"[kubernetes]Register kubernetes start");
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            LOGGER.error((Object)"[kubernetes]Register kubernetes error, cause siteId dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = KubeCheckUtil.checkSiteId(siteId);
        CheckKubeConfigResult checkKubeConfigResult = KubeCheckUtil.checkKubeConfig(file, null);
        KubeConfigCluster kubeConfigCluster = KubeCheckUtil.checkAndGetConfigCluster(checkKubeConfigResult.getConfigData());
        String clusterServer = kubeConfigCluster.getCluster().getServer();
        KubeCheckUtil.checkKubeRepeat(StringUtilsX.parseHostByAddress(clusterServer));
        this.addDiscoveryTask(siteId, checkKubeConfigResult);
        String host = StringUtilsX.parseHostByAddress(clusterServer);
        String[] successLogParam = new String[]{host, site.getName()};
        this.writeSucOperationLog("site_sendAddResourceCmd_operateName", 1, host, "site_sendAddResourceCmd_operateDetail", successLogParam);
        LOGGER.info((Object)"[kubernetes]Register kubernetes complete");
        return Response.ok().build();
    }

    private void addDiscoveryTask(String siteId, CheckKubeConfigResult checkKubeConfigResult) {
        KubeConfig config = checkKubeConfigResult.getConfigData();
        DiscoveryPolicy policy = new DiscoveryPolicy();
        policy.setLocation(siteId);
        KubeConfigCluster kubeConfigCluster = KubeCheckUtil.checkAndGetConfigCluster(config);
        KubeConfigClusterItem currentCluster = kubeConfigCluster.getCluster();
        String host = StringUtilsX.parseHostByAddress(currentCluster.getServer());
        int port = StringUtilsX.parsePortByAddress(currentCluster.getServer());
        policy.setStartIP(host);
        policy.setEndIP(host);
        policy.setDeviceType("ism.drm.deviceType.container.mainType");
        policy.setDeviceSubType("");
        KubeConfigContextUser currentUser = KubeCheckUtil.checkAndGetConfigUser(config);
        HashMap<String, String> paramMap = new HashMap<String, String>(5);
        paramMap.put("siteId", siteId);
        paramMap.put("ip", host);
        paramMap.put("port", String.valueOf(port));
        paramMap.put("server", currentCluster.getServer());
        paramMap.put("user", currentUser.getName());
        paramMap.put("clusterName", kubeConfigCluster.getName());
        paramMap.put("config", WccEncryptor.encrypt((String)checkKubeConfigResult.getConfigText()));
        policy.setParamMap(paramMap);
        policy.setOperatorId(this.getCurrentUserId());
        long taskId = ((IResourceService)this.getBundleService(IResourceService.class)).discoveryResource(policy);
        paramMap.put(TASK_ID, String.valueOf(taskId));
    }

    @Override
    @Context(name="kubernetes")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_modifyResProtocol_operateName", rank=3, detail="resource_modifyResProtocol_operateDetail_2", object="$kubernetes?.name")
    public Response updateKube(String id, Attachment file) {
        LOGGER.info((Object)"[kubernetes]Update kubernetes start");
        if (!ParamChecker.checkGeneralId((String)id)) {
            LOGGER.error((Object)"[kubernetes]Update kubernetes error, cause id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes currentResource = KubeCheckUtil.checkKubeExist(id);
        if (currentResource == null) {
            LOGGER.error((Object)"[kubernetes]Modify kubernetes error, cause resource is not exist. resourceId: %s", new Object[]{id});
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)CONTAINER_CLUSTER, (Object)currentResource);
        CheckKubeConfigResult checkKubeConfigResult = KubeCheckUtil.checkKubeConfig(file, WccEncryptor.decrypt((String)currentResource.getConfig()));
        this.getService().checkCDRStatusByConfig(checkKubeConfigResult.getConfigText());
        KubeConfig config = checkKubeConfigResult.getConfigData();
        KubeConfigCluster kubeConfigCluster = KubeCheckUtil.checkAndGetConfigCluster(config);
        KubeConfigContextUser currentUser = KubeCheckUtil.checkAndGetConfigUser(config);
        boolean isUpdateSuccess = this.getService().updateKube(id, WccEncryptor.encrypt((String)checkKubeConfigResult.getConfigText()), currentUser.getName(), kubeConfigCluster.getName());
        if (!isUpdateSuccess) {
            LOGGER.error((Object)"[kubernetes]Modify kubernetes error, cause operate database failed");
            throw new LegoCheckedException(0x200909L);
        }
        LOGGER.info((Object)"[kubernetes]Update kubernetes complete");
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getKubeNamespaces(String kubeId) {
        if (!ParamChecker.checkGeneralId((String)kubeId)) {
            LOGGER.error((Object)"[kubernetes]Query namespace error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)kubeId)) {
            LOGGER.error((Object)"The kubeId is illegal.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getService().getKubeNamespaces(kubeId);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getKubeLabels(String kubeId) {
        if (!ParamChecker.checkGeneralId((String)kubeId)) {
            LOGGER.error((Object)"[kubernetes]Query kube labels error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)kubeId)) {
            LOGGER.error((Object)"The kubeId is illegal.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getService().getKubeUsableLabels(kubeId);
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="kubernetes_add_resourceSet_operateName", rank=3, object="$2.name", detail="kubernetes_add_resourceSet_operateDetail", parameters={"$2.name"})
    public String createKubeResourceSets(String kubeId, ResourceSetInfo resourceSetInfo) {
        if (!ParamChecker.checkGeneralId((String)kubeId)) {
            LOGGER.error((Object)"[kubernetes]Create kubernetes resourceSet error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes currentResource = KubeCheckUtil.checkKubeExist(kubeId);
        if (currentResource == null) {
            LOGGER.error((Object)"Create kubernetes resourceSet error, cause resource is not exist. resourceId: %s", new Object[]{kubeId});
            throw new LegoCheckedException(2117645L);
        }
        if (!KubeCheckUtil.checkResourceSetInfo(resourceSetInfo)) {
            throw new LegoCheckedException(1073947393L);
        }
        Set resourceSetNames = this.getService().getResourceSets(kubeId).stream().map(ResourceSetInfo::getName).collect(Collectors.toSet());
        if (resourceSetNames.contains(resourceSetInfo.getName())) {
            LOGGER.error((Object)"Resourceset already exist.");
            throw new LegoCheckedException(1073947742L);
        }
        String taskId = this.getService().createKubeResourceSet(kubeId, resourceSetInfo, this.getCurrentUser().getUserName());
        JSONObject result = new JSONObject();
        result.set((Object)TASK_ID, (Object)taskId);
        return result.toString();
    }

    @Override
    @Contexts(value={@Context(name="kubernetes"), @Context(name="resourceSetName")})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="kubernetes_delete_resourceSet_operateName", rank=3, object="$resourceSetName", detail="kubernetes_delete_resourceSet_operateDetail", parameters={"$kubernetes?.name", "$resourceSetName"})
    public Response deleteKubeResourceSets(String kubeId, String resourceSetId) {
        if (!ParamChecker.checkGeneralId((String)kubeId) || !ParamChecker.checkGeneralId((String)resourceSetId)) {
            LOGGER.error((Object)"[kubernetes]Delete kubernetes resourceSet error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)kubeId) || VerifyUtil.isEmpty((String)resourceSetId)) {
            LOGGER.error((Object)"The input id is illegal.");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes currentResource = KubeCheckUtil.checkKubeExist(kubeId);
        if (currentResource == null) {
            LOGGER.error((Object)"Kubernetes (%s) is not exist", new Object[]{kubeId});
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)CONTAINER_CLUSTER, (Object)currentResource);
        ResourceSetInfo resourceSet = this.getService().getResourceSet(kubeId, resourceSetId);
        Context.Variable.set((String)RESOURCE_SET_NAME, (Object)resourceSet.getName());
        KubeCheckUtil.isKubeResourceSetUsed(kubeId, resourceSetId);
        this.getService().deleteKubeResourceSet(kubeId, resourceSetId);
        return Response.ok().build();
    }

    @Override
    @Context(name="kube")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_refresh_operateName", rank=3, object="$kube?.name", parameters={"$kube?.name", "$kube?.ipAddress"}, detail="resource_refresh_operateDetail")
    public Response refreshKubernetes(String id) {
        LOGGER.info((Object)"[kubernetes]Refresh kubernetes start");
        if (!ParamChecker.checkGeneralId((String)id)) {
            LOGGER.error((Object)"[kubernetes]Refresh kubernetes error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.error((Object)"[kubernetes]Refresh kubernetes error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes currentResource = KubeCheckUtil.checkKubeExist(id);
        if (currentResource == null) {
            LOGGER.error((Object)"[kubernetes]Refresh kubernetes error, cause resource is not exist. resourceId: %s", new Object[]{id});
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"kube", (Object)currentResource);
        IKubeService service = this.getService();
        service.refreshKubernetes(id, this.getCurrentUser().getUserName());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, uuid={"$1"})
    public List<KubernetesVO> queryKubernetes(String siteId) {
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            LOGGER.error((Object)"[kubernetes]Query kubernetes error, cause siteId dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)siteId)) {
            LOGGER.error((Object)"[kubernetes]Query kubernetes error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IKubeService service = this.getService();
        List kubernetesList = service.getKubernetesList(siteId);
        if (VerifyUtil.isEmpty((Collection)kubernetesList)) {
            return Collections.emptyList();
        }
        ArrayList<KubernetesVO> kubernetesVOList = new ArrayList<KubernetesVO>();
        for (Kubernetes kubernetes : kubernetesList) {
            KubernetesVO kubernetesVO = new KubernetesVO();
            kubernetesVO.setName(kubernetes.getName());
            kubernetesVO.setServer(kubernetes.getIpAddress());
            kubernetesVO.setUserName(kubernetes.getUserName());
            kubernetesVO.setStatus(kubernetes.getStatus());
            kubernetesVO.setId(kubernetes.getDbId());
            kubernetesVOList.add(kubernetesVO);
        }
        return kubernetesVOList;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<KubeStorageVO> queryStorages(String id) {
        if (!ParamChecker.checkGeneralId((String)id)) {
            LOGGER.error((Object)"[kubernetes]Query storages error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)id)) {
            LOGGER.error((Object)"[kubernetes]Query storages error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IKubeService service = this.getService();
        List kubeStorages = service.getKuberStorages(id);
        if (VerifyUtil.isEmpty((Collection)kubeStorages)) {
            return Collections.emptyList();
        }
        ArrayList<KubeStorageVO> kubeStorageVOList = new ArrayList<KubeStorageVO>();
        for (KubeStorage kubeStorage : kubeStorages) {
            KubeStorageVO kubeStorageVO = new KubeStorageVO();
            kubeStorageVO.setName(kubeStorage.getName());
            kubeStorageVO.setNamespace(kubeStorage.getNamespace());
            kubeStorageVO.setDeviceSn(kubeStorage.getDeviceSn());
            kubeStorageVO.setStatus(kubeStorage.getStatus());
            kubeStorageVO.setIpAddress(kubeStorage.getIpAddress());
            kubeStorageVO.setStorageType(kubeStorage.getStorageType());
            kubeStorageVOList.add(kubeStorageVO);
        }
        return kubeStorageVOList;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<ResourceSetVO> queryResourceSets(String id) {
        if (!ParamChecker.checkGeneralId((String)id)) {
            LOGGER.error((Object)"[kubernetes]Query resourceSets error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)id)) {
            LOGGER.error((Object)"[kubernetes]Query resourceSets error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IKubeService service = this.getService();
        List resourceSets = service.getResourceSets(id);
        if (VerifyUtil.isEmpty((Collection)resourceSets)) {
            return Collections.emptyList();
        }
        ArrayList<ResourceSetVO> resourceSetVOList = new ArrayList<ResourceSetVO>();
        for (ResourceSetInfo resourceSet : resourceSets) {
            ResourceSetVO resourceSetVO = this.formResourceSetVO(resourceSet);
            resourceSetVOList.add(resourceSetVO);
        }
        return resourceSetVOList;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$2"})
    public ResourceSetVO queryResourceSetDetail(String kubeId, String resourceSetId) {
        if (!ParamChecker.checkGeneralId((String)kubeId) || !ParamChecker.checkGeneralId((String)resourceSetId)) {
            LOGGER.error((Object)"[kubernetes]Query resourceSetDetail error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)kubeId) || VerifyUtil.isEmpty((String)resourceSetId)) {
            LOGGER.error((Object)"[kubernetes]Query resourceSetDetail error, cause resource id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IKubeService service = this.getService();
        ResourceSetInfo resourceSet = service.getResourceSet(kubeId, resourceSetId);
        if (resourceSet == null) {
            LOGGER.error((Object)"[ResourceSets]Query ResourceSet error, cause resource is not exist. Id: %s. ResourceSetId:%s", new Object[]{kubeId, resourceSetId});
            throw new LegoCheckedException(2117645L);
        }
        return this.formResourceSetVO(resourceSet);
    }

    private ResourceSetVO formResourceSetVO(ResourceSetInfo resourceSet) {
        ResourceSetVO resourceSetVO = new ResourceSetVO();
        resourceSetVO.setId(resourceSet.getId());
        resourceSetVO.setNamespace(resourceSet.getNamespace());
        resourceSetVO.setName(resourceSet.getName());
        ArrayList labels = new ArrayList();
        Map labelMap = (Map)JSONObject.toBean((String)resourceSet.getLabels(), Map.class);
        labelMap.keySet().forEach(key -> labels.add(key + ":" + (String)labelMap.get(key)));
        resourceSetVO.setLabels(labels);
        resourceSetVO.setIncludeResources(JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)resourceSet.getIncludeResources()), ResourceVO.class));
        resourceSetVO.setExcludeResources(JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)resourceSet.getExcludeResources()), ResourceVO.class));
        resourceSetVO.setPodResources(JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)resourceSet.getProtectResources()), PodResource.class));
        return resourceSetVO;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<HookVO> getKubeHooks(String kubeId, String hookName) {
        if (!ParamChecker.checkGeneralId((String)kubeId)) {
            LOGGER.error((Object)"[kubernetes]Query kubernetes hooks error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes kubernetes = KubeCheckUtil.checkKubeExist(kubeId);
        if (VerifyUtil.isEmpty((Object)kubernetes)) {
            LOGGER.error((Object)"Query kubernetes hooks error, cause resource is not exist. resourceId: %s", new Object[]{kubeId});
            throw new LegoCheckedException(2117645L);
        }
        List hooks = this.getService().getKubeHooks(kubeId, hookName);
        if (VerifyUtil.isEmpty((Collection)hooks)) {
            return Collections.emptyList();
        }
        ArrayList<HookVO> result = new ArrayList<HookVO>(hooks.size());
        for (HookBO bo : hooks) {
            HookVO vo = new HookVO();
            vo.setName(bo.getName());
            result.add(vo);
        }
        return result;
    }

    @Override
    @Contexts(value={@Context(name="kubernetes"), @Context(name="resourceSetName")})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="kubernetes_refresh_resourceSet_operateName", rank=3, object="$resourceSetName", detail="kubernetes_refresh_resourceSet_operateDetail", parameters={"$kubernetes?.name", "$resourceSetName"})
    public Response refreshResourceSet(String kubeId, String resourceSetName) {
        if (!ParamChecker.checkGeneralId((String)kubeId) || !ParamChecker.checkGeneralId((String)resourceSetName)) {
            LOGGER.error((Object)"[kubernetes]Refresh kubernetes error, cause resource id dont match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)kubeId) || VerifyUtil.isEmpty((String)resourceSetName)) {
            LOGGER.error((Object)"The parameter is illegal.kubeId: %s, resourceSetName: %", new Object[]{kubeId, resourceSetName});
            throw new LegoCheckedException(1073947393L);
        }
        Kubernetes cluster = KubeCheckUtil.checkKubeExist(kubeId);
        if (cluster == null) {
            LOGGER.error((Object)"Kubernetes (%s) is not exist", new Object[]{kubeId});
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)CONTAINER_CLUSTER, (Object)cluster);
        Context.Variable.set((String)RESOURCE_SET_NAME, (Object)resourceSetName);
        this.getService().refreshResourceSet(kubeId, resourceSetName, this.getCurrentUser().getUserName());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getClusterTime(String kubeId) {
        if (!ParamChecker.checkGeneralId((String)kubeId)) {
            LOGGER.error((Object)"Query kubernetes cluster system time error, cause kube id don't match pattern.");
            throw new LegoCheckedException(1073947393L);
        }
        String clusterTime = this.getService().getClusterTime(kubeId);
        JSONObject result = new JSONObject();
        result.set((Object)"clusterTime", (Object)clusterTime);
        return result.toString();
    }
}

