/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.userauth.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.rest.service.framework.license.model.LicenseTimeout;
import com.huawei.ism.drm.rest.service.framework.userauth.model.LoginRequest;
import com.huawei.ism.drm.rest.service.framework.userauth.model.LogoutVo;
import com.huawei.ism.drm.rest.service.framework.userauth.service.BaseUserAuthRestServiceImpl;
import com.huawei.ism.drm.rest.service.framework.userauth.service.IUserAuthRestService;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class UserAuthRestServiceImpl
extends BaseUserAuthRestServiceImpl
implements IUserAuthRestService {
    private static final Log LOGGER = LogFactory.getInstance(UserAuthRestServiceImpl.class);
    private static final long MAX_FREE_USE_TIME = 7776000000L;
    private static final String ADMIN_NAME = "admin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(LogoutVo logout) {
        Cookie[] cookies;
        try {
            this.getSession().removeAttribute("rd_randomStr_HW");
            this.getSession().removeAttribute("LOGIN_NEED_LIC ");
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
        }
        if (this.getRequest().getSession().getAttribute("currentUser") != null) {
            User tempUsr = (User)this.getRequest().getSession().getAttribute("currentUser");
            String sessId = tempUsr.getSession();
            try {
                IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
                mgr.logout(sessId);
            }
            finally {
                this.getSession().invalidate();
                String detailMsg = "";
                String optUser = tempUsr.getUserName();
                if (logout != null && logout.isTimeOut().booleanValue()) {
                    detailMsg = "logout_timeout_description";
                    optUser = "system";
                }
                SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog((String)"user_logout_operateName", (String)optUser, (Integer)1, (String)detailMsg, (String)tempUsr.getUserName(), (String)UserAuthRestServiceImpl.getRemoteAddr((HttpServletRequest)this.getRequest()));
                SysOpLogBuilder.writeOperateLog((SysOptLog)sysOptLog);
            }
        }
        if (null != (cookies = this.getRequest().getCookies()) && cookies.length > 0) {
            CookieUtil.invalidateCookie((HttpServletResponse)this.getResponse(), (Cookie[])cookies);
        }
        CookieUtil.addCookie((HttpServletResponse)this.getResponse(), (String)"rd_language", (String)this.setLanguage(), null);
    }

    private String setLanguage() {
        Cookie[] cookies = this.getRequest().getCookies();
        String lang = null;
        if (cookies != null) {
            lang = this.getLangFromCookies(cookies);
        }
        if (lang == null) {
            Locale defaultLocale = this.getRequest().getLocale();
            lang = defaultLocale.getLanguage();
        }
        return lang;
    }

    private String getLangFromCookies(Cookie[] cookies) {
        String lang = null;
        for (Cookie c : cookies) {
            String value = c.getValue();
            c.setSecure(true);
            if (!c.getName().equalsIgnoreCase("rd_language")) continue;
            if (!this.isValidLangCookie(value)) break;
            lang = value;
            break;
        }
        return lang;
    }

    private boolean isValidLangCookie(String value) {
        return !VerifyUtil.isEmpty((String)value) && ("zh_CN".equals(value) || "en".equals(value));
    }

    public LicenseTimeout isLicenseTimeout() {
        LicenseTimeout timeout = new LicenseTimeout();
        try {
            ISoftwareInfoService softwareService = (ISoftwareInfoService)this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
            boolean isVasa = LegoConfig.getInstance((String)"../conf/catalina.properties").getBoolean("VASA", Boolean.valueOf(false));
            SoftwareInfo softInfo = softwareService.getSoftwareInfo();
            if (isVasa || "UltraVR".equals(softInfo.getProductModel())) {
                LOGGER.debug((Object)"vasa or PRODUCT_VR, not expire.", 653110170615808L);
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
                return timeout;
            }
            this.setLicenceTimeOut(timeout);
        }
        catch (Exception e) {
            LOGGER.error((Object)("isLicenseTimeout failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            timeout.setExpire(true);
        }
        return timeout;
    }

    private void setLicenceTimeOut(LicenseTimeout timeout) {
        ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
        long sysInstallTime = mgr.getSysInstallTime();
        long curTime = System.currentTimeMillis();
        timeout.setCurTime(curTime);
        timeout.setInstallTime(sysInstallTime);
        boolean expire = curTime - sysInstallTime > 7776000000L;
        LicenseInfoBo bo = mgr.getLicenseNotUpdateUseNum();
        if (null == bo) {
            if (mgr.isDRVMPlatinic()) {
                LOGGER.debug((Object)"license isDRVMPlatinic, not expire.", 653110170615808L);
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
            } else if (mgr.isLicenseProbationTimeout()) {
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
            } else {
                timeout.setExpire(expire);
                timeout.setCurTime(curTime);
                timeout.setInstallTime(sysInstallTime);
            }
        } else {
            LOGGER.debug((Object)"license is import, not expire.", 653110170615808L);
            timeout.setExpire(false);
            timeout.setCurTime(0L);
            timeout.setInstallTime(0L);
        }
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.resetpassword"})
    @Logging(name="user_resetPWD_operateName", rank=2, object="$this.getCurrentUser().getUserName()")
    public Response adminAuth(LoginRequest loginRequest) {
        LOGGER.trace((Object)"Enter adminAuth");
        this.checkUserOperationAuthority("user_resetPWD_operateName", 2, "lego.sys.operatorMgr.operator.resetpassword");
        if (VerifyUtil.isEmpty((Object)loginRequest) || !ADMIN_NAME.equals(loginRequest.getUserName()) || VerifyUtil.isEmpty((String)loginRequest.getPwd())) {
            LOGGER.error((Object)"Param format error!");
            throw new LegoCheckedException(256L);
        }
        IUserMgr mgr = this.getUserMgrService();
        mgr.adminAuth(loginRequest.getUserName(), loginRequest.getPwd());
        return Response.ok().build();
    }

    private IUserMgr getUserMgrService() {
        Object userMgrService = this.getBundleService("user", "usermgr");
        if (!(userMgrService instanceof IUserMgr)) {
            LOGGER.error((Object)"Get user mgr Service error!");
            throw new LegoCheckedException(201L);
        }
        return (IUserMgr)userMgrService;
    }
}

