/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.report;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.model.TestStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.report.sdk.service.ITestReportService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.report.IReportRestService;
import com.huawei.ism.drm.rest.service.platform.report.ProtectGroupStatisticInfoVo;
import com.huawei.ism.drm.rest.service.platform.report.TestStatisticInfoVo;
import com.huawei.ism.drm.util.RPOMeetCaculator;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileFactory;
import com.huawei.ism.drm.web.util.FileUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class ReportRestServiceImpl
extends AbstractRestService
implements IReportRestService {
    private static final Log LOGGER = LogFactory.getInstance(ReportRestServiceImpl.class);
    private static final int TIME_24_HOURS = 24;
    private static final int TIME_3_DAYS = 3;
    private static final int TIME_7_DAYS = 7;
    private static final int TIME_30_DAYS = 30;
    private static final int ONE_MONTH = 1;
    private static final int THREE_MONTH = 3;
    private static final int SIX_MONTH = 6;
    private static final int TWELVE_MONTH = 12;
    private static final int TIME_UNIT = 60;
    private static final int DAY_UNIT = 24;
    private static final int MILLIS_UNIT = 1000;
    private static final String UNKNOWNCOUNT = "unknownCount";
    private static final String NOTMEETCOUNT = "notmeetCount";
    private static final String MEETCOUNT = "meetCount";
    private static final Map<Integer, String> POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP = new HashMap<Integer, String>();

    @Override
    @Permission(name={"ism.drm.report.protection.auth.scan"})
    public String getReportPolicyInfoList(String orderBy, String orderType, int pageSize, int startPage, int queryTime) {
        int total;
        this.checkReportParams(orderType, pageSize, startPage, queryTime);
        Page page = null;
        String orderByField = "name";
        boolean orderByAscend = true;
        if (orderBy != null) {
            orderByField = orderBy;
        }
        if (orderType != null && !orderType.equalsIgnoreCase("asc")) {
            orderByAscend = false;
        }
        List protectGroupStatisticInfoList = null;
        try {
            page = this.getProtectGroupReportService().pageQueryProtectGroupStatisticInfoByTimeRange(this.getQueryConditionForProtectReport(queryTime), orderByField, pageSize, startPage, orderByAscend, this.getCurrentUserId());
        }
        catch (Exception e) {
            LOGGER.error((Object)("excetion happened.error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            if (null != page) {
                List ppInfos;
                int total2 = (int)page.getTotalCount();
                protectGroupStatisticInfoList = ppInfos = page.getResult();
            } else {
                boolean total3 = false;
            }
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"totalCount", (Object)total);
        returnObject.put((Object)"records", (Object)this.protectGroupStatisticInfoToJsonStr(protectGroupStatisticInfoList));
        return returnObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.report.rp.auth.scan"})
    public String getTestStatusStatistic(String siteId) {
        int succNum = 0;
        int failNum = 0;
        int untestNum = 0;
        try {
            ITestReportService testReportService = (ITestReportService)this.getBundleService("DRM_Report", ITestReportService.class.getName());
            List testStatisticInfos = "-1".equals(siteId) ? testReportService.getOnlyTestStatisticInfo(DrmEnumDefine.ReportTimeRangeE.LAST_THREE_MONTHS, this.getCurrentUserId(), null) : testReportService.getOnlyTestStatisticInfo(DrmEnumDefine.ReportTimeRangeE.LAST_THREE_MONTHS, this.getCurrentUserId(), siteId);
            for (TestStatisticInfo testStatisticInfo : testStatisticInfos) {
                succNum += testStatisticInfo.getSuccessNum();
                failNum += testStatisticInfo.getTotalNum() - testStatisticInfo.getSuccessNum();
                if (testStatisticInfo.getTotalNum() != 0 || testStatisticInfo.getSuccessNum() != 0) continue;
                ++untestNum;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("getTestStatus" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
        }
        JSONArray responseData = new JSONArray();
        JSONObject successNumObj = new JSONObject();
        successNumObj.put((Object)"successCount", (Object)succNum);
        responseData.add((Object)successNumObj);
        JSONObject failNumObj = new JSONObject();
        failNumObj.put((Object)"failCount", (Object)failNum);
        responseData.add((Object)failNumObj);
        JSONObject unTestNumObj = new JSONObject();
        unTestNumObj.put((Object)"unTestCount", (Object)untestNum);
        responseData.add((Object)unTestNumObj);
        return responseData.toString();
    }

    @Override
    @Permission(name={"ism.drm.report.protection.auth.scan"})
    public String getProtectStatistics(String siteId) {
        List protectGroups = this.getProtectGroupService().queryProtectGroups(this.getCurrentUserId());
        int totalAppCount = 0;
        HashMap<Integer, Integer> validProtectObjectStat = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> invalidProtectObjectStat = new HashMap<Integer, Integer>();
        for (Object protectGroup : protectGroups) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
                LOGGER.debug((Object)"param is null");
                continue;
            }
            String productSiteId = protectGroup.getProductSiteId();
            if (!"-1".equals(siteId) && !siteId.equals(productSiteId)) continue;
            totalAppCount += protectGroup.getPolist().size();
            if (protectGroup.getStatus() == DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus() || protectGroup.getStatus() == DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus()) {
                this.statisticProtectObjectsByType(protectGroup.getPolist(), invalidProtectObjectStat);
                continue;
            }
            this.statisticProtectObjectsByType(protectGroup.getPolist(), validProtectObjectStat);
        }
        int totalValidPoNum = 0;
        for (Integer validPoNum : validProtectObjectStat.values()) {
            totalValidPoNum += validPoNum.intValue();
        }
        int totalNoProtectedPoNum = totalAppCount - totalValidPoNum;
        IProtectObjectProviderDelegate protectObjectProviderDelegate = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List supportedProtectObjects = protectObjectProviderDelegate.getSupportProtectObjectTypes();
        JSONObject responseData = new JSONObject();
        responseData.put((Object)"totalAppCount", (Object)totalAppCount);
        responseData.put((Object)"totalNoProtectedAppCount", (Object)totalNoProtectedPoNum);
        JSONArray protectionDetail = new JSONArray();
        for (ProtectObject protectObject : supportedProtectObjects) {
            int poType = protectObject.getPoType();
            int validPoNum = null == validProtectObjectStat.get(poType) ? 0 : (Integer)validProtectObjectStat.get(poType);
            int invalidPoNum = null == invalidProtectObjectStat.get(poType) ? 0 : (Integer)invalidProtectObjectStat.get(poType);
            JSONObject appProtectionStat = new JSONObject();
            appProtectionStat.put((Object)"appType", (Object)poType);
            appProtectionStat.put((Object)"protectedAppCount", (Object)validPoNum);
            appProtectionStat.put((Object)"noProtectedAppCount", (Object)invalidPoNum);
            protectionDetail.add((Object)appProtectionStat);
        }
        responseData.put((Object)"details", (Object)protectionDetail);
        return responseData.toString();
    }

    private void statisticProtectObjectsByType(Set<ProtectObject> protectObjects, Map<Integer, Integer> protectObjectStatistic) {
        if (protectObjects == null || protectObjects.isEmpty()) {
            LOGGER.debug((Object)"param is null");
            return;
        }
        for (ProtectObject protectObject : protectObjects) {
            int type = protectObject.getPoType();
            Integer appCount = protectObjectStatistic.get(type);
            appCount = appCount != null ? Integer.valueOf(appCount + 1) : Integer.valueOf(1);
            protectObjectStatistic.put(type, appCount);
        }
    }

    private String protectGroupStatisticInfoToJsonStr(List<ProtectGroupStatisticInfo> protectGroupStatisticInfoList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(protectGroupStatisticInfoList)) {
            LOGGER.debug((Object)"param is null");
            return jsonArray.toString();
        }
        List<ProtectGroupStatisticInfoVo> pgInfoVoList = this.convertVoByInfo(protectGroupStatisticInfoList, false);
        for (ProtectGroupStatisticInfoVo pgsi : pgInfoVoList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"uuid", (Object)pgsi.getPgId());
            jsonObject.put((Object)"name", (Object)pgsi.getPgName());
            jsonObject.put((Object)"poType", (Object)pgsi.getPoType());
            jsonObject.put((Object)"productSite", (Object)pgsi.getProduceSiteName());
            jsonObject.put((Object)"recoverySite", (Object)pgsi.getRecoverSiteName());
            jsonObject.put((Object)"replicationType", (Object)pgsi.getReplicationType());
            jsonObject.put((Object)"successNum", (Object)pgsi.getSuccessNum());
            jsonObject.put((Object)"totalNum", (Object)pgsi.getTotalNum());
            Map props = pgsi.getProps();
            if (props != null) {
                String rpo = (String)props.get("RPO_ITEM_KEY");
                jsonObject.put((Object)"RPO_ITEM_KEY", (Object)(rpo == null ? "[]" : rpo));
                String rto = (String)props.get("RTO_ITEM_KEY");
                jsonObject.put((Object)"RTO_ITEM_KEY", (Object)(rto == null ? "[]" : rto));
            } else {
                jsonObject.put((Object)"RPO_ITEM_KEY", (Object)"[]");
                jsonObject.put((Object)"RTO_ITEM_KEY", (Object)"[]");
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    @Override
    @Permission(name={"ism.drm.report.rp.auth.scan"})
    public String getTestReportList(String orderBy, String orderType, int pageSize, int startPage, int queryTime) {
        int total;
        this.checkReportParams(orderType, pageSize, startPage, queryTime);
        this.checkUserOperationAuthority("report_queryRemoteRecoveryPlanTestReport_operateName", SysoplogLevel.WARNING.getValue(), "ism.drm.report.rp.auth.scan");
        Page page = null;
        String orderByField = "planName";
        boolean orderByAscend = true;
        if (orderBy != null) {
            orderByField = orderBy;
        }
        if (orderType != null && !orderType.equalsIgnoreCase("asc")) {
            orderByAscend = false;
        }
        List testStatisticInfoList = null;
        try {
            ITestReportService reportService = (ITestReportService)this.getBundleService("DRM_Report", ITestReportService.class.getName(), ITestReportService.class);
            page = reportService.pageQueryTestStatisticInfoByTimeRange(this.getQueryConditionForTestReport(queryTime), orderByField, pageSize, startPage, orderByAscend, this.getCurrentUserId());
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception happened." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            if (null != page) {
                List ppInfos;
                int total2 = (int)page.getTotalCount();
                testStatisticInfoList = ppInfos = page.getResult();
            } else {
                boolean total3 = false;
            }
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"totalCount", (Object)total);
        returnObject.put((Object)"records", this.testStatisticInfoListToJsonStr(testStatisticInfoList.stream().filter(info -> info.getPoType() != 21 && info.getPoType() != 20).collect(Collectors.toList())));
        return returnObject.toString();
    }

    private void checkReportParams(String orderType, int pageSize, int startPage, int queryTime) {
        if (!Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage) || queryTime < 0) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Object testStatisticInfoListToJsonStr(List<TestStatisticInfo> testStatisticInfoList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(testStatisticInfoList)) {
            LOGGER.error((Object)"testStatisticInfoList is empty.");
            return jsonArray.toString();
        }
        for (TestStatisticInfo tsi : testStatisticInfoList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"uuid", (Object)tsi.getPlanId());
            jsonObject.put((Object)"name", (Object)tsi.getPlanName());
            jsonObject.put((Object)"poType", (Object)tsi.getPoType());
            jsonObject.put((Object)"productSite", (Object)tsi.getProductSite());
            jsonObject.put((Object)"recoverySite", (Object)tsi.getRecoverySite());
            jsonObject.put((Object)"successNum", (Object)tsi.getSuccessNum());
            jsonObject.put((Object)"totalNum", (Object)tsi.getTotalNum());
            jsonObject.put((Object)"maximumTime", (Object)tsi.getMaximumTime());
            jsonObject.put((Object)"minimumTime", (Object)tsi.getMinimumTime());
            jsonObject.put((Object)"averageTime", (Object)tsi.getAverageTime());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    private DrmEnumDefine.ReportTimeRangeE getQueryConditionForProtectReport(int timeType) {
        DrmEnumDefine.ReportTimeRangeE queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
        switch (timeType) {
            case 0: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
                break;
            }
            case 24: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_24_HOURS;
                break;
            }
            case 3: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_THREE_DAYS;
                break;
            }
            case 7: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_SEVEN_DAYS;
                break;
            }
            case 30: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_30_DAYS;
                break;
            }
        }
        return queryTime;
    }

    private DrmEnumDefine.ReportTimeRangeE getQueryConditionForTestReport(int timeType) {
        DrmEnumDefine.ReportTimeRangeE queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
        switch (timeType) {
            case 0: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.ALL_TIME;
                break;
            }
            case 1: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_ONE_MONTH;
                break;
            }
            case 3: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_THREE_MONTHS;
                break;
            }
            case 6: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_HALF_YEAR;
                break;
            }
            case 12: {
                queryTime = DrmEnumDefine.ReportTimeRangeE.LAST_ONE_YEAR;
                break;
            }
        }
        return queryTime;
    }

    @Override
    @Permission(name={"ism.drm.report.protection.auth.exportxls"})
    @Logging(name="report_exportPGExecutionReport_operateName", object="=protectedGroupExeReport_objectName")
    public Response exportProtectGroupReport() {
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        List ppInfos = this.getProtectGroupReportService().getAllProtectGroupExecutedInfo(this.getCurrentUserId());
        List<ProtectGroupStatisticInfoVo> ppReportInfoList = this.convertVoByInfo(ppInfos, true);
        FileUtil fileUtil = FileFactory.getFileUtil((int)1, (String)"com.huawei.ism.drm.rest.service.platform.report.util.ExportProtectGroupReportUtil");
        if (fileUtil == null) {
            LOGGER.error((Object)"fileUtil is null");
            throw new LegoCheckedException(0x300001L);
        }
        fileUtil.fileSet("", this.getColumnTitleForExportPGReport(), FileUtil.createFilePath((HttpServletRequest)this.getRequest(), (String)"ExportProtectGroupReport_", (String)"xlsx"), ppReportInfoList, null, (AbstractRestService)this);
        fileUtil.downloadFile(this.getResponse());
        return Response.ok().build();
    }

    private List<ProtectGroupStatisticInfoVo> convertVoByInfo(List<ProtectGroupStatisticInfo> ppInfo, Boolean isExport) {
        ArrayList<ProtectGroupStatisticInfoVo> ppReportInfoList = new ArrayList<ProtectGroupStatisticInfoVo>();
        if (VerifyUtil.isEmpty(ppInfo)) {
            LOGGER.debug((Object)"param is null");
            return ppReportInfoList;
        }
        for (ProtectGroupStatisticInfo pp : ppInfo) {
            ProtectGroupStatisticInfoVo ppVo = new ProtectGroupStatisticInfoVo();
            ppVo.setPoType(pp.getPoType());
            ppVo.setPgId(pp.getPgId());
            ppVo.setPgName(pp.getPgName());
            ppVo.setPpTypeStr(this.getTypeLabelByType(pp.getReplicationType(), isExport));
            String productSite = pp.getProductSite();
            ppVo.setProduceSiteName(productSite);
            String recoverySite = pp.getRecoverySite();
            ppVo.setRecoverSiteName(recoverySite);
            ppVo.setPoTypeStr(this.getPoTypeLabel(pp.getPoType(), isExport));
            ppVo.setPoType(pp.getPoType());
            ppVo.setTotalNum(pp.getTotalNum());
            ppVo.setSuccessNum(pp.getSuccessNum());
            ppVo.setReplicationType(pp.getReplicationType());
            ppVo.setFailedNum(pp.getTotalNum() - pp.getSuccessNum());
            ppVo.setProps(pp.getProps());
            ppReportInfoList.add(ppVo);
        }
        return ppReportInfoList;
    }

    protected String getPoTypeLabel(int poType, Boolean isExport) {
        String key = "--";
        switch (poType) {
            case 11: 
            case 99: {
                key = "ism.drm.app.type.storage.lun";
                break;
            }
            case 1: {
                key = "ism.drm.app.type.oracle";
                break;
            }
            case 2: {
                key = "ism.drm.app.type.sqlserver";
                break;
            }
            case 3: {
                key = "ism.drm.app.type.db2";
                break;
            }
            case 8: 
            case 13: {
                key = "Protection.term.Exchange.label";
                break;
            }
            case 9: {
                key = "Protection.term.localFS.label";
                break;
            }
            case 10: {
                key = "Protection.term.VMwareVM.label";
                break;
            }
            case 12: {
                key = "Protection.term.HWVM.label";
                break;
            }
            case 14: {
                key = "protection_term_nasFS_label";
                break;
            }
            case 20: {
                key = "resourceset_set_type_label";
                break;
            }
            case 21: {
                key = "persistent_volume_type_label";
                break;
            }
            case 19: {
                key = "ism.drm.app.type.opengauss";
                break;
            }
        }
        return isExport != false ? this.getText(key) : key;
    }

    private String getTypeLabelByType(int type, Boolean isExport) {
        String key = POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.get(type);
        if (!VerifyUtil.isEmpty((String)key)) {
            return isExport != false ? this.getText(key) : key;
        }
        return "--";
    }

    @Override
    @Permission(name={"ism.drm.report.rp.auth.exportxls"})
    @Logging(name="report_exportRemoteRecoveryPlanTestReport_operateName", object="=recoveryTestReport_objectName")
    public Response exportRecoveryPlanTestReport() {
        ITestReportService reportService = (ITestReportService)this.getBundleService("DRM_Report", ITestReportService.class.getName(), ITestReportService.class);
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        List ppInfos = reportService.getAllTestStatisticInfo(this.getCurrentUserId());
        List<TestStatisticInfoVo> recoveryReportVos = this.convertVoByInfoForRp(ppInfos);
        FileUtil fileUtil = FileFactory.getFileUtil((int)1, (String)"com.huawei.ism.drm.rest.service.platform.report.util.ExportDrpReportUtil");
        if (null == fileUtil) {
            LOGGER.error((Object)"fileUtil is null");
            throw new LegoCheckedException(0x300001L);
        }
        fileUtil.fileSet("", this.getColumnTitleForExportDrpReport(), FileUtil.createFilePath((HttpServletRequest)this.getRequest(), (String)"ExportRecoveryPlanTest_", (String)"xlsx"), recoveryReportVos, this.constructDataRowsForDrp(recoveryReportVos), (AbstractRestService)this);
        fileUtil.downloadFile(this.getResponse());
        return Response.ok().build();
    }

    private List<List<String>> constructDataRowsForDrp(List<TestStatisticInfoVo> voDatas) {
        if (voDatas == null) {
            LOGGER.debug((Object)"param is null");
            return null;
        }
        ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
        for (TestStatisticInfoVo data : voDatas) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(data.getPlanName());
            rowData.add(data.getProduceSiteName());
            rowData.add(data.getRecoverSiteName());
            rowData.add(data.getPoTypeStr());
            rowData.add(data.getSuccessNum() + "");
            rowData.add(data.getTotalNum() - data.getSuccessNum() + "");
            rowData.add(this.formatTime(data.getMaximumTime()));
            rowData.add(this.formatTime(data.getMinimumTime()));
            rowData.add(this.formatTime(data.getAverageTime()));
            rowDataList.add(rowData);
        }
        return rowDataList;
    }

    private List<TestStatisticInfoVo> convertVoByInfoForRp(List<TestStatisticInfo> testInfos) {
        ArrayList<TestStatisticInfoVo> recoveryReportVos = new ArrayList<TestStatisticInfoVo>();
        if (VerifyUtil.isEmpty(testInfos)) {
            LOGGER.debug((Object)"param is null");
            return recoveryReportVos;
        }
        for (TestStatisticInfo drp : testInfos) {
            TestStatisticInfoVo drpVo = new TestStatisticInfoVo();
            drpVo.setPlanId(drp.getPlanId());
            drpVo.setPlanName(drp.getPlanName());
            String productSite = drp.getProductSite();
            drpVo.setProductSite(productSite);
            String recoverySite = drp.getRecoverySite();
            drpVo.setRecoverySite(recoverySite);
            String localProductSite = productSite;
            drpVo.setProduceSiteName(CommUtils.containIp((String)productSite) ? productSite : localProductSite);
            String localRecoverySiteName = recoverySite;
            drpVo.setRecoverSiteName(CommUtils.containIp((String)recoverySite) ? recoverySite : localRecoverySiteName);
            drpVo.setPoType(drp.getPoType());
            drpVo.setPoTypeStr(this.getPoTypeLabel(drp.getPoType(), true));
            drpVo.setAverageTime(drp.getAverageTime());
            drpVo.setMaximumTime(drp.getMaximumTime());
            drpVo.setMinimumTime(drp.getMinimumTime());
            drpVo.setSuccessNum(drp.getSuccessNum());
            drpVo.setTotalNum(drp.getTotalNum());
            drpVo.setFailedNum(drp.getTotalNum() - drp.getSuccessNum());
            drpVo.setMaxmunTimeStr(this.formatTime(drp.getMaximumTime()));
            drpVo.setMinmunTimeStr(this.formatTime(drp.getMinimumTime()));
            drpVo.setAverageTimeStr(this.formatTime(drp.getAverageTime()));
            recoveryReportVos.add(drpVo);
        }
        return recoveryReportVos;
    }

    public String formatTime(double millisL) {
        if (Math.abs(millisL - 0.0) < Double.MIN_VALUE) {
            LOGGER.debug((Object)"param is 0");
            return "--";
        }
        double day = 0.0;
        double hour = 0.0;
        double minute = 0.0;
        double second = millisL / 1000.0;
        if (second > 60.0) {
            minute = second / 60.0;
            second %= 60.0;
        }
        if (minute > 60.0) {
            hour = minute / 60.0;
            minute %= 60.0;
        }
        if (hour > 24.0) {
            day = hour / 24.0;
            hour %= 24.0;
        }
        return this.getText("ism.drm.average.time.label", new String[]{(int)day + "", (int)hour + "", (int)minute + "", (int)second + ""});
    }

    private List<String> getColumnTitleForExportDrpReport() {
        ArrayList<String> headName = new ArrayList<String>();
        headName.add(this.getText("ism.drm.protect.policy.name"));
        headName.add(this.getText("ism.drm.site.master"));
        headName.add(this.getText("ism.drm.site.standby"));
        headName.add(this.getText("ism.drm.po.type.column"));
        headName.add(this.getText("ism.drm.report.run.success.excel.column"));
        headName.add(this.getText("ism.drm.report.run.faild.excel.column"));
        headName.add(this.getText("ism.drm.test.drilling.longest"));
        headName.add(this.getText("ism.drm.test.drilling.shortest"));
        headName.add(this.getText("ism.drm.drilling.average.time.column"));
        return headName;
    }

    private List<String> getColumnTitleForExportPGReport() {
        ArrayList<String> headNames = new ArrayList<String>();
        headNames.add(this.getText("ism.drm.protect.policy.name"));
        headNames.add(this.getText("protect_template_title"));
        headNames.add(this.getText("ism.drm.site.master"));
        headNames.add(this.getText("ism.drm.site.standby"));
        headNames.add(this.getText("ism.drm.po.type.column"));
        headNames.add(this.getText("ism.drm.po.cfgRPO"));
        headNames.add(this.getText("ism.drm.po.actualRPO"));
        headNames.add(this.getText("ism.drm.po.estimateRTO"));
        headNames.add(this.getText("ism.drm.report.run.success.excel.column"));
        headNames.add(this.getText("ism.drm.report.run.faild.excel.column"));
        return headNames;
    }

    @Override
    @Permission(name={"ism.drm.report.rp.auth.scan"})
    public String getRpTestTimeStatisticInfo(String siteId) {
        ITestReportService testReportService = (ITestReportService)this.getBundleService("DRM_Report", ITestReportService.class.getName());
        List testStatisticInfos = "-1".equals(siteId) ? testReportService.getOnlyTestStatisticInfo(DrmEnumDefine.ReportTimeRangeE.LAST_THREE_MONTHS, this.getCurrentUserId(), null) : testReportService.getOnlyTestStatisticInfo(DrmEnumDefine.ReportTimeRangeE.LAST_THREE_MONTHS, this.getCurrentUserId(), siteId);
        int level1 = 0;
        int level2 = 0;
        int level3 = 0;
        int level4 = 0;
        for (TestStatisticInfo testStatisticInfo : testStatisticInfos) {
            level1 += testStatisticInfo.getLess15minTimes();
            level2 += testStatisticInfo.getLess30minTimes();
            level3 += testStatisticInfo.getLess60minTimes();
            level4 += testStatisticInfo.getOtherTimes();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"level1", (Object)level1);
        jsonObject.put((Object)"level2", (Object)level2);
        jsonObject.put((Object)"level3", (Object)level3);
        jsonObject.put((Object)"level4", (Object)level4);
        return jsonObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.report.protection.auth.scan"})
    public Map<String, Integer> getRpoMetStatisticInfo(String siteId) {
        List pgs = this.getProtectGroupService().queryProtectGroups(this.getCurrentUserId());
        HashMap<String, Integer> statMap = new HashMap<String, Integer>();
        statMap.put(UNKNOWNCOUNT, 0);
        statMap.put(NOTMEETCOUNT, 0);
        statMap.put(MEETCOUNT, 0);
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            LOGGER.debug((Object)"param is null");
            return statMap;
        }
        for (ProtectGroup pg : pgs) {
            String productSiteId = pg.getProductSiteId();
            if (!"-1".equals(siteId) && !siteId.equals(productSiteId) || pg.getStatus() == DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus()) continue;
            Map props = pg.getProps();
            JSONArray jsonArray = null;
            String rpoStr = (String)props.get("RPO_ITEM_KEY");
            if (VerifyUtil.isEmpty((String)rpoStr)) {
                statMap.put(UNKNOWNCOUNT, (Integer)statMap.get(UNKNOWNCOUNT) + 1);
                continue;
            }
            try {
                jsonArray = JSONArray.fromObject((Object)rpoStr);
            }
            catch (Exception e) {
                LOGGER.error((Object)"getRpoMetStatisticInfo error!", -1L);
                statMap.put(UNKNOWNCOUNT, (Integer)statMap.get(UNKNOWNCOUNT) + 1);
                continue;
            }
            int result = RPOMeetCaculator.calculateSinglePgRPOMet((JSONArray)jsonArray);
            this.countRPO(statMap, result);
        }
        return statMap;
    }

    private void countRPO(Map<String, Integer> statMap, int result) {
        if (result == -2) {
            statMap.put(UNKNOWNCOUNT, statMap.get(UNKNOWNCOUNT) + 1);
        } else if (result == -1) {
            statMap.put(NOTMEETCOUNT, statMap.get(NOTMEETCOUNT) + 1);
        } else {
            statMap.put(MEETCOUNT, statMap.get(MEETCOUNT) + 1);
        }
    }

    @Override
    @Permission(name={"ism.drm.report.rp.auth.scan"})
    public String recoverylogs(int pageSize, int startPage) {
        if (!Validator.checkPageQueryParams((int)pageSize, (int)startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject resultObject = new JSONObject();
        Page page = this.getRecoveryPlanService().pageQueryRecoveryLog(startPage, pageSize, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            LOGGER.debug((Object)("param is null.page:" + page));
            return "";
        }
        List recoveryLogs = page.getResult();
        JSONArray result = this.constructRecoveryLogJsonObj(recoveryLogs);
        resultObject.put((Object)"totalCount", (Object)page.getTotalCount());
        resultObject.put((Object)"records", (Object)result);
        return resultObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.report.protection.auth.scan"})
    public String protectgrouplogs(int pageSize, int startPage) {
        if (!Validator.checkPageQueryParams((int)pageSize, (int)startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject resultObject = new JSONObject();
        Page page = this.getProtectGroupReportService().pageQueryProtectGroupLog(startPage, pageSize, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            LOGGER.debug((Object)("param is null.page:" + page));
            return "";
        }
        List protectGroupLogs = page.getResult();
        JSONArray result = this.constructPgLogJsonObj(protectGroupLogs);
        resultObject.put((Object)"totalCount", (Object)page.getTotalCount());
        resultObject.put((Object)"records", (Object)result);
        return resultObject.toString();
    }

    protected IRecoveryPlanService getRecoveryPlanService() {
        return (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
    }

    protected IProtectGroupService getProtectGroupService() {
        return (IProtectGroupService)this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
    }

    protected IProtectGroupReportService getProtectGroupReportService() {
        return (IProtectGroupReportService)this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName(), IProtectGroupReportService.class);
    }

    private JSONArray constructRecoveryLogJsonObj(List<RecoveryLog> recoveryLogs) {
        JSONArray result = new JSONArray();
        for (RecoveryLog rplog : recoveryLogs) {
            JSONObject logJsonObj = new JSONObject();
            logJsonObj.put((Object)"logId", (Object)rplog.getLogId());
            logJsonObj.put((Object)"logType", (Object)rplog.getLogType());
            logJsonObj.put((Object)"logStatus", (Object)rplog.getLogStatus());
            logJsonObj.put((Object)"operator", (Object)rplog.getOperator());
            logJsonObj.put((Object)"logName", (Object)rplog.getLogName());
            if (VerifyUtil.isEmpty((String)rplog.getStartTime())) {
                logJsonObj.put((Object)"startTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"startTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rplog.getStartTime()))));
            }
            if (VerifyUtil.isEmpty((String)rplog.getEndTime())) {
                logJsonObj.put((Object)"endTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"endTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rplog.getEndTime()))));
            }
            String executeTime = this.calcExecuteTime(rplog.getStartTime(), rplog.getEndTime());
            logJsonObj.put((Object)"executeTime", (Object)executeTime);
            logJsonObj.put((Object)"planId", (Object)rplog.getPlanId());
            RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(rplog.getPlanId());
            logJsonObj.put((Object)"planName", (Object)rp.getName());
            logJsonObj.put((Object)"planProgress", (Object)rp.getPlanProgress());
            result.add((Object)logJsonObj);
        }
        return result;
    }

    private JSONArray constructPgLogJsonObj(List<ProtectGroupLog> protectGroupLogs) {
        JSONArray result = new JSONArray();
        for (ProtectGroupLog pglog : protectGroupLogs) {
            JSONObject logJsonObj = new JSONObject();
            logJsonObj.put((Object)"logId", (Object)pglog.getHistoryLogId());
            logJsonObj.put((Object)"result", (Object)pglog.getResult());
            if (VerifyUtil.isEmpty((String)pglog.getStartTime())) {
                logJsonObj.put((Object)"startTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"startTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)pglog.getStartTime()))));
            }
            if (VerifyUtil.isEmpty((String)pglog.getEndTime())) {
                logJsonObj.put((Object)"endTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"endTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)pglog.getEndTime()))));
            }
            String executeTime = this.calcExecuteTime(pglog.getStartTime(), pglog.getEndTime());
            logJsonObj.put((Object)"executeTime", (Object)executeTime);
            logJsonObj.put((Object)"pgId", (Object)pglog.getPgId());
            logJsonObj.put((Object)"pgName", (Object)pglog.getPgName());
            result.add((Object)logJsonObj);
        }
        return result;
    }

    static {
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(0, "array.replica.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(1, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(2, "array.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(44, "array.san.airgap.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(48, "array.san.activeactive.async.ring.airgap.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(45, "array.nas.airgap.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(46, "array.nas.airgap.antiblackmail.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(3, "array.cascade3dc.syncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(4, "array.cascade3dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(5, "array.concurrent3dc.syncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(6, "array.concurrent3dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(11, "host.base.replica.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(14, "array.snapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(16, "array.clone.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(19, "array.activeactive.storageSnapshot.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(17, "array.integratedBackup.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(28, "array.hyperMetroVault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(20, "array.async.activeactive.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(18, "array.activeactive.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(21, "array.replica.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(22, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(34, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(37, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(35, "array.cascade4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(36, "array.concurrent4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(33, "array.replica.async.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(58, "array.cascade4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(59, "array.concurrent4dc.asyncasync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(40, "array.cascade4dc.syncasync.vault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(41, "array.concurrent4dc.syncasync.vault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(42, "array.cascade4dc.asyncasync.vault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(43, "array.concurrent4dc.asyncasync.vault.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(47, "oracle.allflash.integrate.sync.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(49, "kube.resource.set.local.backup.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(50, "kube.resource.set.remote.backup.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(54, "kube.resource.set.replication.name");
        POLICYTEMPLATE_TYPE_RESOURCE_KEY_MAP.put(55, "kube.persistent.volume.replication.name");
    }
}

