/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.storage;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.StorageEnumDefine;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.storage.IStorageResourcePoolRestService;
import com.huawei.ism.drm.rest.util.DrmStorageUtil;
import com.huawei.ism.drm.storage.sdk.model.StoragePoolResource;
import com.huawei.ism.drm.storage.sdk.model.StorageResourcePool;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageResourcePoolRestServiceImpl
extends AbstractRestService
implements IStorageResourcePoolRestService {
    private static final Log LOGGER = LogFactory.getInstance(StorageResourcePoolRestServiceImpl.class);
    private static final String POOL = "pool";
    @Autowired
    private PermissionService permissionService;

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getStorageResourcePools(String deviceSn, int type) {
        if (StorageEnumDefine.ResourcePoolEnum.getType((int)type) == null) {
            LOGGER.error((Object)("enter getStorageResourcePools.deviceSn:" + deviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        List resourcePools = storagePoolService.getStorageResourcePools(deviceSn, StorageEnumDefine.ResourcePoolEnum.getType((int)type));
        JSONArray result = this.convertPoolsToJSONString(resourcePools);
        return result.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getStorageResourcePool(String uuid) {
        String[] deviceSNs;
        if (VerifyUtil.isEmpty((String)uuid)) {
            LOGGER.error((Object)("enter getStorageResourcePool.uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePool = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePool) {
            throw new LegoCheckedException(1073947394L);
        }
        String resourceProviderSN = resourcePool.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        return this.convertPoolToJSONObject(resourcePool).toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String storageResources(String uuid, String orderBy, String orderType, int pageSize, int startPage, int resourceType) {
        String[] deviceSNs;
        if (!"name".equals(orderBy)) {
            orderBy = "name";
        }
        if (!"asc".equals(orderType)) {
            orderType = "asc";
        }
        if (1024 != pageSize) {
            pageSize = 1024;
        }
        if (0 != startPage) {
            startPage = 0;
        }
        if (VerifyUtil.isEmpty((String)uuid) || !Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage) || null == DrmEnumDefine.ResourceTypeE.getType((int)resourceType)) {
            LOGGER.error((Object)("enter storageResources.uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePool = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePool) {
            throw new LegoCheckedException(1073947394L);
        }
        String resourceProviderSN = resourcePool.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        Page page = storagePoolService.storageResources(uuid, orderBy, orderType, pageSize, startPage, DrmEnumDefine.ResourceTypeE.getType((int)resourceType));
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.convertPoolResourceToJSONString(page.getResult()));
        return result.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_storage_createPool_operateName", object="$1?.name")
    public Response createStorageResourcePool(StorageResourcePool storageResourcePool) {
        if (null == storageResourcePool) {
            LOGGER.error((Object)"enter createStorageResourcePool");
            throw new LegoCheckedException(1073947393L);
        }
        String name = storageResourcePool.getName();
        String desc = storageResourcePool.getDescription();
        int type = storageResourcePool.getType();
        this.checkPoolParams(storageResourcePool, name, desc, type);
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        ArrayList<String> resourceUuids = new ArrayList<String>();
        for (StorageResource resource : storageResourcePool.getResourceList()) {
            resourceUuids.add(resource.getUuid());
        }
        IStorageResourceService resourceService = this.getStorageResourceService();
        List storageReosurcesInDB = resourceService.getStorageResourcesByUuid(resourceUuids, StorageResource.class);
        if (!VerifyUtil.isEmpty((Collection)storageReosurcesInDB)) {
            for (StorageResource storageResource : storageReosurcesInDB) {
                this.permissionService.checkUserMoAuthority((Object)storageResource.getDevSn());
            }
        }
        storagePoolService.createStorageResourcePool(name, desc, StorageEnumDefine.ResourcePoolEnum.getType((int)type), resourceUuids);
        return Response.ok().build();
    }

    private void checkPoolParams(StorageResourcePool storageResourcePool, String name, String desc, int type) {
        if (!CommUtil.checkDrmNameParam((String)name) || !CommUtil.checkDrmDescParam((String)desc) || null == StorageEnumDefine.ResourcePoolEnum.getType((int)type) || VerifyUtil.isEmpty((Collection)storageResourcePool.getResourceList())) {
            LOGGER.error((Object)("enter checkPoolParams.name:" + name));
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Context(name="pool")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_storage_deletePool_operateName", rank=2, object="$pool?.name")
    public Response deleteStorageResourcePool(String uuid) {
        String[] deviceSNs;
        if (VerifyUtil.isEmpty((String)uuid)) {
            LOGGER.error((Object)("enter deleteStorageResourcePool.uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePoolInDB = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePoolInDB) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)POOL, (Object)resourcePoolInDB);
        String resourceProviderSN = resourcePoolInDB.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        storagePoolService.deleteStorageResourcePool(uuid);
        return Response.ok().build();
    }

    @Override
    @Context(name="pool")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_storage_modifyPool_operateName", rank=3, object="$pool?.name", detail="site_storage_modifyPool_operateDetail", parameters={"$pool?.name", "$2?.name"})
    public Response modifyStorageResourcePool(String uuid, StorageResourcePool resourcePool) {
        String[] deviceSNs;
        if (VerifyUtil.isEmpty((String)uuid) || null == resourcePool) {
            LOGGER.error((Object)("uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        String name = resourcePool.getName();
        String desc = resourcePool.getDescription();
        if (!CommUtil.checkDrmNameParam((String)name) || !CommUtil.checkDrmDescParam((String)desc)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePoolInDB = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePoolInDB) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)POOL, (Object)resourcePoolInDB);
        String resourceProviderSN = resourcePoolInDB.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        storagePoolService.modifyStorageResourcePool(uuid, name, desc);
        return Response.ok().build();
    }

    @Override
    @Context(name="pool")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_storage_addResource2Pool_operateName", object="$pool?.name")
    public Response addResources(String uuid, List<String> resourceList) {
        IStorageResourcePoolService storagePoolService;
        StorageResourcePool resourcePoolInDB;
        if (VerifyUtil.isEmpty((String)uuid) || VerifyUtil.isEmpty(resourceList)) {
            LOGGER.error((Object)("uuid:" + uuid));
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("site_storage_addResource2Pool_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        IStorageResourceService resourceService = this.getStorageResourceService();
        List storageResourcesInDB = resourceService.getStorageResourcesByUuid(resourceList, StorageResource.class);
        if (!VerifyUtil.isEmpty((Collection)storageResourcesInDB)) {
            for (StorageResource storageResource : storageResourcesInDB) {
                this.permissionService.checkUserMoAuthority((Object)storageResource.getDevSn());
            }
        }
        if (null == (resourcePoolInDB = (storagePoolService = this.getStorageResourcePoolService()).getStorageReosurcePool(uuid))) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)POOL, (Object)resourcePoolInDB);
        storagePoolService.addResources(uuid, resourceList.toArray(new String[resourceList.size()]));
        return Response.ok().build();
    }

    @Override
    @Context(name="pool")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_storage_removeResourceFromPool_operateName", rank=2, object="$pool?.name")
    public Response removeResources(String uuid, List<String> resourceList) {
        String[] deviceSNs;
        if (VerifyUtil.isEmpty((String)uuid) || VerifyUtil.isEmpty(resourceList)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("site_storage_removeResourceFromPool_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePoolInDB = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePoolInDB) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)POOL, (Object)resourcePoolInDB);
        String resourceProviderSN = resourcePoolInDB.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        storagePoolService.removeResources(uuid, resourceList.toArray(new String[0]));
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getAvailableStorageResources(String deviceSn) {
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        List storageResources = storagePoolService.getAvailableStorageResources(deviceSn, DrmEnumDefine.ResourceTypeE.LUN);
        JSONArray result = this.convertToJSONString(storageResources);
        return result.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getStorageResourcesStatistic(String uuid, int templateType, List<StorageResource> excludedResources) {
        String[] deviceSNs;
        if (VerifyUtil.isEmpty((String)uuid) || "-1".equals(uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = this.getStorageResourcePoolService();
        StorageResourcePool resourcePoolInDB = storagePoolService.getStorageReosurcePool(uuid);
        if (null == resourcePoolInDB) {
            throw new LegoCheckedException(1073947394L);
        }
        String resourceProviderSN = resourcePoolInDB.getResourceProvider();
        for (String deviceSn : deviceSNs = resourceProviderSN.split(",")) {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        List storagePoolResources = storagePoolService.getUnusedStorageResources(uuid, DrmEnumDefine.ResourceTypeE.LUN);
        HashMap<String, StorageResource> excludedResourceMap = new HashMap<String, StorageResource>();
        if (!VerifyUtil.isEmpty(excludedResources)) {
            for (StorageResource resource : excludedResources) {
                excludedResourceMap.put(resource.getUuid(), resource);
            }
        }
        ArrayList<StorageResource> storageResources = new ArrayList<StorageResource>();
        if (!VerifyUtil.isEmpty((Collection)storagePoolResources)) {
            for (StoragePoolResource poolResource : storagePoolResources) {
                if (null != excludedResourceMap.get(poolResource.getStorageResource().getUuid())) continue;
                storageResources.add(poolResource.getStorageResource());
            }
        }
        return DrmStorageUtil.getStorageResourceStatisticByLun(storageResources, templateType);
    }

    private JSONArray convertToJSONString(List<StorageResource> storageResources) {
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(storageResources)) {
            return result;
        }
        for (StorageResource storageResource : storageResources) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"uuid", (Object)storageResource.getUuid());
            jsonObj.put((Object)"name", (Object)storageResource.getName());
            jsonObj.put((Object)"deviceSn", (Object)storageResource.getDevSn());
            jsonObj.put((Object)"resourceId", (Object)storageResource.getResourceId());
            jsonObj.put((Object)"identifier", (Object)storageResource.getResourceIndentifier());
            double totalCapacity = UnitConvert.convert((double)storageResource.getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)storageResource.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.MB, (int)3);
            jsonObj.put((Object)"totalCapacity", (Object)totalCapacity);
            String displayTotalCapacity = CapacityUnitUtil.getCapacityAndUnit((Double)totalCapacity, (CapabilityUnitType)CapabilityUnitType.MB);
            jsonObj.put((Object)"displayTotalCapacity", (Object)displayTotalCapacity);
            this.fillResponseResultByLun(storageResource, jsonObj);
            result.add((Object)jsonObj);
        }
        return result;
    }

    private JSONArray convertPoolResourceToJSONString(List<StoragePoolResource> storagePoolResources) {
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(storagePoolResources)) {
            return result;
        }
        for (StoragePoolResource poolResource : storagePoolResources) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"uuid", (Object)poolResource.getStorageResource().getUuid());
            jsonObj.put((Object)"name", (Object)poolResource.getStorageResource().getName());
            jsonObj.put((Object)"deviceSn", (Object)poolResource.getStorageResource().getDevSn());
            jsonObj.put((Object)"resourceId", (Object)poolResource.getStorageResource().getResourceId());
            jsonObj.put((Object)"identifier", (Object)poolResource.getStorageResource().getResourceIndentifier());
            double totalCapacity = UnitConvert.convert((double)poolResource.getStorageResource().getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)poolResource.getStorageResource().getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.MB, (int)3);
            jsonObj.put((Object)"totalCapacity", (Object)totalCapacity);
            String displayTotalCapacity = CapacityUnitUtil.getCapacityAndUnit((Double)totalCapacity, (CapabilityUnitType)CapabilityUnitType.MB);
            jsonObj.put((Object)"displayTotalCapacity", (Object)displayTotalCapacity);
            jsonObj.put((Object)"isUsed", (Object)poolResource.getIsUsed());
            this.fillResponseResultByLun(poolResource.getStorageResource(), jsonObj);
            result.add((Object)jsonObj);
        }
        return result;
    }

    private JSONArray convertPoolsToJSONString(List<StorageResourcePool> storageResourcePools) {
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(storageResourcePools)) {
            LOGGER.debug((Object)"enter convertPoolsToJSONString.");
            return result;
        }
        for (StorageResourcePool storageResourcePool : storageResourcePools) {
            result.add((Object)this.convertPoolToJSONObject(storageResourcePool));
        }
        return result;
    }

    private JSONObject convertPoolToJSONObject(StorageResourcePool storageResourcePool) {
        JSONObject jsonObj = new JSONObject();
        if (VerifyUtil.isEmpty((Object)storageResourcePool)) {
            LOGGER.debug((Object)("enter convertPoolToJSONObject.storageResourcePool:" + storageResourcePool));
            return jsonObj;
        }
        jsonObj.put((Object)"uuid", (Object)storageResourcePool.getUuid());
        jsonObj.put((Object)"name", (Object)storageResourcePool.getName());
        jsonObj.put((Object)"deviceSn", (Object)storageResourcePool.getResourceProvider());
        jsonObj.put((Object)"type", (Object)storageResourcePool.getType());
        jsonObj.put((Object)"description", (Object)storageResourcePool.getDescription());
        return jsonObj;
    }

    private void fillResponseResultByLun(StorageResource storageResource, JSONObject jsonObj) {
        if (!(storageResource instanceof Lun)) {
            return;
        }
        Lun lun = (Lun)storageResource;
        jsonObj.put((Object)"type", (Object)lun.getResourceType());
        jsonObj.put((Object)"controllerId", (Object)lun.getControllerName());
        JSONObject storagePool = new JSONObject();
        if (storageResource instanceof XveLun) {
            XveLun xveLun = (XveLun)storageResource;
            storagePool.put((Object)"poolId", (Object)xveLun.getStoragePoolId());
            storagePool.put((Object)"name", (Object)xveLun.getStoragePoolName());
        } else {
            storagePool.put((Object)"poolId", (Object)"--");
            storagePool.put((Object)"name", (Object)"--");
        }
        jsonObj.put((Object)"storagePool", (Object)storagePool.toString());
    }

    private IStorageResourcePoolService getStorageResourcePoolService() {
        return (IStorageResourcePoolService)this.getBundleService("DRM_Base", IStorageResourcePoolService.class.getName());
    }

    private IStorageResourceService getStorageResourceService() {
        return (IStorageResourceService)this.getBundleService("DRM_Base", IStorageResourceService.class.getName());
    }
}

