/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.listener.SessionListener;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SystemSecurityFilter
implements Filter {
    public static final String VALID_URIS = "validUris";
    public static final String VALID_REFRESH_URIS = "validRefreshUris";
    public static final String CURRENT_USER_SESSION = "currentUser";
    private static final Log logger = LogFactory.getInstance(SystemSecurityFilter.class);
    private static final Log RESTCLIENTLOG = LogFactory.getInstance((Object)"3rd_rest_client_log");
    private static final String PAGE_LOGIN = "/src/index.html";
    private static final String FIRST_LOGIN_REDIRECT_PAGE = "/src/index.html";
    private static final String LOGOUT_URI = "/ws/auth/logout";
    private static final String HTTP_METHOD_GET = "GET";
    private static final List<String> CLOUD_URIS = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om");
    private static final Map<String, String> sessionIdMap = new HashMap<String, String>();
    private final Map<String, String> loginMap = new HashMap<String, String>();
    private final Map<String, String> refreshMap = new HashMap<String, String>();
    private final Map<String, String> firstLoginMap = new HashMap<String, String>();
    private final List<String> noAuthResources = new ArrayList<String>();

    private static void setResponseHeaderWithUri(HttpServletResponse httpResponse, String uri) {
        if (!uri.startsWith("/help")) {
            httpResponse.setHeader("content-type", "application/json;charset=UTF-8");
        }
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setHeader("Cache", "no-cache");
        httpResponse.setHeader("Expires", "0");
        httpResponse.setHeader("Cache-Control", "no-store, must-revalidate");
        httpResponse.setHeader("Content-Security-Policy", "connect-src 'self';object-src 'self';frame-src 'self';media-src 'self';font-src 'self'");
        httpResponse.setHeader("Content-Security-Policy-Report-Only", "''");
        httpResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
    }

    public static boolean isCloudRestService(String uri) {
        for (String s : CLOUD_URIS) {
            if (!uri.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static String getMachineInterfaceVisitorName(HttpServletRequest httpRequest, String uri) {
        String authUser = httpRequest.getHeader("x-auth-user");
        String authPwd = httpRequest.getHeader("x-auth-key");
        if (uri.startsWith("/ws") && null != authUser && null != authPwd) {
            return authUser;
        }
        return null;
    }

    public static boolean checkNoAuthResources(List<String> noAuthResources, String uri, String method) {
        if (!HTTP_METHOD_GET.equalsIgnoreCase(method)) {
            return false;
        }
        for (String type : noAuthResources) {
            if (!uri.endsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRestRequest(String uri) {
        if (null == uri || uri.isEmpty()) {
            return false;
        }
        return uri.startsWith("/ws/");
    }

    public static boolean checkUriAndMethod(Map<String, String> map, String uri, String method) {
        if (null == map || map.isEmpty()) {
            return false;
        }
        if (null == map.get(uri)) {
            return false;
        }
        return method.equalsIgnoreCase(map.get(uri));
    }

    public static List<String> addNoAuthResources(List<String> noAuthResources) {
        noAuthResources.add(".css");
        noAuthResources.add(".png");
        noAuthResources.add(".gif");
        noAuthResources.add(".jpg");
        noAuthResources.add(".ico");
        noAuthResources.add(".svg");
        noAuthResources.add(".ttf");
        noAuthResources.add(".js");
        noAuthResources.add(".json");
        noAuthResources.add(".mp3");
        return noAuthResources;
    }

    public void destroy() {
        this.loginMap.clear();
        this.refreshMap.clear();
        this.firstLoginMap.clear();
        this.noAuthResources.clear();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = UriUtil.getNormalizeRequestServletUri((HttpServletRequest)httpRequest);
        if (SystemSecurityFilter.isCloudRestService(uri)) {
            RESTCLIENTLOG.info((Object)String.format(Locale.getDefault(), "IpAddress %s send request uri %s:%s.", httpRequest.getRemoteAddr(), httpRequest.getMethod(), uri));
            chain.doFilter(request, response);
            return;
        }
        String authUser = SystemSecurityFilter.getMachineInterfaceVisitorName(httpRequest, uri);
        if (authUser != null) {
            RESTCLIENTLOG.info((Object)String.format(Locale.getDefault(), "User name %s send request uri %s:%s.", authUser, httpRequest.getMethod(), uri));
            chain.doFilter(request, response);
            return;
        }
        if (SystemSecurityFilter.checkNoAuthResources(this.noAuthResources, uri, httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        if (SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        SystemSecurityFilter.setResponseHeaderWithUri(httpResponse, uri);
        if (SystemSecurityFilter.isRestRequest(uri)) {
            this.doWithRestRequest(chain, httpRequest, httpResponse, uri, session);
            return;
        }
        if (!this.checkSessionTime(httpRequest.getMethod(), session, uri)) {
            logger.warn((Object)"Invalid session access, uri: %s", new Object[]{uri});
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/src/index.html");
            return;
        }
        if (this.checkFirstLogin(session, uri, httpRequest.getMethod())) {
            httpResponse.getWriter().write("{\"mustModifyPwd\": \"true\"}");
            logger.warn((Object)"The user needs to change the password for the first login");
            return;
        }
        chain.doFilter(request, response);
    }

    private void doWithRestRequest(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String uri, HttpSession session) throws IOException, ServletException {
        String clientIp = httpRequest.getRemoteAddr();
        if (null != session && !this.checkSessionId(clientIp, session.getId())) {
            logger.error((Object)"Check session ID failed, ip=%s", new Object[]{clientIp});
            httpResponse.getWriter().write("{\"status\": 401}");
            return;
        }
        if (!this.checkSessionTime(httpRequest.getMethod(), session, uri)) {
            logger.error((Object)"Invalid session access, uri: %s", new Object[]{uri});
            httpResponse.getWriter().write("{\"status\": 401}");
            return;
        }
        if (this.checkFirstLogin(session, uri, httpRequest.getMethod()) && !LOGOUT_URI.equals(uri)) {
            httpResponse.getWriter().write("{\"status\": \"211\"}");
            logger.info((Object)"Redirect user to modify password, uri: ", new Object[]{uri});
            return;
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void updateSessionMap() {
        Set sList = SessionListener.getSessionIdList();
        Set<String> map = sessionIdMap.keySet();
        if (VerifyUtil.isEmpty(map)) {
            return;
        }
        Iterator<String> iter = map.iterator();
        while (iter.hasNext()) {
            String id = iter.next();
            if (sList.contains(id)) continue;
            iter.remove();
        }
    }

    private boolean checkSessionId(String ip, String sessionId) {
        boolean status = true;
        this.updateSessionMap();
        String existIp = sessionIdMap.get(sessionId);
        if (VerifyUtil.isEmpty((String)existIp)) {
            sessionIdMap.put(sessionId, ip);
        } else if (!existIp.equals(ip)) {
            status = false;
        }
        return status;
    }

    private boolean checkFirstLogin(HttpSession session, String uri, String method) {
        if (session == null) {
            logger.warn((Object)"Exit system time: HttpSession  is null", 653110170615808L);
            return true;
        }
        User currentUser = (User)session.getAttribute(CURRENT_USER_SESSION);
        if (currentUser == null) {
            logger.info((Object)("Exit system time: currentUser is null .uri is \uff1a" + uri), 653110170615808L);
            return true;
        }
        if (SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method) || SystemSecurityFilter.checkUriAndMethod(this.firstLoginMap, uri, method)) {
            return false;
        }
        return currentUser.isMustModifyPwd();
    }

    private boolean checkSessionTime(String method, HttpSession session, String uri) throws IOException, ServletException {
        if (session == null) {
            logger.warn((Object)"Exit system time: HttpSession  is null", 653110170615808L);
            return false;
        }
        Object object = session.getAttribute(CURRENT_USER_SESSION);
        if (object == null || !(object instanceof User)) {
            logger.info((Object)("Exit system time: currentUser session is invalid .uri is \uff1a" + uri), 653110170615808L);
            return false;
        }
        User currentUser = (User)object;
        String sessId = currentUser.getSession();
        try {
            ServiceContext context = ServiceContext.getInstance();
            IUserMgr mgr = (IUserMgr)context.lookup("user/usermgr");
            if (this.checkTimeoutRefresh(method, uri, sessId, mgr)) {
                logger.info((Object)("Backend timeout ,exit system time:" + currentUser.getLoginDate() + ", uri is : " + uri), 653110170615808L);
                return false;
            }
            if (mgr.checkTimeOut(sessId, true).booleanValue()) {
                logger.info((Object)("Backend timeout ,exit system time:" + currentUser.getLoginDate() + ", uri is : " + uri), 653110170615808L);
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("exception Exit system time:" + currentUser.getLoginDate() + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
            return false;
        }
        return true;
    }

    private boolean checkTimeoutRefresh(String method, String uri, String sessionId, IUserMgr mgr) {
        if (SystemSecurityFilter.checkUriAndMethod(this.refreshMap, uri, method)) {
            return mgr.checkTimeOut(sessionId);
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SystemSecurityFilter.addNoAuthResources(this.noAuthResources);
        if (null == filterConfig) {
            logger.warn((Object)"System security filter config is null", 653110170615808L);
            return;
        }
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter(VALID_URIS), this.loginMap);
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter(VALID_REFRESH_URIS), this.refreshMap);
        FilterUtil.initSpecialUriMap((String)filterConfig.getInitParameter("firstLoginUris"), this.firstLoginMap);
    }
}

