/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.web.filter.SSOLogoutHandler;
import com.huawei.lego.cbb.user.sdk.model.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class SessionUtil {
    private SessionUtil() {
    }

    public static User getCurrentUser(HttpServletRequest request) {
        Object user = SessionUtil.getSessionAttribute(request, "currentUser");
        return user instanceof User ? (User)User.class.cast(user) : null;
    }

    public static Object getSessionAttribute(HttpServletRequest request, String name) {
        return SessionUtil.getSessionAttribute(request.getSession(false), name);
    }

    public static Object getSessionAttribute(HttpSession session, String name) {
        return session != null ? session.getAttribute(name) : null;
    }

    private static String getUserLoginMode(HttpServletRequest request) {
        Object mode = SessionUtil.getSessionAttribute(request, "user.login.mode");
        if (mode == null) {
            return null;
        }
        return mode.toString();
    }

    private static String getUserLoginMode(HttpSession session) {
        Object mode = SessionUtil.getSessionAttribute(session, "user.login.mode");
        if (mode == null) {
            return null;
        }
        return mode.toString();
    }

    public static boolean isLocalLoginMode(HttpServletRequest request) {
        return "local".equals(SessionUtil.getUserLoginMode(request));
    }

    public static boolean isLocalLoginMode(HttpSession session) {
        return "local".equals(SessionUtil.getUserLoginMode(session));
    }

    public static boolean isSSOLoginMode(HttpSession session) {
        return "sso".equals(SessionUtil.getUserLoginMode(session));
    }

    public static void logout(String sessionId) {
        new SSOLogoutHandler(sessionId).run();
    }

    public static void logout(HttpSession session) {
        User user = (User)session.getAttribute("currentUser");
        if (user != null) {
            SessionUtil.logout(user.getSession());
        }
    }
}

