/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.NoneCriticalVmWebBean;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IDsgService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.model.VMConfigs;
import com.huawei.ism.drm.protection.provider.sdk.model.VmBlockIoModel;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapter;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapterManager;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.CloudInformation;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.FusionSphereRecoveryPlanVMInfo;
import com.huawei.ism.drm.rest.fusionsphere.cloud.service.AbsFsQueryRestServiceImpl;
import com.huawei.ism.drm.rest.fusionsphere.cloud.service.IFusionsphereRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereExUtil;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereUtil;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.RecoveryPlanPOIpSettingInfoExcelOperator;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.XlsFileHandleUtil;
import com.huawei.ism.drm.rest.fusionsphere.drp.RecoveryPlanBs;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.NicInfoVO;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParam;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.SetNicInfoParamFromExcel;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.rest.fusionsphere.vrg.util.VrgRestUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.ExcelUtil;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class FusionsphereRestServiceImpl
extends AbsFsQueryRestServiceImpl
implements IFusionsphereRestService,
IAdapterManager {
    private static final Log logger = LogFactory.getInstance(FusionsphereRestServiceImpl.class);
    private static final String VPC_UUID = "uuid";
    private static final String VPC_NAME = "name";
    private static final String DRM_BASE = "DRM_Base";
    private static final String PRODUCT_SITE = "product";
    private static final String RECOVERY_SITE = "recovery";
    private static final String HUANGUP_VM = "com.huawei.ism.drm.galax.host.recovery.process.HangUpNoncriticalVmHostRecoveryProcessor";
    private static final String START_HOST = "com.huawei.ism.drm.galax.storage.recovery.process.PowerOnHostRecoveryProcessor";
    private static final String DRM_GALAX_MANAGER = "DRM_FusionShpere_Base";
    private static final String VRG_BUNDLE_NAME = "DRM_FusionShpere_VRG";
    private static final int MAX_PAGE_SIZE = 1000;
    private static final String Y = "Y";
    private static final String N = "N";
    private static final String RESOURCE_REFRESH_OPERATENAME = "resource_refresh_operateName";
    private static final String RESOURCE_REFRESH_OPERATEDETAIL = "resource_refresh_operateDetail";
    private static final int IO_HANG_TIMEOUT_MAX_SIZE = 65535;
    private final Set<IAdapter> adapters = new HashSet<IAdapter>();

    public void addAdapter(IAdapter adapter) {
        if (adapter != null) {
            this.adapters.add(adapter);
        }
    }

    @Override
    public String getFusionsphereBySite(String siteId, String cloudType) {
        logger.debug((Object)("FusionsphereRestServiceImpl:getFusionsphereBySite enter, siteId=" + siteId), 90160758786816L);
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId) && !FusionsphereExUtil.isCloudTypeValid(cloudType)) {
            logger.error((Object)("parameter invalid, siteId=" + siteId + ", cloudType=" + cloudType), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ICloudService cloudService = (ICloudService)this.getBundleService(DRM_GALAX_MANAGER, ICloudService.class.getName(), ICloudService.class);
        Page page = null;
        if (!VerifyUtil.isEmpty((String)siteId)) {
            this.checkUserAuthority(siteId);
            page = cloudService.pageQueryRegistedCloudsBySiteId(siteId, VPC_NAME, 0, 1000, true, this.getCurrentUserId());
        } else {
            page = cloudService.pageQueryAllRegistedClouds(VPC_NAME, 0, 1000, true, this.getCurrentUserId());
        }
        List<CloudInformation> cloudList = this.getCloudInformations(siteId, page);
        if (!VerifyUtil.isEmpty((String)cloudType)) {
            cloudList = FusionsphereExUtil.filterCloudInfo(cloudType, cloudList);
        }
        JSONArray cloudArray = FusionsphereUtil.parseCloudInfo(cloudList);
        if ((VerifyUtil.isEmpty((String)cloudType) || cloudType.equals("VRG")) && !VerifyUtil.isEmpty((String)siteId)) {
            cloudArray.addAll((Collection)this.getVrgBySite(siteId));
        }
        JSONArray retArray = FusionsphereUtil.sortJsonArrayByName((JSONArray)cloudArray);
        logger.debug((Object)("FusionsphereRestServiceImpl:getFusionsphereBySite leave, size=" + retArray.size()), 90160758786816L);
        return retArray.toString();
    }

    private List<CloudInformation> getCloudInformations(String siteId, Page page) {
        logger.info((Object)("CloudAction: get CloudList from the site whose siteId = " + siteId), 90160758786816L);
        List<CloudInformation> cloudList = null;
        if (null != page) {
            List resultList = page.getResult();
            ArrayList<CloudInformation> independRes = new ArrayList<CloudInformation>();
            Map<String, List<CloudInformation>> fcInFmMap = FusionsphereExUtil.convertToCloudInfo(resultList, independRes);
            cloudList = FusionsphereExUtil.orderFcInFmAfterFm(independRes, fcInFmMap);
        } else {
            logger.warn((Object)("query cloud from site is null, siteId=" + siteId), 90160758787071L);
        }
        return cloudList;
    }

    @Override
    public String queryVmsByCloudSn(String cloudSn, String orderBy, Integer pageSize, Integer startPage, String orderType, String filterName, String filterValue) {
        logger.debug((Object)"FusionsphereRestServiceImpl:queryVmsByCloudSne enter, cloudSn=%s , orderBy=%s , pageSize=%s , startPage= %s , orderType=%s , filterName=%s , filterValue=%s.", new Object[]{cloudSn, orderBy, pageSize, startPage, orderType, filterName, filterValue});
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{cloudSn, pageSize, startPage});
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        this.checkUserResourceAuthority(newCloudSn);
        ICloudService cloudService = (ICloudService)this.getBundleService(DRM_GALAX_MANAGER, ICloudService.class.getName(), ICloudService.class);
        boolean isAsc = VerifyUtil.isEmpty((String)orderType) || orderType.equals("asc");
        String oderBy = VerifyUtil.isEmpty((String)orderBy) ? VPC_NAME : orderBy;
        for (IAdapter adapter : this.adapters) {
            Integer[] pageInfo;
            String info = adapter.queryVms(newCloudSn, pageInfo = new Integer[]{pageSize, startPage}, isAsc, oderBy, this.getCurrentUserId());
            if (info == null) continue;
            return info;
        }
        Page pageVms = cloudService.pageQueryVmsByCloudSn(newCloudSn, oderBy, pageSize.intValue(), startPage.intValue(), isAsc, filterName, filterValue);
        JSONObject jsonObject = new JSONObject();
        if (pageVms == null) {
            logger.error((Object)"Result of page query vm is null, cloudSn=%s.", new Object[]{cloudSn});
            return jsonObject.toString();
        }
        List vms = pageVms.getResult();
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.info((Object)"There is no vm under the cloud, cloudSn=%s.", new Object[]{cloudSn});
            return jsonObject.toString();
        }
        JSONArray jsonArray = new JSONArray();
        for (GalaxVM vm : vms) {
            IProtectGroupBaseService pgServices = (IProtectGroupBaseService)this.getBundleService(IProtectGroupBaseService.class.getName(), IProtectGroupBaseService.class);
            List poList = pgServices.getProtectObjectListByRealMoUUID(Collections.singletonList(vm.getUuid()));
            ArrayList<ProtectGroup> pgList = new ArrayList<ProtectGroup>();
            poList.forEach(protectObject -> pgList.add(protectObject.getProtectGroup()));
            jsonArray.add((Object)FusionsphereExUtil.parseVmInfo(vm, pgList, newCloudSn));
        }
        jsonObject.put((Object)"totalCount", (Object)pageVms.getTotalCount());
        jsonObject.put((Object)"records", (Object)jsonArray);
        logger.debug((Object)"FusionsphereRestServiceImpl:queryVmsByCloudSne leave. count=%s.", new Object[]{String.valueOf(jsonArray.size())});
        return jsonObject.toString();
    }

    @Override
    public Response refreshFusionsphere(String cloudSn) {
        logger.debug((Object)"FusionsphereRestServiceImpl:refreshFusionsphere enter, cloudSn=%s.", new Object[]{cloudSn});
        this.checkUserOperationAuthority(RESOURCE_REFRESH_OPERATENAME, 3, "ism.drm.site.resource.auth.management.operateID");
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            logger.error((Object)("parameter invalid, cloudSn=" + cloudSn), 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRefreshCloudLog(null, ex);
            throw ex;
        }
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        try {
            this.handleRefreshBussness(newCloudSn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("refresh Cloud failed, cloudSn=" + newCloudSn), (Throwable)e, 90160758787071L);
            this.generateRefreshCloudLog(newCloudSn, e);
            throw e;
        }
        this.generateRefreshCloudLog(newCloudSn, null);
        logger.debug((Object)"FusionsphereRestServiceImpl:refreshFusionsphere leave.", 90160758786816L);
        return Response.ok().build();
    }

    private void handleRefreshBussness(String cloudSn) {
        this.checkUserResourceAuthority(cloudSn);
        ICloudService cloudService = (ICloudService)this.getBundleService(DRM_GALAX_MANAGER, ICloudService.class.getName(), ICloudService.class);
        cloudService.refreshCloud(cloudSn, this.getCurrentUserName());
    }

    private IVRGController getVrgService() {
        return (IVRGController)this.getBundleService(VRG_BUNDLE_NAME, IVRGController.class.getName(), IVRGController.class);
    }

    @Override
    public String getFmAvailableVpcList(String fmSn, String siteId, String searchType, Boolean editFlag, String vpcSn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId) || VerifyUtil.isEmpty((String)fmSn)) {
            logger.error((Object)"Failed to get product VPC list, siteId or fmSn is empty.", 90160758787071L);
            return new JSONArray().toString();
        }
        Site productSite = this.getSiteBySiteId(siteId);
        this.checkUserAuthority(siteId);
        if (0 == productSite.getSiteType()) {
            this.checkUserResourceAuthority(fmSn);
        }
        return this.getFmVpcString(fmSn, siteId, searchType, editFlag, vpcSn);
    }

    private String getFmVpcString(String fmSn, String siteId, String searchType, Boolean editFlag, String vpcSn) {
        try {
            IResourceMappingService rmService = (IResourceMappingService)this.getBundleService(DRM_GALAX_MANAGER, IResourceMappingService.class.getName());
            List vpcs = new ArrayList();
            if (PRODUCT_SITE.equals(searchType)) {
                vpcs = rmService.getAllVPC(siteId, fmSn);
            } else if (RECOVERY_SITE.equals(searchType)) {
                vpcs = editFlag != false ? rmService.getAvailableVpcByVpc(siteId, fmSn, vpcSn) : rmService.getMappingVpcByVpc(siteId, fmSn, vpcSn);
            }
            return this.returnResource(vpcs);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to GET VPC list, caught Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return new JSONArray().toString();
        }
    }

    private String returnResource(List<VPC> vpcs) {
        logger.debug((Object)"returnResource start");
        JSONArray arrayVPCs = new JSONArray();
        for (VPC vpc : vpcs) {
            JSONObject jsonVpc = new JSONObject();
            jsonVpc.put((Object)VPC_UUID, (Object)vpc.getUuid());
            jsonVpc.put((Object)VPC_NAME, (Object)vpc.getName());
            arrayVPCs.add((Object)jsonVpc);
        }
        return arrayVPCs.toString();
    }

    @Override
    public String getSelectedNonCriticalVm(String planId, String recoverySiteId) {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"getSelectedNonCriticalVMs error, planId is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        IGalaxRecoveryPlanService galaxRecoveryPlanService = (IGalaxRecoveryPlanService)this.getBundleService(DRM_GALAX_MANAGER, IGalaxRecoveryPlanService.class.getName(), IGalaxRecoveryPlanService.class);
        ArrayList selectedVms = galaxRecoveryPlanService.queryNoneCriticalVm(planId, recoverySiteId, this.getCurrentUserId().longValue());
        if (VerifyUtil.isEmpty((Collection)selectedVms)) {
            selectedVms = new ArrayList();
        }
        JSONArray arrayVMWebBeans = new JSONArray();
        for (NoneCriticalVmWebBean vmWebBean : selectedVms) {
            JSONObject jsonVMWebBean = new JSONObject();
            jsonVMWebBean.put((Object)VPC_UUID, (Object)vmWebBean.getVmUuid());
            jsonVMWebBean.put((Object)VPC_NAME, (Object)vmWebBean.getVmName());
            jsonVMWebBean.put((Object)"uri", (Object)vmWebBean.getVmUri());
            arrayVMWebBeans.add((Object)jsonVMWebBean);
        }
        return arrayVMWebBeans.toString();
    }

    @Override
    public String getAvailableNonCirticalVm(String planId, String recoverySiteId) {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"getAvailNonCriticalVMs error, planId is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        IGalaxRecoveryPlanService galaxRecoveryPlanService = (IGalaxRecoveryPlanService)this.getBundleService(DRM_GALAX_MANAGER, IGalaxRecoveryPlanService.class.getName(), IGalaxRecoveryPlanService.class);
        List availableVms = galaxRecoveryPlanService.queryUnSetVm(planId, recoverySiteId, this.getCurrentUserId().longValue());
        JSONArray arrayVMWebBeans = new JSONArray();
        for (NoneCriticalVmWebBean vmWebBean : availableVms) {
            JSONObject jsonVMWebBean = new JSONObject();
            jsonVMWebBean.put((Object)VPC_UUID, (Object)vmWebBean.getVmUuid());
            jsonVMWebBean.put((Object)VPC_NAME, (Object)vmWebBean.getVmName());
            jsonVMWebBean.put((Object)"uri", (Object)vmWebBean.getVmUri());
            arrayVMWebBeans.add((Object)jsonVMWebBean);
        }
        return arrayVMWebBeans.toString();
    }

    @Override
    public Response saveSelectedNonCriticalVMs(FusionSphereRecoveryPlanVMInfo vmInfo) {
        logger.info((Object)"start to saveSelectedNonCriticalVMs", 90160758786988L);
        this.checkUserOperationAuthority("recoveryPlan_NoncriticalVm_operateName", 2, "ism.drm.drp.auth.recoverysetting.modify.operateID");
        if (VerifyUtil.isEmpty((Object)vmInfo)) {
            logger.error((Object)"saveSelectedNonCriticalVMs failed, params are invalid", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String planId = vmInfo.getPlanId();
        String[] uuids = vmInfo.getUuids();
        Integer typeStr = vmInfo.getType();
        String recoverySiteId = vmInfo.getRecoverySiteId();
        try {
            if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((Object)typeStr) || null == uuids) {
                logger.error((Object)"saveSelectedNonCriticalVMs failed, params are invalid", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            this.checkPlanType(typeStr);
            this.checkUserAuthority(planId);
            IGalaxRecoveryPlanService galaxRecoveryPlanService = (IGalaxRecoveryPlanService)this.getBundleService(DRM_GALAX_MANAGER, IGalaxRecoveryPlanService.class.getName(), IGalaxRecoveryPlanService.class);
            List availableVms = galaxRecoveryPlanService.queryUnSetVm(planId, recoverySiteId, this.getCurrentUserId().longValue());
            List selectedVms = galaxRecoveryPlanService.queryNoneCriticalVm(planId, recoverySiteId, this.getCurrentUserId().longValue());
            FusionsphereExUtil.checkAvailableVM(availableVms, selectedVms, uuids);
            galaxRecoveryPlanService.setNoneCriticalVm(planId, recoverySiteId, new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(uuids))), this.getCurrentUserId().longValue());
        }
        catch (LegoCheckedException legoEx) {
            logger.error((Object)"saveSelectedNonCriticalVMs failed with exception:", (Throwable)legoEx, 90160758787071L);
            this.genetrageStepLog(planId, HUANGUP_VM, legoEx);
            throw legoEx;
        }
        catch (Exception e) {
            LegoCheckedException newEx = new LegoCheckedException(-1L, (Throwable)e);
            this.genetrageStepLog(planId, HUANGUP_VM, newEx);
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveSelectedNonCriticalVMs failed with exception:", (long)-1L, null, (Log)logger);
        }
        logger.info((Object)"saveSelectedNonCriticalVMs successfully", 90160758786988L);
        this.genetrageStepLog(planId, HUANGUP_VM, null);
        return Response.ok().build();
    }

    private IRecoveryPlanBaseService getRecoveryPlanService() {
        return (IRecoveryPlanBaseService)this.getBundleService(DRM_BASE, IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
    }

    private IProtectGroupBaseService getProctectGroupService() {
        return (IProtectGroupBaseService)this.getBundleService(DRM_BASE, IProtectGroupBaseService.class.getName(), IProtectGroupBaseService.class);
    }

    @Override
    public String getSelectedHosts(String planId, String recoverySiteId) {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"getSelectedHosts error, planId is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        ArrayList selectedHosts = this.getStorageRecPlanService().queryPowerOnHost(planId, recoverySiteId, this.getCurrentUserId().longValue());
        if (VerifyUtil.isEmpty((Collection)selectedHosts)) {
            selectedHosts = new ArrayList();
        }
        JSONArray arrayVMWebBeans = new JSONArray();
        for (ComputeNode vmWebBean : selectedHosts) {
            JSONObject jsonVMWebBean = new JSONObject();
            jsonVMWebBean.put((Object)"uri", (Object)vmWebBean.getUri());
            jsonVMWebBean.put((Object)VPC_NAME, (Object)vmWebBean.getName());
            jsonVMWebBean.put((Object)VPC_UUID, (Object)vmWebBean.getUrn());
            arrayVMWebBeans.add((Object)jsonVMWebBean);
        }
        return arrayVMWebBeans.toString();
    }

    @Override
    public String getAvailableHosts(String planId, String recoverySiteId) {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"getAvailableHosts error, planId is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        List availableHosts = this.getStorageRecPlanService().queryUnSetHost(planId, recoverySiteId, this.getCurrentUserId().longValue());
        JSONArray arrayVMWebBeans = new JSONArray();
        for (ComputeNode vmWebBean : availableHosts) {
            JSONObject jsonVMWebBean = new JSONObject();
            jsonVMWebBean.put((Object)"uri", (Object)vmWebBean.getUri());
            jsonVMWebBean.put((Object)VPC_NAME, (Object)vmWebBean.getName());
            jsonVMWebBean.put((Object)VPC_UUID, (Object)vmWebBean.getUrn());
            arrayVMWebBeans.add((Object)jsonVMWebBean);
        }
        return arrayVMWebBeans.toString();
    }

    @Override
    public String getAvailableTestNetwork(String planId, String recoverySiteId, String recNetworkUrn) {
        logger.debug((Object)("FusionsphereRestServiceImpl:getAvailableTestNetwork enter, planId=" + planId), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)recNetworkUrn)) {
            logger.error((Object)"query available testNetwork error, planId or recNetworkSn is empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        JSONArray array = RecoveryPlanBs.getInstance().getAvailableTestNetwork(planId, recoverySiteId, recNetworkUrn, this.getCurrentUserId());
        logger.debug((Object)"FusionsphereRestServiceImpl:getAvailableTestNetwork leave.", 90160758786816L);
        return array.toString();
    }

    @Override
    public String getVmNicsBase(String planId, String poId) {
        logger.debug((Object)("FusionsphereRestServiceImpl:getVmNicsBase enter, poId=" + poId + ", planId=" + planId), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId)) {
            logger.error((Object)"Failed to query network card info, planId or poId is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        JSONArray array = RecoveryPlanBs.getInstance().queryNetworkCards(planId, poId);
        logger.debug((Object)"FusionsphereRestServiceImpl:getVmNicsBase leave.", 90160758786816L);
        return array.toString();
    }

    @Override
    public String getVmNicDetail(String nicSeqNum, String poId, String planId) {
        logger.debug((Object)("FusionsphereRestServiceImpl:getVmNicDetail enter, poId=" + poId + ", planId=" + planId + ", nicSeqNum=" + nicSeqNum), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty((String)nicSeqNum)) {
            logger.error((Object)"Failed to query network card info, planId or poId or nicSeqNum is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        JSONObject object = RecoveryPlanBs.getInstance().queryNetworkCardInfo(nicSeqNum, poId, planId);
        logger.debug((Object)"FusionsphereRestServiceImpl:getVmNicDetail leave.", 90160758786816L);
        return object.toString();
    }

    @Override
    public Response setVmNicInformation(String nicSeqNum, String poId, String planId, NicInfoVO nicInfoVO) {
        logger.debug((Object)("FusionsphereRestServiceImpl:setVmNicInformation enter, poId=" + poId + ", planId=" + planId + ", nicSeqNum=" + nicSeqNum), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_modifyRecoveryNetworkSetting_operateName", 2, "ism.drm.drp.auth.recoverysetting.modify.operateID");
        if (VerifyUtil.isEmpty((String)nicSeqNum) || VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty((Object)nicInfoVO)) {
            logger.error((Object)"parameter is invalid.", 90160758787071L);
            LegoCheckedException exception = new LegoCheckedException(1073947393L);
            this.generateSetVmVicLog(poId, planId, exception);
            throw exception;
        }
        try {
            this.checkUserAuthority(planId);
            SetNicInfoParam nicParam = new SetNicInfoParam();
            nicParam.setNicSeqNum(nicSeqNum);
            nicParam.setPlanId(planId);
            nicParam.setPoId(poId);
            nicParam.setNicInfoVO(nicInfoVO);
            RecoveryPlanBs.getInstance().saveNetworkCardInfo(nicParam);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"set vm nic catch exception:", (Throwable)e, 90160758787071L);
            this.generateSetVmVicLog(poId, planId, e);
            throw e;
        }
        this.generateSetVmVicLog(poId, planId, null);
        logger.debug((Object)"FusionsphereRestServiceImpl:setVmNicInformation leave.", 90160758786816L);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importVmNicInformation(Attachment file, String planId) {
        String fileName = "";
        IRecoveryPlanBaseService recoveryplanservice = (IRecoveryPlanBaseService)this.getBundleService(DRM_BASE, IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
        RecoveryPlan rp = recoveryplanservice.getRecoveryPlan(planId);
        this.isRpEmpty(rp);
        try {
            fileName = System.getProperty("java.io.tmpdir") + File.separator + System.currentTimeMillis() + "_" + planId + "IP.xlsx";
            XlsFileHandleUtil.uploadFileToServerLocal(file, fileName, this.getRequest().getContentLength());
        }
        catch (RuntimeException e1) {
            return this.upFileDeleteRecordError(fileName, rp);
        }
        catch (IOException e) {
            return this.upFileDeleteRecordError(fileName, rp);
        }
        ArrayList<SetNicInfoParamFromExcel> setNicInfoParamCheckList = new ArrayList<SetNicInfoParamFromExcel>();
        try {
            this.checkFileContentFormat(fileName, planId, rp);
            List<SetNicInfoParamFromExcel> setV4NicInfoParamCheckList = XlsFileHandleUtil.fetchNicInfoListFromExcel(fileName);
            List<SetNicInfoParamFromExcel> setV6NicInfoParamCheckList = XlsFileHandleUtil.fetchV6NicInfoListFromExcel(fileName);
            this.combineIPV4AndIPV6(setNicInfoParamCheckList, setV4NicInfoParamCheckList, setV6NicInfoParamCheckList);
        }
        catch (RuntimeException e1) {
            return this.deleteFileDealError(fileName, rp);
        }
        catch (InvalidFormatException e) {
            return this.deleteFileDealError(fileName, rp);
        }
        catch (IOException e) {
            return this.deleteFileDealError(fileName, rp);
        }
        try {
            JSONArray errorArray = new JSONArray();
            List<SetNicInfoParamFromExcel> errorNicInfo = RecoveryPlanBs.getInstance().checkNicInfoVOAndSave(setNicInfoParamCheckList);
            this.generateErrorArray(errorArray, errorNicInfo);
            if (errorArray.size() > 0) {
                this.writeFailedOperationLogNoException("recoveryplan_ipimport_operateName", 2, rp.getName(), (Exception)((Object)new LegoCheckedException(-1L)));
                String string = errorArray.toString();
                return string;
            }
            this.writeSucOperationLog("recoveryplan_ipimport_operateName", 1, rp.getName(), "", new String[0]);
            String string = "";
            return string;
        }
        finally {
            this.deleteFile(fileName);
        }
    }

    private void combineIPV4AndIPV6(List<SetNicInfoParamFromExcel> setNicInfoParamCheckList, List<SetNicInfoParamFromExcel> setV4NicInfoParamCheckList, List<SetNicInfoParamFromExcel> setV6NicInfoParamCheckList) {
        if (setV4NicInfoParamCheckList.size() != setV6NicInfoParamCheckList.size()) {
            throw new LegoCheckedException("1st sheet protected object number does not equal 2rd sheet protected object number");
        }
        for (int i = 0; i < setV4NicInfoParamCheckList.size(); ++i) {
            boolean checkV4AndV6HideInfoStatus2;
            SetNicInfoParamFromExcel v4Temp = setV4NicInfoParamCheckList.get(i);
            SetNicInfoParamFromExcel v6Temp = setV6NicInfoParamCheckList.get(i);
            boolean checkV4AndV6HideInfoStatus1 = v4Temp.getPoId().equals(v6Temp.getPoId()) && v4Temp.getPlanId().equals(v6Temp.getPlanId()) && v4Temp.getNicSeqNum().equals(v6Temp.getNicSeqNum());
            boolean bl = checkV4AndV6HideInfoStatus2 = v4Temp.getProtectGroupName().equals(v6Temp.getProtectGroupName()) && v4Temp.getProtectobjectName().equals(v6Temp.getProtectobjectName()) && v4Temp.getNetWorkCardName().equals(v6Temp.getNetWorkCardName());
            if (!checkV4AndV6HideInfoStatus1 || !checkV4AndV6HideInfoStatus2) {
                logger.error((Object)"1st sheet's content does not match 2rn sheet's content! the content of two sheet can not be composed! ");
                throw new LegoCheckedException("1st sheet's content does not match 2rn sheet's content! the content of two sheet can not  be composed! ");
            }
            SetNicInfoParamFromExcel nicInfoParamFromExcelWhole = new SetNicInfoParamFromExcel();
            NicInfoVO nicInfoVOV4AndV6 = new NicInfoVO();
            nicInfoParamFromExcelWhole.setPoId(v4Temp.getPoId());
            nicInfoParamFromExcelWhole.setPlanId(v4Temp.getPlanId());
            nicInfoParamFromExcelWhole.setNicSeqNum(v4Temp.getNicSeqNum());
            nicInfoParamFromExcelWhole.setProtectGroupName(v4Temp.getProtectGroupName());
            nicInfoParamFromExcelWhole.setProtectobjectName(v4Temp.getProtectobjectName());
            nicInfoParamFromExcelWhole.setNetWorkCardName(v4Temp.getNetWorkCardName());
            nicInfoParamFromExcelWhole.setIsConfigIP(v4Temp.getIsConfigIP());
            nicInfoParamFromExcelWhole.setIsConfigIPV6(v6Temp.getIsConfigIPV6());
            NicInfoVO v4NicInfoVO = v4Temp.getNicInfoVO();
            NicInfoVO v6NicInfoVO = v6Temp.getNicInfoVO();
            if (Y.equals(v4Temp.getIsConfigIP())) {
                nicInfoVOV4AndV6.setIp(v4NicInfoVO.getIp());
                nicInfoVOV4AndV6.setNetmask(v4NicInfoVO.getNetmask());
                nicInfoVOV4AndV6.setGateway(v4NicInfoVO.getGateway());
                nicInfoVOV4AndV6.setSetdns(v4NicInfoVO.getSetdns());
                nicInfoVOV4AndV6.setAdddns(v4NicInfoVO.getAdddns());
            }
            if (Y.equals(v6Temp.getIsConfigIPV6())) {
                nicInfoVOV4AndV6.setIpAddress6(v6NicInfoVO.getIpAddress6());
                nicInfoVOV4AndV6.setGatewayIpAddr6(v6NicInfoVO.getGatewayIpAddr6());
                nicInfoVOV4AndV6.setSetdns6(v6NicInfoVO.getSetdns6());
                nicInfoVOV4AndV6.setAdddns6(v6NicInfoVO.getAdddns6());
            }
            nicInfoParamFromExcelWhole.setNicInfoVO(nicInfoVOV4AndV6);
            setNicInfoParamCheckList.add(nicInfoParamFromExcelWhole);
        }
    }

    private String upFileDeleteRecordError(String fileName, RecoveryPlan rp) {
        logger.error((Object)"upload file to server local error! ");
        this.deleteFile(fileName);
        JSONObject object = new JSONObject();
        object.put((Object)"errorCode", (Object)String.valueOf(1073947459L));
        this.writeFailedOperationLogNoException("recoveryplan_ipimport_operateName", 2, rp.getName(), (Exception)((Object)new LegoCheckedException(-1L)));
        return object.toString();
    }

    private String deleteFileDealError(String fileName, RecoveryPlan rp) {
        this.deleteFile(fileName);
        logger.error((Object)"excel file format or content is not accord with requirements! please modify excel file and recheck!");
        JSONObject object = new JSONObject();
        object.put((Object)"errorCode", (Object)String.valueOf(1073947459L));
        this.writeFailedOperationLogNoException("recoveryplan_ipimport_operateName", 2, rp.getName(), (Exception)((Object)new LegoCheckedException(-1L)));
        return object.toString();
    }

    private void isRpEmpty(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)"rp is null.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void generateErrorArray(JSONArray errorArray, List<SetNicInfoParamFromExcel> errorNicInfo) {
        for (SetNicInfoParamFromExcel param : errorNicInfo) {
            JSONObject object = new JSONObject();
            object.put((Object)"protectObjectName", (Object)param.getProtectobjectName());
            object.put((Object)"protectObjectId", (Object)param.getPoId());
            object.put((Object)"protectGroupName", (Object)param.getProtectGroupName());
            object.put((Object)"recoveryPlanId", (Object)param.getPlanId());
            object.put((Object)"networkCardName", (Object)param.getNetWorkCardName());
            object.put((Object)"errorCode", (Object)param.getErrorCode());
            object.put((Object)"errorMessage", (Object)param.getErrorMessage());
            errorArray.add((Object)object);
        }
    }

    private void deleteFile(String fileName) {
        try {
            File file = new File(fileName);
            if (null != file && file.exists()) {
                boolean result = file.delete();
                logger.debug((Object)("delete license file:" + result), 90160758786816L);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("delete license file exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
        }
    }

    private void checkFileContentFormat(String path, String planId, RecoveryPlan rp) throws InvalidFormatException, IOException {
        List<SetNicInfoParamFromExcel> nicInfoParamCheckList = XlsFileHandleUtil.checkFileContentFormatAndFetchNicCheckInfo(path, 0);
        List v4setNicInfoParamCheckList = nicInfoParamCheckList.stream().filter(nic -> "IPV4".equals(nic.getIpType())).collect(Collectors.toList());
        List v6setNicInfoParamCheckList = nicInfoParamCheckList.stream().filter(nic -> "IPV6".equals(nic.getIpType())).collect(Collectors.toList());
        if (v4setNicInfoParamCheckList.size() != v6setNicInfoParamCheckList.size()) {
            throw new LegoCheckedException("1st sheet protected object number does not equal 2rd sheet protected object number");
        }
        for (int i = 0; i < v4setNicInfoParamCheckList.size(); ++i) {
            boolean checkV4AndV6HideInfoStatus;
            SetNicInfoParam v4Temp = (SetNicInfoParam)v4setNicInfoParamCheckList.get(i);
            SetNicInfoParam v6Temp = (SetNicInfoParam)v6setNicInfoParamCheckList.get(i);
            boolean bl = checkV4AndV6HideInfoStatus = v4Temp.getPoId().equals(v6Temp.getPoId()) && v4Temp.getPlanId().equals(v6Temp.getPlanId()) && v4Temp.getNicSeqNum().equals(v6Temp.getNicSeqNum());
            if (checkV4AndV6HideInfoStatus) continue;
            logger.error((Object)"1st sheet content does not match 2rn sheet content!");
            throw new LegoCheckedException("1st sheet content does not match 2rn sheet content!");
        }
        int rowIndex = 3;
        JSONArray jsonArray = new JSONArray();
        String protectGroupName = rp.getProtectGroup().getName();
        Set poList = rp.getProtectGroup().getPolist();
        for (ProtectObject temp : poList) {
            String protectObjId = temp.getUuid();
            String nicInfo = this.getVmNicsBase(planId, protectObjId);
            JSONArray nicArray = JSONArray.fromObject((Object)nicInfo);
            for (int i = 0; i < nicArray.size(); ++i) {
                JSONObject jsobj = new JSONObject();
                jsobj.set((Object)"protectGroupName", (Object)protectGroupName);
                jsobj.set((Object)"protectObjName", (Object)temp.getName());
                jsobj.set((Object)"protectObjId", (Object)protectObjId);
                jsobj.set((Object)"planId", (Object)planId);
                String nicNu = String.valueOf(nicArray.getJSONObject(i).get("id"));
                jsobj.set((Object)"nicNo", (Object)nicNu);
                jsobj.set((Object)"nicName", nicArray.getJSONObject(i).get(VPC_NAME));
                jsonArray.add((Object)jsobj);
            }
        }
        for (SetNicInfoParamFromExcel param : nicInfoParamCheckList) {
            boolean testStatus2;
            JSONObject jsObjectInFile = new JSONObject();
            String nicName = param.getNetWorkCardName();
            String nicSeqNum = param.getNicSeqNum();
            String planIdInfile = param.getPlanId();
            String poId = param.getPoId();
            String protectGroupNameInfile = param.getProtectGroupName();
            String protectObjectName = param.getProtectobjectName();
            jsObjectInFile.set((Object)"protectGroupName", (Object)protectGroupNameInfile);
            jsObjectInFile.set((Object)"protectObjName", (Object)protectObjectName);
            jsObjectInFile.set((Object)"protectObjId", (Object)poId);
            jsObjectInFile.set((Object)"planId", (Object)planId);
            jsObjectInFile.set((Object)"nicNo", (Object)nicSeqNum);
            jsObjectInFile.set((Object)"nicName", (Object)nicName);
            boolean testStatus1 = VerifyUtil.isEmpty((String)nicSeqNum) || VerifyUtil.isEmpty((String)planIdInfile) || VerifyUtil.isEmpty((String)poId);
            boolean bl = testStatus2 = VerifyUtil.isEmpty((String)nicName) || VerifyUtil.isEmpty((String)protectGroupName) || VerifyUtil.isEmpty((String)protectObjectName);
            if (testStatus1 || testStatus2) {
                logger.error((Object)("the 1st sheet " + rowIndex + " row info isn't correct! please check carefully!"));
                logger.error((Object)"parameter is invalid.", 90160758787071L);
                LegoCheckedException exception = new LegoCheckedException(1073947393L);
                throw exception;
            }
            if (!planIdInfile.equals(planId)) {
                logger.error((Object)("the " + rowIndex + "sheet info isn't correct! because the planId isn't match! planId: " + planId));
                logger.error((Object)"parameter is invalid.", 90160758787071L);
                LegoCheckedException exception = new LegoCheckedException(1073947393L);
                throw exception;
            }
            int countNo = 0;
            for (int i = 0; i < jsonArray.size(); ++i) {
                for (int j = 0; j < jsonArray.size(); ++j) {
                    if (!jsonArray.getJSONObject(j).toString().equals(jsObjectInFile.toString())) continue;
                    ++countNo;
                }
            }
            if (countNo == 0) {
                logger.error((Object)"excel file is invalid! pleause use template file!");
                throw new LegoCheckedException(1073947393L);
            }
            RecoveryPlanBs.getInstance().checkNetworkCardInfoInExcel((SetNicInfoParam)param);
            ++rowIndex;
        }
    }

    @Override
    public String checkElasticIpValid(String elasticIp, String poId, String planId, String recoverySiteId) {
        logger.debug((Object)("FusionsphereRestServiceImpl:checkElasticIpValid enter, poId=" + poId + ", planId=" + planId + ", elasticIp=" + elasticIp), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)elasticIp) || VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty((String)recoverySiteId)) {
            logger.error((Object)"checkFlexIpAvailability error, params are empty. ", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        JSONObject jsonObject = RecoveryPlanBs.getInstance().checkElasticIpValid(elasticIp, poId, planId, recoverySiteId);
        logger.debug((Object)"FusionsphereRestServiceImpl:checkElasticIpValid leave.", 90160758786816L);
        return jsonObject.toString();
    }

    @Override
    public Response saveSelectedHosts(FusionSphereRecoveryPlanVMInfo vmInfo) {
        logger.info((Object)"start to saveSelectedHosts", 90160758786988L);
        this.checkUserOperationAuthority("recoveryPlan_poweronHost_operateName", 2, "ism.drm.drp.auth.recoverysetting.modify.operateID");
        String planId = vmInfo.getPlanId();
        String[] hostUrns = vmInfo.getUuids();
        Integer typeStr = vmInfo.getType();
        String recoverySiteId = vmInfo.getRecoverySiteId();
        try {
            if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((Object)typeStr) || null == hostUrns) {
                logger.error((Object)"saveSelectedNonCriticalVMs failed, params are invalid", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            this.checkPlanType(typeStr);
            this.checkUserAuthority(planId);
            IStorageRecoveryPlanService storageRecoveryPlanService = this.getStorageRecPlanService();
            List availableHosts = storageRecoveryPlanService.queryUnSetHost(planId, recoverySiteId, this.getCurrentUserId().longValue());
            List selectedHosts = storageRecoveryPlanService.queryPowerOnHost(planId, recoverySiteId, this.getCurrentUserId().longValue());
            FusionsphereExUtil.checkAvailableHost(availableHosts, selectedHosts, hostUrns);
            storageRecoveryPlanService.setPowerOnHost(planId, recoverySiteId, new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(hostUrns))), this.getCurrentUserId().longValue());
        }
        catch (LegoCheckedException legoEx) {
            logger.error((Object)"saveSelectedHosts failed with exception:", (Throwable)legoEx, 90160758787071L);
            this.genetrageStepLog(planId, START_HOST, legoEx);
            throw legoEx;
        }
        catch (Exception e) {
            LegoCheckedException newEx = new LegoCheckedException(-1L, (Throwable)e);
            this.genetrageStepLog(planId, START_HOST, newEx);
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveSelectedHosts failed with exception:", (long)-1L, null, (Log)logger);
        }
        logger.info((Object)"saveSelectedHosts successfully", 90160758786988L);
        this.genetrageStepLog(planId, START_HOST, null);
        return Response.ok().build();
    }

    private void generateRefreshCloudLog(String cloudSn, LegoCheckedException ex) {
        String cloudName = "--";
        String cloudIp = "--";
        if (!VerifyUtil.isEmpty((String)cloudSn)) {
            try {
                NetworkEntity nEntity = (NetworkEntity)this.getMo(NetworkEntity.class, "sn", cloudSn);
                if (null != nEntity) {
                    cloudName = nEntity.getName();
                    cloudIp = nEntity.getLinkIp();
                }
            }
            catch (Exception e) {
                logger.error((Object)("get cloud info failed, cloudSn=" + cloudSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(RESOURCE_REFRESH_OPERATENAME, 3, cloudName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(RESOURCE_REFRESH_OPERATENAME, 3, cloudName, RESOURCE_REFRESH_OPERATEDETAIL, new String[]{cloudName, cloudIp});
        }
    }

    private void generateSetVmVicLog(String poId, String planId, LegoCheckedException ex) {
        String poName = "--";
        String planName = "--";
        try {
            IRecoveryPlanBaseService rpServices;
            RecoveryPlan recoveryPlan;
            IResScopeService resScopeService = (IResScopeService)this.getBundleService(DRM_GALAX_MANAGER, IResScopeService.class.getName(), IResScopeService.class);
            String tempName = resScopeService.getPoNameByPoId(poId);
            if (null != tempName) {
                poName = tempName;
            }
            if (null != (recoveryPlan = (rpServices = this.getRecoveryPlanService()).getRecoveryPlan(planId))) {
                planName = recoveryPlan.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("query network adaptor log values failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("recoveryPlan_modifyRecoveryNetworkSetting_operateName", 2, planName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("recoveryPlan_modifyRecoveryNetworkSetting_operateName", 2, planName, "recoveryPlan_modifyRecoveryNetworkSetting_operateDetail", new String[]{poName});
        }
    }

    @Override
    public String queryAvaiableDatastoregroup(boolean isavailable, String cloudSn, Integer protectionType) {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", 2, "ism.drm.protectgroup.auth.scan");
        logger.info((Object)"into queryAvaiableDatastoregroup.", 90160758786816L);
        if (VerifyUtil.isEmpty((String)cloudSn) || VerifyUtil.isEmpty((Object)protectionType)) {
            logger.error((Object)"cloudSn or protectionType is empty, queryAvaiableDatastoregroup failed.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectionType(protectionType);
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        try {
            this.checkUserResourceAuthority(newCloudSn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"not enough right, queryAvaiableDatastoregroup failed.", 90160758787071L);
            throw e;
        }
        JSONArray array = null;
        try {
            logger.info((Object)("To get unused DataStoreGroupList by cloudSn, cloudSn=" + newCloudSn), 90160758786816L);
            array = this.queryDsgOfStorageRep(newCloudSn, isavailable, protectionType);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Failed to get unused DataStoreGroup list, caught LegoCheckedException ", (Throwable)e, 90160758787071L);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get DataStoreGroup list, caught Excepiton " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        logger.info((Object)"end queryAvaiableDatastoregroup.", 90160758786816L);
        return null == array ? new JSONArray().toString() : array.toString();
    }

    private IDsgService getDataStoreGroupService() {
        IDsgService dataStoreGroupService = (IDsgService)this.getBundleService("DRM_FusionShpere_SRA", IDsgService.class.getName(), IDsgService.class);
        if (VerifyUtil.isEmpty((Object)dataStoreGroupService)) {
            logger.error((Object)"Failed to repair vrg, mappingId or mapStatus is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return dataStoreGroupService;
    }

    private void genetrageStepLog(String planId, String stepName, LegoCheckedException ex) {
        String planName = "--";
        String modifyType = "recoveryPlan_NoncriticalVmSetting_operateDetail";
        String optObject = "recoveryPlan_NoncriticalVm_operateName";
        try {
            RecoveryPlan rp = new RecoveryPlan();
            if (!VerifyUtil.isEmpty((String)planId)) {
                rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
            }
            if (!VerifyUtil.isEmpty((Object)rp)) {
                planName = rp.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("query param error by planId: " + planId + ",with exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optObject, 2, planName, (Exception)((Object)ex));
        } else {
            if (stepName.equals(START_HOST)) {
                modifyType = "recoveryPlan_poweronHost_operateDetail";
                optObject = "recoveryPlan_poweronHost_operateName";
            }
            this.writeSucOperationLog(optObject, 2, planName, modifyType, new String[]{planName});
        }
    }

    private void checkPlanType(int planType) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != planType && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != planType && DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != planType) {
            logger.error((Object)(" params are invalid by plan type:" + planType), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private JSONArray getVrgBySite(String siteId) {
        Page page = this.getVrgService().pageQueryVrgsBySiteId(siteId, this.getCurrentUserId(), VPC_NAME, 1000, 0, true);
        if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
            logger.error((Object)("there is no vrg in site, siteId=" + siteId), 90160758787071L);
            return new JSONArray();
        }
        JSONArray arrays = VrgRestUtil.parseVrgVOs(page.getResult());
        return arrays;
    }

    private JSONArray queryDsgOfStorageRep(String cloudSn, boolean isavailable, int protectType) {
        IDsgService dataStoreGroupService = this.getDataStoreGroupService();
        List storeGroups = dataStoreGroupService.getUnusedDataStoreGroupListByCloudSn(cloudSn, isavailable, Integer.valueOf(protectType));
        if (!VerifyUtil.isEmpty((Collection)storeGroups)) {
            logger.info((Object)("Succeed to get unused DataStoreGroup list by cloudSn, DataStoreGroup count is [" + storeGroups.size() + "]"), 90160758786816L);
            StringBuffer dsInfos = new StringBuffer("Get unused DataStoreGroup list info is ");
            int count = 0;
            for (VirtualDataStoreGroup dsg : storeGroups) {
                dsInfos.append("[" + count + "]" + dsg.getGroupId() + "  " + dsg.getName() + ";");
                ++count;
            }
            logger.info((Object)dsInfos.toString(), 90160758786816L);
        } else if (VerifyUtil.isEmpty((Collection)storeGroups)) {
            logger.info((Object)"Succeed to get unused DataStoreGroup list by cloudSn, DataStoreGroup list is EMPTY.", 90160758786816L);
        }
        JSONArray array = FusionsphereExUtil.parseVirtualDataStoreGroup(storeGroups);
        return array;
    }

    private void checkProtectionType(int protectionType) {
        if (protectionType != ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue() && protectionType != ProtectionTypeEnum.STORAGE_REPLICATION.getValue() && protectionType != ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue()) {
            logger.error((Object)String.format("ProtectionType is invalid, value:%s", protectionType), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response exportProtectObjectIPSettingInfo(String planId) {
        logger.debug((Object)("RecoveryPlanRestServiceImpl:exportProtectObjectIPSettingInfo enter, planId=" + planId), 90160758786816L);
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"Failed to export excel, planId is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserAuthority(planId);
        IRecoveryPlanBaseService recoveryplanservice = (IRecoveryPlanBaseService)this.getBundleService(DRM_BASE, IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
        RecoveryPlan rp = recoveryplanservice.getRecoveryPlan(planId);
        this.isRpEmpty(rp);
        RecoveryPlanBs.getInstance().checkRecoveryPlanWhenIpsSet(rp);
        try {
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            this.exportHelper(planId);
            this.writeSucOperationLog("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", SysoplogLevel.INFO.getValue(), rp.getName(), "", new String[0]);
        }
        catch (Exception le) {
            this.writeFailedOperationLog("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", SysoplogLevel.INFO.getValue(), rp.getName(), le);
        }
        return Response.ok().build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportHelper(String planId) {
        RecoveryPlanPOIpSettingInfoExcelOperator operator = new RecoveryPlanPOIpSettingInfoExcelOperator(this);
        FileOutputStream fileOutputStream = null;
        SXSSFWorkbook wb = null;
        try {
            wb = operator.createExportExcel(planId);
            File excelFile = new File(this.getExportExcelFilePath());
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            operator.downloadFile(this.getResponse(), excelFile);
        }
        catch (LegoCheckedException e) {
            try {
                logger.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                throw e;
                catch (Exception ex) {
                    throw new LegoCheckedException(-1L, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                ExcelUtil.closeExcelExport((SXSSFWorkbook)wb, fileOutputStream);
                throw throwable;
            }
        }
        ExcelUtil.closeExcelExport((SXSSFWorkbook)wb, (FileOutputStream)fileOutputStream);
    }

    public String getExportExcelFilePath() {
        boolean ret;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String exportExcelName = "ExportIPSettingInfo_" + df.format(new Date()) + ".xlsx";
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            logger.error((Object)"to creat dir failed.");
            throw new LegoCheckedException(-1L);
        }
        downloadPath = downloadPath + File.separator + exportExcelName;
        return downloadPath;
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="resource_vmBlockIoHangTimeout_operateName")
    public BatchOperationResult multiSetVmBlockIoHangTimeout(String cloudSn, VmBlockIoModel vmBlockIoModel) {
        String newCloudSn = BaseRestUtils.base64Decode((String)cloudSn);
        try {
            this.checkUserResourceAuthority(newCloudSn);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Not enough right, multiSetVmBlockIoHangTimeout failed. error msg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        IProtectObjectProviderBaseDelegate poProvider = (IProtectObjectProviderBaseDelegate)this.getBundleService(IProtectObjectProviderBaseDelegate.class.getName(), IProtectObjectProviderBaseDelegate.class);
        List vmConfigsList = vmBlockIoModel.getVmConfigList();
        this.checkVmConfigParams(vmConfigsList);
        return poProvider.multiSetVmBlockIoHangTimeout(newCloudSn, vmConfigsList);
    }

    private void checkVmConfigParams(List<VMConfigs> vmConfigsList) {
        if (VerifyUtil.isEmpty(vmConfigsList) || vmConfigsList.size() > 200) {
            logger.error((Object)"The size of vmConfigsList is available in 1-200");
            throw new LegoCheckedException(1073947393L);
        }
        for (VMConfigs vmConfigs : vmConfigsList) {
            Integer timeout = vmConfigs.getBlockIoHangTimeout();
            if (VerifyUtil.isEmpty((Object)timeout)) {
                logger.error((Object)"Timeout is empty");
                throw new LegoCheckedException(1073947393L);
            }
            if (timeout <= 0 || timeout > 65535) {
                logger.error((Object)"The size of timeout is available in 1-65535");
                throw new LegoCheckedException(1073947393L);
            }
            if (!VerifyUtil.isEmpty((String)vmConfigs.getMoUuid())) continue;
            logger.error((Object)"The moUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }
}

