/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.VmTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.NoneCriticalVmWebBean;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.CloudInformation;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereUtil;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.util.VirtualMachineTypeEnum;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FusionsphereExUtil {
    private static Log logger = LogFactory.getInstance(FusionsphereExUtil.class);

    private FusionsphereExUtil() {
    }

    public static JSONArray parseDrFms(List<DrFm> drFms) {
        logger.debug((Object)"parseDrFms start");
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(drFms)) {
            return array;
        }
        for (DrFm drFm : drFms) {
            if (null == drFm) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"ip", (Object)drFm.getIpAddress());
            object.put((Object)"port", (Object)drFm.getPort());
            object.put((Object)"cloudStatus", (Object)drFm.getStatus());
            object.put((Object)"cloudName", (Object)drFm.getName());
            object.put((Object)"cloudSn", (Object)drFm.getDeviceSn());
            object.put((Object)"cloudType", (Object)"FusionManager");
            array.add((Object)object);
        }
        return array;
    }

    public static JSONArray parseDrVrms(List<DrVrm> drVrms) {
        logger.debug((Object)"parseDrFms start");
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(drVrms)) {
            return array;
        }
        for (DrVrm drVrm : drVrms) {
            if (null == drVrm) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"ip", (Object)drVrm.getIpAddress());
            object.put((Object)"port", (Object)drVrm.getPort());
            object.put((Object)"cloudStatus", (Object)drVrm.getStatus());
            object.put((Object)"cloudName", (Object)drVrm.getName());
            object.put((Object)"cloudSn", (Object)drVrm.getDeviceSn());
            object.put((Object)"cloudType", (Object)"FusionCompute");
            array.add((Object)object);
        }
        return array;
    }

    public static Map<String, List<CloudInformation>> convertToCloudInfo(List<CloudInfo> oriList, List<CloudInformation> destList) {
        logger.debug((Object)"convertToCloudInfo start");
        HashMap<String, List<CloudInformation>> rstMap = new HashMap<String, List<CloudInformation>>();
        if (null == oriList) {
            return rstMap;
        }
        for (CloudInfo drCloud : oriList) {
            CloudInformation cloudInfo = new CloudInformation();
            cloudInfo.setIp(drCloud.getIpAddress());
            cloudInfo.setPort(drCloud.getPort());
            cloudInfo.setCloudName(drCloud.getName());
            cloudInfo.setVersion(drCloud.getVersion());
            cloudInfo.setCloudStatus(String.valueOf(drCloud.getStatus()));
            cloudInfo.setCloudSn(drCloud.getDeviceSn());
            cloudInfo.setCloudType(FusionsphereExUtil.getCloudTypeStr(drCloud.getResType()));
            cloudInfo.setCloudTypeBack(drCloud.getResType());
            cloudInfo.setParentResource(drCloud.getParentResource());
            if ("DrVrm".equals(drCloud.getResType()) && drCloud.getParentResource() != null) {
                ArrayList<CloudInformation> infrLst = (ArrayList<CloudInformation>)rstMap.get(drCloud.getParentResource());
                if (VerifyUtil.isEmpty((Collection)infrLst)) {
                    infrLst = new ArrayList<CloudInformation>();
                    rstMap.put(drCloud.getParentResource(), infrLst);
                }
                infrLst.add(cloudInfo);
                continue;
            }
            destList.add(cloudInfo);
        }
        return rstMap;
    }

    private static String getCloudTypeStr(String resType) {
        if ("DrFm".equals(resType)) {
            return "FusionManager";
        }
        if ("DrVrm".equals(resType)) {
            return "FusionCompute";
        }
        if ("DrFusionSphereOpenStack".equals(resType)) {
            return "OpenStack";
        }
        return "FusionCompute";
    }

    public static CloudInfo getCloudInfoBySn(List<CloudInfo> cloudList, String cloudSn) {
        logger.debug((Object)"getCloudInfoBySn start");
        if (VerifyUtil.isEmpty(cloudList) || VerifyUtil.isEmpty((String)cloudSn)) {
            return null;
        }
        for (CloudInfo cloudInfo : cloudList) {
            if (null == cloudInfo || !cloudSn.equals(cloudInfo.getDeviceSn())) continue;
            return cloudInfo;
        }
        return null;
    }

    public static List<CloudInformation> orderFcInFmAfterFm(List<CloudInformation> independRes, Map<String, List<CloudInformation>> fcInFmMap) {
        logger.debug((Object)"orderFcInFmAfterFm start");
        ArrayList<CloudInformation> cloudList = new ArrayList<CloudInformation>();
        if (VerifyUtil.isEmpty(independRes)) {
            return cloudList;
        }
        if (VerifyUtil.isEmpty(fcInFmMap)) {
            cloudList.addAll(independRes);
            return cloudList;
        }
        for (CloudInformation cdInfo : independRes) {
            cloudList.add(cdInfo);
            if (!cdInfo.getCloudTypeBack().equals("DrFm") || VerifyUtil.isEmpty((Collection)fcInFmMap.get(cdInfo.getCloudSn()))) continue;
            cdInfo.setParentResource(String.valueOf(fcInFmMap.get(cdInfo.getCloudSn()).size()));
            cloudList.addAll((Collection<CloudInformation>)fcInFmMap.get(cdInfo.getCloudSn()));
        }
        return cloudList;
    }

    public static List<CloudInformation> filterCloudInfo(String cloudType, List<CloudInformation> srcClouds) {
        logger.debug((Object)"filterCloudInfo start");
        if (VerifyUtil.isEmpty((String)cloudType)) {
            return srcClouds;
        }
        ArrayList<CloudInformation> destClouds = new ArrayList<CloudInformation>();
        if (VerifyUtil.isEmpty(srcClouds)) {
            return null;
        }
        for (CloudInformation cloudInfo : srcClouds) {
            if (null == cloudInfo || !cloudType.equals(cloudInfo.getCloudType())) continue;
            destClouds.add(cloudInfo);
        }
        return destClouds;
    }

    public static boolean isCloudTypeValid(String cloudType) {
        logger.debug((Object)("isCloudTypeValid start:cloudType=" + cloudType));
        if (!VerifyUtil.isEmpty((String)cloudType)) {
            return cloudType.equals("FusionManager") || cloudType.equals("FusionCompute") || cloudType.equals("VRG") || cloudType.equals("OpenStack");
        }
        return true;
    }

    public static JSONObject parseVmInfo(GalaxVM vm, List<ProtectGroup> protectGroups, String cloudSn) {
        logger.debug((Object)"parseVmInfo start");
        if (null == vm) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)vm.getName());
        jsonObject.put((Object)"osStatus", (Object)vm.getStatus());
        jsonObject.put((Object)"osType", (Object)vm.getOsType());
        jsonObject.put((Object)"vmId", (Object)vm.getUri().split("vms")[1].replace("/", ""));
        jsonObject.put((Object)"vmType", (Object)FusionsphereExUtil.getVmType(vm));
        JSONArray groupIDArray = new JSONArray();
        JSONArray groupNameArray = new JSONArray();
        if (!VerifyUtil.isEmpty(protectGroups)) {
            for (ProtectGroup protectGroup : protectGroups) {
                if (!FusionsphereUtil.isVmInProtectGroup((String)vm.getUuid(), (ProtectGroup)protectGroup, (String)cloudSn)) continue;
                groupIDArray.add((Object)protectGroup.getUuid());
                groupNameArray.add((Object)protectGroup.getName());
            }
        }
        jsonObject.put((Object)"protectgroupId", (Object)groupIDArray);
        jsonObject.put((Object)"protectgroupName", (Object)groupNameArray);
        return jsonObject;
    }

    private static int getVmType(GalaxVM gVm) {
        logger.debug((Object)"getVmType start");
        int defaultType = VirtualMachineTypeEnum.NORMAL.getValue();
        Boolean isTemplate = gVm.isTemplate();
        Boolean isClone = gVm.isLinkClone();
        if (null != isTemplate && isTemplate.booleanValue()) {
            defaultType = VirtualMachineTypeEnum.TEMPLATE.getValue();
        } else if (gVm.getVmType().intValue() == VmTypeEnum.PLACE_HOLDER_VM.getStatus()) {
            defaultType = VirtualMachineTypeEnum.PLACEHOLDER.getValue();
        } else if (null != isClone && isClone.booleanValue()) {
            defaultType = VirtualMachineTypeEnum.LINKCLONE.getValue();
        } else if (FusionsphereExUtil.isFtVm(gVm)) {
            defaultType = VirtualMachineTypeEnum.FTVM.getValue();
        }
        return defaultType;
    }

    private static boolean isFtVm(GalaxVM gVm) {
        logger.debug((Object)"isFtVm start");
        try {
            JSONObject vmConfig = JSONObject.fromObject((Object)gVm.getVmConfig());
            if (null == vmConfig) {
                return false;
            }
            JSONObject vmProperties = vmConfig.getJSONObject("properties");
            if (null == vmProperties) {
                return false;
            }
            Object isEnableFt = vmProperties.get("isEnableFt");
            if (VerifyUtil.isEmpty((Object)isEnableFt) || "null".equalsIgnoreCase(isEnableFt.toString())) {
                return false;
            }
            return (Boolean)isEnableFt;
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(2097932L, (Throwable)e);
        }
    }

    public static void checkAvailableVM(List<NoneCriticalVmWebBean> availableVms, List<NoneCriticalVmWebBean> selectedVms, String[] uuids) {
        logger.debug((Object)"checkAvailableVM start");
        ArrayList<NoneCriticalVmWebBean> allAvailableVMs = new ArrayList<NoneCriticalVmWebBean>();
        if (null != availableVms) {
            allAvailableVMs.addAll(availableVms);
        }
        if (null != selectedVms) {
            allAvailableVMs.addAll(selectedVms);
        }
        ArrayList<String> avriableUuid = new ArrayList<String>();
        for (NoneCriticalVmWebBean availableVm : allAvailableVMs) {
            avriableUuid.add(availableVm.getVmUuid());
        }
        for (String uuid : uuids) {
            if (avriableUuid.contains(uuid)) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkAvailableHost(List<ComputeNode> availableHosts, List<ComputeNode> selectedHosts, String[] hostUrns) {
        logger.debug((Object)"checkAvailableHost start");
        ArrayList<ComputeNode> allAvailableHosts = new ArrayList<ComputeNode>();
        if (null != availableHosts) {
            allAvailableHosts.addAll(availableHosts);
        }
        if (null != selectedHosts) {
            allAvailableHosts.addAll(selectedHosts);
        }
        ArrayList<String> avriableUrn = new ArrayList<String>();
        for (ComputeNode availableHost : allAvailableHosts) {
            avriableUrn.add(availableHost.getUrn());
        }
        for (String hostUrn : hostUrns) {
            if (avriableUrn.contains(hostUrn)) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static JSONArray parseVirtualDataStoreGroup(List<VirtualDataStoreGroup> dataStoreGroups) {
        logger.debug((Object)"parseVirtualDataStoreGroup start");
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(dataStoreGroups)) {
            return array;
        }
        for (VirtualDataStoreGroup dsg : dataStoreGroups) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"groupId", (Object)dsg.getGroupId());
            jsonObject.put((Object)"name", (Object)dsg.getName());
            jsonObject.put((Object)"vmQuantity", (Object)(VerifyUtil.isEmpty((Collection)dsg.getVmUuidSet()) ? 0 : dsg.getVmUuidSet().size()));
            jsonObject.put((Object)"datastoreInfo", (Object)dsg.getDataStores());
            array.add((Object)jsonObject);
        }
        return array;
    }
}

