/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FusionsphereQueryPlanUtil {
    private static final Log LOGGER = LogFactory.getInstance(FusionsphereQueryPlanUtil.class);

    private FusionsphereQueryPlanUtil() {
    }

    public static String getRecoverySettingValue(String key, RecoveryPlan rp) {
        BaseRestUtils.checkParamCommon((Object[])new Object[]{key, rp});
        Map recSettins = rp.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)recSettins)) {
            return null;
        }
        for (Map.Entry tempSetting : recSettins.entrySet()) {
            if (!key.equals(tempSetting.getKey())) continue;
            return (String)tempSetting.getValue();
        }
        return null;
    }

    public static JSONObject getJsonObjectFromArray(String arrayValue, String key, String keyValue) {
        BaseRestUtils.checkParamCommon((Object[])new Object[]{key, arrayValue, keyValue});
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)arrayValue);
            if (null == jsonArray || jsonArray.isEmpty()) {
                return null;
            }
            JSONObject oldSetting = null;
            for (int idx = 0; idx < jsonArray.size(); ++idx) {
                JSONObject tempJson = jsonArray.getJSONObject(idx);
                if (!keyValue.equals(tempJson.getString(key))) continue;
                oldSetting = tempJson;
                break;
            }
            return oldSetting;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("parse info catch json exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
    }

    public static Set<String> getPortGroupsByVm(GalaxVM vm) {
        HashSet<String> pgUrns = new HashSet<String>();
        if (null == vm) {
            return pgUrns;
        }
        try {
            JSONObject vmConfig = JSONObject.fromObject((Object)vm.getVmConfig());
            if (null == vmConfig) {
                return pgUrns;
            }
            JSONArray vmNics = vmConfig.getJSONArray("nics");
            if (null == vmNics || vmNics.isEmpty()) {
                return pgUrns;
            }
            for (int idx = 0; idx < vmNics.size(); ++idx) {
                JSONObject vmNic = vmNics.getJSONObject(idx);
                String pgUrn = vmNic.getString("portGroupUrn");
                if (VerifyUtil.isEmpty((String)pgUrn)) continue;
                pgUrns.add(pgUrn);
            }
            return pgUrns;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("parse vm nic info catch json exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return pgUrns;
        }
    }

    public static JSONArray changeJsonObjects(List<JSONObject> jsonObjects) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(jsonObjects)) {
            return jsonArray;
        }
        for (JSONObject jsonObject : jsonObjects) {
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

