/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public final class ResourceMappingUtil {
    private static Log logger = LogFactory.getInstance(ResourceMappingUtil.class);

    private ResourceMappingUtil() {
        logger.trace((Object)"enter ResourceMappingUtil");
    }

    public static void checkResMappingStatus(int status) {
        if (status == VrgMapStatusEnum.NORMAL.getStatus() || status == VrgMapStatusEnum.MAPPING.getStatus()) {
            logger.error((Object)("Failed to repair ResourceMapping, vrg map status is " + status), 90160758787071L);
            throw new LegoCheckedException(102401L, "Failed to repair ResourceMapping error, vrg is normal or mapping.");
        }
    }

    public static int getVrgMappingStatus(ResourceMapping mapping, IVRGController vrgService) {
        VRG vrgInfo;
        if (null == mapping || null == vrgService) {
            logger.error((Object)"parameter invalid, mapping information or service is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            vrgInfo = vrgService.getVRGBySn(mapping.getProductResourceId());
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947394L) {
                vrgInfo = vrgService.getVRGBySn(mapping.getRecoveryResourceId());
            }
            logger.error((Object)"get VRG information catch LegoCheckedException:", (Throwable)e, 90160758787071L);
            throw e;
        }
        if (VerifyUtil.isEmpty((Object)vrgInfo)) {
            logger.error((Object)("get VRG information failed, mapping=:" + mapping), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return vrgInfo.getMapStatus();
    }
}

