/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class GalaxVMRecoveryProxy {
    private static Log logger = LogFactory.getInstance(GalaxVMRecoveryProxy.class);
    private static final int POLICY_TEMPLATE_TYPE_HOST_REPLICATION = 11;
    private static final Set<Integer> STORAGE_ARRAY_TEMPLATE = ImmutableSet.builder().add((Object)1).add((Object)0).add((Object)18).add((Object)20).add((Object)23).add((Object)24).add((Object)3).add((Object)4).add((Object)5).add((Object)6).add((Object)26).add((Object)27).add((Object)33).add((Object)39).add((Object)51).add((Object)52).build();
    private final RecoveryPlan plan;

    public GalaxVMRecoveryProxy(RecoveryPlan plan) {
        this.plan = plan;
    }

    public String getRepBundleName() {
        ProtectGroup pg = this.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return "";
        }
        PolicyTemplate pt = pg.getTemplate();
        if (VerifyUtil.isEmpty((Object)pt)) {
            return "";
        }
        switch (pt.getType()) {
            case 11: {
                return "DRM_FusionShpere_HRA";
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 33: 
            case 39: {
                return "DRM_FusionShpere_SRA";
            }
        }
        return "";
    }

    public String getProtectReplicationType() {
        PolicyTemplate template = this.getProtectGroup().getTemplate();
        if (template == null) {
            logger.error((Object)"The template of protect group is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int ptType = template.getType();
        if (ptType == 11) {
            return ProtectTypeEnum.HOST_REPLICATION.getType();
        }
        if (STORAGE_ARRAY_TEMPLATE.contains(ptType)) {
            return ProtectTypeEnum.STORAGE_ARRAY.getType();
        }
        return "";
    }

    private ProtectGroup getProtectGroup() {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.plan.getProtectGroups());
        if (pg == null) {
            throw new LegoCheckedException(String.format(Locale.ROOT, "The pg in rp is empty, planId=%s.", this.plan.getPlanId()));
        }
        return pg;
    }

    public List<ProtectObject> getPos() {
        return new ArrayList<ProtectObject>(this.getProtectGroup().getPolist());
    }

    public String getRecoverySiteId() {
        Set pgrSet = this.getProtectGroup().getReplicaList();
        Iterator iterator = pgrSet.iterator();
        if (iterator.hasNext()) {
            ProtectGroupReplica pgr = (ProtectGroupReplica)iterator.next();
            return pgr.getRecoverySite();
        }
        return "";
    }
}

