/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.TestNetwork;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmNicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.IpAddress6;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.rest.fusionsphere.drp.model.IdNameValueVo;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.List;

public final class ReCoveryPlanUtil {
    private ReCoveryPlanUtil() {
    }

    public static JSONArray parseTestNetwork(List<TestNetwork> networks) {
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(networks)) {
            return array;
        }
        for (TestNetwork testNetwork : networks) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"proUrn", (Object)testNetwork.getProUrn());
            jsonObject.put((Object)"proName", (Object)testNetwork.getProName());
            jsonObject.put((Object)"drUrn", (Object)testNetwork.getDrUrn());
            jsonObject.put((Object)"drName", (Object)testNetwork.getDrName());
            jsonObject.put((Object)"testUrn", (Object)testNetwork.getTestUrn());
            jsonObject.put((Object)"testName", (Object)testNetwork.getTestName());
            array.add((Object)jsonObject);
        }
        return array;
    }

    public static JSONArray parseNicBases(List<IdNameValueVo> nicBases) {
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(nicBases)) {
            return array;
        }
        for (IdNameValueVo nicBase : nicBases) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)nicBase.getId());
            jsonObject.put((Object)"name", (Object)nicBase.getName());
            array.add((Object)jsonObject);
        }
        return array;
    }

    public static JSONObject parseNicDetail(NicSpecification nicInfo) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)nicInfo)) {
            return jsonObject;
        }
        jsonObject.put((Object)"sequenceNum", (Object)nicInfo.getSequenceNum());
        jsonObject.put((Object)"ip", (Object)nicInfo.getIp());
        jsonObject.put((Object)"netmask", (Object)nicInfo.getNetmask());
        jsonObject.put((Object)"gateway", (Object)nicInfo.getGateway());
        jsonObject.put((Object)"setdns", (Object)nicInfo.getSetdns());
        jsonObject.put((Object)"adddns", (Object)nicInfo.getAdddns());
        jsonObject.put((Object)"ipVersion", (Object)nicInfo.getIpVersion());
        jsonObject.put((Object)"autoConfEnabled6", (Object)nicInfo.getAutoConfEnabled6());
        jsonObject.put((Object)"dhcpEnabled6", (Object)nicInfo.getDhcpEnabled6());
        jsonObject.put((Object)"gatewayIpAddr6", (Object)nicInfo.getGatewayIpAddr6());
        jsonObject.put((Object)"setdns6", (Object)nicInfo.getSetdns6());
        jsonObject.put((Object)"adddns6", (Object)nicInfo.getAdddns6());
        JSONArray array = new JSONArray();
        List ip6s = nicInfo.getIpAddress6();
        if (!VerifyUtil.isEmpty((Collection)ip6s)) {
            for (IpAddress6 ip6 : ip6s) {
                JSONObject ip6Object = new JSONObject();
                ip6Object.put((Object)"ipv6Addr", (Object)ip6.getIpv6Addr());
                ip6Object.put((Object)"ipv6Prefix", (Object)ip6.getIpv6Prefix());
                array.add((Object)ip6Object);
            }
        }
        jsonObject.put((Object)"ipAddress6", (Object)array);
        if (nicInfo instanceof FmNicSpecification) {
            FmNicSpecification fmNicInfo = (FmNicSpecification)nicInfo;
            jsonObject.put((Object)"flexIpMap", (Object)fmNicInfo.getFlexIpMap());
            jsonObject.put((Object)"privatePort", (Object)fmNicInfo.getPrivatePort());
            jsonObject.put((Object)"publicPort", (Object)fmNicInfo.getPublicPort());
            jsonObject.put((Object)"protocal", (Object)fmNicInfo.getProtocal());
        }
        return jsonObject;
    }
}

