/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drsmapping.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.PageQuery;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsGroupInfo;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.DrsMappingQueryVo;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.model.DrsGroupVo;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.model.DrsMappingUpdateVo;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.model.DrsMappingVo;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.model.GroupMappingInfoVo;
import com.huawei.ism.drm.rest.fusionsphere.drsmapping.service.IDrsMappingRestService;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.ResourceMappingScope;
import com.huawei.ism.drm.rest.fusionsphere.util.AnnotationParamValidUtils;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class DrsMappingRestServiceIml
extends AbsVRRestService
implements IDrsMappingRestService {
    private static final Log LOGGER = LogFactory.getInstance(DrsMappingRestServiceIml.class);
    private static final String LOG_OBJECT_NAME = "drsMapping_objectName";
    private static final String DRM_GALAX_MANAGER = "DRM_FusionShpere_Base";

    @Override
    public BatchOperationResult createDrsMapping(DrsMappingVo vo) {
        BatchOperationResult optResult = null;
        try {
            AnnotationParamValidUtils.checkObject(vo);
            this.checkUserOperationAuthority("resource_create_drsMapping_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
            IDrsMappingService drsService = this.getDrsMappingService();
            List<DrsMapping> drsMappingList = this.configDrsMappingList(vo);
            optResult = drsService.createDrsMappings(drsMappingList, vo.getGroupType(), vo.getResourceMappingId());
            LOGGER.info((Object)"Succeed to add drsMappings");
            for (BatchOperation batchOperation : optResult.getResult()) {
                this.writeSucOperationLog("resource_create_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_createDrsMapping_operateDetail", batchOperation.getDetailParam());
            }
        }
        catch (Exception ex) {
            String msg = "Create drsMapping list error.";
            this.handlingExceptionLog(ex, "resource_create_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
        return optResult;
    }

    @Override
    public Response modifyDrsMapping(String mappingId, DrsMappingUpdateVo updateVo) {
        try {
            AnnotationParamValidUtils.checkObject(updateVo);
            this.checkUserOperationAuthority("resource_modify_drsMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
            IDrsMappingService drsService = this.getDrsMappingService();
            DrsMapping oldDrsMapping = drsService.getResourceMappingById(mappingId);
            if (oldDrsMapping == null) {
                LOGGER.error((Object)"Method modifyDrsMapping oldDrsMapping is null.");
                throw new LegoCheckedException(1073947394L);
            }
            ResourceMapping oldResMap = oldDrsMapping.getResourceMapping();
            if (oldResMap == null) {
                LOGGER.error((Object)"Method modifyDrsMapping resourceMapping is null.");
                throw new LegoCheckedException(1073947394L);
            }
            this.checkResourceMappingAuthority(oldResMap);
            this.configUpdateMapping(oldDrsMapping, updateVo, oldResMap);
            if (updateVo.getRecoveryGroupUrn().equals(oldDrsMapping.getRecoveryGroupUrn())) {
                LOGGER.error((Object)"Data drsMapping is already exists.");
                throw new LegoCheckedException(1073949742L, new String[]{oldDrsMapping.getRecoveryGroupName()});
            }
            String productGroupName = oldDrsMapping.getProductGroupName();
            String oldRecoveryGroupName = oldDrsMapping.getRecoveryGroupName();
            oldDrsMapping.setRecoveryGroupUrn(updateVo.getRecoveryGroupUrn());
            DrsMapping newDrsMapping = drsService.updateDrsMapping(oldDrsMapping);
            String newRecoveryGroupName = newDrsMapping.getRecoveryGroupName();
            LOGGER.info((Object)"Succeed to modify DrsMapping, mappingId is [%s].", new Object[]{mappingId});
            this.writeSucOperationLog("resource_modify_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_modifyDrsMapping_operateDetail", new String[]{productGroupName, oldRecoveryGroupName, newRecoveryGroupName, oldResMap.getProductResourceName(), oldResMap.getProductSiteName(), oldResMap.getProductResourceProviderName(), oldResMap.getRecoveryResourceName(), oldResMap.getRecoverySiteName(), oldResMap.getRecoveryResourceProviderName()});
        }
        catch (Exception ex) {
            String msg = "Update drsMapping error.";
            this.handlingExceptionLog(ex, "resource_modify_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
        return Response.ok().build();
    }

    private void configUpdateMapping(DrsMapping oldDrsMapping, DrsMappingUpdateVo updateVo, ResourceMapping oldResMap) {
        Site productSite = this.getSiteBySiteId(oldResMap.getProductSiteId());
        if (productSite.getSiteType() != 0) {
            LOGGER.error((Object)"Only product site can do it.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response deleteDrsMapping(String mappingId) {
        try {
            this.checkUserOperationAuthority("resource_delete_drsMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
            IDrsMappingService drsService = this.getDrsMappingService();
            DrsMapping delDrsMapping = drsService.getResourceMappingById(mappingId);
            if (VerifyUtil.isEmpty((Object)delDrsMapping)) {
                LOGGER.error((Object)"Method deleteDrsMapping drsMapping is null.");
                throw new LegoCheckedException(1073947394L);
            }
            ResourceMapping oldResMap = delDrsMapping.getResourceMapping();
            Site productSite = this.getSiteBySiteId(oldResMap.getProductSiteId());
            if (productSite.getSiteType() != 0) {
                LOGGER.error((Object)"Only product site can do it.");
                throw new LegoCheckedException(1073947393L);
            }
            this.checkResourceMappingAuthority(oldResMap);
            drsService.deleteDrsMapping(mappingId, oldResMap);
            String[] parameters = new String[]{delDrsMapping.getProductGroupName(), delDrsMapping.getRecoveryGroupName(), oldResMap.getProductResourceName(), oldResMap.getProductSiteName(), oldResMap.getProductResourceProviderName(), oldResMap.getRecoveryResourceName(), oldResMap.getRecoverySiteName(), oldResMap.getRecoveryResourceProviderName()};
            this.writeSucOperationLog("resource_delete_drsMapping_operateName", 1, LOG_OBJECT_NAME, "resource_deleteDrsMapping_operateDetail", parameters);
            LOGGER.info((Object)"Succeed to delete drsMapping, mappingId is %s.", new Object[]{mappingId});
        }
        catch (Exception ex) {
            String msg = String.format(Locale.ROOT, "Failed to delete drsMapping. drsMapping is %s.", mappingId);
            this.handlingExceptionLog(ex, "resource_delete_drsMapping_operateName", msg, LOG_OBJECT_NAME, LOGGER);
        }
        return Response.ok().build();
    }

    @Override
    public String getDrsMapping(String resourceMappingId, DrsMappingQueryVo queryVo) {
        JSONObject returnObject = new JSONObject();
        try {
            Page page;
            this.checkUserOperationAuthority("resource_query_drsMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
            IResourceMappingService resService = this.getResourceMappingService();
            ResourceMapping resourceMapping = this.getResourceMapping(resService, resourceMappingId);
            ResourceMappingScope rmScope = new ResourceMappingScope();
            if (!rmScope.checkResourceMapping(resourceMapping, this.getCurrentUserId())) {
                page = new Page(0L, 0L, queryVo.getPageSize(), Collections.emptyList());
            } else {
                IDrsMappingService drsService = this.getDrsMappingService();
                PageQuery pageQuery = this.createPageQuery(resourceMapping, queryVo);
                page = drsService.getDrsMappingByPage(pageQuery, resourceMapping);
            }
            returnObject.put((Object)"totalCount", (Object)page.getTotalCount());
            returnObject.put((Object)"records", (Object)this.resourceMappingToJsonStr(page));
        }
        catch (Exception ex) {
            this.handlingExceptionNoLog(ex, "Failed to get drsMapping", LOGGER);
        }
        return returnObject.toString();
    }

    private JSONArray resourceMappingToJsonStr(Page page) {
        List list;
        try {
            list = page.getResult();
        }
        catch (Exception exception) {
            list = Collections.emptyList();
            LOGGER.error((Object)"Data Of page cannot convert to list,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
        }
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(list)) {
            return jsonArray;
        }
        try {
            jsonArray = JSONArray.fromObject(list);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Convert drsMappings to jsonArray.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return jsonArray;
    }

    @Override
    public String getDrsGroup(DrsGroupVo drsGroupVo) {
        JSONObject jo = new JSONObject();
        try {
            AnnotationParamValidUtils.checkObject(drsGroupVo);
            this.checkUserOperationAuthority("resource_query_drsMapping_operateName", 2, "ism.drm.site.auth.scan");
            this.checkUserAuthority(drsGroupVo.getSiteId());
            Site site = this.getSiteBySiteId(drsGroupVo.getSiteId());
            if (site.getSiteType() == 0) {
                this.checkUserResourceAuthority(drsGroupVo.getResourceProviderId());
            }
            IDrsMappingService drsService = this.getDrsMappingService();
            DrsGroupInfo drsGroupInfo = this.createDrsGroupInfo(drsGroupVo);
            Page page = drsService.getAvailableGroup(drsGroupInfo);
            jo.put((Object)"totalCount", (Object)page.getTotalCount());
            jo.put((Object)"records", (Object)this.handlingDrsGroupData(page));
        }
        catch (Exception ex) {
            this.handlingExceptionNoLog(ex, "Failed to get drsGroup", LOGGER);
        }
        return jo.toString();
    }

    @Override
    public String getDrsGroupByUrn(String siteId, String urn) {
        String newUrn;
        if (VerifyUtil.isEmpty((String)siteId) || VerifyUtil.isEmpty((String)urn)) {
            LOGGER.error((Object)"Data siteId or urn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            newUrn = URLDecoder.decode(urn, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error((Object)"Data urn is invalidation,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_query_drsMapping_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserAuthority(siteId);
        Site site = this.getSiteBySiteId(siteId);
        IDrsMappingService drsService = this.getDrsMappingService();
        return drsService.getDrsGroupByUrn(site, newUrn);
    }

    @Override
    public String checkDrsMappingState(String planId, int procType) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        this.checkAuthorityForOpera(planId, executeType);
        boolean isValid = false;
        try {
            isValid = ((IDrsMappingService)this.getBundleService(DRM_GALAX_MANAGER, IDrsMappingService.class.getName(), IDrsMappingService.class)).checkDrsMappingState(planId, executeType);
        }
        catch (Exception ex) {
            this.handlingExceptionNoLog(ex, "Method checkDrsMappingState failed", LOGGER);
        }
        JSONObject jb = new JSONObject();
        jb.put((Object)"isValid", (Object)isValid);
        return jb.toString();
    }

    private void checkAuthorityForOpera(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, type});
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == type.getValue()) {
            this.checkUserOperationAuthority("recoveryPlan_enableTest_operateName", 3, "ism.drm.drp.auth.test");
            this.checkUserBizObjAuthority("recoveryPlan_enableTest_operateName", 3, planId);
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == type.getValue()) {
            this.checkUserOperationAuthority("recoveryPlan_enablePlannedMigration_operateName", 2, "ism.drm.drp.auth.planed.motion");
            this.checkUserBizObjAuthority("recoveryPlan_enablePlannedMigration_operateName", 2, planId);
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == type.getValue()) {
            this.checkUserOperationAuthority("recoveryPlan_enableFaultRecovery_operateName", 2, "ism.drm.drp.auth.disaster.recovery");
            this.checkUserBizObjAuthority("recoveryPlan_enableFaultRecovery_operateName", 2, planId);
        } else {
            LOGGER.error((Object)"The parameter is incorrect,type is %s.", new Object[]{String.valueOf(type.getValue())});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private DrsGroupInfo createDrsGroupInfo(DrsGroupVo drsGroupVo) {
        DrsGroupInfo info = new DrsGroupInfo();
        info.setGroupName(drsGroupVo.getGroupName());
        info.setClusterId(drsGroupVo.getClusterId());
        info.setGroupType(drsGroupVo.getGroupType());
        info.setPageSize(drsGroupVo.getPageSize());
        info.setHostRuleType(drsGroupVo.getHostRuleType());
        info.setSiteId(drsGroupVo.getSiteId());
        info.setStartPage(drsGroupVo.getStartPage());
        info.setRuleType(drsGroupVo.getRuleType());
        info.setResourceProviderId(drsGroupVo.getResourceProviderId());
        return info;
    }

    private JSONArray handlingDrsGroupData(Page page) {
        List<DrsGroup> list;
        try {
            list = page.getResult();
        }
        catch (Exception exception) {
            list = Collections.emptyList();
            LOGGER.error((Object)"Data Of page cannot convert to list,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
        }
        if (VerifyUtil.isEmpty(list)) {
            return new JSONArray();
        }
        ArrayList<DrsGroup> reList = new ArrayList<DrsGroup>();
        for (DrsGroup drsGroup : list) {
            DrsGroup group = new DrsGroup();
            group.setUrn(drsGroup.getUrn());
            group.setVmParentGroupUrn(drsGroup.getVmParentGroupUrn());
            group.setVmGroupUrn(drsGroup.getVmGroupUrn());
            group.setHostGroupUrn(drsGroup.getHostGroupUrn());
            group.setGroupType(drsGroup.getGroupType());
            group.setRuleType(drsGroup.getRuleType());
            group.setName(drsGroup.getName());
            group.setVm2HostRuleType(drsGroup.getVm2HostRuleType());
            reList.add(group);
        }
        return JSONArray.fromObject(reList);
    }

    private IDrsMappingService getDrsMappingService() {
        return (IDrsMappingService)this.getBundleService(DRM_GALAX_MANAGER, IDrsMappingService.class.getName());
    }

    private IResourceMappingService getResourceMappingService() {
        return (IResourceMappingService)this.getBundleService(DRM_GALAX_MANAGER, IResourceMappingService.class.getName());
    }

    private ResourceMapping getResourceMapping(IResourceMappingService resService, String resourceMappingId) {
        ResourceMapping resourceMapping = resService.getResourceMappingById(resourceMappingId);
        if (resourceMapping == null || resourceMapping.getResourceType() != 0) {
            LOGGER.error((Object)"Data ResourceMapping is invalids, resourceMapping is %s.", new Object[]{JSONObject.fromObject((Object)resourceMapping)});
            throw new LegoCheckedException(1073947393L);
        }
        return resourceMapping;
    }

    private PageQuery createPageQuery(ResourceMapping resourceMapping, DrsMappingQueryVo queryVo) {
        PageQuery pageQuery = new PageQuery(queryVo.getStartPage(), queryVo.getPageSize());
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("resourceMapping.mappingId", (Object)resourceMapping.getMappingId(), true, true);
        conditions.add(queryCondition);
        pageQuery.setOrderBy(queryVo.getOrderBy());
        pageQuery.setAsc("asc".equalsIgnoreCase(queryVo.getOrderType()));
        pageQuery.setQueryConditionList(conditions);
        return pageQuery;
    }

    private List<DrsMapping> configDrsMappingList(DrsMappingVo vo) {
        if (VerifyUtil.isEmpty(vo.getGroupMappingInfo())) {
            return Collections.emptyList();
        }
        ArrayList<DrsMapping> list = new ArrayList<DrsMapping>();
        for (GroupMappingInfoVo infoVo : vo.getGroupMappingInfo()) {
            DrsMapping drsMapping = new DrsMapping();
            drsMapping.setGroupType(vo.getGroupType());
            drsMapping.setProductGroupUrn(infoVo.getProductGroupUrn());
            drsMapping.setRecoveryGroupUrn(infoVo.getRecoveryGroupUrn());
            list.add(drsMapping);
        }
        return list;
    }
}

