/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.host.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.host.service.IBHRPgController;
import com.huawei.ism.drm.galax.sdk.pg.host.service.IRecoveryVmController;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.model.AssignedVm;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.host.service.IRecoveryVmRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RecoveryVmRestServiceImpl
extends AbsVRRestService
implements IRecoveryVmRestService {
    private static final String HOST_REPLICATION_BUNDLE_NAME = "DRM_FusionShpere_HRA";
    private static Log logger = LogFactory.getInstance(RecoveryVmRestServiceImpl.class);
    private static final int MAX_POPROPS_LEN = 8192;

    @Override
    public void syncCreateRecoveryVm(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncCreateDRVM_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        Map params = (Map)request.toObject();
        String vmName = "--";
        ResourceMapping resMap = null;
        try {
            List lisResMaps;
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            GalaxVM vm = this.getGalaxVMParam(params);
            vmName = vm.getName();
            String recoveryCloudSn = this.getRecoveryCloudSnParam(params);
            String recoveryVrgSn = this.getRecoveryVRGSnParam(params);
            String extendProps = this.getExtendProps(params);
            this.checkUserResourceAuthority(recoveryVrgSn);
            this.checkUserResourceAuthority(recoveryCloudSn);
            IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
            QueryCondition condition = new QueryCondition("productResourceId", (Object)recoveryVrgSn);
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            conditions.add(condition);
            String orderBy = "productResourceName";
            Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
            if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
                conditions.clear();
                QueryCondition newCondition = new QueryCondition("recoveryResourceId", (Object)recoveryVrgSn);
                conditions.add(newCondition);
                page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
            }
            List list = lisResMaps = null == page ? null : page.getResult();
            if (!VerifyUtil.isEmpty((Collection)lisResMaps)) {
                resMap = (ResourceMapping)lisResMaps.iterator().next();
                this.checkResourceMappingAuthority(resMap);
            }
            this.getService().syncCreateRecoveryVm(vm, recoveryVrgSn, recoveryCloudSn, extendProps);
        }
        catch (LegoCheckedException e) {
            if (0L != e.getErrorCode()) {
                this.generateCreatePHVmlog(resMap, vmName, e);
            } else {
                this.generateCreatePHVmlog(resMap, vmName, null);
            }
            throw e;
        }
        catch (Exception e) {
            this.generateCreatePHVmlog(resMap, vmName, new LegoCheckedException(-1L));
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        this.generateCreatePHVmlog(resMap, vmName, null);
    }

    private void generateCreatePHVmlog(ResourceMapping resMap, String vmName, LegoCheckedException ex) {
        logger.trace((Object)"enter generateCreatePHVmlog");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_syncCreateDRVM_operateName", 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_syncCreateDRVM_operateName", 2, vmName, "site_resource_syncCreateDRVM_operateDetail", logParams);
        }
    }

    @Override
    public void syncDeleteRecoveryVm(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncDeleteDRVM_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        String vmName = "--";
        this.checkRequest(request, vmName);
        Map params = (Map)request.toObject();
        String cloudSn = (String)params.get("cloudSn");
        String vmUuid = (String)params.get("vmUuid");
        String vrgSn = (String)params.get("vrgSn");
        String vmId = (String)params.get("phVmId");
        boolean isDelPhVm = Boolean.valueOf((String)params.get("isNeedToDelPhVm"));
        boolean isForce = Boolean.valueOf((String)params.get("isForceDelete"));
        IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
        ArrayList<String> vmUuids = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)vmUuid)) {
            logger.error((Object)"param vmUuid is null", 90160758787071L);
            LegoCheckedException e = new LegoCheckedException(1073947393L);
            this.generateRemoveVmsFromVRGLog(null, vmName, e);
            throw e;
        }
        vmUuids.add(vmUuid);
        List vmLists = resService.getResources(AssignedVm.class, "vmUuid", vmUuids);
        if (!VerifyUtil.isEmpty((Collection)vmLists)) {
            FixLengthProps poRecoveryProps = new FixLengthProps(((AssignedVm)vmLists.iterator().next()).getExtendProps(), 8192);
            String extendProps = poRecoveryProps.getValue("vmMgrInfo");
            vmName = JSONObject.fromObject((Object)extendProps).getString("name");
        }
        if (VerifyUtil.isEmpty((String)vrgSn)) {
            logger.error((Object)"param vrgSn or vmId is null", 90160758787071L);
            LegoCheckedException e = new LegoCheckedException(1073947393L);
            this.generateRemoveVmsFromVRGLog(null, vmName, e);
            throw e;
        }
        IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
        QueryCondition condition = new QueryCondition("productResourceId", (Object)vrgSn);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        String orderBy = "productResourceName";
        Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
            conditions.clear();
            QueryCondition newCondition = new QueryCondition("recoveryResourceId", (Object)vrgSn);
            conditions.add(newCondition);
            page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        }
        List lisResMaps = null == page ? null : page.getResult();
        ResourceMapping resMap = null;
        try {
            this.checkUserResourceAuthority(cloudSn);
            this.checkUserResourceAuthority(vrgSn);
            if (!VerifyUtil.isEmpty((Collection)lisResMaps)) {
                resMap = (ResourceMapping)lisResMaps.iterator().next();
                this.checkResourceMappingAuthority(resMap);
            }
            this.getService().syncDeleteRecoveryVm(cloudSn, vrgSn, vmUuid, vmId, isDelPhVm, isForce);
        }
        catch (LegoCheckedException e) {
            this.generateRemoveVmsFromVRGLog(resMap, vmName, e);
            throw e;
        }
        catch (Exception e) {
            this.generateRemoveVmsFromVRGLog(resMap, vmName, new LegoCheckedException(-1L));
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        this.generateRemoveVmsFromVRGLog(resMap, vmName, null);
    }

    private void checkRequest(RestJsonRequest request, String vmName) {
        logger.trace((Object)"enter checkRequest");
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
        }
        catch (LegoCheckedException e) {
            this.generateRemoveVmsFromVRGLog(null, vmName, e);
            throw e;
        }
    }

    private void generateRemoveVmsFromVRGLog(ResourceMapping resMap, String vmName, LegoCheckedException ex) {
        logger.trace((Object)"enter generateRemoveVmsFromVRGLog");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (null != resMap) {
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = resMap.getProductSiteName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = resMap.getRecoverySiteName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_syncDeleteDRVM_operateName", 2, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_syncDeleteDRVM_operateName", 2, vmName, "site_resource_syncDeleteDRVM_operateDetail", logParams);
        }
    }

    private GalaxVM getGalaxVMParam(Map<String, Object> params) {
        Object obj = params.get("GalaxVM");
        if (obj != null && obj instanceof GalaxVM) {
            return (GalaxVM)obj;
        }
        logger.error((Object)"param GalaxVM is null or not instanceof GalaxVM ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getRecoveryVRGSnParam(Map<String, Object> params) {
        Object obj = params.get("Recovery_VRG_SN");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        logger.error((Object)"param VRG_SN is null or not instanceof String ", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getRecoveryCloudSnParam(Map<String, Object> params) {
        Object obj = params.get("Recovery_Cloud_SN");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        logger.error((Object)"param CloudSn is null or not instanceof String", 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    private String getExtendProps(Map<String, Object> params) {
        logger.trace((Object)"enter getExtendProps");
        Object obj = params.get("extendProps");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    private IRecoveryVmController getService() {
        logger.trace((Object)"enter getService");
        return (IRecoveryVmController)this.getBundleService(HOST_REPLICATION_BUNDLE_NAME, IRecoveryVmController.class.getName());
    }

    @Override
    public String syncDeleteProductRecoveryVm(String vmUuid, String proVrgSn) throws ClassNotFoundException {
        GalaxVM gv;
        List lisResMaps;
        this.checkUserOperationAuthority("site_resource_syncDeleteDRVM_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        String vmName = "--";
        ResourceMapping resMap = null;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{vmUuid, proVrgSn});
            this.checkUserResourceAuthority(proVrgSn);
        }
        catch (LegoCheckedException e) {
            this.generateRemoveVmsFromVRGLog(null, vmName, e);
            throw e;
        }
        IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
        QueryCondition condition = new QueryCondition("productResourceId", (Object)proVrgSn);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        String orderBy = "productResourceName";
        Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        if (null == page || VerifyUtil.isEmpty((Collection)page.getResult())) {
            conditions.clear();
            QueryCondition newCondition = new QueryCondition("recoveryResourceId", (Object)proVrgSn);
            conditions.add(newCondition);
            page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
        }
        List list = lisResMaps = null == page ? null : page.getResult();
        if (!VerifyUtil.isEmpty((Collection)lisResMaps)) {
            resMap = (ResourceMapping)lisResMaps.iterator().next();
        }
        IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
        ArrayList<String> vmUuids = new ArrayList<String>();
        vmUuids.add(vmUuid);
        List vmList = resService.getResources(GalaxVM.class, "uuid", vmUuids);
        if (!VerifyUtil.isEmpty((Collection)vmList) && null != (gv = (GalaxVM)vmList.iterator().next())) {
            vmName = gv.getName();
        }
        String result = null;
        try {
            result = this.getService().syncDeleteProductRecoveryVm(vmUuid, proVrgSn);
        }
        catch (LegoCheckedException e) {
            this.generateRemoveVmsFromVRGLog(resMap, vmName, e);
            throw e;
        }
        catch (Exception e) {
            this.generateRemoveVmsFromVRGLog(resMap, vmName, new LegoCheckedException(-1L));
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        this.generateRemoveVmsFromVRGLog(resMap, vmName, null);
        return result;
    }

    @Override
    public String syncVmManagementInfo(String vmUuid, String vmUriOrId, String cloudSn) throws ClassNotFoundException {
        this.checkUserOperationAuthority("site_resource_syncUpdateVRGVMInfo_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        String vmName = "--";
        String result = null;
        try {
            GalaxVM gVM;
            BaseRestUtils.checkParamCommon((Object[])new Object[]{vmUuid, vmUriOrId, cloudSn});
            IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
            ArrayList<String> vmUuids = new ArrayList<String>();
            vmUuids.add(vmUuid);
            List vmLists = resService.getResources(GalaxVM.class, "uuid", vmUuids);
            if (!VerifyUtil.isEmpty((Collection)vmLists) && null != (gVM = (GalaxVM)vmLists.iterator().next())) {
                vmName = gVM.getName();
            }
            this.checkUserResourceAuthority(cloudSn);
            result = this.getService().syncVmManagementInfo(vmUuid, vmUriOrId, cloudSn);
        }
        catch (LegoCheckedException e) {
            this.generateSynVMManageInfolog(vmName, e);
            throw e;
        }
        catch (Exception e) {
            this.generateSynVMManageInfolog(vmName, new LegoCheckedException(-1L));
            ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)-1L, null, (Log)logger);
        }
        this.generateSynVMManageInfolog(vmName, null);
        return result;
    }

    private void generateSynVMManageInfolog(String vmName, LegoCheckedException ex) {
        logger.trace((Object)"enter generateSynVMManageInfolog");
        if (null != ex) {
            this.writeFailedOperationLogNoException("site_resource_syncUpdateVRGVMInfo_operateName", 3, vmName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("site_resource_syncUpdateVRGVMInfo_operateName", 3, vmName, null, null);
        }
    }

    @Override
    public String syncGetVmStatsAndPgr(String pgId) throws ClassNotFoundException {
        this.checkUserOperationAuthority("protectedGroup_query_operateName", 2, "ism.drm.protectgroup.auth.scan");
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"parameter pgId is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = ((IProtectGroupBaseService)this.getBundleService(IProtectGroupBaseService.class)).getProtectGroupByID(pgId);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)("can not get the protect group, pgId=" + pgId), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserAuthority(pgId);
        IBHRPgController service = (IBHRPgController)this.getBundleService(HOST_REPLICATION_BUNDLE_NAME, IBHRPgController.class.getName());
        String valueString = service.syncGetVmStatsAndPgr(pgId);
        return valueString;
    }
}

