/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgNetInfoEnum;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VrgIpInfo;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.IResMappingSynRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.List;

public class ResMappingSynRestServiceImpl
extends AbsVRRestService
implements IResMappingSynRestService {
    private static final String GALAX_BUNDLE_NAME = "DRM_FusionShpere_Base";
    private static final Log LOG = LogFactory.getInstance(ResMappingSynRestServiceImpl.class);

    private IResourceMappingService getService() {
        return (IResourceMappingService)this.getBundleService(GALAX_BUNDLE_NAME, IResourceMappingService.class.getName());
    }

    @Override
    public void synAddResourceMapping(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("resource_createResourceMapping_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        int restype = 0;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            ResourceMapping resMap = (ResourceMapping)request.toObject();
            restype = resMap.getResourceType();
            Site proSite = this.getSiteBySiteId(resMap.getProductSiteId());
            Site recoverySite = this.getSiteBySiteId(resMap.getRecoverySiteId());
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = proSite.getName();
            logParams[3] = resMap.getProductResourceProviderName();
            if (3 == restype || 4 == restype) {
                logParams[4] = resMap.getProductVpcName();
                logParams[5] = recoverySite.getName();
                logParams[6] = resMap.getRecoveryResourceProviderName();
                logParams[7] = resMap.getRecoveryVpcName();
            } else {
                logParams[4] = recoverySite.getName();
                logParams[5] = resMap.getRecoveryResourceProviderName();
            }
            this.checkResourceMappingAuthority(resMap);
            this.getService().synAddResourceMapping(resMap);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create resourceMapping error.", (Throwable)e, 90160758787071L);
            this.generateAddResLog(logParams, restype, e);
            throw e;
        }
        this.generateAddResLog(logParams, restype, null);
    }

    @Override
    public void synDeleteResourceMapping(String resMappingId) {
        this.checkUserOperationAuthority("resource_deleteResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        ResourceMapping resMap = null;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{resMappingId});
            IResourceMappingService rmService = (IResourceMappingService)this.getBundleService(GALAX_BUNDLE_NAME, IResourceMappingService.class.getName(), IResourceMappingService.class);
            if (VerifyUtil.isEmpty((Object)rmService)) {
                LOG.error((Object)"get IResourceMappingService failed", 90160758787071L);
                throw new LegoCheckedException(-1L);
            }
            resMap = rmService.getResourceMappingById(resMappingId);
            if (!VerifyUtil.isEmpty((Object)resMap)) {
                this.checkResourceMappingAuthority(resMap);
                this.getService().synDeleteResourceMapping(resMappingId);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"delete resourceMapping error.", (Throwable)e, 90160758787071L);
            this.generateDelOptResLog(resMap, e, "resource_deleteResourceMapping_operateName");
            throw e;
        }
        this.generateDelOptResLog(resMap, null, "resource_deleteResourceMapping_operateName");
    }

    @Override
    public void synUpdateResourceMapping(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("resource_modifyResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        ResourceMapping srcResMap = null;
        ResourceMapping dstResMap = null;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            dstResMap = (ResourceMapping)request.toObject();
            IResourceMappingService rmService = (IResourceMappingService)this.getBundleService(GALAX_BUNDLE_NAME, IResourceMappingService.class.getName(), IResourceMappingService.class);
            if (VerifyUtil.isEmpty((Object)rmService)) {
                LOG.error((Object)"get IResourceMappingService failed", 90160758787071L);
                throw new LegoCheckedException(-1L);
            }
            srcResMap = rmService.getResourceMappingById(dstResMap.getMappingId());
            this.checkResourceMappingAuthority(srcResMap);
            this.checkResourceMappingAuthority(dstResMap);
            this.getService().synUpdateResourceMapping(dstResMap);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"update resourceMapping error.", (Throwable)e, 90160758787071L);
            this.generateModOptResLog(srcResMap, dstResMap, e, "resource_modifyResourceMapping_operateName");
            throw e;
        }
        this.generateModOptResLog(srcResMap, dstResMap, null, "resource_modifyResourceMapping_operateName");
    }

    @Override
    public String getAvailableCluster(String siteId, String vrmId) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, vrmId});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(vrmId);
        List computeClusterList = this.getService().getAvailableCluster(siteId, vrmId);
        return this.convertArrayToJsonString(computeClusterList);
    }

    @Override
    public String getAvailablePortGroup(String siteId, String vrmId) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, vrmId});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(vrmId);
        List portGroupList = this.getService().getAvailablePortGroup(siteId, vrmId);
        return this.convertArrayToJsonString(portGroupList);
    }

    @Override
    public String getAvailableComputeNode(String siteId, String vrmId) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, vrmId});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(vrmId);
        List computeNodeList = this.getService().getAvailableComputeNode(siteId, vrmId);
        return this.convertArrayToJsonString(computeNodeList);
    }

    @Override
    public String getAvailableNetwork(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(sn);
        List networkList = this.getService().getAvailableNetwork(siteId, sn);
        return this.convertArrayToJsonString(networkList);
    }

    @Override
    public String getAvailableSecurityGroup(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(sn);
        List securityGroupList = this.getService().getAvailableSecurityGroup(siteId, sn);
        return this.convertArrayToJsonString(securityGroupList);
    }

    @Override
    public String getAllVPC(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(sn);
        List vpcList = this.getService().getAllVPC(siteId, sn);
        return this.convertArrayToJsonString(vpcList);
    }

    @Override
    public String getMappingVpcByVpc(String siteId, String fmSn, String vpcSn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, fmSn, vpcSn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(fmSn);
        List vpcList = this.getService().getMappingVpcByVpc(siteId, fmSn, vpcSn);
        return this.convertArrayToJsonString(vpcList);
    }

    @Override
    public String getRemoteCloudPaltformDrResource(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        DrResource drCloud = this.getService().getRemoteCloudPaltformDrResource(siteId, sn);
        JSONObject object = new JSONObject();
        if (null == drCloud) {
            return object.toString();
        }
        try {
            object.put((Object)"name", (Object)drCloud.getName());
            object.put((Object)"uuid", (Object)drCloud.getDeviceSn());
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return object.toString();
    }

    @Override
    public String getAvailableVpcByVpc(String siteId, String fmSn, String vpcSn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, fmSn, vpcSn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(fmSn);
        List vpcList = this.getService().getAvailableVpcByVpc(siteId, fmSn, vpcSn);
        return this.convertArrayToJsonString(vpcList);
    }

    @Override
    public String getAvailableDataStore(String siteId, String vrmId) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, vrmId});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(vrmId);
        List dataStoreList = this.getService().getAvailableDataStore(siteId, vrmId);
        return this.convertArrayToJsonString(dataStoreList);
    }

    @Override
    public String getAvailableVDC(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(sn);
        List vdcList = this.getService().getAvailableVDC(siteId, sn);
        return this.convertArrayToJsonString(vdcList);
    }

    private <T extends ManagedObject> String convertArrayToJsonString(List<T> list) {
        JSONArray result = new JSONArray();
        if (null == list || list.isEmpty()) {
            return result.toString();
        }
        try {
            for (ManagedObject galaxObject : list) {
                JSONObject object = new JSONObject();
                object.put((Object)"name", (Object)galaxObject.getName());
                object.put((Object)"uuid", (Object)galaxObject.getUuid());
                if (galaxObject instanceof DataStore) {
                    DataStore dataStore = (DataStore)galaxObject;
                    object.put((Object)"storageUnits", (Object)dataStore.getStorageUnits());
                }
                if (galaxObject instanceof ComputeCluster) {
                    ComputeCluster computeCluster = (ComputeCluster)galaxObject;
                    object.put((Object)"arch", (Object)computeCluster.getArch());
                }
                if (galaxObject instanceof ComputeNode) {
                    ComputeNode computeNode = (ComputeNode)galaxObject;
                    object.put((Object)"arch", (Object)computeNode.getArch());
                }
                result.add((Object)object);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return result.toString();
    }

    @Override
    public String getAvailableVRG(String siteId, String sn) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        BaseRestUtils.checkParamCommon((Object[])new Object[]{siteId, sn});
        this.checkUserAuthority(siteId);
        this.checkUserResourceAuthority(sn);
        List vrgList = this.getService().getAvailableVRG(siteId, sn);
        List<VRG> vrgRetList = this.filterResourceList(vrgList);
        return this.convertVRGArrayToJsonString(vrgRetList);
    }

    private String convertVRGArrayToJsonString(List<VRG> list) {
        JSONArray result = new JSONArray();
        if (null == list || list.isEmpty()) {
            return result.toString();
        }
        try {
            for (VRG vrg : list) {
                JSONObject object = new JSONObject();
                object.put((Object)"name", (Object)vrg.getName());
                object.put((Object)"uuid", (Object)vrg.getUuid());
                object.put((Object)"ipAddress", (Object)vrg.getIpAddress());
                VrgIpInfo businessIp = this.getVRGBusinessIpInfo(vrg.getMoId());
                if (businessIp != null) {
                    object.put((Object)"businessIp", (Object)businessIp.getAddress());
                    object.put((Object)"businessPort", (Object)businessIp.getPort());
                }
                result.add((Object)object);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"create json object error. ", (Throwable)e, 90160758787071L);
        }
        return result.toString();
    }

    private VrgIpInfo getVRGBusinessIpInfo(Long moId) {
        IVRGController vrgService = (IVRGController)this.getBundleService("DRM_FusionShpere_VRG", IVRGController.class.getName());
        return vrgService.getVrgIpInfo(moId.longValue(), VrgNetInfoEnum.BUSINESS);
    }
}

