/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VrgMapStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.VRGResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.drp.ExportResMappingBs;
import com.huawei.ism.drm.rest.fusionsphere.drp.RecoveryPlanBs;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.model.ResourceMappingVO;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.IResourceMappingRestService;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.ResourceMappingScope;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.ResourceMappingUtil;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.VRGResPairTask;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class ResourceMappingRestServiceImpl
extends AbsVRRestService
implements IResourceMappingRestService {
    private static Log logger = LogFactory.getInstance(ResourceMappingRestServiceImpl.class);
    private static final String DRM_GALAX_MANAGER = "DRM_FusionShpere_Base";
    private static final String VRG_BUNDLE_NAME = "DRM_FusionShpere_VRG";

    @Override
    public BatchOperationResult createResourceMapping(ResourceMappingVO rmvo) {
        this.checkUserOperationAuthority("resource_createResourceMapping_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        BatchOperationResult optResult = null;
        try {
            this.checkArchAndCpuVendor(rmvo);
            List<ResourceMapping> resourceMappings = this.configResourceMappingList(rmvo);
            logger.info((Object)"To add ResourceMapping.", 90160758786816L);
            IResourceMappingService rmService = this.getResourceMappingService();
            optResult = rmService.createResourceMapping(resourceMappings);
            if (resourceMappings.get(0).getResourceType() == ResTypeEnum.VRG.getResType()) {
                VRGResPairTask vrgResPairTask = new VRGResPairTask(resourceMappings, this.getVRGService());
                vrgResPairTask.start();
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create resourceMapping list error.", (Throwable)e, 90160758787071L);
            this.addOptLogByOptResult(optResult, rmvo, e);
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            this.addOptLogByOptResult(optResult, rmvo, ex);
            ExceptionUtil.rethrowException((Throwable)e, (String)"create resourceMapping list with exception.", (long)-1L, null, (Log)logger);
        }
        this.addOptLogByOptResult(optResult, rmvo, null);
        return optResult;
    }

    private void checkArchAndCpuVendor(ResourceMappingVO rmvo) {
        if (rmvo.getResourceType() == ResTypeEnum.CLUSTER_RESOURCE.getResType() || rmvo.getResourceType() == ResTypeEnum.COMPUTE_NODE.getResType()) {
            List<ManagedObject> resProList = this.getResourceListAddResMapping(String.valueOf(rmvo.getResourceType()), rmvo.getProductSiteId(), rmvo.getProductResourceProviderId());
            List<ManagedObject> resRecList = this.getResourceListAddResMapping(String.valueOf(rmvo.getResourceType()), rmvo.getRecoverySiteId(), rmvo.getRecoveryResourceProviderId());
            for (int i = 0; i < rmvo.getProductResourceId().length; ++i) {
                String productResoureId = rmvo.getProductResourceId()[i];
                String recoveryResoureId = rmvo.getRecoveryResourceId()[i];
                GalaxObject productResource = (GalaxObject)resProList.stream().filter(a -> a.getUuid().equals(productResoureId)).findFirst().get();
                GalaxObject recoveyResource = (GalaxObject)resRecList.stream().filter(a -> a.getUuid().equals(recoveryResoureId)).findFirst().get();
                if (VerifyUtil.isEmpty((Object)productResource) || VerifyUtil.isEmpty((Object)recoveyResource)) {
                    throw new LegoCheckedException(1073947394L);
                }
                this.checkArchAndCpuVendor(productResource, recoveyResource);
            }
        }
    }

    private void checkArchAndCpuVendor(GalaxObject productResource, GalaxObject recoveyResource) {
        if (!(VerifyUtil.isEmpty((String)productResource.getArch()) || VerifyUtil.isEmpty((String)recoveyResource.getArch()) || productResource.getArch().equals(recoveyResource.getArch()))) {
            logger.error((Object)"Failed to verify the arch, local(%s):remote(%s).", new Object[]{productResource.getArch(), recoveyResource.getArch()});
            throw new LegoCheckedException(1073949725L, new String[]{productResource.getName(), recoveyResource.getName()});
        }
        if (!(VerifyUtil.isEmpty((String)productResource.getCpuVendor()) || VerifyUtil.isEmpty((String)recoveyResource.getCpuVendor()) || productResource.getCpuVendor().equals(recoveyResource.getCpuVendor()))) {
            logger.error((Object)"Failed to verify the CPU vendor, local(%s):remote(%s).", new Object[]{productResource.getCpuVendor(), recoveyResource.getCpuVendor()});
            throw new LegoCheckedException(1073949727L, new String[]{productResource.getName(), recoveyResource.getName()});
        }
    }

    private void checkArchAndCpuVendor(ResourceMapping resMap) {
        if (resMap.getResourceType() == ResTypeEnum.CLUSTER_RESOURCE.getResType() || resMap.getResourceType() == ResTypeEnum.COMPUTE_NODE.getResType()) {
            List<ManagedObject> resProList = this.getResourceListAddResMapping(String.valueOf(resMap.getResourceType()), resMap.getProductSiteId(), resMap.getProductResourceProviderId());
            List<ManagedObject> resRecList = this.getResourceListAddResMapping(String.valueOf(resMap.getResourceType()), resMap.getRecoverySiteId(), resMap.getRecoveryResourceProviderId());
            GalaxObject productResource = (GalaxObject)resProList.stream().filter(a -> a.getUuid().equals(resMap.getProductResourceId())).findFirst().get();
            GalaxObject recoveyResource = (GalaxObject)resRecList.stream().filter(a -> a.getUuid().equals(resMap.getRecoveryResourceId())).findFirst().get();
            if (VerifyUtil.isEmpty((Object)productResource) || VerifyUtil.isEmpty((Object)recoveyResource)) {
                throw new LegoCheckedException(1073947394L);
            }
            if (!(VerifyUtil.isEmpty((String)productResource.getArch()) || VerifyUtil.isEmpty((String)recoveyResource.getArch()) || productResource.getArch().equals(recoveyResource.getArch()))) {
                throw new LegoCheckedException(1073949725L, new String[]{productResource.getName(), recoveyResource.getName()});
            }
            if (!(VerifyUtil.isEmpty((String)productResource.getCpuVendor()) || VerifyUtil.isEmpty((String)recoveyResource.getCpuVendor()) || productResource.getCpuVendor().equals(recoveyResource.getCpuVendor()))) {
                throw new LegoCheckedException(1073949727L, new String[]{productResource.getName(), recoveyResource.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResourceMapping(int resourceType, String filterName, String filterValue, String orderBy, String orderType) {
        int total;
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        Validator.canOrderBy((String)orderBy);
        Page page = null;
        ArrayList<ResourceMapping> rmList = new ArrayList();
        Boolean sortOrder = true;
        try {
            IResourceMappingService rmService = this.getResourceMappingService();
            if ("desc".equalsIgnoreCase(orderType)) {
                sortOrder = false;
            }
            PageParameter pagePara = this.getPageParameter();
            page = rmService.pageQueryConditionResourceMapping(pagePara.getStartPage(), pagePara.getPageSize(), orderBy, sortOrder.booleanValue(), this.queryCondition(resourceType, filterName, filterValue));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to pageQueryResourceMapping. Caught Exception ", (long)-1L, null, (Log)logger);
        }
        finally {
            if (null != page) {
                total = (int)page.getTotalCount();
                rmList = page.getResult();
                ResourceMappingScope rmScope = new ResourceMappingScope();
                List<ResourceMapping> delResmappings = rmScope.filterResourceMapping(rmList, this.getCurrentUserId());
                total -= delResmappings.size();
            } else {
                total = 0;
            }
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"totalCount", (Object)total);
        returnObject.put((Object)"records", (Object)this.resourceMappingToJsonStr(rmList));
        return returnObject.toString();
    }

    @Override
    public String getResourceMappingById(String mappingId) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)mappingId)) {
            logger.error((Object)"Failed to get ResourceMapping, mappingId is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L, "Failed to get ResourceMapping, mappingId is empty.");
        }
        ResourceMapping resMap = new ResourceMapping();
        try {
            IResourceMappingService rmService = this.getResourceMappingService();
            resMap = rmService.getResourceMappingById(mappingId);
            this.checkResourceMappingAuthority(resMap);
            logger.info((Object)("To get ResourceMapping, mappingId is [" + mappingId + "]."), 90160758786816L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to modify ResourceMapping. ResourceMapping is [" + mappingId + "]. "), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to modify ResourceMapping. ResourceMapping is [" + mappingId + "]. "), (long)-1L, null, (Log)logger);
        }
        JSONObject returnRes = this.getResMapJsonObject(resMap);
        return returnRes.toString();
    }

    @Override
    public Response modifyResourceMapping(String mappingId, ResourceMapping newResMap) {
        this.checkUserOperationAuthority("resource_modifyResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        if (VerifyUtil.isEmpty((String)mappingId)) {
            logger.error((Object)"Failed to modify ResourceMapping, mappingId is empty.");
            LegoCheckedException ex = new LegoCheckedException(1073947393L, "Failed to modify ResourceMapping, mappingId is empty.");
            this.generateModOptResLog(null, null, ex, "resource_modifyResourceMapping_operateName");
            throw ex;
        }
        ResourceMapping srcResMap = null;
        ResourceMapping dstResMap = null;
        try {
            IResourceMappingService rmService = this.getResourceMappingService();
            ResourceMapping oldResMap = rmService.getResourceMappingById(mappingId);
            if (oldResMap == null) {
                logger.error((Object)"Data resMap is null when modifyResourceMapping.");
                throw new LegoCheckedException(1073947394L);
            }
            if (!oldResMap.getRecoveryResourceId().equals(newResMap.getRecoveryResourceId())) {
                this.checkDrsMapping(oldResMap);
            }
            srcResMap = rmService.getResourceMappingById(mappingId);
            this.checkResourceMappingAuthority(oldResMap);
            this.configResourceMapping(oldResMap, newResMap);
            this.checkResourceMappingAuthority(oldResMap);
            this.checkArchAndCpuVendor(oldResMap);
            logger.info((Object)"To modify ResourceMapping, mappingId is %s.", new Object[]{mappingId});
            rmService.updateResourceMapping(oldResMap);
            dstResMap = rmService.getResourceMappingById(mappingId);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Failed to modify ResourceMapping. ResourceMapping is %s.", new Object[]{ex, mappingId});
            this.generateModOptResLog(srcResMap, null, ex, "resource_modifyResourceMapping_operateName");
            throw ex;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            this.generateModOptResLog(srcResMap, null, ex, "resource_modifyResourceMapping_operateName");
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to modify ResourceMapping. ResourceMapping is [" + mappingId + "]. "), (long)-1L, null, (Log)logger);
        }
        logger.info((Object)"Succeed to modify ResourceMapping, mappingId is %s.", new Object[]{mappingId});
        this.generateModOptResLog(srcResMap, dstResMap, null, "resource_modifyResourceMapping_operateName");
        return Response.ok().build();
    }

    private void configResourceMapping(ResourceMapping resourceMapping, ResourceMapping newResMap) {
        Site productSite = this.getSiteBySiteId(resourceMapping.getProductSiteId());
        if (productSite.getSiteType() != 0) {
            logger.error((Object)"only product site can do it.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String recoverySiteId = newResMap.getRecoverySiteId();
        String recoveryResourceProviderId = newResMap.getRecoveryResourceProviderId();
        String recoveryResourceId = newResMap.getRecoveryResourceId();
        this.checkParam(new String[]{recoverySiteId, recoveryResourceProviderId, recoveryResourceId});
        resourceMapping.setRecoverySiteId(recoverySiteId);
        resourceMapping.setRecoverySiteName("");
        resourceMapping.setRecoveryResourceProviderId(recoveryResourceProviderId);
        resourceMapping.setRecoveryResourceProviderName("");
        resourceMapping.setRecoveryResourceId(recoveryResourceId);
        resourceMapping.setRecoveryResourceName("");
        if (3 == resourceMapping.getResourceType() || 4 == resourceMapping.getResourceType()) {
            String recoveryVpcId = newResMap.getRecoveryVpcId();
            this.checkParam(new String[]{recoveryVpcId});
            resourceMapping.setRecoveryVpcId(recoveryVpcId);
            resourceMapping.setRecoveryVpcName("");
        }
    }

    @Override
    public Response deleteResourceMapping(String mappingId, Boolean isForce) {
        this.checkUserOperationAuthority("resource_deleteResourceMapping_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        ResourceMapping resMap = null;
        if (VerifyUtil.isEmpty((String)mappingId)) {
            logger.error((Object)"Failed to delete ResourceMapping, mappingId is empty.");
            LegoCheckedException ex = new LegoCheckedException(1073947393L, "Failed to delete ResourceMapping error, mappingId is empty.");
            this.generateDelOptResLog(null, ex, "resource_deleteResourceMapping_operateName");
            throw ex;
        }
        try {
            IResourceMappingService rmService = this.getResourceMappingService();
            resMap = rmService.getResourceMappingById(mappingId);
            if (VerifyUtil.isEmpty((Object)resMap)) {
                throw new LegoCheckedException(1073947394L);
            }
            Site productSite = this.getSiteBySiteId(resMap.getProductSiteId());
            if (productSite.getSiteType() != 0) {
                logger.error((Object)"only product site can do it.");
                throw new LegoCheckedException(1073947393L);
            }
            this.checkResourceMappingAuthority(resMap);
            this.checkDrsMapping(resMap);
            if (resMap.getResourceType() == ResTypeEnum.VRG.getResType()) {
                this.deleteVRGMapping(isForce, resMap);
            } else {
                rmService.checkResourceMappingCanDelete(mappingId);
                rmService.deleteResourceMapping(mappingId);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Failed to delete ResourceMapping. ResourceMappingId is %s.", new Object[]{ex, mappingId});
            this.generateDelOptResLog(resMap, ex, "resource_deleteResourceMapping_operateName");
            throw ex;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            this.generateDelOptResLog(resMap, ex, "resource_deleteResourceMapping_operateName");
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to delete ResourceMapping. ResourceMapping is [" + mappingId + "]. "), (long)-1L, null, (Log)logger);
        }
        this.generateDelOptResLog(resMap, null, "resource_deleteResourceMapping_operateName");
        logger.info((Object)"Succeed to delete ResourceMapping, mappingId is %s.", new Object[]{mappingId});
        return Response.ok().build();
    }

    private void checkDrsMapping(ResourceMapping resMap) {
        if (resMap.getResourceType() != 0) {
            return;
        }
        IDrsMappingService drsMappingService = (IDrsMappingService)this.getBundleService(DRM_GALAX_MANAGER, IDrsMappingService.class.getName());
        int num = drsMappingService.countMappingByCluster(resMap.getMappingId());
        if (num > 0) {
            logger.info((Object)"Data drsMapping is existing, mappingId is %s.", new Object[]{resMap.getMappingId()});
            throw new LegoCheckedException(1073949751L);
        }
    }

    private void deleteVRGMapping(Boolean isForce, ResourceMapping resMap) {
        IVRGController vrgService = this.getVRGService();
        int status = ResourceMappingUtil.getVrgMappingStatus(resMap, vrgService);
        if (status == VrgMapStatusEnum.MAPPING.getStatus()) {
            throw new LegoCheckedException(102401L, "Failed to delete ResourceMapping error, vrg is mapping.");
        }
        if (status == VrgMapStatusEnum.NORMAL.getStatus() || status == VrgMapStatusEnum.MAPPING_FAILED.getStatus() || status == VrgMapStatusEnum.LINK_DOWN.getStatus()) {
            vrgService.deleteVRGMap(this.getCurrentUserName(), resMap.getProductResourceId(), resMap.getRecoveryResourceId(), isForce.booleanValue());
        }
    }

    @Override
    public String getResource(int resourceType, String siteId, String resourceProviderId, String filterName, String filterValue) {
        this.checkUserOperationAuthority("resource_queryResourceMapping_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId) || VerifyUtil.isEmpty((String)resourceProviderId)) {
            logger.error((Object)("param error by siteId: " + siteId + " providerId :" + resourceProviderId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(siteId);
        Site site = this.getSiteBySiteId(siteId);
        if (0 == site.getSiteType()) {
            this.checkUserResourceAuthority(resourceProviderId);
        }
        List<ManagedObject> resList = this.getResourceListAddResMapping(String.valueOf(resourceType), siteId, resourceProviderId);
        JSONArray arrayResources = new JSONArray();
        for (ManagedObject managedObject : resList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"resourceId", (Object)managedObject.getUuid());
            jsonObject.put((Object)"resourceName", (Object)managedObject.getName());
            if (managedObject instanceof ComputeCluster) {
                ComputeCluster computeCluster = (ComputeCluster)managedObject;
                jsonObject.put((Object)"arch", (Object)computeCluster.getArch());
                jsonObject.put((Object)"cpuVendor", (Object)computeCluster.getCpuVendor());
            }
            if (managedObject instanceof ComputeNode) {
                ComputeNode computeNode = (ComputeNode)managedObject;
                jsonObject.put((Object)"arch", (Object)computeNode.getArch());
                jsonObject.put((Object)"cpuVendor", (Object)computeNode.getCpuVendor());
            }
            if (VerifyUtil.isEmpty((String)filterValue)) {
                arrayResources.add((Object)jsonObject);
                continue;
            }
            if (!managedObject.getName().contains(filterValue.toLowerCase(Locale.getDefault())) && !managedObject.getName().contains(filterValue.toUpperCase(Locale.getDefault()))) continue;
            arrayResources.add((Object)jsonObject);
        }
        return arrayResources.toString();
    }

    @Override
    public String getTestnetworks(String planId, String recoverySiteId) {
        logger.debug((Object)("ResourceMappingRestServiceImpl:getTestnetworks enter, planId=" + planId), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"get test networks failed, the recovery planId is empty", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(planId);
        JSONObject jsonObject = RecoveryPlanBs.getInstance().getAllTestnetworks(planId, recoverySiteId, this.getCurrentUserId());
        logger.debug((Object)"ResourceMappingRestServiceImpl:getTestnetworks leave.", 90160758786816L);
        return jsonObject.toString();
    }

    @Override
    public Response exportRecoveryReport(String planId) {
        logger.debug((Object)("ResourceMappingRestServiceImpl:exportRecoveryReport enter, planId=" + planId), 90160758786816L);
        this.checkUserOperationAuthority("recoveryPlan_exportResourceMaping_operateName", 1, "ism.drm.drp.auth.recoverymapping.export");
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"export resource mapping failed, the recovery planId is empty", 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateExportLog(planId, ex);
            throw ex;
        }
        try {
            this.checkUserAuthority(planId);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            ExportResMappingBs.getInstance().exportResMapping(planId, this.createHeadInfo(), this.getResponse());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"export resource mapping failed, LegoCheckedException:", (Throwable)e, 90160758787071L);
            this.generateExportLog(planId, e);
            throw e;
        }
        catch (Exception e) {
            LegoCheckedException ex = new LegoCheckedException(-1L, (Throwable)e);
            this.generateExportLog(planId, ex);
            ExceptionUtil.rethrowException((Throwable)e, (String)"export resource mapping catch Exception", (long)-1L, null, (Log)logger);
        }
        this.generateExportLog(planId, null);
        logger.debug((Object)"ResourceMappingRestServiceImpl:exportRecoveryReport leave.", 90160758786816L);
        return Response.ok().build();
    }

    private IResourceMappingService getResourceMappingService() {
        logger.debug((Object)"getResourceMappingService start");
        return (IResourceMappingService)this.getBundleService(DRM_GALAX_MANAGER, IResourceMappingService.class.getName());
    }

    private List<QueryCondition> queryCondition(int resourceType, String field, String value) {
        logger.debug((Object)"queryCondition start");
        ArrayList<QueryCondition> qcs = new ArrayList<QueryCondition>();
        String queryFiled = "resourceType";
        QueryCondition queryCondition = new QueryCondition(queryFiled, (Object)resourceType);
        qcs.add(queryCondition);
        if (null == field || field.length() == 0 || value == null) {
            return qcs;
        }
        QueryCondition qc = new QueryCondition(field, (Object)value);
        qcs.add(qc);
        return qcs;
    }

    private String resourceMappingToJsonStr(List<ResourceMapping> resourceMappingInfoList) {
        logger.debug((Object)"resourceMappingToJsonStr start");
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(resourceMappingInfoList)) {
            return jsonArray.toString();
        }
        for (ResourceMapping resMap : resourceMappingInfoList) {
            jsonArray.add((Object)this.getResMapJsonObject(resMap));
        }
        return jsonArray.toString();
    }

    private IVRGController getVRGService() {
        logger.debug((Object)"getVRGService start");
        return (IVRGController)super.getBundleService(VRG_BUNDLE_NAME, IVRGController.class.getName(), IVRGController.class);
    }

    private List<ManagedObject> getResourceListAddResMapping(String resourceType, String siteId, String vrmId) {
        ArrayList<ManagedObject> moList = new ArrayList<ManagedObject>();
        IResourceMappingService rmService = this.getResourceMappingService();
        logger.info((Object)("To get resourceType:" + resourceType + " resource list, siteId is [" + siteId + "] vrmId is [" + vrmId + "]"), 90160758786816L);
        try {
            Collection<? extends ManagedObject> availaleResources = this.getAvailableResource(siteId, vrmId, resourceType, rmService);
            if (null == availaleResources) {
                availaleResources = Collections.emptySet();
            }
            moList.addAll(availaleResources);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get resourceType:" + resourceType + " Resource list, caught Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return moList;
    }

    private Collection<? extends ManagedObject> getAvailableResource(String siteId, String vrmId, String resourceType, IResourceMappingService rmService) {
        logger.debug((Object)("getAvailableResource start:resourceType=" + resourceType));
        if (Integer.parseInt(resourceType) == ResTypeEnum.CLUSTER_RESOURCE.getResType()) {
            return rmService.getAvailableCluster(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.COMPUTE_NODE.getResType()) {
            return rmService.getAvailableComputeNode(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.PORT_GROUP.getResType()) {
            return rmService.getAvailablePortGroup(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.NETWORK.getResType()) {
            return rmService.getAvailableNetwork(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.SECURITY_GROUP.getResType()) {
            return rmService.getAvailableSecurityGroup(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.VRG.getResType()) {
            return this.getAvaiableVrg(siteId, vrmId, rmService);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.DATASTORE.getResType()) {
            return rmService.getAvailableDataStore(siteId, vrmId);
        }
        if (Integer.parseInt(resourceType) == ResTypeEnum.VDC.getResType()) {
            return rmService.getAvailableVDC(siteId, vrmId);
        }
        return Collections.emptySet();
    }

    private Collection<? extends ManagedObject> getAvaiableVrg(String siteId, String vrmId, IResourceMappingService rmService) {
        Site site = this.getSiteBySiteId(siteId);
        if (0 == site.getSiteType()) {
            List allVrgs = rmService.getAvailableVRG(siteId, vrmId);
            return this.filterResourceList(allVrgs);
        }
        return rmService.getAvailableVRG(siteId, vrmId);
    }

    private List<ResourceMapping> configResourceMappingList(ResourceMappingVO rmvo) {
        Site recoverySite;
        ArrayList<ResourceMapping> resourceMapping = new ArrayList<ResourceMapping>();
        String productSiteId = rmvo.getProductSiteId();
        String productResourceProviderId = rmvo.getProductResourceProviderId();
        String recoverySiteId = rmvo.getRecoverySiteId();
        String recoveryResourceProviderId = rmvo.getRecoveryResourceProviderId();
        int resourceType = rmvo.getResourceType();
        String[] productResourceId = rmvo.getProductResourceId();
        String[] recoveryResourceId = rmvo.getRecoveryResourceId();
        String productVpcId = rmvo.getProductVpcId();
        String recoveryVpcId = rmvo.getRecoveryVpcId();
        this.checkParam(new String[]{productSiteId, productResourceProviderId, recoverySiteId, recoveryResourceProviderId});
        this.checkParam(productResourceId);
        this.checkParam(recoveryResourceId);
        this.checkUserAuthority(productSiteId);
        this.checkUserAuthority(recoverySiteId);
        Site productSite = this.getSiteBySiteId(productSiteId);
        if (0 == productSite.getSiteType()) {
            this.checkUserResourceAuthority(productResourceProviderId);
        }
        if (0 == (recoverySite = this.getSiteBySiteId(recoverySiteId)).getSiteType()) {
            this.checkUserResourceAuthority(recoveryResourceProviderId);
        }
        try {
            for (int i = 0; i < productResourceId.length; ++i) {
                ResourceMapping tmpResourceMapping = new ResourceMapping();
                tmpResourceMapping.setProductSiteId(productSiteId);
                tmpResourceMapping.setProductResourceProviderId(productResourceProviderId);
                tmpResourceMapping.setRecoverySiteId(recoverySiteId);
                tmpResourceMapping.setRecoveryResourceProviderId(recoveryResourceProviderId);
                tmpResourceMapping.setResourceType(resourceType);
                tmpResourceMapping.setProductResourceId(productResourceId[i]);
                tmpResourceMapping.setRecoveryResourceId(recoveryResourceId[i]);
                if (3 == resourceType || 4 == resourceType) {
                    this.checkParam(new String[]{productVpcId, recoveryVpcId});
                    tmpResourceMapping.setProductVpcId(productVpcId);
                    tmpResourceMapping.setRecoveryVpcId(recoveryVpcId);
                }
                if (ResTypeEnum.VRG.getResType() == resourceType) {
                    this.vrgCheck(productSiteId, recoverySiteId, productResourceId, recoveryResourceId, i);
                } else {
                    this.checkResourceProvider(productResourceId[i], productResourceProviderId);
                    this.checkResourceProvider(recoveryResourceId[i], recoveryResourceProviderId);
                }
                resourceMapping.add(tmpResourceMapping);
            }
            return resourceMapping;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Failed to set resource mapping list, caught Exception ", (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to set resource mapping list, caught Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    private void vrgCheck(String productSiteId, String recoverySiteId, String[] productResourceId, String[] recoveryResourceId, int i) {
        Site recoverySite;
        Site productSite = this.getSiteBySiteId(productSiteId);
        if (0 == productSite.getSiteType()) {
            this.checkUserResourceAuthority(productResourceId[i]);
        }
        if (0 == (recoverySite = this.getSiteBySiteId(recoverySiteId)).getSiteType()) {
            this.checkUserResourceAuthority(recoveryResourceId[i]);
        }
    }

    private void checkParam(String[] params) {
        if (null == params) {
            throw new LegoCheckedException(1073947393L);
        }
        for (int i = 0; i < params.length; ++i) {
            if (!VerifyUtil.isEmpty((String)params[i])) continue;
            logger.error((Object)"Failed to create resourcemapping, params are empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private JSONObject getResMapJsonObject(ResourceMapping resMap) {
        logger.debug((Object)"getResMapJsonObject start");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"mappingId", (Object)resMap.getMappingId());
        jsonObject.put((Object)"resourceType", (Object)resMap.getResourceType());
        jsonObject.put((Object)"productSiteId", (Object)resMap.getProductSiteId());
        jsonObject.put((Object)"productSiteName", (Object)resMap.getProductSiteName());
        jsonObject.put((Object)"productResourceProviderId", (Object)resMap.getProductResourceProviderId());
        jsonObject.put((Object)"productResourceProviderName", (Object)resMap.getProductResourceProviderName());
        jsonObject.put((Object)"productVpcId", (Object)resMap.getProductVpcId());
        jsonObject.put((Object)"productVpcName", (Object)resMap.getProductVpcName());
        jsonObject.put((Object)"productResourceId", (Object)resMap.getProductResourceId());
        jsonObject.put((Object)"productResourceName", (Object)resMap.getProductResourceName());
        jsonObject.put((Object)"recoverySiteId", (Object)resMap.getRecoverySiteId());
        jsonObject.put((Object)"recoverySiteName", (Object)resMap.getRecoverySiteName());
        jsonObject.put((Object)"recoveryResourceProviderId", (Object)resMap.getRecoveryResourceProviderId());
        jsonObject.put((Object)"recoveryResourceProviderName", (Object)resMap.getRecoveryResourceProviderName());
        jsonObject.put((Object)"recoveryVpcId", (Object)resMap.getRecoveryVpcId());
        jsonObject.put((Object)"recoveryVpcName", (Object)resMap.getRecoveryVpcName());
        jsonObject.put((Object)"recoveryResourceId", (Object)resMap.getRecoveryResourceId());
        jsonObject.put((Object)"recoveryResourceName", (Object)resMap.getRecoveryResourceName());
        jsonObject.put((Object)"role", (Object)resMap.getRole());
        if (resMap instanceof VRGResourceMapping) {
            jsonObject.put((Object)"status", (Object)((VRGResourceMapping)resMap).getStatus());
        } else {
            jsonObject.put((Object)"status", (Object)"");
        }
        return jsonObject;
    }

    private IRecoveryPlanBaseService getRecoveryPlanService() {
        return (IRecoveryPlanBaseService)this.getBundleService(IRecoveryPlanBaseService.class.getName(), IRecoveryPlanBaseService.class);
    }

    private List<String> createHeadInfo() {
        logger.debug((Object)"createHeadInfo start");
        ArrayList<String> headInfo = new ArrayList<String>();
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.type"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.product.platform.id"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.product.resource.name"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.product.resource.id"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.recovery.platform.id"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.recovery.resource.name"));
        headInfo.add(this.getText("ism.drm.recovery.plan.export.mappinginfo.recovery.resource.id"));
        return headInfo;
    }

    private void generateExportLog(String planId, LegoCheckedException ex) {
        String planName = "--";
        if (!VerifyUtil.isEmpty((String)planId)) {
            try {
                IRecoveryPlanBaseService rpServices = this.getRecoveryPlanService();
                RecoveryPlan recoveryPlan = rpServices.getRecoveryPlan(planId);
                if (null != recoveryPlan) {
                    planName = recoveryPlan.getName();
                }
            }
            catch (Exception e) {
                logger.error((Object)("get recovery plan failed, planId=" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException("recoveryPlan_exportResourceMaping_operateName", 1, planName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog("recoveryPlan_exportResourceMaping_operateName", 1, planName, "recoveryPlan_exportResourceMaping_operateDetail", null);
        }
    }

    private void addOptLogByOptResult(BatchOperationResult optResult, ResourceMappingVO rmvo, LegoCheckedException pubEx) {
        logger.debug((Object)"addOptLogByOptResult start");
        if (!VerifyUtil.isEmpty((Object)optResult)) {
            for (BatchOperation batchOpt : optResult.getResult()) {
                String[] detailParams = null == batchOpt ? null : batchOpt.getDetailParam();
                LegoCheckedException ex = null;
                if (null != batchOpt && batchOpt.getErrorCode() != 0L) {
                    ex = new LegoCheckedException(batchOpt.getErrorCode());
                }
                this.generateAddResLog(detailParams, rmvo.getResourceType(), ex);
            }
        } else {
            String dbLine = "--";
            String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
            int len = rmvo.getProductResourceId().length;
            for (int i = 0; i < len; ++i) {
                this.generateAddResLog(logParams, rmvo.getResourceType(), pubEx);
            }
        }
    }
}

