/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.galax.sdk.vrg.service.IVRGController;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.resourcemapping.service.IVRGMapRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class VRGMapRestServiceImpl
extends AbsVRRestService
implements IVRGMapRestService {
    private static final Log LOG = LogFactory.getInstance(VRGMapRestServiceImpl.class);
    private static final String SYN_ADD_VRGMAP_DETAIL = "site_resource_syncUpdateVRGVM_operateDetail";
    private static final String SYN_DELETE_VRGMAP_DETAIL = "site_resource_syncUpdateVRGVM_operateDetail";
    private static final String VRGMAPPING_TARGET_NAME = "VRGMapping_objectName";

    @Override
    public void synAddVRGMap(String localVRGSn, String peerVRGIp, int peerVRGPort) {
        this.checkUserOperationAuthority("resource_createVRGMappingSYN_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        LOG.debug((Object)("recreate VRGMap with localVRGSn=" + localVRGSn + ",peerVRGIp=" + peerVRGIp + ",peerVRGPort=" + peerVRGPort + ",operated by userId =" + this.getCurrentUserId() + " in ip=" + VRGMapRestServiceImpl.getRemoteAddr((HttpServletRequest)this.getRequest())), 90160758786816L);
        if (VerifyUtil.isEmpty((String)localVRGSn) || !Validator.validateIP((String)peerVRGIp) || !Validator.isPort((int)peerVRGPort)) {
            LOG.error((Object)("param error, localVRGSn\uff1a" + localVRGSn + " peerVRGIp\uff1a" + peerVRGIp + " peerVRGPort\uff1a" + peerVRGPort), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        List lisResMaps = null;
        try {
            this.checkUserResourceAuthority(localVRGSn);
            IResScopeService resService = (IResScopeService)this.getBundleService("DRM_FusionShpere_Base", IResScopeService.class.getName(), IResScopeService.class);
            lisResMaps = resService.getResources(ResourceMapping.class, "recoveryResourceId", Arrays.asList(localVRGSn));
            this.getVRGControllerService().synAddVRGMap(localVRGSn, peerVRGIp, peerVRGPort);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("recreate VRGMap error localVRGSn=" + localVRGSn + ",peerVRGIp=" + peerVRGIp + ",peerVRGPort=" + peerVRGPort + ",operated by userId =" + this.getCurrentUserId() + " in ip=" + VRGMapRestServiceImpl.getRemoteAddr((HttpServletRequest)this.getRequest())), (Throwable)e, 90160758787071L);
            this.generateVRGPairOptLog("resource_createVRGMappingSYN_operateName", 1, lisResMaps, null, e);
            throw e;
        }
        this.generateVRGPairOptLog("resource_createVRGMappingSYN_operateName", 1, lisResMaps, "site_resource_syncUpdateVRGVM_operateDetail", null);
    }

    @Override
    public void synDeleteVRGMap(RestJsonRequest request) throws ClassNotFoundException {
        this.checkUserOperationAuthority("resource_deleteVRGMappingSYN_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        List lisResMaps = null;
        try {
            BaseRestUtils.checkParamCommon((Object[])new Object[]{request});
            Map params = (Map)request.toObject();
            String vrgSn = (String)params.get("vrgSn");
            BaseRestUtils.checkParamCommon((Object[])new Object[]{vrgSn});
            BaseRestUtils.checkParamCommon((Object[])new Object[]{params.get("isForceDelete")});
            boolean isForce = Boolean.valueOf((String)params.get("isForceDelete"));
            this.checkUserResourceAuthority(vrgSn);
            IResourceMappingService rmService = (IResourceMappingService)this.getBundleService("DRM_FusionShpere_Base", IResourceMappingService.class.getName(), IResourceMappingService.class);
            QueryCondition condition = new QueryCondition("recoveryResourceId", (Object)vrgSn);
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            conditions.add(condition);
            String orderBy = "productResourceName";
            Page page = rmService.pageQueryConditionResourceMapping(0, 10, orderBy, true, conditions);
            lisResMaps = null == page ? null : page.getResult();
            this.getVRGControllerService().synDeleteVRGMap(vrgSn, isForce);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"delete VRGMap error ", (Throwable)e, 90160758787071L);
            this.generateVRGPairOptLog("resource_deleteVRGMappingSYN_operateName", 2, lisResMaps, null, e);
            throw e;
        }
        this.generateVRGPairOptLog("resource_deleteVRGMappingSYN_operateName", 2, lisResMaps, "site_resource_syncUpdateVRGVM_operateDetail", null);
    }

    private IVRGController getVRGControllerService() {
        return (IVRGController)this.getBundleService("DRM_FusionShpere_VRG", IVRGController.class.getName());
    }

    private void generateVRGPairOptLog(String optionName, int optLevel, List<ResourceMapping> lisResMaps, String optDetail, LegoCheckedException ex) {
        String dbLine = "--";
        String[] logParams = new String[]{dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine, dbLine};
        if (!VerifyUtil.isEmpty(lisResMaps)) {
            ResourceMapping resMap = lisResMaps.get(0);
            Site proSite = this.getSiteBySiteId(resMap.getProductSiteId());
            Site recoverySite = this.getSiteBySiteId(resMap.getRecoverySiteId());
            logParams[0] = resMap.getProductResourceName();
            logParams[1] = resMap.getRecoveryResourceName();
            logParams[2] = proSite.getName();
            logParams[3] = resMap.getProductResourceProviderName();
            logParams[4] = recoverySite.getName();
            logParams[5] = resMap.getRecoveryResourceProviderName();
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(optionName, optLevel, VRGMAPPING_TARGET_NAME, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(optionName, optLevel, VRGMAPPING_TARGET_NAME, optDetail, logParams);
        }
    }
}

