/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.host.util.DrHostValidUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public abstract class AbstractDataBaseProvider
extends AbstractProtectObjectProvider {
    private static Log logger = LogFactory.getInstance(AbstractDataBaseProvider.class);

    public void updateProtectObjectProps(ProtectObject protectObject, Map<String, String> props) {
        logger.debug((Object)"update po props.", 90160758786988L);
        if (null == props) {
            logger.debug((Object)"param props is null.");
            return;
        }
        String userName = props.get("USERNAME");
        String pwd = props.get("PASSWD");
        String asmUserName = props.get("ASM_USERNAME");
        String asmpwd = props.get("ASM_PASSWD");
        DrHostValidUtil.checkUsernameAndPwd((String)userName, (boolean)true);
        DrHostValidUtil.checkUsernameAndPwd((String)pwd, (boolean)true);
        DrHostValidUtil.checkUsernameAndPwd((String)asmUserName, (boolean)true);
        DrHostValidUtil.checkUsernameAndPwd((String)asmpwd, (boolean)true);
        if (!VerifyUtil.isEmpty((String)userName)) {
            protectObject.getProps().put("USERNAME", props.get("USERNAME"));
        }
        if (!VerifyUtil.isEmpty((String)asmUserName)) {
            protectObject.getProps().put("ASM_USERNAME", props.get("ASM_USERNAME"));
        }
        if (!VerifyUtil.isEmpty((String)pwd)) {
            String encryptPwd = WccEncryptor.encrypt((String)pwd);
            props.put("PASSWD", encryptPwd);
            protectObject.getProps().put("PASSWD", encryptPwd);
        }
        if (!VerifyUtil.isEmpty((String)asmpwd)) {
            String encryptAsmPwd = WccEncryptor.encrypt((String)asmpwd);
            props.put("ASM_PASSWD", encryptAsmPwd);
            protectObject.getProps().put("ASM_PASSWD", encryptAsmPwd);
        }
    }

    protected List<ProtectObject> getRegisteredProtectObjectByHost(String hostSN, String pgId, int poType) {
        List result;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"providerSN", (Object)hostSN));
            crit.add((Criterion)Restrictions.eq((String)"poType", (Object)poType));
            crit.createAlias("protectGroup", "protectGroup").add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)pgId));
            crit.addOrder(Order.asc((String)"name"));
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query Exchange ProtectObject by host.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return result;
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
        super.checkPolicyTemplate(policyTemplate);
    }

    private ProtectGroup splitNasProtectObjects(ProtectGroup appProtectGroup) {
        ProtectGroup nasProtectGroup = new ProtectGroup();
        ArrayList<ProtectObject> appPoList = new ArrayList<ProtectObject>();
        ArrayList<ProtectObject> nasPoList = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : appProtectGroup.getPolist()) {
            if (protectObject.getPoType() == 14) {
                nasPoList.add(protectObject);
                continue;
            }
            appPoList.add(protectObject);
        }
        if (nasPoList.isEmpty()) {
            return nasProtectGroup;
        }
        try {
            nasProtectGroup = (ProtectGroup)appProtectGroup.clone();
            appProtectGroup.getPolist().clear();
            nasProtectGroup.getPolist().clear();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"CloneNotSupportedException.", (Throwable)e, 90160758786896L);
        }
        appProtectGroup.getPolist().addAll(appPoList);
        nasProtectGroup.getPolist().addAll(nasPoList);
        IProtectObjectBaseProvider nasProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(14);
        nasProvider.buildProtectObjects(nasProtectGroup);
        return nasProtectGroup;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup nasprotectGroup = this.splitNasProtectObjects(protectGroup);
        this.buildSubAppProtectObjects(protectGroup);
        this.updateProtectGroupProps(protectGroup);
        protectGroup.getPolist().addAll(nasprotectGroup.getPolist());
    }

    private void updateProtectGroupProps(ProtectGroup protectGroup) {
        ProtectObject appPo;
        Iterator storageIter;
        Iterator poIter = protectGroup.getPolist().iterator();
        if (poIter.hasNext() && (storageIter = (appPo = (ProtectObject)poIter.next()).getUsedStorageResourceSet().iterator()).hasNext()) {
            ProtectObjectStorageInfo poStorage = (ProtectObjectStorageInfo)storageIter.next();
            boolean isManualConfigLun = poStorage.getIsManualConfigLun();
            protectGroup.getProps().put("IS_MANUAL_CONFIG_LUN", String.valueOf(isManualConfigLun));
        }
    }

    protected void buildSubAppProtectObjects(ProtectGroup protectGroup) {
        logger.debug((Object)"Build sub app ProtectObjects.");
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject protectObject) {
        if (VerifyUtil.isEmpty((Object)protectObject)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (protectObject.getPoType() == 14) {
            return this.getNasStorageInfo(protectObject);
        }
        return this.getPoStorageInfo(protectObject);
    }

    protected abstract List<ProtectObjectStorageInfo> getPoStorageInfo(ProtectObject var1);

    private List<ProtectObjectStorageInfo> getNasStorageInfo(ProtectObject protectObject) {
        IProtectObjectBaseProvider nasProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(14);
        return nasProvider.getProtectObjectStorageInfo(protectObject);
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
        ArrayList<ProtectObject> appPoList = new ArrayList<ProtectObject>();
        ArrayList<ProtectObject> nasPoList = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : protectObjectList) {
            if (protectObject.getPoType() == 14) {
                nasPoList.add(protectObject);
                continue;
            }
            appPoList.add(protectObject);
        }
        if (!nasPoList.isEmpty()) {
            IProtectObjectBaseProvider nasProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(14);
            nasProvider.refreshProtectObjectProperties(nasPoList);
        }
        if (!appPoList.isEmpty()) {
            this.refreshAppProtectObjectProperties(appPoList);
        }
    }

    protected void refreshAppProtectObjectProperties(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"Refresh app po properties.");
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            logger.debug((Object)"param protectObjectList is null or empty.");
            return;
        }
        ArrayList<ProtectObject> appPoList = new ArrayList<ProtectObject>();
        ArrayList<ProtectObject> nasPoList = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getMoUuid();
            ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(uuid, Boolean.valueOf(true));
            if (mo instanceof NasFileSystem) {
                protectObject.setPoType(14);
                nasPoList.add(protectObject);
                continue;
            }
            appPoList.add(protectObject);
        }
        if (!nasPoList.isEmpty()) {
            IProtectObjectBaseProvider nasProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(14);
            nasProvider.loadProtectObjectStorageInfo(nasPoList);
        }
        this.loadAppStorageInfo(appPoList);
        this.checkAllProtectObjectStorageInfo(appPoList);
    }

    protected void loadAppStorageInfo(List<ProtectObject> protectObjectList) {
        ProtectGroupHelper.getInstance().loadProtectObjectStorageInfo(protectObjectList);
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        List<PolicyTemplate> commonTemplateList;
        boolean hasNasFileSystem = false;
        for (ProtectObject po : protectObjectList) {
            if (po.getPoType() != 14) continue;
            hasNasFileSystem = true;
            break;
        }
        List<PolicyTemplate> appTemplateList = this.getAppSupportPolicyTemplate(protectObjectList);
        if (hasNasFileSystem) {
            IProtectObjectBaseProvider nasProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(14);
            List nasTemplateList = nasProvider.getSupportPolicyTemplate(protectObjectList);
            commonTemplateList = this.mergeAppAndNasTemplate(appTemplateList, nasTemplateList);
        } else {
            commonTemplateList = appTemplateList;
        }
        return commonTemplateList;
    }

    private void checkAllProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject firstPo = protectObjectList.get(0);
        Set poStorages = firstPo.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)poStorages)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!poStorages.iterator().hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean firstConfig = ((ProtectObjectStorageInfo)poStorages.iterator().next()).getIsManualConfigLun();
        for (ProtectObject protectObject : protectObjectList) {
            Set poStorageInfos = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo poStorage : poStorageInfos) {
                if (firstConfig == poStorage.getIsManualConfigLun()) continue;
                logger.error((Object)("isManualConfigLun in po not same,protectObject name=" + protectObject.getName()));
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private List<PolicyTemplate> mergeAppAndNasTemplate(List<PolicyTemplate> appTemplateList, List<PolicyTemplate> nasTemplateList) {
        ArrayList<PolicyTemplate> commonTemplateList = new ArrayList<PolicyTemplate>();
        if (null == nasTemplateList || null == appTemplateList) {
            return commonTemplateList;
        }
        for (PolicyTemplate template : nasTemplateList) {
            for (PolicyTemplate appTemplate : appTemplateList) {
                if (appTemplate.getType() != template.getType()) continue;
                commonTemplateList.add(appTemplate);
            }
        }
        return commonTemplateList;
    }

    protected List<PolicyTemplate> getAppSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        return new ArrayList<PolicyTemplate>();
    }

    public void encryptProperties(ProtectGroup protectGroup) {
        super.encryptProperties(protectGroup);
        Set poList = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            logger.error((Object)("polist is null,pgName=" + protectGroup.getName()), 90160758786896L);
            return;
        }
        this.updateSensitiveData(poList, true);
    }

    public void decryptPropreties(ProtectGroup protectGroup) {
        super.decryptPropreties(protectGroup);
        Set poList = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            logger.error((Object)("polist is null,pgName=" + protectGroup.getName()), 90160758786896L);
            return;
        }
        this.updateSensitiveData(poList, false);
    }

    private void updateSensitiveData(Set<ProtectObject> poList, boolean encrypt) {
        for (ProtectObject protectObject : poList) {
            this.updateSensitiveData(protectObject, "PASSWD", encrypt);
            this.updateSensitiveData(protectObject, "ASM_PASSWD", encrypt);
        }
    }

    private void updateSensitiveData(ProtectObject protectObject, String key, boolean encrypt) {
        Map props = protectObject.getProps();
        if (props.containsKey(key)) {
            String password = (String)props.get(key);
            if (encrypt) {
                props.put(key, WccEncryptor.encrypt((String)password));
            } else {
                props.put(key, WccEncryptor.decrypt((String)password));
            }
        }
    }
}

