/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Set;

public class ShutdownDBSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log LOGGER = LogFactory.getInstance(ShutdownDBSubProcessor.class);
    protected static final long SCRIPT_FAILED = 2002L;
    private static final long serialVersionUID = -6541910435800412348L;
    private String poId;
    private String dbName;
    private String shutDownAppResults;
    private boolean isStopSuccess = true;
    private long stopErrorCode = 0L;

    public String getShutDownAppResults() {
        return this.shutDownAppResults;
    }

    public void setShutDownAppResults(String shutDownAppResults) {
        this.shutDownAppResults = shutDownAppResults;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getStopAppProcResultKey((String)this.poId);
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.already.shutdown", new String[]{this.getDbName()});
            LOGGER.info((Object)("database instance has been shutdown succ, dbName=" + this.getDbName()), 90160758784001L);
            return true;
        }
        ProtectObject po = this.getPoForStop(context);
        if (null == po) {
            LOGGER.error((Object)("ProtectObject(" + this.poId + ") is not existed."), 90160758786989L);
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        JSONArray results = this.generateStopAppResult(context.getRecoveryPlan(), po);
        if (null == results) {
            LOGGER.error((Object)("result is null. dbName:" + this.getDbName()));
            this.updateProcessDetail("lego.err.-1", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        for (int i = 0; i < results.size(); ++i) {
            JSONObject obj = results.getJSONObject(i);
            this.doStop(po, obj, context.getProtectGroup());
            if (!this.isStopSuccess) break;
        }
        this.shutDownAppResults = results.toString();
        if (this.isStopSuccess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    protected ProtectObject getPoForStop(RecoveryProcessorContext context) {
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.poId);
        return po;
    }

    private JSONArray generateStopAppResult(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        JSONArray results = null;
        try {
            results = VerifyUtil.isEmpty((String)this.shutDownAppResults) ? this.generateShutDownResultJson(recoveryPlan, protectObject) : JSONArray.fromObject((Object)this.shutDownAppResults);
        }
        catch (Exception e) {
            LOGGER.error((Object)("generateStartAppResult error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return results;
    }

    protected JSONArray generateShutDownResultJson(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        String resourceSn = this.getShutDownResourceSn(recoveryPlan, protectObject);
        if (VerifyUtil.isEmpty((String)resourceSn)) {
            LOGGER.warn((Object)"resourceSn is null.", 90160758784001L);
            return null;
        }
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceSn);
        if (null == resource) {
            LOGGER.warn((Object)("resource is null. sn is " + resourceSn), 90160758784001L);
            return null;
        }
        JSONArray results = new JSONArray();
        if (resource instanceof DrHostGroup) {
            DrHostGroup drhostGroup = (DrHostGroup)resource;
            if ((protectObject.getPoType() != 1 || drhostGroup.getClusterType() != DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) && protectObject.getPoType() != 16) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"sn", (Object)resource.getDeviceSn());
                obj.put((Object)"ip", (Object)resource.getName());
                obj.put((Object)"result", (Object)false);
                results.add((Object)obj);
            } else {
                for (DrResource host : resource.getChildResources()) {
                    JSONObject obj = this.castDrResourceToJson(host);
                    results.add((Object)obj);
                }
            }
        } else if (resource instanceof DrHost) {
            JSONObject obj = this.castDrResourceToJson(resource);
            results.add((Object)obj);
        } else {
            return null;
        }
        return results;
    }

    protected String getShutDownResourceSn(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        return DBRecoveryTools.getDisasterHostSn((RecoveryPlan)recoveryPlan, (String)protectGroup.getUuid(), (int)this.getProcType());
    }

    protected JSONObject castDrResourceToJson(DrResource resource) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"sn", (Object)resource.getDeviceSn());
        obj.put((Object)"ip", (Object)resource.getIpAddress());
        obj.put((Object)"result", (Object)false);
        return obj;
    }

    private void doStop(ProtectObject po, JSONObject obj, ProtectGroup protectGroup) {
        if (!obj.getBoolean("result")) {
            String sn = obj.getString("sn");
            String ip = obj.getString("ip");
            String providerSn = po.getProviderSN();
            po.setProviderSN(sn);
            try {
                this.shutdownDBApp(po, providerSn, protectGroup);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("stop db on " + ip + " error.errorcode is " + this.stopErrorCode), (Throwable)e, 90160758784001L);
                this.stopErrorCode = e.getErrorCode();
                obj.put((Object)"errcode", (Object)this.stopErrorCode);
                String[] errorParams = null == e.getParameters() ? new String[]{} : e.getParameters();
                this.updateErrorInfoDetail(ip, "lego.err." + this.stopErrorCode, errorParams);
                this.isStopSuccess = false;
                return;
            }
            this.stopErrorCode = this.getDBTestRunning(po, protectGroup);
            if (0L == this.stopErrorCode) {
                LOGGER.error((Object)("test db on " + ip + " success."), 90160758784001L);
                obj.put((Object)"errcode", (Object)0);
                this.updateErrorInfoDetail(ip, "lego.err.1073948735", new String[]{ip, this.getDbName()});
                this.isStopSuccess = false;
                return;
            }
            obj.put((Object)"result", (Object)true);
            obj.put((Object)"errcode", (Object)0);
        }
    }

    private void updateErrorInfoDetail(String ip, String key, String[] params) {
        JSONObject details = new JSONObject();
        params = params != null ? params : new String[]{};
        JSONObject detail = new JSONObject();
        detail.put((Object)ip, (Object)ip);
        detail.put((Object)key, (Object)params);
        details.put((Object)"ism.drm.rac.node.shutdown.detail", (Object)detail);
        this.updateProcessDetail("ism.drm.recovery.database.shutdown.racfailed", new String[]{details.toString()});
    }

    protected long getDBTestRunning(ProtectObject po, ProtectGroup protectGroup) {
        long code = 0L;
        po.getProps().put("OPER_TYPE", String.valueOf(1));
        try {
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).testConnecting(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("getDBTestRunning po(" + po.getUuid() + ") LegoCheckedException"), (Throwable)e, -1L);
            code = e.getErrorCode();
        }
        catch (Exception e) {
            LOGGER.error((Object)("getDBTestRunning po(" + po.getUuid() + ")'s isDBAppRunning Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            code = -1L;
        }
        code = code == 1L ? 2002L : code;
        return code;
    }

    protected void shutdownDBApp(ProtectObject po, String providerSn, ProtectGroup protectGroup) {
        try {
            po.getProps().put("APP_PROC_TYPE", String.valueOf(this.getProcType()));
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).suspend(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("ShutdownDBSubProcessor po(" + po.getUuid() + ")'s shutdownDBApp LegoCheckedException"), (Throwable)e, -1L);
            long errorCode = e.getErrorCode();
            if (errorCode == 1L) {
                throw new LegoCheckedException(2002L, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "ShutdownDBSubProcessor po(" + po.getUuid() + ")'s shutdownDBApp Exception";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)LOGGER);
        }
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

