/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.StartupDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StartupDBProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7250346799213813519L;
    private static final Log LOGGER = LogFactory.getInstance(StartupDBProcessor.class);
    private static final int DEFAULT_START_PRI = 10;
    private String hostOrGroupId;

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    protected StartupDBSubProcessor createDBSubProccessor() {
        return new StartupDBSubProcessor();
    }

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<StartupDBSubProcessor> startupDBSubProcessors = new HashSet<StartupDBSubProcessor>();
        List allPOs = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        for (ProtectObject po : allPOs) {
            boolean isStartApp = this.getIsStartApp(recoverySettings, po);
            if (!isStartApp) {
                LOGGER.info((Object)(po.getName() + " need not startup app"), -1L);
                continue;
            }
            StartupDBSubProcessor processor = this.createDBSubProccessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(po.getUuid());
            processor.setDbName(this.getNewDatabaseName(context.getRecoveryPlan(), po));
            startupDBSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(startupDBSubProcessors);
        } else {
            this.setChildProc(startupDBSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected String getNewDatabaseName(RecoveryPlan recoveryPlan, ProtectObject po) {
        return po.getName();
    }

    protected boolean getIsStartApp(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        boolean isStartApp = true;
        for (RecoverySetting rs : recoverySettings) {
            if (!rs.getName().equals("isStart") || !rs.getOwnerId().equals(po.getUuid())) continue;
            isStartApp = Boolean.parseBoolean(rs.getValue());
            break;
        }
        return isStartApp;
    }

    public boolean execute(RecoveryProcessorContext context) {
        boolean createResult;
        LOGGER.info((Object)"Begin to execute in StartupDBProcessor", 90160758786988L);
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost((RecoveryPlan)context.getRecoveryPlan(), (int)this.getProcType());
        if (!(!VerifyUtil.isEmpty((Collection)this.getChildProc()) && currentHostOrGroupId.equals(this.getHostOrGroupId()) || (createResult = this.createSubProcessors(context)))) {
            LOGGER.info((Object)"create subprocessors error.", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setHostOrGroupId(currentHostOrGroupId);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"StartupDBProcessor subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority(context);
        LOGGER.info((Object)("there are " + processorsWithPriority.entrySet().size() + " Priorities."), 90160758786988L);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithSerialSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        if (!VerifyUtil.isEmpty((Object)recoveryTemplate)) {
            recoveryTemplate.process(context);
        }
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            Set rProcesses = this.getChildProc();
            for (RecoveryProcessor process : rProcesses) {
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != process.getProcStatus()) continue;
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                executeResult = false;
                break;
            }
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor process : childProcessor) {
            StartupDBSubProcessor subProcess = (StartupDBSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    protected int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = NumberUtil.convertToInteger((Object)setting.getValue());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("parseInt error : " + setting.getValue()), (Throwable)e, -1L);
            }
            break;
        }
        return priValue;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        return oldProcess.getProcId().equals(newProcess.getProcId());
    }
}

