/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public abstract class TestConnDBSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log LOGGER = LogFactory.getInstance(TestConnDBSubProcessor.class);
    protected static final long LOG_CODE = -1L;
    private static final long serialVersionUID = -757242243050943073L;
    private String instanceName;
    private String instances;
    private String poId;
    private String dbName;

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstances() {
        return this.instances;
    }

    public void setInstances(String instances) {
        this.instances = instances;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public abstract String getName();

    private String getInstanceNameByPO(ProtectObject po) {
        String tmpInstanceName = (String)po.getProps().get("INSTANCENAME");
        LOGGER.info((Object)("get instance name by po, instanceName=" + tmpInstanceName + ", poId=" + po.getUuid()), 90160758784001L);
        return tmpInstanceName;
    }

    protected Set<ProtectObject> getAllPOsByInstanceName(RecoveryProcessorContext context) {
        HashSet<ProtectObject> protectObjects = new HashSet<ProtectObject>();
        Set allPOs = context.getRecoveryProtectObjects();
        for (ProtectObject po : allPOs) {
            if (!Objects.equals(this.getInstances(), this.getInstanceNameByPO(po))) continue;
            protectObjects.add(po);
        }
        return protectObjects;
    }

    protected boolean isDBStartup(ProtectObject po) {
        try {
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).testConnecting(po);
            LOGGER.info((Object)("test connection of database succ, dbName=" + this.getDbName()), 90160758787071L);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("test connection of database failed:" + po.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)("begin execute testconn db sub processor, dbName=" + this.getDbName()), 90160758786816L);
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.already.connected", new String[]{this.getDbName()});
            LOGGER.info((Object)("database instance has been testconn succ, dbName=" + this.getDbName()), 90160758784001L);
            return true;
        }
        Set<ProtectObject> pos = this.getAllPOsByInstanceName(context);
        Host host = this.getHostByMoId(pos, context.getRecoveryPlan());
        ProtectObject po = this.findPoById(pos, this.getPoId());
        po.setProviderSN(host.getHostSN());
        if (this.isDBStartup(po)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            LOGGER.error((Object)("can't testConn this database instance, the dbName=" + this.getDbName()), 90160758784001L);
            this.updateProcessDetail("ism.drm.recovery.database.test.failed", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        LOGGER.info((Object)("end execute testconn db sub processor, dbName=" + this.getDbName()), 90160758786816L);
        return true;
    }

    public String generateResultKey() {
        String resultKey = RecoveryProcessResult.getTestConnDBProcResultKey((String)this.getInstances());
        LOGGER.info((Object)("generate result key for testconn db sub processor, resultKey=" + resultKey), 90160758784001L);
        return resultKey;
    }

    protected Host getHostByMoId(Set<ProtectObject> pos, RecoveryPlan recoveryPlan) {
        String hostId;
        block3: {
            block2: {
                hostId = null;
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType()) break block2;
                Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
                if (!pgIter.hasNext()) break block3;
                ProtectGroup pg = (ProtectGroup)pgIter.next();
                hostId = pg.getPoProviderSN();
                break block3;
            }
            hostId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
            for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
                if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
                hostId = setting.getValue();
                break;
            }
        }
        ManagedObject moObj = CommonDAOLocator.getMoDao().getMoByUuid(hostId, Boolean.valueOf(false));
        if (null == moObj) {
            LOGGER.error((Object)("The host does not exist. HostId:" + hostId), -1L);
            throw new LegoCheckedException(1073947394L);
        }
        return (Host)moObj;
    }

    protected ProtectObject findPoById(Set<ProtectObject> pos, String inputPoId) {
        for (ProtectObject po : pos) {
            if (!po.getUuid().equals(inputPoId)) continue;
            return po;
        }
        LOGGER.error((Object)("The host does not exist. poId:" + inputPoId), -1L);
        throw new LegoCheckedException(1073947394L);
    }

    protected Set<AbstractMap.SimpleEntry<String, Boolean>> getPoRecoveryStatus(RecoveryProcessorContext context) {
        HashSet<AbstractMap.SimpleEntry<String, Boolean>> entries = new HashSet<AbstractMap.SimpleEntry<String, Boolean>>();
        boolean poRecoveryResult = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus();
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)this.getPoId(), (int)this.getAssociatedPoType(context));
        entries.add(new AbstractMap.SimpleEntry<String, Boolean>(key, poRecoveryResult));
        return entries;
    }
}

