/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process.listener;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.db.recovery.process.StartupDBProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanListener;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;

public class StartupDBProcessorListener
implements IRecoveryPlanListener {
    private static Log logger = LogFactory.getInstance(StartupDBProcessorListener.class);

    public void notify(MessageEvent event) {
        if (null == event) {
            return;
        }
        if (null == event.getMessageMap()) {
            return;
        }
        RecoveryProcessDefinition processDefinition = null;
        StartupDBProcessor startupDBProcessor = null;
        Collection objectList = event.getMessageMap().values();
        for (Object object : objectList) {
            if (object instanceof RecoveryProcessDefinition) {
                processDefinition = (RecoveryProcessDefinition)object;
            }
            if (!(object instanceof StartupDBProcessor)) continue;
            startupDBProcessor = (StartupDBProcessor)((Object)object);
        }
        if (null == processDefinition || null == startupDBProcessor) {
            logger.info((Object)"RecoveryProcessDefinition or StartupDBProcessor is null!");
            return;
        }
        String planId = processDefinition.getPlanId();
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = planService.getRecoveryPlan(planId, false, false);
        if (null == plan) {
            logger.error((Object)"Recovery plan [%s] is null!", new Object[]{planId});
            return;
        }
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.info((Object)"The Replica does not exist in recovery plan[%s] and does not need to update the mount Configuration of replica", new Object[]{replicaId, planId});
            return;
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"The Replica[%s] does not exist!", new Object[]{replicaId});
            return;
        }
        String mountConfigs = replica.getProperty("mountConfigs");
        if (VerifyUtil.isEmpty((String)mountConfigs)) {
            logger.error((Object)"get mountConfigs got error,mountConfigs is null");
            return;
        }
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        mountConfiguration.setStartDB(startupDBProcessor.getIsEnabled().booleanValue());
        replica.addProperty("mountConfigs", JSONObject.fromObject((Object)mountConfiguration).toString());
        replicaService.saveOrUpdateReplica(replica);
    }
}

