/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.topology;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.db.topology.DataBaseTopoBuilder;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.topology.skin.HostGroupSkin;
import com.huawei.ism.drm.host.topology.skin.HostSkin;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.twaver.IData;
import com.huawei.twaver.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class DB2AndSqlServerBaseTopoBuilder
extends DataBaseTopoBuilder {
    private static Log logger = LogFactory.getInstance(DB2AndSqlServerBaseTopoBuilder.class);
    private static final String ISPRIMARY = "isPrimary";
    private static final String SITE = "site";

    protected abstract String getAppLabel();

    protected abstract int getPoType();

    public void buildTopo(TopoBaseContext context) {
        this.initialize(context);
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSN = protectGroup.getPoProviderSN();
        DrResource resource = this.getDrResource(hostSN);
        if (null == resource) {
            logger.error((Object)("get resource failed, provederSN=" + hostSN));
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(ISPRIMARY, protectGroup.isPrimary());
        String productSiteId = protectGroup.getProductSiteId();
        Site productSite = context.getSiteService().getSiteById(productSiteId);
        dataMap.put(SITE, productSite);
        if (this.getSanActiveTemplateTypes().contains(protectGroup.getTemplate().getType())) {
            this.buildDoubleActiveTopo(context, resource, this.getAppLabel(), dataMap);
            return;
        }
        SiteElement productSiteNode = new SiteElement(productSite);
        context.addChild((IData)context.getRootNode(), (IData)productSiteNode);
        if (resource instanceof DrHost) {
            dataMap.put("isHostGroup", false);
            this.buildHostTopo(context, (DrHost)resource, (Node)productSiteNode, this.getAppLabel(), dataMap);
        } else if (resource instanceof DrHostGroup) {
            dataMap.put("isHostGroup", true);
            this.buildHostGroupTopo(context, protectGroup, resource, (Node)productSiteNode, dataMap);
        }
    }

    private void buildHostGroupTopo(TopoBaseContext context, ProtectGroup protectGroup, DrResource resource, Node productSiteNode, Map<String, Object> dataMap) {
        Node fatherNode = productSiteNode;
        DrHostGroup hostGroupInfo = (DrHostGroup)resource;
        Node deviceAndDiskParentNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)("deviceAndDiskStyle:" + protectGroup.getPoProviderSN()));
        deviceAndDiskParentNode.setClient("layout", (Object)"leftright");
        context.addChild((IData)fatherNode, (IData)deviceAndDiskParentNode);
        TopoElement hostStyleNode = new TopoElement((Object)(hostGroupInfo.getDeviceSn() + ":hostStyleNode")).use(new Skin[]{new HostSkin()});
        context.addChild((IData)deviceAndDiskParentNode, (IData)hostStyleNode);
        TopoElement hostGroupStyleNode = new TopoElement((Object)(hostGroupInfo.getDeviceSn() + ":hostGroup")).use(new Skin[]{new HostGroupSkin()});
        context.addChild((IData)hostStyleNode, (IData)hostGroupStyleNode);
        Set drHosts = hostGroupInfo.getChildResources();
        for (DrResource eHost : drHosts) {
            Set poSet = protectGroup.getPolist();
            if (!this.needDisplayHost(poSet, (DrHost)eHost)) {
                logger.debug((Object)("don't need display host, po name : " + eHost.getName()));
                continue;
            }
            dataMap.put("isOracle", true);
            this.buildHostTopo(context, (DrHost)eHost, (Node)hostGroupStyleNode, this.getAppLabel(), null, dataMap);
        }
    }

    protected boolean needDisplayHost(Set<ProtectObject> pos, DrHost resource) {
        return true;
    }

    @Override
    protected boolean getDatabaseStatus(String hostSN, ProtectObject po, Map<String, Object> dataMap) {
        String databaseName = po.getName();
        return this.isDatabaseOnline(hostSN, databaseName, dataMap);
    }

    protected boolean isDatabaseOnline(String hostSN, String databaseName, Map<String, Object> dataMap) {
        Database database = this.getLocalDatabase(hostSN, databaseName, this.getPoType());
        if (null == database) {
            logger.error((Object)"get database failed, database is null.");
            return false;
        }
        int dbstatus = NumberUtil.convertToInteger((Object)database.getDbStatus());
        boolean isHostGroup = (Boolean)dataMap.get("isHostGroup");
        if (!isHostGroup) {
            logger.debug((Object)"get signal host database status.");
            return dbstatus == 0;
        }
        logger.debug((Object)"get hostgroup database status.");
        DatabaseInstance dbInstance = (DatabaseInstance)database.getParentMo();
        return dbstatus == 0 && dbInstance.getInstanceStatus() == 1;
    }
}

