/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.util;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DatabaseApplicationUtil {
    private static final Log LOGGER = LogFactory.getInstance(DatabaseApplicationUtil.class);
    private static Map<String, String> activeNodeMap = new HashMap<String, String>();
    private static DatabaseApplicationUtil dbUtilObj = new DatabaseApplicationUtil();

    private DatabaseApplicationUtil() {
    }

    public static DatabaseApplicationUtil getInstance() {
        return dbUtilObj;
    }

    public static List<Database> queryAllDatabaseInstance(String hostSN, int type, Map<String, Object> conditionMap) {
        IMoDao moDao;
        List dbInstances;
        if (VerifyUtil.isEmpty((String)hostSN)) {
            LOGGER.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> dbInstanceConditions = new ArrayList<QueryCondition>();
        dbInstanceConditions.add(new QueryCondition("hostSN", (Object)hostSN, true, false));
        dbInstanceConditions.add(new QueryCondition("dbType", (Object)type, true, false));
        String instanceName = (String)conditionMap.get("instanceName");
        if (!VerifyUtil.isEmpty((String)instanceName)) {
            dbInstanceConditions.add(new QueryCondition("instanceName", (Object)instanceName));
        }
        if (VerifyUtil.isEmpty((Collection)(dbInstances = (moDao = CommonDAOLocator.getMoDao()).findMoBy(DatabaseInstance.class, dbInstanceConditions)))) {
            return Collections.emptyList();
        }
        Long[] moIds = new Long[dbInstances.size()];
        for (int i = 0; i < dbInstances.size(); ++i) {
            moIds[i] = ((DatabaseInstance)dbInstances.get(i)).getMoId();
        }
        ArrayList<QueryCondition> dbConditions = new ArrayList<QueryCondition>();
        dbConditions.add(new QueryCondition("parentMo.moId", (Object)moIds));
        String dbName = (String)conditionMap.get("name");
        if (!VerifyUtil.isEmpty((String)dbName)) {
            dbConditions.add(new QueryCondition("name", (Object)dbName));
        }
        return moDao.findMoBy(Database.class, "name", true, dbConditions);
    }

    public static List<DatabaseInstance> queryAllDatabaseInstances(String hostSN, int type, Map<String, Object> conditionMap) {
        IMoDao moDao;
        List dbInstances;
        if (VerifyUtil.isEmpty((String)hostSN)) {
            LOGGER.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> dbInstanceConditions = new ArrayList<QueryCondition>();
        dbInstanceConditions.add(new QueryCondition("hostSN", (Object)hostSN, true, false));
        dbInstanceConditions.add(new QueryCondition("dbType", (Object)type, true, false));
        String instanceName = (String)conditionMap.get("instanceName");
        if (!VerifyUtil.isEmpty((String)instanceName)) {
            dbInstanceConditions.add(new QueryCondition("instanceName", (Object)instanceName));
        }
        if ((dbInstances = (moDao = CommonDAOLocator.getMoDao()).findMoBy(DatabaseInstance.class, dbInstanceConditions)) == null) {
            return Collections.emptyList();
        }
        return dbInstances;
    }

    public static List<Database> queryDatabaseByHostSnAndDbId(String hostSn, String dbId, int type) {
        if (VerifyUtil.isEmpty((String)hostSn)) {
            LOGGER.error((Object)"HostSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> dbInstanceConditions = new ArrayList<QueryCondition>();
        dbInstanceConditions.add(new QueryCondition("hostSN", (Object)hostSn, true, false));
        dbInstanceConditions.add(new QueryCondition("dbId", (Object)dbId, true, false));
        dbInstanceConditions.add(new QueryCondition("dbType", (Object)type, true, false));
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List dbInstances = moDao.findMoBy(DatabaseInstance.class, dbInstanceConditions);
        if (VerifyUtil.isEmpty((Collection)dbInstances)) {
            return Collections.emptyList();
        }
        Long[] moIds = new Long[dbInstances.size()];
        for (int i = 0; i < dbInstances.size(); ++i) {
            moIds[i] = ((DatabaseInstance)dbInstances.get(i)).getMoId();
        }
        ArrayList<QueryCondition> dbConditions = new ArrayList<QueryCondition>();
        dbConditions.add(new QueryCondition("parentMo.moId", (Object)moIds));
        return moDao.findMoBy(Database.class, "name", true, dbConditions);
    }

    public static void clearActiveMap(String drResouceName) {
        activeNodeMap.remove(drResouceName);
    }

    public static void saveActiveNode(String key, String value) {
        activeNodeMap.put(key, value);
    }

    public static String getActiveNode(String key) {
        return activeNodeMap.get(key);
    }
}

