/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;

public final class DrsEnumDefine {

    public static enum ErrCode {
        THE_OPERATION_OBJECT_DOES_NOT_EXIST(0x989688L),
        THE_DRS_RULE_DOES_NOT_EXIST(10300130L),
        THE_SPECIFIED_CLUSTER_DOES_NOT_EXIST(10300028L),
        INVALID_REQUEST_FORMAT(10000001L);

        long value;

        private ErrCode(long value) {
            this.value = value;
        }

        public static boolean isContains(String value) {
            if (VerifyUtil.isEmpty((String)value)) {
                return false;
            }
            return Arrays.stream(ErrCode.values()).anyMatch(errCode -> errCode.value == Long.parseLong(value));
        }
    }

    public static enum OperateType {
        DELETE(0),
        ADD(1);

        int value;

        private OperateType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum HostRuleTypeEnum {
        MUST_RUN_ON_HOSTS(1),
        SHOULD_RUN_ON_HOSTS(2),
        MUST_NOT_RUN_ON_HOSTS(3),
        SHOULD_NOT_RUN_ON_HOSTS(4);

        int value;

        private HostRuleTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static boolean isContains(Integer va) {
            if (va == null) {
                return false;
            }
            for (HostRuleTypeEnum hostRuleType : HostRuleTypeEnum.values()) {
                if (hostRuleType.value != va) continue;
                return true;
            }
            return false;
        }
    }

    public static enum RuleTypeEnum {
        AGGREGATE_VM(1),
        MUTUALLY_EXCLUSIVE_VM(2),
        VM_TO_HOST(3),
        VM_TO_VM(4);

        int value;

        private RuleTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static boolean isContains(Integer va) {
            if (va == null) {
                return false;
            }
            for (RuleTypeEnum ruleType : RuleTypeEnum.values()) {
                if (ruleType.value != va) continue;
                return true;
            }
            return false;
        }
    }

    public static enum GroupTypeEnum {
        HOST_GROUP(1),
        VM_GROUP(2),
        RULE_GROUP(3),
        BALANCED_GROUP(4);

        int value;

        private GroupTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static boolean isContains(Integer va) {
            if (va == null) {
                return false;
            }
            for (GroupTypeEnum groupType : GroupTypeEnum.values()) {
                if (groupType.value != va) continue;
                return true;
            }
            return false;
        }
    }
}

