/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.meter;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.meter.LargeLunMeterStatisticStrategyImpl;
import com.huawei.ism.drm.meter.SmallLunMeterStatisticStrategyImpl;
import com.huawei.ism.drm.meter.model.MeterStatisticInfo;
import com.huawei.ism.drm.meter.service.MeterService;
import com.huawei.ism.drm.meter.service.statistic.MeterStatisticStrategy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@Service(name="com.huawei.ism.drm.meter.service.MeterService", desc="", interfaceClass=MeterService.class)
public class MeterServiceImpl
extends BaseService
implements MeterService {
    private static final Set<MeterStatisticStrategy> METER_STATISTIC_STRATEGIES = ImmutableSet.of((Object)new LargeLunMeterStatisticStrategyImpl(), (Object)new SmallLunMeterStatisticStrategyImpl());

    @Override
    public synchronized Collection<MeterStatisticInfo> getMeter() {
        HashMap statisticInfos = new HashMap();
        List protectGroups = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroup", new Object[0]);
        for (MeterStatisticStrategy meterStatisticStrategy : METER_STATISTIC_STRATEGIES) {
            protectGroups.stream().filter(meterStatisticStrategy::isMatchStrategy).forEach(pg -> {
                int templateType = pg.getTemplate().getType();
                MeterStatisticInfo info = statisticInfos.getOrDefault(pg.getTemplate().getType(), new MeterStatisticInfo(templateType));
                meterStatisticStrategy.statisticMeter((ProtectGroup)pg, info);
                statisticInfos.put(templateType, info);
            });
        }
        return new ArrayList<MeterStatisticInfo>(statisticInfos.values());
    }
}

