/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StoragePair {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String srcControlClusterId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String targetControlClusterId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String srcHyperMetroDomainId;
    private String srcDevSN;
    private String tgtDevSN;
    private Map<String, String> storagePools = new HashMap<String, String>();

    public Map<String, String> getStoragePools() {
        return this.storagePools;
    }

    public void setStoragePools(Map<String, String> storagePools) {
        this.storagePools = storagePools;
    }

    public String getSrcDevSN() {
        return this.srcDevSN;
    }

    public void setSrcDevSN(String srcDevSN) {
        this.srcDevSN = srcDevSN;
    }

    public String getTgtDevSN() {
        return this.tgtDevSN;
    }

    public void setTgtDevSN(String tgtDevSN) {
        this.tgtDevSN = tgtDevSN;
    }

    public String getSrcControlClusterId() {
        return this.srcControlClusterId;
    }

    public void setSrcControlClusterId(String srcControlClusterId) {
        this.srcControlClusterId = srcControlClusterId;
    }

    public String getSrcHyperMetroDomainId() {
        return this.srcHyperMetroDomainId;
    }

    public void setSrcHyperMetroDomainId(String srcHyperMetroDomainId) {
        this.srcHyperMetroDomainId = srcHyperMetroDomainId;
    }

    public String getTargetControlClusterId() {
        return this.targetControlClusterId;
    }

    public void setTargetControlClusterId(String targetControlClusterId) {
        this.targetControlClusterId = targetControlClusterId;
    }

    public String getTgtStoragePool(String srcStoragePool) {
        return this.storagePools.get(srcStoragePool);
    }

    public String getTgtStoragePool(String devSn, String srcStoragePool) {
        if (this.srcDevSN.equals(devSn)) {
            return this.storagePools.get(srcStoragePool);
        }
        if (this.tgtDevSN.equals(devSn)) {
            return this.storagePools.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey())).get(srcStoragePool);
        }
        return "";
    }

    public void checkPair() {
        HashSet<String> srcPools = new HashSet<String>();
        HashSet<String> tgtPools = new HashSet<String>();
        int storagePoolsMaplenth = this.getStoragePools().size();
        for (Map.Entry<String, String> entry : this.getStoragePools().entrySet()) {
            srcPools.add(entry.getKey());
            tgtPools.add(entry.getValue());
        }
        if (storagePoolsMaplenth != srcPools.size()) {
            throw new LegoCheckedException(1073947393L);
        }
        if (storagePoolsMaplenth != tgtPools.size()) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkStoragePool(List<StoragePool> pools, StoragePair storagePair, boolean isSrcDevice) {
        if (null == pools || pools.isEmpty() || null == storagePair) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> collection = new HashSet<String>();
        for (StoragePool storagePool : pools) {
            collection.add(storagePool.getPoolId());
        }
        for (Map.Entry entry : storagePair.getStoragePools().entrySet()) {
            boolean haveThisPool = isSrcDevice ? collection.contains(entry.getKey()) : collection.contains(entry.getValue());
            if (haveThisPool) continue;
            throw new LegoCheckedException(1073947393L, "storage resource not have this pool");
        }
    }
}

