/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.sdk.utils;

import com.huawei.ism.drm.topo.sdk.consts.TopoServiceConstants;
import com.huawei.twaver.Node;
import java.util.Locale;

public class NodeDemension {
    private double width;
    private double hight;

    public NodeDemension() {
    }

    public NodeDemension(double width, double hight) {
        this.width = width;
        this.hight = hight;
    }

    public void setHight(double hight) {
        this.hight = hight;
    }

    public double getHight() {
        return this.hight;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getWidth() {
        return this.width;
    }

    public static NodeDemension getNodeDemension(String image) {
        NodeDemension demension = null;
        if (image.matches(".*-\\d+[Xx]\\d+\\.\\w+")) {
            int index = image.lastIndexOf(".");
            image = image.substring(0, index);
            index = image.lastIndexOf("-");
            image = image.substring(index + 1).toLowerCase(Locale.getDefault());
            index = image.indexOf("x");
            demension = new NodeDemension();
            try {
                demension.setWidth(Integer.parseInt(image.substring(0, index)));
            }
            catch (NumberFormatException e) {
                demension.setWidth(48.0);
            }
            try {
                demension.setHight(Integer.parseInt(image.substring(index + 1)));
            }
            catch (NumberFormatException e) {
                demension.setHight(48.0);
            }
        } else if (TopoServiceConstants.CUTLINE_IMAGE_DEMENSION_MAP.containsKey(image)) {
            demension = TopoServiceConstants.CUTLINE_IMAGE_DEMENSION_MAP.get(image);
        }
        return demension;
    }

    public static void update(Node node, String image) {
        NodeDemension demension = NodeDemension.getNodeDemension(image);
        if (demension != null) {
            node.setClient("imageWidth", demension.getWidth());
            node.setClient("imageHeight", demension.getHight());
        }
    }
}

