/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class RecoveryUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryUtil.class);

    private RecoveryUtil() {
    }

    public static RecoverySetting getRecoverySetting(String planId, String ownerId, String itemKey, Set<RecoverySetting> recoverySettings) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)ownerId) || VerifyUtil.isEmpty((String)itemKey) || VerifyUtil.isEmpty(recoverySettings)) {
            return null;
        }
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getRecoveryPlan().getPlanId().equals(planId) || !setting.getOwnerId().equals(ownerId) || !setting.getName().equals(itemKey)) continue;
            return setting;
        }
        return null;
    }

    public static Set<RecoverySetting> getRecoverySettingsByItemKey(String planId, String itemKey, Set<RecoverySetting> recoverySettings) {
        HashSet<RecoverySetting> settings = new HashSet<RecoverySetting>();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)itemKey) || VerifyUtil.isEmpty(recoverySettings)) {
            return settings;
        }
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getRecoveryPlan().getPlanId().equals(planId) || !setting.getName().equals(itemKey)) continue;
            settings.add(setting);
        }
        return settings;
    }

    public static Set<RecoverySetting> getRecoverySettingsByOwnerId(String planId, String ownerId, Set<RecoverySetting> recoverySettings) {
        HashSet<RecoverySetting> settings = new HashSet<RecoverySetting>();
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)ownerId) || VerifyUtil.isEmpty(recoverySettings)) {
            return settings;
        }
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getRecoveryPlan().getPlanId().equals(planId) || !setting.getOwnerId().equals(ownerId)) continue;
            settings.add(setting);
        }
        return settings;
    }

    public static List<String> getMountedResources(Session session, Boolean isVm) {
        if (session == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String hql = "select planId from RecoveryPlan where planStatus=:planStatus";
        List planIds = session.createQuery(hql).setParameter("planStatus", (Object)DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED.getValue()).list();
        if (VerifyUtil.isEmpty((Collection)planIds)) {
            logger.info((Object)"Mount completed plan is empty.");
            return Collections.emptyList();
        }
        ArrayList<String> mountHosts = new ArrayList<String>();
        ArrayList<String> mountVms = new ArrayList<String>();
        for (String planId : planIds) {
            if (RecoveryUtil.isVmPg(RecoveryUtil.queryProtectGroupByPgReplicaId(RecoveryUtil.queryPgReplicaIdByMountPlanId(planId, session), session))) {
                mountVms.add(RecoveryUtil.queryMountResourceIdByPlanId(planId, session));
                continue;
            }
            mountHosts.add(RecoveryUtil.queryMountResourceIdByPlanId(planId, session));
        }
        if (isVm == null) {
            mountHosts.addAll(mountVms);
            return mountHosts;
        }
        if (isVm.booleanValue()) {
            return mountVms;
        }
        return mountHosts;
    }

    public static String queryMountResourceIdByPlanId(String planId, Session session) {
        if (session == null || planId == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String nativeSql = "select propvalue from ti_rp_globalsettings where planid=:_planid and propname=:_propname";
        NativeQuery query = session.createNativeQuery(nativeSql);
        query.setParameter("_planid", (Object)planId);
        query.setParameter("_propname", (Object)"PG_DISASTER_HOST");
        List results = query.list();
        if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) {
            logger.error((Object)"Query mount host id failed from db by plan id(%s)", new Object[]{planId});
            throw new LegoCheckedException(-1L);
        }
        return String.valueOf(results.get(0));
    }

    public static String queryPgReplicaIdByMountPlanId(String planId, Session session) {
        if (planId == null || session == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String nativeSql = "select propvalue from ti_rp_globalsettings where propname=:_propname and planid=:_planid";
        NativeQuery query = session.createNativeQuery(nativeSql);
        query.setParameter("_planid", (Object)planId);
        query.setParameter("_propname", (Object)"REPLICA_ID");
        List dbReplicaId = query.list();
        if (VerifyUtil.isEmpty((Collection)dbReplicaId) || 1 != dbReplicaId.size()) {
            logger.error((Object)"Query protectGroup replica id failed from db by plan id(%s)", new Object[]{planId});
            throw new LegoCheckedException(-1L);
        }
        return String.valueOf(dbReplicaId.get(0));
    }

    public static ProtectGroup queryProtectGroupByPgReplicaId(String replicaId, Session session) {
        if (replicaId == null || session == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String hql = "select pg from ProtectGroupReplica where id=:id";
        List dbProtectGroup = session.createQuery(hql).setParameter("id", (Object)replicaId).list();
        if (VerifyUtil.isEmpty((Collection)dbProtectGroup) || 1 != dbProtectGroup.size()) {
            logger.error((Object)"Query protectGroup failed from db by replica id(%s)", new Object[]{replicaId});
            throw new LegoCheckedException(-1L);
        }
        return (ProtectGroup)dbProtectGroup.get(0);
    }

    public static boolean isVmPg(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            throw new LegoCheckedException(1073947393L);
        }
        return 10 == protectGroup.getPoType() || 12 == protectGroup.getPoType();
    }

    public static List<String> handleDbProtectObject(List<String> mountedVms, List<?> protectObjects) {
        ArrayList<String> moUuids = new ArrayList<String>();
        ArrayList<String> providerSns = new ArrayList<String>();
        for (Object object : protectObjects) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 2) continue;
            moUuids.add(String.valueOf(values[0]));
            providerSns.add(String.valueOf(values[1]));
        }
        mountedVms.removeAll(providerSns);
        mountedVms.removeAll(moUuids);
        return moUuids;
    }

    public static String changeToFsbVolumeName(String snapshotName) {
        if (VerifyUtil.isEmpty((String)snapshotName)) {
            return snapshotName;
        }
        return snapshotName.replaceAll("_BAK$", "_Clone");
    }
}

