/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.sdk.model.constants;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class KubeEnumDefine {

    public static enum KubeResourceType {
        PROTECTION_PLAN("protectionPlan"),
        BACKUP_INSTANCE("backupInstance"),
        SCHEDULE_POLICY("schedulePolicy"),
        BACKUP_LOCATION("backupLocation"),
        CLUSTER("cluster"),
        PERSISTENT_VOLUME_CLAIM("persistentVolumeClaim"),
        RESOURCESET("resourceSet"),
        STORAGE_CLASS("storageClass"),
        META_DATA_PVC("metaDataPersistentVolumeClaim"),
        VOLUMESET("volumeset");

        private final String value;

        private KubeResourceType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum KubeBackupStatus {
        NEW("New", DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS),
        VALIDATING("Validating", DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS),
        PROCESSING("Processing", DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS),
        COMPLETED("Completed", DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS),
        DELETING("Deleting", DrmEnumDefine.ReplicaStatus.DELETING_STATUS),
        FAILED("Failed", DrmEnumDefine.ReplicaStatus.ERROR_STATUS);

        private final String cdrStatus;
        private final DrmEnumDefine.ReplicaStatus bcmStatus;

        private KubeBackupStatus(String cdrStatus, DrmEnumDefine.ReplicaStatus bcmStatus) {
            this.cdrStatus = cdrStatus;
            this.bcmStatus = bcmStatus;
        }

        public static DrmEnumDefine.ReplicaStatus getBcmBackupStatus(String cdrValue) {
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)cdrValue)) {
                return DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS;
            }
            for (KubeBackupStatus mapping : KubeBackupStatus.values()) {
                if (!StringUtils.equals((CharSequence)cdrValue, (CharSequence)mapping.getCdrStatus())) continue;
                return mapping.getBcmStatus();
            }
            throw new LegoCheckedException(1073947393L);
        }

        public String getCdrStatus() {
            return this.cdrStatus;
        }

        public DrmEnumDefine.ReplicaStatus getBcmStatus() {
            return this.bcmStatus;
        }
    }

    public static enum CDRProtectGroupStatus {
        NORMAL("Normal"),
        DISABLE("Disabled"),
        PENDING("Pending"),
        REBUILDING("Rebuilding"),
        SYNCHRONIZING("Synchronizing"),
        ERROR("Error"),
        DELETING("Deleting");

        private final String value;

        private CDRProtectGroupStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static CDRProtectGroupStatus getStatus(String value) {
            return Arrays.stream(CDRProtectGroupStatus.values()).filter(item -> Objects.equals(item.getValue(), value)).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        }
    }

    public static enum BackupInstanceStatus {
        NORMAL("Normal"),
        DISABLE("Disabled"),
        BACKUPING("Backuping"),
        DELETING("Deleting"),
        CRASH("Crash");

        private final String value;

        private BackupInstanceStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static BackupInstanceStatus getStatus(String value) {
            return Arrays.stream(BackupInstanceStatus.values()).filter(item -> Objects.equals(item.getValue(), value)).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        }
    }

    public static enum DayOfWeek {
        MONDAY("Mon", 1),
        TUESDAY("Tue", 2),
        WEDNESDAY("Wed", 3),
        THURSDAY("Thur", 4),
        FRIDAY("Fri", 5),
        SATURDAY("Sat", 6),
        SUNDAY("Sun", 7);

        private final String value;
        private final int day;

        private DayOfWeek(String value, int day) {
            this.day = day;
            this.value = value;
        }

        public static String getValue(int day) {
            return Arrays.stream(DayOfWeek.values()).filter((Predicate<DayOfWeek>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getValue$0(int com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine$DayOfWeek ), (Lcom/huawei/ism/drm/kube/sdk/model/constants/KubeEnumDefine$DayOfWeek;)Z)((int)day)).findAny().orElseThrow((Supplier<LegoCheckedException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getValue$1(), ()Lcom/huawei/lego/core/sdk/exception/LegoCheckedException;)()).value;
        }

        private static /* synthetic */ LegoCheckedException lambda$getValue$1() {
            return new LegoCheckedException(1073947393L);
        }

        private static /* synthetic */ boolean lambda$getValue$0(int day, DayOfWeek item) {
            return item.day == day;
        }
    }

    public static enum TimeWaitType {
        AFTER_SYNC_BEGINS("AfterSyncBegins"),
        AFTER_SYNC_ENDS("AfterSyncEnds");

        private final String value;

        private TimeWaitType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static TimeWaitType getTimeWaitType(String value) {
            return Arrays.stream(TimeWaitType.values()).filter(type -> Objects.equals(type.getValue(), value)).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        }
    }

    public static enum PolicyType {
        HOURS("hours"),
        DAILY("daily"),
        WEEKLY("weekly"),
        MONTHLY("monthly");

        private final String value;

        private PolicyType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VolumeSpeed {
        HIGHEST("Highest", 4),
        HIGH("High", 3),
        MEDIUM("Medium", 2),
        LOW("Low", 1);

        private final String value;
        private final int index;

        private VolumeSpeed(String value, int index) {
            this.index = index;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static VolumeSpeed getVolumeSpeed(int index) {
            return Arrays.stream(VolumeSpeed.values()).filter(item -> item.index == index).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        }
    }

    public static enum RollBackType {
        PVC("pvc"),
        RESOURCE_SET("resourceSet"),
        VOLUME_SET("volumeSet"),
        NAMESPACE("namespace"),
        BACKUP_INSTANCE("backupInstance"),
        SC("sc");

        private final String value;

        private RollBackType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RoleType {
        PROTECTED("Protected"),
        RECOVERY("Recovery");

        private final String value;

        private RoleType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BackupJobStage {
        FINISHED("Finished");

        private final String value;

        private BackupJobStage(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BackupJobStatus {
        COMPLETED("Completed"),
        PROCESSING("Processing"),
        FAILED("Failed");

        private final String value;

        private BackupJobStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BackupType {
        REPLICATION("replication"),
        LOCAL("local");

        private final String value;

        private BackupType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SpeedType {
        LOW("1", "Low"),
        MEDIUM("2", "Medium"),
        HIGH("3", "High"),
        HIGHEST("4", "Highest");

        private final String bcmValue;
        private final String cdrValue;

        private SpeedType(String bcmValue, String cdrValue) {
            this.bcmValue = bcmValue;
            this.cdrValue = cdrValue;
        }

        public static String getCdrRestoreSpeed(String bcmRestoreSpeed) {
            if (VerifyUtil.isEmpty((String)bcmRestoreSpeed)) {
                return HIGH.getCdrValue();
            }
            for (SpeedType mapping : SpeedType.values()) {
                if (!StringUtils.equals((CharSequence)bcmRestoreSpeed, (CharSequence)mapping.getBcmValue())) continue;
                return mapping.getCdrValue();
            }
            throw new LegoCheckedException(1073947393L);
        }

        public String getBcmValue() {
            return this.bcmValue;
        }

        public String getCdrValue() {
            return this.cdrValue;
        }
    }
}

