/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="recoveryProcessMgr")
public interface IRecoveryProcessProvider
extends IRecoveryProcessBaseProvider {
    public void enableRecoverySyncProcessor(RecoveryProcessDefinition var1, boolean var2);

    public void disableRecoverySyncProcessor(RecoveryProcessDefinition var1, boolean var2);

    public void updateRecoveryProcessorEnableStatus(RecoveryProcessDefinition var1, List<Class<? extends RecoveryProcessor>> var2, boolean var3);

    @Deprecated
    public String addCustomRecoveryProcessor(RecoveryProcessDefinition var1, Class<? extends RecoveryProcessor> var2, Map<String, Object> var3, boolean var4, boolean var5);

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition var1, RecoveryProcessor var2, Map<String, Object> var3, boolean var4, boolean var5);

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition var1, String var2, Map<String, Object> var3);

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition var1, DrmEnumDefine.RecoveryPlanExecuteTypeE var2, String var3);

    public boolean checkProductionBusinessStopped(RecoveryProcessorContext var1);

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass();

    default public Set<RecoverySetting> getMountRecoverySettings(RecoveryPlan plan, ProtectGroupReplica protectGroupReplica, MountConfiguration mountConfigs) {
        if (null == protectGroupReplica || null == mountConfigs) {
            return new HashSet<RecoverySetting>();
        }
        HashSet<RecoverySetting> results = new HashSet<RecoverySetting>();
        Set protectObjectReplicaSet = protectGroupReplica.getReplicas();
        for (ProtectObjectReplica replica : protectObjectReplicaSet) {
            RecoverySetting startAppSetting = new RecoverySetting();
            startAppSetting.setRecoveryPlan(plan);
            startAppSetting.setOwnerId(replica.getPoId());
            startAppSetting.setName("isStart");
            startAppSetting.setValue(String.valueOf(mountConfigs.isStartDB()));
            results.add(startAppSetting);
            RecoverySetting startOrderSetting = new RecoverySetting();
            startOrderSetting.setRecoveryPlan(plan);
            startOrderSetting.setOwnerId(replica.getPoId());
            startOrderSetting.setName("startOrder");
            startOrderSetting.setValue("10");
            results.add(startOrderSetting);
        }
        return results;
    }
}

