/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanBaseServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

@Service(name="IRecoveryPlanService", desc="", interfaceClass=IRecoveryPlanService.class)
public class RecoveryPlanServiceImpl
extends RecoveryPlanBaseServiceImpl
implements IRecoveryPlanService {
    private static Log logger = LogFactory.getInstance(RecoveryPlanServiceImpl.class);
    private static final Object RECOVERY_PLAN_LOCK = new Object();
    private static final String QUERY_PLAN_SQL = "select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME from ti_recoveryplan rp ";
    private List<IRecoveryPlanCreateEventHandler> recoveryPlanCreateEventHandlers = new ArrayList<IRecoveryPlanCreateEventHandler>();

    public void syncSaveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!this.checkRecoverySettings(planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessBaseProvider procProvider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        RecoveryPlan tempPlan = new RecoveryPlan();
        tempPlan.setRecoverySettings(new HashSet<RecoverySetting>(settings));
        if (procProvider == null) {
            logger.error((Object)"procProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        procProvider.encryptProperties(tempPlan);
        this.saveOrUpdateRecoverySettings(recoveryPlan, settings);
    }

    private boolean checkRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(settings)) {
            return false;
        }
        for (RecoverySetting setting : settings) {
            RecoveryPlan plan = setting.getRecoveryPlan();
            if (null != plan && null != plan.getPlanId() && plan.getPlanId().equals(planId)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCreateRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            this.createRecoveryPlan(userID, recoveryPlan, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncModifyRecoveryPlan(RecoveryPlan recoveryPlan) {
        RecoveryPlan localInfo = this.getRecoveryPlan(recoveryPlan.getPlanId());
        if (null == localInfo) {
            logger.debug((Object)"localInfo null,not syncModifyRecoveryPlan");
            return;
        }
        localInfo.setDescription(recoveryPlan.getDescription());
        localInfo.setName(recoveryPlan.getName());
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession((Session)session);
            ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUpdateRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap) {
        RecoveryPlan localInfo = this.getRecoveryPlan(recoveryPlan.getPlanId());
        if (null == localInfo) {
            return;
        }
        localInfo.setLastExecuteType(recoveryPlan.getLastExecuteType());
        localInfo.setPlanStatus(recoveryPlan.getPlanStatus());
        localInfo.setProcessStatus(recoveryPlan.getProcessStatus());
        localInfo.setPlanProgress(recoveryPlan.getPlanProgress());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == localInfo.getLastExecuteType()) {
            localInfo.setLastTestStatus(recoveryPlan.getLastTestStatus());
            String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            localInfo.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN((RecoveryPlan)recoveryPlan);
            if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                localInfo.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(recoveryPlan.getPlanStatus()));
            }
        }
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.saveOrUpdate((Object)localInfo);
            this.updatePoRecoveryStatus(localInfo.getProtectGroups(), poRecoveryStatusMap, session);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public void syncRemoveRecoveryPlan(String recoveryPlanId) {
        block3: {
            if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
                logger.error((Object)"Invalid parameter", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            try {
                this.deleteRecoveryPlan(recoveryPlanId, false);
            }
            catch (LegoCheckedException e) {
                if (201L == e.getErrorCode() || 1073947394L == e.getErrorCode()) break block3;
                throw e;
            }
        }
        this.getBizScopeManager().deleteScopeObject(recoveryPlanId);
    }

    public void syncRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        if (VerifyUtil.isEmpty(recoveryLogs)) {
            return;
        }
        this.saveOrUpdateRecoveryLogs(recoveryLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan queryRecoveryPlan(String planId, boolean isQueryPo) {
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery("select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME from ti_recoveryplan rp  where rp.planid=:planId");
            query.setString("planId", planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlan = this.constructRecoveryPlans(results).get(0);
                Map globalSettings = this.getRecoveryGlobalSettings(planId);
                recoveryPlan.setGlobalSettings(globalSettings);
                Set recoverySettings = this.getRecoverySettingsBy(planId);
                recoveryPlan.setRecoverySettings(recoverySettings);
                for (RecoverySetting setting : recoverySettings) {
                    setting.setRecoveryPlan(recoveryPlan);
                }
                Set<ProtectGroup> protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPo);
                recoveryPlan.setProtectGroups(protectGroups);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery plan failed. Id:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
        return recoveryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> getRecoveryLogList(String recoveryPlanId, String queryHQL) {
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHQL);
            query.setString("planId", recoveryPlanId);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery logs failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
        return Collections.EMPTY_LIST;
    }

    public RecoveryLog getLatestSuccessHistoryRecoveryLog(String recoveryPlanId, Long endTime) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(recoveryPlanId);
        if (!isExisted) {
            logger.error((Object)("Recovery plan does not exist. logId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        String queryHQL = "from RecoveryLog rl where rl.planId=:planId and rl.endTime!=null and rl.logStatus=0 order by rl.startTime desc";
        List<?> recoveryLogList = this.getRecoveryLogList(recoveryPlanId, queryHQL);
        return this.getLastSuccessRecoveryLog(recoveryLogList, endTime);
    }

    private RecoveryLog getLastSuccessRecoveryLog(List<?> recoveryLogList, Long currentDate) {
        long min = Long.MAX_VALUE;
        RecoveryLog tmpRecovery = null;
        for (Object object : recoveryLogList) {
            if (!(object instanceof RecoveryLog)) continue;
            RecoveryLog rl = (RecoveryLog)object;
            long tmp = currentDate - Long.parseLong(rl.getEndTime());
            if (tmp <= 0L || tmp >= min) continue;
            min = tmp;
            tmpRecovery = rl;
        }
        return tmpRecovery;
    }

    private Set<ProtectGroup> getProtectGroupsByPlanId(String planId, Session session, boolean isQueryPos) {
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        List<String> protectGroupIds = this.getProtectGroupIdsByPlanId(planId, session);
        String querySQL = "select pg.PGID, pg.UUID as PGUUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pt.UUID as PTUUID, pt.NAME, pt.DESCRIPTION, pg.PGPROVIDERSN from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId and pg.PGID=:pgId";
        NativeQuery query = session.createSQLQuery(querySQL);
        for (String protectGroupId : protectGroupIds) {
            query.setString("pgId", protectGroupId);
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) continue;
            List<ProtectGroup> pgs = this.constructProtectGroups(results);
            for (ProtectGroup protectGroup : pgs) {
                Set pgReplicas = this.getProtectGroupReplicas(protectGroup.getUuid(), session);
                protectGroup.setReplicaList(pgReplicas);
                protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
                if (isQueryPos) {
                    Set protectObjects = this.getProtectObjects(protectGroup.getUuid(), session);
                    protectGroup.setPolist(protectObjects);
                }
                protectGroups.add(protectGroup);
            }
        }
        return protectGroups;
    }

    protected Map<String, String> getProtectGroupProps(String pgId, Session session) {
        return QueryProtectGroupRefineService.getInstance().getProtectGroupProps(pgId, session);
    }

    protected List<ProtectGroup> constructProtectGroups(List<?> result) {
        ArrayList<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 14 != (values = (Object[])object).length) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(CommUtil.convertToString((Object)values[1]));
            protectGroup.setProductSiteId(CommUtil.convertToString((Object)values[2]));
            protectGroup.setProductSiteName(CommUtil.convertToString((Object)values[3]));
            protectGroup.setName(CommUtil.convertToString((Object)values[4]));
            protectGroup.setPoType(CommUtil.convertToInteger((Object)values[5]).intValue());
            protectGroup.setPoProviderSN(CommUtil.convertToString((Object)values[13]));
            PolicyTemplate template = new PolicyTemplate();
            Integer templateType = CommUtil.convertToInteger((Object)values[6]);
            Integer templateSubType = CommUtil.convertToInteger((Object)values[7]);
            template.setType(templateType.intValue());
            template.setSubType((0 >= templateSubType ? templateType : templateSubType).intValue());
            template.setUuid(String.valueOf(values[10]));
            template.setName(String.valueOf(values[11]));
            template.setDescription(String.valueOf(values[12]));
            protectGroup.setTemplate(template);
            protectGroup.setPrimary(CommUtil.convertToBoolean((Object)values[8]).booleanValue());
            protectGroup.setStatus(NumberUtil.convertToInteger((Object)String.valueOf(values[9])).intValue());
            protectGroups.add(protectGroup);
        }
        return protectGroups;
    }

    private List<String> getProtectGroupIdsByPlanId(String planId, Session session) {
        ArrayList<String> protectGroupIds = new ArrayList<String>();
        String strSQL = "select PGID from ti_drp_r_pg where PLANID=:planId";
        NativeQuery query = session.createSQLQuery(strSQL);
        query.setString("planId", planId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results) && 1 == results.size()) {
            protectGroupIds.add(String.valueOf(results.get(0)));
        } else {
            logger.error((Object)"Can not find protectgroup for planID: %s", new Object[]{planId});
        }
        return protectGroupIds;
    }

    protected List<RecoveryPlan> constructRecoveryPlans(List<?> result) {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 11 != (values = (Object[])object).length) continue;
            RecoveryPlan recoveryPlan = new RecoveryPlan();
            recoveryPlan.setPlanId(CommUtil.convertToString((Object)values[0]));
            recoveryPlan.setUuid(CommUtil.convertToString((Object)values[1]));
            recoveryPlan.setName(CommUtil.convertToString((Object)values[2]));
            recoveryPlan.setDescription(CommUtil.convertToString((Object)values[3]));
            recoveryPlan.setPlanStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            recoveryPlan.setPlanProgress(CommUtil.convertToInteger((Object)values[5]).intValue());
            recoveryPlan.setPlanType(CommUtil.convertToInteger((Object)values[6]).intValue());
            recoveryPlan.setLastTestStatus(CommUtil.convertToInteger((Object)values[7]).intValue());
            recoveryPlan.setProcessStatus(CommUtil.convertToInteger((Object)values[8]).intValue());
            recoveryPlan.setUse(CommUtil.convertToInteger((Object)values[9]));
            recoveryPlan.setCreateTime(CommUtil.convertToLong((Object)values[10]));
            recoveryPlans.add(recoveryPlan);
        }
        return recoveryPlans;
    }

    public void checkBackendRecoveryTaskCount() {
        int count = this.getBackRunningRecoveryTaskNum();
        int defaultLimit = 10;
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        long vasaRecoveryTaskThreshold = LegoConfig.getInstance().getNumber("VASA_RECOVERY_TASK_THRESHOLD", Long.parseLong(String.valueOf(100)));
        if (isVasa) {
            defaultLimit = Integer.parseInt(String.valueOf(vasaRecoveryTaskThreshold));
        }
        if (defaultLimit <= count) {
            throw new LegoCheckedException(1073948713L, new String[]{String.valueOf(defaultLimit)});
        }
    }

    public void disableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, false);
    }

    public void disableAllSchemeRecoveryProcessor(String planId) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, true);
        Set recoveryProcessDefinitions = recoveryPlan.getRecoveryProcesses();
        for (RecoveryProcessDefinition definition : recoveryProcessDefinitions) {
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                boolean isUserDefined = Boolean.valueOf((String)processor.getProps().get("isUserDefined"));
                if (processor.getIsPreset().booleanValue() || isUserDefined) continue;
                this.disableRecoveryProcessor(processor.getPlanId(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)processor.getProcType()), processor.getProcId());
            }
        }
    }

    public void enableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, true);
    }

    public void syncDisableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, false);
    }

    public void syncEnableRecoveryProcessor(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        this.updateRecoveryProcessorEnableStatus(planId, procType, procId, true);
    }

    public void createMountPlan(User user, MountConfiguration mountPlan) {
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkMountPlan(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        String mountConfigs = JSONObject.fromObject((Object)mountPlan).toString();
        replicaService.mountReplica(user, mountPlan.getProtectGroupId(), mountPlan.getReplicaId(), mountConfigs);
    }

    private void checkMountPlan(MountConfiguration mountPlan) {
        int[] targetTypes;
        Site site;
        if (VerifyUtil.isEmpty((String)mountPlan.getHostOrGroupSn())) {
            logger.error((Object)"Mount planName: %s mount host is invalid.", new Object[]{mountPlan.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!VerifyUtil.isEmpty((String)mountPlan.getSiteId()) && VerifyUtil.isEmpty((Object)(site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(mountPlan.getSiteId())))) {
            logger.error((Object)("The site is not exist, siteId is" + mountPlan.getSiteId()));
            throw new LegoCheckedException(2117645L, "The site is not exist");
        }
        DrResource hostOrGroup = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(mountPlan.getHostOrGroupSn().split(":")[0]);
        if (VerifyUtil.isEmpty((Object)hostOrGroup)) {
            logger.error((Object)"Mount planName: %s mount host is not exist.", new Object[]{mountPlan.getName()});
            throw new LegoCheckedException(1077950337L, "The host is not exist");
        }
        String protectGroupId = mountPlan.getProtectGroupId();
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"Protect group not exist.id: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(2117645L);
        }
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        if (provider.needRefreshPgStorageInfoPreBuildReplica(protectGroup)) {
            logger.error((Object)"Protect group cannot create recovery plan.name: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073948748L);
        }
        if (!VerifyUtil.isEmpty((String)mountPlan.getStartTime())) {
            Date execDate;
            Date currentDate = new Date();
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                execDate = sDateFormat.parse(mountPlan.getStartTime());
            }
            catch (Exception e) {
                logger.error((Object)"Mount plan start time: %s is error format.", new Object[]{mountPlan.getStartTime()});
                throw new LegoCheckedException(1073947393L);
            }
            if (currentDate.getTime() >= execDate.getTime()) {
                logger.error((Object)"Execution time: %s is less than current time.", new Object[]{mountPlan.getStartTime()});
                throw new LegoCheckedException(1073948456L);
            }
        }
        for (int targetType : targetTypes = new int[]{-1, 3, 9, 10, 5}) {
            if (targetType != mountPlan.getTargetReplicaType()) continue;
            return;
        }
        logger.error((Object)("target type is invalid " + mountPlan.getTargetReplicaType()));
        throw new LegoCheckedException(1073947393L);
    }

    public void execMountPlanManual(User user, RecoveryPlan mountPlan) {
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)("can not get replica with replica id " + replicaId + "."));
            throw new LegoCheckedException(2117645L);
        }
        if (1 != replica.getStatus()) {
            logger.error((Object)"Replica is not valid: %s, status=%s.", new Object[]{replica.getId(), String.valueOf(replica.getStatus())});
            throw new LegoCheckedException(1073948459L);
        }
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = manager.getReplicaFactory(replica.getType());
        if (!factory.validReplica(replica, true)) {
            logger.error((Object)("Replica is not valid: " + replica.getId()));
            throw new LegoCheckedException(1073948459L);
        }
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountCnf = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        String hostSn = mountCnf.getHostOrGroupSn();
        mountCnf.getExtParameters().put("REPLICA_ID", replicaId);
        mountCnf.getExtParameters().put("PG_DISASTER_HOST", hostSn);
        mountCnf.getExtParameters().put("disasterHostSn", hostSn);
        IUseCopyDataService useCopyService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        useCopyService.mountReplica(mountPlan.getPlanId(), replicaId, mountCnf, user);
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        service.updateTask(mountPlan, null);
        mountCnf.setStartTime(null);
        ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
        String newConfig = JSONObject.fromObject((Object)mountCnf).toString();
        newReplica.addProperty("mountConfigs", newConfig);
        replicaService.saveOrUpdateReplica(newReplica);
    }

    private String getReplicaIdByPlanId(RecoveryPlan mountPlan) {
        String replicaId = (String)mountPlan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)("mountPlan " + mountPlan.getPlanId() + "have no replica, can not mount replica!"));
            throw new LegoCheckedException(1073947393L);
        }
        return replicaId;
    }

    private String getMountConfigByReplicaId(ProtectGroupReplica replica) {
        String mountConfigs = replica.getProperty("mountConfigs");
        if (VerifyUtil.isEmpty((String)mountConfigs)) {
            logger.error((Object)("replica id " + replica.getId() + " can not get mountConfiguration."));
            throw new LegoCheckedException(2117645L);
        }
        return mountConfigs;
    }

    public void clearMountPlanManual(User user, RecoveryPlan mountPlan, boolean bDeleteReplica) {
        if (null == mountPlan) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replicaService.unmountReplica(user, mountPlan.getProtectGroup().getUuid(), replicaId, bDeleteReplica);
    }

    public void modifyMountplan(User user, RecoveryPlan mountPlan, MountConfiguration configuration) {
        if (VerifyUtil.isEmpty((Object)mountPlan) || VerifyUtil.isEmpty((Object)configuration)) {
            logger.error((Object)"The parameter mountPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String startTime = configuration.getStartTime() == null ? "" : configuration.getStartTime();
        String description = configuration.getDescription();
        String name = configuration.getName();
        String replicaId = this.getReplicaIdByPlanId(mountPlan);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        String mountConfigs = this.getMountConfigByReplicaId(replica);
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        IUseCopyDataService service = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        if (VerifyUtil.isEmpty((String)startTime)) {
            this.execMountPlanManual(user, mountPlan);
        } else {
            Date startDate = null;
            try {
                SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                startDate = sDateFormat.parse(startTime, new ParsePosition(0));
            }
            catch (Exception e) {
                String errorMsg = "parse start time got error,startTime cannot  from \"yyyy-MM-dd HH:mm:ss\". startTime:" + startTime;
                ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
            }
            Date currentDate = new Date();
            if (currentDate.getTime() >= startDate.getTime()) {
                logger.error((Object)"Execution time %s is less than current time.", new Object[]{startTime});
                throw new LegoCheckedException(1073948456L);
            }
            String newTime = String.valueOf(startDate.getTime());
            service.updateTask(mountPlan, newTime);
        }
        mountConfiguration.setStartTime(startTime);
        mountPlan.setName(name);
        mountConfiguration.setName(name);
        mountPlan.setDescription(description);
        mountConfiguration.setDescription(description);
        this.getBaseDao().getTransactionTemplate().execute(status -> {
            ProtectGroupReplica newReplica = replicaService.queryProtectGroupReplicaById(replicaId);
            if (VerifyUtil.isEmpty((Object)newReplica)) {
                logger.error((Object)"replica dose not exists. replicaId:[%s]", new Object[]{replicaId});
                throw new LegoCheckedException(2117645L);
            }
            String newConfig = JSONObject.fromObject((Object)mountConfiguration).toString();
            newReplica.addProperty("mountConfigs", newConfig);
            replicaService.saveOrUpdateReplica(newReplica);
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)mountPlan);
            return null;
        });
    }

    public void updateRecoveryProcessorEnableStatus(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId, boolean isEnable) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)procId) || null == procType) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.EDIT_RECOVERY_PROCESSOR);
        Set processes = this.getRecoveryProcesses(planId, procType.getValue());
        this.saveOrUpdateProcessorEnableStatus(procId, isEnable, processes);
    }

    private void saveOrUpdateProcessorEnableStatus(String procId, boolean isEnable, Set<RecoveryProcessDefinition> processes) {
        if (VerifyUtil.isEmpty(processes)) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean isProcessorExist = false;
        Iterator<RecoveryProcessDefinition> iterator = processes.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = iterator.next();
        for (RecoveryProcessor processor : rpDefinition.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            isProcessorExist = true;
            if (!processor.getIsEditable().booleanValue()) {
                throw new LegoCheckedException(1073948732L);
            }
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)processor);
            MessageEvent event = MessageEvent.createMessageEvent((int)1, (Object[])new Object[]{rpDefinition, processor});
            this.notifyListener(event);
            break;
        }
        if (!isProcessorExist) {
            throw new LegoCheckedException(201L);
        }
    }
}

