/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RecoveryServiceExtendUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryServiceUtil.class);

    private RecoveryServiceExtendUtil() {
    }

    public static void checkRollBackOperationPrivilege(RecoveryPlan recoveryPlan) {
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            return;
        }
        provider.checkIfAllowRollBack(recoveryPlan);
    }

    public static List<Site> getRemoteSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Set disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (null == disasterSite || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        Site productSite = siteService.getSiteById(productSiteId);
        if (null != productSite && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }

    public static Site getRemoteDisasterSite(RecoveryPlan recoveryPlan) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        HashSet disasterSiteIds = new HashSet();
        disasterSiteIds.addAll(RecoveryServiceUtil.getDisasterSiteIds((RecoveryPlan)recoveryPlan));
        if (1 < disasterSiteIds.size()) {
            String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
                return null;
            }
            if (!RecoveryServiceUtil.isContainSite((List)localSites, (String)curDisasterSiteId)) {
                return siteService.getSiteById(curDisasterSiteId);
            }
        } else if (1 == disasterSiteIds.size()) {
            String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
            Site productSite = siteService.getSiteById(productSiteId);
            Site disasterSite = siteService.getSiteById((String)disasterSiteIds.iterator().next());
            if (localSites.contains(productSite) && !localSites.contains(disasterSite)) {
                return disasterSite;
            }
        }
        return null;
    }
}

