/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionLogManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.BackupTask;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public class AbstractBackupMonitorAction
extends AbstractBaseProtectAction {
    public static final String BACKUP_COMPLETE = "com.huawei.ism.drm.protection.framework.engine.action.BackupMonitorAction.Complete";
    public static final String BACKUP_PROGRESS = "com.huawei.ism.drm.protection.framework.engine.action.BackupMonitorAction.Progress";
    private static final Log logger = LogFactory.getInstance(AbstractBackupMonitorAction.class);
    private static final long DEFAULT_TIMEOUT = 2592000000L;
    private static final long DEFAULT_PENDING_ALARM_TIME = 1800000L;

    public boolean doExecute(ActionContext context) {
        return this.monitorBackupProgress(context);
    }

    private boolean monitorBackupProgress(ActionContext context) {
        long startTime = System.currentTimeMillis();
        long pendingStartTime = System.currentTimeMillis();
        String engineId = this.getReplicaFromContext(context).getStorageDeviceId();
        ProtectionTask backupTask = (ProtectionTask)context.getObject("TASK_ENTITY");
        Schedule schedule = backupTask.getSchedule();
        String backupPlanId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
        while (true) {
            BackupTask task;
            CommUtil.pauseThread((long)5000L);
            String taskId = "";
            try {
                IBackupManager mgr = this.getBackupEngine();
                if (VerifyUtil.isEmpty((Object)mgr)) {
                    logger.error((Object)"Not find mgr info, return false.");
                    return false;
                }
                task = mgr.queryTaskByRequestID(engineId, (String)context.getObject("BACKUP_REQUEST_ID"));
                if (!VerifyUtil.isEmpty((Object)task)) {
                    taskId = task.getId();
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"query backup task catch LegoCheckedException. errorCode is %s", e.getErrorCode());
                this.dealFailedBackup(context, taskId);
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"query backup task catch exception. errorCode is %s", new Object[]{e.getMessage()});
                this.dealFailedBackup(context, taskId);
                return false;
            }
            if (null == task || VerifyUtil.isEmpty((Object)task.getStatus())) {
                logger.error((Object)"task or task's status is null.");
                this.dealFailedBackup(context, taskId);
                return false;
            }
            if (BackupTask.STATUS.COMPLETED.getValue() == task.getStatus().getValue()) {
                AlarmReporter.restoreAlarm((long)52625499L, (String[])new String[]{backupPlanId});
                return this.dealSuccessedBackup(context, task);
            }
            if (BackupTask.STATUS.ABORTED.getValue() == task.getStatus().getValue() || BackupTask.STATUS.FAILED.getValue() == task.getStatus().getValue()) {
                this.dealFailedBackup(context, taskId);
                return false;
            }
            if (System.currentTimeMillis() - startTime > 2592000000L) {
                this.dealFailedBackup(context, taskId);
                return false;
            }
            pendingStartTime = this.getPendingStartTime(context, pendingStartTime, schedule, backupPlanId, task);
        }
    }

    private long getPendingStartTime(ActionContext context, long pendingStartTime, Schedule schedule, String backupPlanId, BackupTask task) {
        if (BackupTask.STATUS.PENDING.getValue() == task.getStatus().getValue() && System.currentTimeMillis() - pendingStartTime > 1800000L) {
            ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
            String backupPlanName = (String)schedule.getExtParameters().get("BACKUP_PLAN_NAME");
            DrResource drResource = TopoServiceUtil.getDrResource((String)schedule.getSourceSn());
            String devIP = "";
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)drResource)) {
                devIP = drResource.getIpAddress();
            }
            AlarmReporter.sendAlarm((long)52625499L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{backupPlanId, protectGroup.getName(), devIP, backupPlanName});
            pendingStartTime = System.currentTimeMillis();
        }
        if (BackupTask.STATUS.IN_PROGRESS.getValue() == task.getStatus().getValue()) {
            AlarmReporter.restoreAlarm((long)52625499L, (String[])new String[]{backupPlanId});
            pendingStartTime = System.currentTimeMillis();
        }
        this.setActionLogDetail((ProtectGroup)context.getObject("PG_ENTITY"), BACKUP_PROGRESS, task.getProgress() + "%");
        return pendingStartTime;
    }

    protected void dealFailedBackup(ActionContext context, String taskId) {
        logger.error((Object)("backup failed. taskId:" + taskId));
        this.setDetail("lego.err.1073947475");
    }

    protected boolean dealSuccessedBackup(ActionContext context, BackupTask backupTask) {
        logger.error((Object)("backup success. taskId:" + backupTask.getId()));
        this.setDetail(BACKUP_COMPLETE);
        return true;
    }

    protected void setActionLogDetail(ProtectGroup group, String info, String infoParams) {
        ProtectActionLogManager logManager = ProtectActionLogManager.getInstance();
        ProtectGroupLogDetail detail = logManager.getActionLogDetail(group.getUuid(), this.getActionId());
        if (null != detail) {
            detail.setInfo(info);
            detail.setInfoParams(infoParams);
            logManager.saveOrUpdateProtectGroupLogDetail(detail);
        }
    }

    protected ProtectGroupReplica getReplicaFromContext(ActionContext context) {
        ProtectGroupReplica replica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
        if (null == replica) {
            logger.error((Object)"replica nox exist.");
            throw new LegoCheckedException(1073947394L);
        }
        return replica;
    }

    protected IBackupManager getBackupEngine() {
        return null;
    }
}

