/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.BaseAsyncReplicateAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.manager.proxy.StorageDrStarManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageDrStarManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.ism.unistor.sdk.model.HyperDRRingMember;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ArraySanHyperMetroAsyncAirGapReplicateAction
extends BaseAsyncReplicateAction {
    private static final Log LOGGER = LogFactory.getInstance(ArraySanHyperMetroAsyncAirGapReplicateAction.class);

    public List<ReplicationRelationBo> getReplicationRelationBos(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
        Set protectGroupReplicas = pg.getReplicaList();
        HashSet newPoReplicas = new HashSet();
        for (ProtectGroupReplica protectGroupReplica : protectGroupReplicas) {
            newPoReplicas.addAll(protectGroupReplica.getReplicas());
        }
        List replicationRelationBos = this.getReplicationRelationBos(context, newPoReplicas);
        return this.checkAndFilterMainRelationBos(replicationRelationBos, context);
    }

    protected List<ReplicationRelationBo> checkAndFilterMainRelationBos(List<ReplicationRelationBo> bos, ActionContext context) {
        SanHyperMetroRingAirGapExecuteInfo executeInfo = (SanHyperMetroRingAirGapExecuteInfo)context.getObject("sanHyperMetroRingAirGapExecuteInfo", SanHyperMetroRingAirGapExecuteInfo.class);
        List<ReplicationRelationBo> siteAReplications = this.getMainReplication(bos, executeInfo.getSiteADevSn());
        List<ReplicationRelationBo> siteBReplications = this.getMainReplication(bos, executeInfo.getSiteBDevSn());
        ArrayList<ReplicationRelationBo> openedReplications = new ArrayList<ReplicationRelationBo>();
        if (executeInfo.isSiteAPortOpenSuccess()) {
            LOGGER.info((Object)"Ports on siteA open success.");
            openedReplications.addAll(siteAReplications);
        } else {
            LOGGER.info((Object)"Ports on siteA chain open failed, use pairs on siteB.");
            openedReplications.addAll(siteBReplications);
        }
        List<ReplicationRelationBo> result = this.getNormalMainReplications(bos, context, openedReplications, executeInfo, executeInfo.isSiteAPortOpenSuccess() && executeInfo.isSiteBPortOpenSuccess());
        if (result.size() == 0 || result.size() != siteAReplications.size()) {
            LOGGER.error((Object)"Some pairs are invalid, normal pair num=%s.", new Object[]{String.valueOf(result.size())});
            throw new LegoCheckedException(1677929521L);
        }
        executeInfo.setReplicationRelationBos(result);
        return result;
    }

    private List<ReplicationRelationBo> getNormalMainReplications(List<ReplicationRelationBo> bos, ActionContext context, List<ReplicationRelationBo> openedReplications, SanHyperMetroRingAirGapExecuteInfo executeInfo, boolean isBothPortOpened) {
        ArrayList<ReplicationRelationBo> normalMainReplications = new ArrayList<ReplicationRelationBo>();
        for (ReplicationRelationBo bo : openedReplications) {
            Integer syncDirection;
            Integer runningStatus;
            if (bo.isConsistentGroup()) {
                HyperMetroConsistentGroup hyperMetroCg = this.getHyperMetroCg(bo, context);
                runningStatus = Integer.parseInt(hyperMetroCg.getRunningState());
                syncDirection = hyperMetroCg.getSyncDirection();
            } else {
                HyperMetroPair hyperMetroPair = this.getHyperMetro(bo, context);
                runningStatus = Integer.parseInt(hyperMetroPair.getRunningState());
                syncDirection = hyperMetroPair.getSyncDirection();
            }
            boolean isMainReplication = this.isMainReplication(bo);
            boolean isAnotherOpenSuccess = executeInfo.isAnotherOpenSuccess(bo.getSrcDeviceSn());
            if (runningStatus.intValue() == XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()) {
                this.dealWhenHyperMetroIsActive(bos, normalMainReplications, bo, isMainReplication, isAnotherOpenSuccess);
                continue;
            }
            if (syncDirection.intValue() == XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_LOCAL_TO_REMOTE.getValue()) {
                this.dealWhenBoIsActive(normalMainReplications, bo, isMainReplication);
                continue;
            }
            if (syncDirection.intValue() != XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()) continue;
            this.dealWhenBoIsNotActive(bos, normalMainReplications, bo, isMainReplication, isAnotherOpenSuccess);
        }
        return normalMainReplications;
    }

    private void dealWhenHyperMetroIsActive(List<ReplicationRelationBo> bos, List<ReplicationRelationBo> normalMainReplications, ReplicationRelationBo bo, boolean isMainReplication, boolean isAnotherOpenSuccess) {
        if (isAnotherOpenSuccess && isMainReplication) {
            LOGGER.info((Object)"Two ports is open success, this is main replication, id =%s.", new Object[]{bo.getReplicationId()});
            normalMainReplications.add(bo);
            return;
        }
        if (isAnotherOpenSuccess) {
            LOGGER.warn((Object)"Two ports is open success, this is slave replication, id =%s.", new Object[]{bo.getReplicationId()});
            normalMainReplications.add(this.getMainReplication(bos, bo));
            return;
        }
        if (isMainReplication) {
            LOGGER.warn((Object)"One ports is open success, this is main replication, id =%s.", new Object[]{bo.getReplicationId()});
            normalMainReplications.add(bo);
            return;
        }
        LOGGER.warn((Object)"One ports is open success, this is slave replication, id =%s, occur swap.", new Object[]{bo.getReplicationId()});
        this.doChangeMainAndSlave(bo.getTgtDeviceSn(), bo.getDrRingId());
        normalMainReplications.add(bo);
    }

    private void dealWhenBoIsNotActive(List<ReplicationRelationBo> bos, List<ReplicationRelationBo> normalMainReplications, ReplicationRelationBo bo, boolean isMainReplication, boolean isAnotherOpenSuccess) {
        if (!isAnotherOpenSuccess) {
            LOGGER.error((Object)"HyperMetro status is not normal, active site's ports open failed.");
            return;
        }
        if (isMainReplication) {
            LOGGER.warn((Object)"HyperMetro status is not normal, active site matches bo.");
            this.doChangeMainAndSlave(bo.getTgtDeviceSn(), bo.getDrRingId());
            normalMainReplications.add(this.getMainReplication(bos, bo));
            return;
        }
        LOGGER.warn((Object)"HyperMetro status is not normal, active site matches bo.");
        normalMainReplications.add(this.getMainReplication(bos, bo));
    }

    private void dealWhenBoIsActive(List<ReplicationRelationBo> normalMainReplications, ReplicationRelationBo bo, boolean isMainReplication) {
        if (isMainReplication) {
            LOGGER.warn((Object)"HyperMetro status is not normal, active site matches bo.");
            normalMainReplications.add(bo);
            return;
        }
        LOGGER.warn((Object)"HyperMetro status is not normal, active site matches bo.");
        this.doChangeMainAndSlave(bo.getTgtDeviceSn(), bo.getDrRingId());
        normalMainReplications.add(bo);
    }

    private void doChangeMainAndSlave(String devSn, String drRingId) {
        IStorageDrStarManager drStarManager = StorageDrStarManagerProxy.getInstance().getStorageDrStarManager(devSn);
        drStarManager.swapDrStar(devSn, drRingId);
    }

    private HyperMetroConsistentGroup getHyperMetroCg(ReplicationRelationBo siteABo, ActionContext context) {
        String hyperMetroId = this.getHyperMetroId(siteABo, context);
        IStorageHyperMetroManager hyperMetroManager = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
        return hyperMetroManager.queryHyperMetroConsistentGroupOnRemote(siteABo.getTgtDeviceSn(), siteABo.getSrcDeviceSn(), hyperMetroId);
    }

    private HyperMetroPair getHyperMetro(ReplicationRelationBo siteABo, ActionContext context) {
        String hyperMetroId = this.getHyperMetroId(siteABo, context);
        IStorageHyperMetroManager hyperMetroManager = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
        return hyperMetroManager.queryHyperMetroPairOnRemote(siteABo.getTgtDeviceSn(), siteABo.getSrcDeviceSn(), hyperMetroId, null);
    }

    private String getHyperMetroId(ReplicationRelationBo siteABo, ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
        String drRingId = siteABo.getDrRingId();
        if (VerifyUtil.isEmpty((String)drRingId)) {
            LOGGER.error((Object)"Dr ringId is empty, pg name: %s, replication id.", new Object[]{pg.getName(), siteABo.getReplicationId()});
            throw new LegoCheckedException(2117645L);
        }
        IStorageDrStarManager drStarManager = StorageDrStarManagerProxy.getInstance().getStorageDrStarManager(siteABo.getTgtDeviceSn());
        List drStarMemberInfos = drStarManager.getDrStarMemberInfos(siteABo.getTgtDeviceSn(), drRingId);
        String hyperMetroId = "";
        for (HyperDRRingMember drStarMemberInfo : drStarMemberInfos) {
            if (!DrmEnumDefine.HyperDrRingMemberType.HYPER_METRO.getValue().equals(drStarMemberInfo.getFeatureType())) continue;
            hyperMetroId = drStarMemberInfo.getId();
        }
        if (VerifyUtil.isEmpty((String)hyperMetroId)) {
            LOGGER.error((Object)"HyperMetro id is empty, pg name: %s., replication id.", new Object[]{pg.getName(), siteABo.getReplicationId()});
            throw new LegoCheckedException(2117645L);
        }
        return hyperMetroId;
    }

    private boolean isMainReplication(ReplicationRelationBo bo) {
        IRecoveryProcessHandler recoveryProcessHandler = null;
        IRecoveryProcessBaseHandler recoveryProcessBaseHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (recoveryProcessBaseHandler instanceof IRecoveryProcessHandler) {
            recoveryProcessHandler = (IRecoveryProcessHandler)recoveryProcessBaseHandler;
        }
        List targetLuns = recoveryProcessHandler.querySyncStatus(bo.getSrcDeviceSn(), bo.getTgtDeviceSn(), bo.getReplicationId(), bo.isConsistentGroup());
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            if (XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue() != repTargetLun.getPairStatus().intValue()) continue;
            LOGGER.info((Object)"This is the slave chain, replication pair id=%s.", new Object[]{bo.getReplicationId()});
            return false;
        }
        return true;
    }

    private List<ReplicationRelationBo> getMainReplication(List<ReplicationRelationBo> bos, String devSn) {
        ArrayList<ReplicationRelationBo> mainBos = new ArrayList<ReplicationRelationBo>();
        for (ReplicationRelationBo bo : bos) {
            if (!bo.getSrcDeviceSn().equals(devSn)) continue;
            mainBos.add(bo);
        }
        if (mainBos.isEmpty()) {
            LOGGER.error((Object)"Failed get main replication, devSn=%s. ", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(2117645L);
        }
        return mainBos;
    }

    private ReplicationRelationBo getMainReplication(List<ReplicationRelationBo> bos, ReplicationRelationBo openedBo) {
        List relationBos = bos.stream().filter(bo -> !bo.getSrcDeviceSn().equals(openedBo.getSrcDeviceSn()) && bo.getTgtLuns().containsValue(openedBo.getTgtLuns().values().iterator().next())).collect(Collectors.toList());
        if (relationBos.size() == 0) {
            LOGGER.error((Object)"Failed get main replication, devSn=%s. ", new Object[]{SecurityUtil.desensitizeId((String)openedBo.getSrcDeviceSn())});
            throw new LegoCheckedException(2117645L);
        }
        return (ReplicationRelationBo)relationBos.get(0);
    }
}

