/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CreateHyperCDPAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(CreateHyperCDPAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)"BaseSnapshotAction begin to execute,pgId: %s", new Object[]{protectGroup.getUuid()});
        return this.createHyperCDPConsistentGroup(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createHyperCDPConsistentGroup(ActionContext context) {
        boolean flag = false;
        try {
            ProtectGroupReplica replica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY");
            ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
            ProtectionTask curTask = (ProtectionTask)context.getObject("TASK_ENTITY");
            this.createAndSetHyperCDP(replica, protectGroup, curTask);
            flag = true;
            this.setTimeStamp(context);
            boolean bl = flag;
            return bl;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"Execute Snapshot failed! errorCode: %s ", new Object[]{String.valueOf(errorCode)});
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948689");
            logger.error((Object)"Execute Snapshot failed! ErrorMsg: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            boolean bl = flag;
            return bl;
        }
        finally {
            if (!flag && context.getContext().containsKey("FREEZE_PO_ENTITY")) {
                Set pos = (Set)context.getObject("FREEZE_PO_ENTITY");
                for (ProtectObject po : pos) {
                    this.thaw(po);
                }
            }
        }
    }

    protected void createAndSetHyperCDP(ProtectGroupReplica replica, ProtectGroup protectGroup, ProtectionTask curTask) {
        HyperCDPConsistencyGroup group = this.createHyperCDPGroup(protectGroup, replica);
        this.fillReplicaStorageInfo(replica, group);
    }

    private void thaw(ProtectObject po) {
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        if (appManager != null) {
            appManager.thaw(po);
        } else {
            logger.error((Object)"IApplicationManager is null!poType: %s", new Object[]{po.getPoType() + ""});
        }
    }

    private HyperCDPConsistencyGroup createHyperCDPGroup(ProtectGroup protectGroup, ProtectGroupReplica replica) {
        String devSn = replica.getStorageDeviceId();
        String lunCgId = this.getLunCgId(protectGroup, replica);
        IStorageHyperCDPGroupManager mgr = StorageHyperCDPGroupManagerProxy.getInstance().getStorageHyperCDPGroupMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperCDPGroupManager is null!storageSn: %s", new Object[]{devSn});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
        return mgr.create(devSn, lunCgId);
    }

    protected void fillReplicaStorageInfo(ProtectGroupReplica replica, HyperCDPConsistencyGroup group) {
        String devSn = replica.getStorageDeviceId();
        String groupId = group.getId();
        IStorageHyperCDPManager mgr = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperCDPManager is null!storageSn: %s", new Object[]{devSn});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
        List list = mgr.getHyperCDPByCGId(devSn, groupId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.error((Object)"HyperCDP is null! storageSn: %s", new Object[]{devSn});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
        HashMap map = new HashMap();
        list.forEach(hyperCDP -> map.put(hyperCDP.getDevSn() + hyperCDP.getSrcResourceId(), hyperCDP.getId()));
        replica.getReplicas().forEach(protectObjectReplica -> protectObjectReplica.getStorageInfos().forEach(storageInfo -> {
            LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
            String cdpId = (String)map.get(localStorageReplica.getStorageProviderSN() + localStorageReplica.getSrcStorageId());
            if (cdpId != null) {
                localStorageReplica.setStorageId(cdpId);
                localStorageReplica.setConsistentGroupId(groupId);
            }
        }));
    }

    protected String getLunCgId(ProtectGroup protectGroup, ProtectGroupReplica replica) {
        String devSn = replica.getStorageDeviceId();
        String lunCgId = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        if (lunCgId == null) {
            logger.error((Object)"LunConsistGroupId is not existed.");
            throw new LegoCheckedException(1073947394L);
        }
        return lunCgId;
    }
}

