/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Set;

public class CreateSanSnapshotAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(CreateSanSnapshotAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseSnapshotAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        return this.activeSnapshot(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean activeSnapshot(ActionContext context) {
        SnapShotAssociateProtectObject apo = (SnapShotAssociateProtectObject)context.getObject("PO_GROUP_MAP");
        boolean flag = false;
        try {
            ArrayList snapshotIds = new ArrayList(apo.getSnapshotInfo().values());
            IStorageSnapshotManager storageSnapshotMgr = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(apo.getTgtStorageProviderSN());
            if (storageSnapshotMgr == null) {
                logger.error((Object)("IStorageSnapshotManager is null!storageSn:" + apo.getTgtStorageProviderSN()));
                this.setDetail("lego.err.1073947394");
                throw new LegoCheckedException(1073947394L);
            }
            this.checkInterruptPoint();
            OperationResult optResult = storageSnapshotMgr.activeSnapshot(apo.getTgtStorageProviderSN(), snapshotIds);
            this.checkInterruptPoint();
            if (null == optResult || !optResult.isSuccess()) {
                String errorCode = null != optResult ? optResult.getErrorCode() : String.valueOf(1073948689L);
                this.updatePgReplicaUnactive(context);
                logger.error((Object)("Active Snapshot failed.the error code is " + errorCode), 90160758786989L);
                this.setDetail("lego.err.1073948689");
                boolean bl = flag;
                return bl;
            }
            this.setTimeStamp(context);
            logger.info((Object)"BaseSnapshotAction end to execute!", 90160758786988L);
            boolean bl = flag = true;
            return bl;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"Execute Snapshot failed! ", errorCode);
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948689");
            logger.error((Object)"Execute Snapshot failed! ", 1073948689L);
            boolean bl = flag;
            return bl;
        }
        finally {
            if (!flag && context.getContext().containsKey("FREEZE_PO_ENTITY")) {
                Set pos = (Set)context.getObject("FREEZE_PO_ENTITY");
                for (ProtectObject po : pos) {
                    this.thaw(po);
                }
            }
        }
    }

    private void thaw(ProtectObject po) {
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        if (appManager != null) {
            appManager.thaw(po);
        } else {
            logger.error((Object)("IApplicationManager is null!poType:" + po.getPoType()));
        }
    }

    protected void updatePgReplicaUnactive(ActionContext context) {
        if (((Boolean)context.getObject("PG_SNAPSHOT_RE_ACTIVE", Boolean.class)).booleanValue()) {
            ProtectGroupReplica replica = (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY", ProtectGroupReplica.class);
            if (!VerifyUtil.isEmpty((Object)replica)) {
                replica.setStatus(0);
            } else {
                logger.error((Object)"update protectGroup replica status failed, replica is null.");
            }
        }
    }
}

