/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.EnableAirGapPortAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTaskList;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EnableHyperMetroAirGapPortAction
extends EnableAirGapPortAction {
    private static final Log LOGGER = LogFactory.getInstance(EnableHyperMetroAirGapPortAction.class);
    private static final int KEEP_ALIVE = 0;
    private static final int THREAD_QUEUE_SIZE = 1;

    @Override
    public boolean getEnablePortResult(ActionContext context) {
        Map portsMap;
        LOGGER.info((Object)"EnableAirGapPortAction begin to execute.");
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            LOGGER.info((Object)"Pg is not airGap networking, Pg name = %s.", new Object[]{pg.getName()});
            return true;
        }
        try {
            portsMap = AirGapLinkPortUtil.getHyperMetroAirGapPortsMap((ProtectGroup)pg);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"  Failed to query ports, airGap site may be abnormal, pg name=%s.", new Object[]{pg.getName()});
            this.setDetail("lego.err.1073948475");
            return false;
        }
        Iterator iterator = portsMap.values().iterator();
        while (iterator.hasNext()) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)iterator.next()))) continue;
            LOGGER.error((Object)"Error: not find pg ports. PgName: %s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        SanHyperMetroRingAirGapExecuteInfo executeInfo = this.getExecuteInfo(pg);
        HashSet<String> failedPortNames = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        LOGGER.info((Object)"Start open port at: %s.", new Object[]{String.valueOf(startTime)});
        try {
            if (!this.checkAndEnableAirGapLinkPort(context, portsMap, pg, failedPortNames, executeInfo)) {
                boolean shouldTerminate = context.isShouldTerminate();
                LOGGER.error((Object)"Check and enable AirGap linkPort failed, shouldTerminate: %s.", new Object[]{shouldTerminate});
                this.setDetail("lego.err." + (shouldTerminate ? 1073948470L : 1073948390L));
                if (!shouldTerminate) {
                    this.setDetailParams(AirGapLinkPortUtil.getPortNames(failedPortNames));
                }
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Enable port exception.", (Throwable)e);
            if (context.isShouldTerminate()) {
                this.setDetail("lego.err.1073948470");
            } else {
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
            }
            return false;
        }
        this.dealAfterOpenSuccess(context, portsMap, failedPortNames, startTime, executeInfo);
        return true;
    }

    private void dealAfterOpenSuccess(ActionContext context, Map<String, List<StorageLinkPort>> portsMap, Set<String> failedPortNames, long startTime, SanHyperMetroRingAirGapExecuteInfo executeInfo) {
        long endTime = System.currentTimeMillis();
        Set<String> enabledPortNames = this.checkAndGetEnablePortNames(portsMap, failedPortNames);
        if (endTime - startTime <= 30000L) {
            this.setDetail("com.huawei.ism.drm.protection.framework.engine.action.EnableAirGapPortAction.EnablePorts.Enabled");
        } else {
            this.setDetail("com.huawei.ism.drm.protection.framework.engine.action.EnableAirGapPortAction.EnablePorts.Complete");
        }
        this.setDetailParams(AirGapLinkPortUtil.getPortNames(enabledPortNames));
        context.addObject("sanHyperMetroRingAirGapExecuteInfo", (Object)executeInfo);
    }

    private Set<String> checkAndGetEnablePortNames(Map<String, List<StorageLinkPort>> portsMap, Set<String> failedPortNames) {
        HashSet<String> enabledPortNames = new HashSet<String>();
        for (List<StorageLinkPort> linkPorts : portsMap.values()) {
            linkPorts.forEach(linkPort -> {
                if (CollectionUtils.isEmpty((Collection)failedPortNames) || !failedPortNames.contains(linkPort.getPortName())) {
                    enabledPortNames.add(linkPort.getPortName());
                }
            });
        }
        return enabledPortNames;
    }

    private SanHyperMetroRingAirGapExecuteInfo getExecuteInfo(ProtectGroup pg) {
        List replicas = pg.listAllReplicatonRepica();
        Map<String, List<ProtectGroupReplica>> map = replicas.stream().collect(Collectors.groupingBy(ProtectGroupReplica::getProductArray));
        if (map.size() != 2) {
            LOGGER.error((Object)"Error: 3DC hyperMetro AirGap must have 2 chains, chain nums: %s, pg name: %s.", new Object[]{map.size(), pg.getName()});
            throw new LegoCheckedException(1677929520L);
        }
        Iterator<String> devSnIter = map.keySet().iterator();
        return new SanHyperMetroRingAirGapExecuteInfo(devSnIter.next(), devSnIter.next(), pg.getPoProviderSN());
    }

    private boolean checkAndEnableAirGapLinkPort(ActionContext context, Map<String, List<StorageLinkPort>> portsMap, ProtectGroup pg, Set<String> failedPortNames, SanHyperMetroRingAirGapExecuteInfo executeInfo) {
        Iterator<Map.Entry<String, List<StorageLinkPort>>> iterator = portsMap.entrySet().iterator();
        EnablePortTaskList portTasks = new EnablePortTaskList();
        int threadsNumber = portsMap.entrySet().size();
        CountDownLatch done = new CountDownLatch(threadsNumber);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threadsNumber, threadsNumber, 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1));
        ArrayList<Future<Map<String, Boolean>>> futures = new ArrayList<Future<Map<String, Boolean>>>(threadsNumber);
        while (iterator.hasNext()) {
            String taskId;
            List<String> portIds;
            Map.Entry<String, List<StorageLinkPort>> entry = iterator.next();
            List<StorageLinkPort> linkPorts = entry.getValue();
            List<StorageLinkPort> needEnablePorts = this.getStorageLinkPorts(context, linkPorts, pg, portIds = this.getAndCheckPortIds(linkPorts, pg), taskId = UUIDGenerator.getUUID());
            if (CollectionUtils.isEmpty(needEnablePorts)) {
                executeInfo.setPortOpenStatus(entry.getKey(), Boolean.valueOf(true));
                done.countDown();
                continue;
            }
            EnablePortTask task = this.buildEnablePorTask(pg, taskId, needEnablePorts, entry.getKey());
            portTasks.addEnablePortTask(task);
            context.addObject("linkPortTaskInfo", (Object)portTasks);
            AirGapLinkProcessor.getInstance().addEnablePortsToProcessor(task);
            HashSet<StorageLinkPort> waitPortsSet = new HashSet<StorageLinkPort>(needEnablePorts);
            futures.add(pool.submit(this.getOpenPortResultTask(entry.getKey(), waitPortsSet, failedPortNames, done)));
        }
        if (futures.size() == 0) {
            return executeInfo.isSiteAPortOpenSuccess() || executeInfo.isSiteBPortOpenSuccess();
        }
        if (!EnableHyperMetroAirGapPortAction.waitAllProcessorComplete(done)) {
            LOGGER.warn((Object)"The thread for enabling the port is interrupted.");
            return false;
        }
        Map<String, Boolean> merged = EnableHyperMetroAirGapPortAction.getResult(futures);
        for (Map.Entry<String, List<StorageLinkPort>> stringListEntry : portsMap.entrySet()) {
            String devSn = stringListEntry.getKey();
            if (merged.get(devSn) == null) {
                return false;
            }
            executeInfo.setPortOpenStatus(devSn, merged.get(devSn));
        }
        return executeInfo.isSiteAPortOpenSuccess() || executeInfo.isSiteBPortOpenSuccess();
    }

    private EnablePortTask buildEnablePorTask(ProtectGroup pg, String taskId, List<StorageLinkPort> needEnablePorts, String remoteDevSn) {
        EnablePortTask task = new EnablePortTask();
        task.setPortList(needEnablePorts);
        task.setDevSn(needEnablePorts.get(0).getDevSn());
        task.setTaskId(taskId);
        task.setRemoteDevSn(remoteDevSn);
        task.setProtectGroup(pg);
        return task;
    }

    private List<StorageLinkPort> getStorageLinkPorts(ActionContext context, List<StorageLinkPort> linkPorts, ProtectGroup pg, List<String> portIds, String taskId) {
        ArrayList<StorageLinkPort> needEnablePorts = new ArrayList<StorageLinkPort>();
        int execMode = (Integer)context.getObject("PG_EXECUTION_MODE");
        for (StorageLinkPort linkPort : linkPorts) {
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            if (VerifyUtil.isEmpty((Object)portInDb)) {
                LOGGER.error((Object)"Not get port in db by id: %s. please check.", new Object[]{linkPort.getPortId()});
                throw new LegoCheckedException(201L);
            }
            DrmEnumDefine.ExecTypeEnum execTypeEnum = AirGapLinkPortUtil.getExecTypeEnum((ProtectGroup)pg, (int)execMode);
            portInDb.setExecTypeEnum(execTypeEnum);
            portInDb.setScheduleModeType(execMode == 1 ? DrmEnumDefine.ExecTypeEnum.MANUAL : DrmEnumDefine.ExecTypeEnum.AUTO);
            portInDb.setTaskId(taskId);
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(1);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)portInDb);
            LOGGER.info((Object)"Need to enable portName: %s.", new Object[]{portInDb.getPortName()});
            needEnablePorts.add(portInDb);
        }
        return needEnablePorts;
    }

    private List<String> getAndCheckPortIds(List<StorageLinkPort> linkPorts, ProtectGroup pg) {
        List<String> portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portIds)) {
            LOGGER.error((Object)"Error: not find pg portIds. PgName: %s.", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        return portIds;
    }

    private Callable<Map<String, Boolean>> getOpenPortResultTask(final String devSn, final Set<StorageLinkPort> waitPortsSet, final Set<String> failedPortNames, final CountDownLatch down) {
        return new Callable(){

            public Map<String, Boolean> call() {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put(devSn, AirGapLinkPortUtil.getInstance().isHasPortEnable(waitPortsSet, failedPortNames));
                down.countDown();
                return map;
            }
        };
    }

    private static boolean waitAllProcessorComplete(CountDownLatch completedSignal) {
        try {
            boolean isInTime = completedSignal.await(370000L, TimeUnit.MILLISECONDS);
            if (!isInTime) {
                LOGGER.error((Object)"Enabling the port times out.");
                throw new LegoCheckedException(1073947433L);
            }
            return isInTime;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"The Air Gap backup task has been manually stopped.");
            return false;
        }
    }

    private static Map<String, Boolean> getResult(List<Future<Map<String, Boolean>>> futures) {
        ArrayList results = new ArrayList();
        futures.forEach(future -> {
            try {
                results.add(future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Object)"Get main|slave chain ports in storage exception, e: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        });
        return results.stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

