/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.action.BaseArraySynMonitorAction;
import com.huawei.ism.drm.protection.framework.engine.action.HyperVaultBackUpMonitorSubAction;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HyperVaultBackUpMonitorAction
extends BaseArraySynMonitorAction {
    private static final Log logger = LogFactory.getInstance(HyperVaultBackUpMonitorAction.class);

    @Override
    public void preExcute(ActionContext context) {
        super.preExcute(context);
    }

    @Override
    protected void updateSubActions(ActionContext context, List<AbstractBaseProtectAction> subActions) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("HyperVaultBackUpMonitorAction begin to execute,pgId:" + protectGroup.getUuid() + " pgName " + protectGroup.getName()));
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (null == pgReplica) {
            logger.error((Object)("HyperVaultBackUpMonitorAction get replica error,pgId:" + protectGroup.getUuid() + " pgName " + protectGroup.getName()));
            this.setDetail("lego.err.2117645");
            throw new LegoCheckedException(1073947394L);
        }
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        this.updateSubActions(pgReplica, subActions);
    }

    private void updateSubActions(ProtectGroupReplica replica, List<AbstractBaseProtectAction> subActions) {
        Set poReplicas = replica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)poReplicas)) {
            logger.error((Object)"can not get rpoReplicas");
            throw new LegoCheckedException(1073947394L);
        }
        HashSet<String> vaultIds = new HashSet<String>();
        for (ProtectObjectReplica poReplica : poReplicas) {
            Set hyperVaultReplicas = poReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)hyperVaultReplicas)) {
                logger.error((Object)"can not get hyperVaultReplicas");
                throw new LegoCheckedException(1073947394L);
            }
            for (RelicaStorageInfo info : hyperVaultReplicas) {
                HyperVaultReplica replicaStorageInfo = (HyperVaultReplica)info;
                if (vaultIds.contains(replicaStorageInfo.getPairId())) continue;
                vaultIds.add(replicaStorageInfo.getPairId());
                subActions.add(new HyperVaultBackUpMonitorSubAction(replicaStorageInfo, this.getOverTaskTime()));
            }
        }
    }
}

