/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HyperVaultReplicaRefreshSubscriber
extends MessageTaskManager {
    private static final Log logger = LogFactory.getInstance(HyperVaultReplicaRefreshSubscriber.class);

    public HyperVaultReplicaRefreshSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(MessageUnit messageUnit) {
        if (null == messageUnit) {
            logger.error((Object)"mu param is empty");
            return;
        }
        long msgType = messageUnit.getCmdcode();
        if (20001L != msgType && 20002L != msgType) {
            logger.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = messageUnit.getObj();
        if (null == msg || !(msg instanceof ProtectGroup)) {
            return;
        }
        if (MessageTopic.DATA.equals((Object)messageUnit.getMt())) {
            ProtectGroup pg = (ProtectGroup)msg;
            if (pg.getTemplate().getType() != 17 && pg.getTemplate().getType() != 28) {
                return;
            }
            ProtectionJobUtil.getInstance().checkIsNeedLock(pg.getUuid());
            try {
                pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid());
                this.refreshReplicaStatus(pg);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"refresh HyperVault Replica error", (Throwable)e);
            }
            finally {
                ProtectionJobUtil.getInstance().releaseLockPg(pg.getUuid());
            }
        } else {
            logger.info((Object)("Not subscribed topic. Type:" + messageUnit.getMt().name()), 90160758784000L);
        }
    }

    private void refreshReplicaStatus(ProtectGroup pg) {
        HyperVaultReplica firstReplicaStorage;
        ArrayList<String> replicaIds = new ArrayList<String>();
        HashSet<String> deviceSns = new HashSet<String>();
        String vaultId = "";
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            for (ProtectObjectReplica poReplica : replica.getReplicas()) {
                Iterator iterator = poReplica.getStorageInfos().iterator();
                if (VerifyUtil.isEmpty(iterator) || !iterator.hasNext()) {
                    logger.error((Object)"poReplica.getStorageInfos() isEmpty");
                    continue;
                }
                firstReplicaStorage = (HyperVaultReplica)iterator.next();
                deviceSns.add(firstReplicaStorage.getStorageProviderSN());
                vaultId = firstReplicaStorage.getPairId();
            }
        }
        ArrayList<HyperVaultCopy> allCopys = new ArrayList<HyperVaultCopy>();
        for (String deviceSn : deviceSns) {
            IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(deviceSn);
            if (mgr == null) {
                logger.error((Object)("IStorageHyperVaultManager is null.deviceSn:" + deviceSn));
                continue;
            }
            List copys = mgr.queryCopysByHyperVault(deviceSn, vaultId);
            allCopys.addAll(copys);
        }
        block3: for (ProtectGroupReplica replica : pg.getReplicaList()) {
            for (ProtectObjectReplica poReplica : replica.getReplicas()) {
                if (VerifyUtil.isEmpty((Collection)poReplica.getStorageInfos())) {
                    logger.error((Object)"poReplica.getStorageInfos isEmpty");
                    continue;
                }
                firstReplicaStorage = (HyperVaultReplica)poReplica.getStorageInfos().iterator().next();
                String copyId = firstReplicaStorage.getStorageId();
                if (VerifyUtil.isEmpty((String)copyId) || copyId.equals("NONE")) continue;
                HyperVaultCopy targetCopy = this.getHyperVaultCopy(copyId, allCopys);
                if (VerifyUtil.isEmpty((Object)targetCopy) || targetCopy.getRestoreAble().booleanValue()) continue block3;
                logger.debug((Object)("deviceSn : " + targetCopy.getDevSn() + "id :" + targetCopy.getId() + " is un restoreable "));
                replicaIds.add(replica.getId());
                continue block3;
            }
        }
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).invalidProtectGroupReplica(pg.getUuid(), replicaIds);
    }

    private HyperVaultCopy getHyperVaultCopy(String copyId, List<HyperVaultCopy> copys) {
        for (HyperVaultCopy copy : copys) {
            if (!copyId.equals(copy.getId())) continue;
            return copy;
        }
        logger.error((Object)("can not find copy if copyId " + copyId));
        this.printAllHyperVaultCopyId(copys);
        return null;
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(20001L);
        mrs[0].addMessageCode(20002L);
        return mrs;
    }

    private void printAllHyperVaultCopyId(List<HyperVaultCopy> copys) {
        StringBuffer sb = new StringBuffer();
        for (HyperVaultCopy copy : copys) {
            sb.append(copy.getId() + ";");
        }
        logger.error((Object)sb.toString());
    }
}

