/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.AbstractProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.AddProtectObjectsBackTask;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectGroupTask;
import com.huawei.ism.drm.protection.framework.service.group.ExportProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.UpdateProtectGroupInfoTask;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.DiskStoragePool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.util.RemoteSiteMonitorTask;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService", desc="", interfaceClass=IProtectGroupBaseService.class)
public class ProtectGroupBaseServiceImpl
extends AbstractProtectGroupServiceImpl
implements IProtectGroupBaseService {
    private static final Log LOG = LogFactory.getInstance(ProtectGroupBaseServiceImpl.class);

    public String getProtectGroupTimeWindowRange(String providerSn, List<ProtectObject> pos) {
        List<StorageLinkPort> linkPorts;
        if (CollectionUtils.isEmpty(pos)) {
            LOG.error((Object)"parameter is error.");
            throw new LegoCheckedException(1073947393L);
        }
        List<String> resourceIds = this.getResourceIdsByPo(pos);
        if (CollectionUtils.isEmpty(resourceIds)) {
            return "";
        }
        try {
            linkPorts = this.getStorageLinkPorts(providerSn, resourceIds, this.getPoType(pos));
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Find link port failed, return null string.");
            return "";
        }
        if (CollectionUtils.isEmpty(linkPorts)) {
            LOG.error((Object)"Not find linkPorts, Check!!!");
            return "";
        }
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        AirGapLinkPortUtil linkPortUtil = AirGapLinkPortUtil.getInstance();
        List ranges = linkPortUtil.getTimeRangesByPgPortIds(portIds, providerSn);
        if (CollectionUtils.isEmpty((Collection)ranges)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ResourceTimeWindowRange range : ranges) {
            String tmpStr = this.getResString(range);
            sb.append(tmpStr).append("; ");
        }
        LOG.info((Object)"resStr: %s", new Object[]{sb.toString()});
        return sb.substring(0, sb.length() - 2);
    }

    private List<String> getResourceIdsByPo(List<ProtectObject> protectObjects) {
        ProtectObject po = protectObjects.get(0);
        if (po.getPoType() == 11) {
            return this.getLunIdsByPo(protectObjects);
        }
        if (po.getPoType() == 14) {
            return this.getNasIdsByPo(protectObjects);
        }
        if (po.getPoType() == 101) {
            IProtectObjectProvider provider = (IProtectObjectProvider)((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(101);
            provider.loadProtectObjectStorageInfo(protectObjects);
            return this.getNasIdsByPo(protectObjects);
        }
        if (po.getPoType() == 99) {
            IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
            List lunList = storageService.getSrcLunByReplicasionUuid(po.getMoUuid());
            return lunList.stream().map(Lun::getLunId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getResString(ResourceTimeWindowRange range) {
        Date startDate = range.getStartTime();
        Date endDate = range.getEndTime();
        String[] strStartArray = new SimpleDateFormat("HH:mm:ss").format(startDate).split(":");
        String startHour = strStartArray[0].trim();
        String startMin = strStartArray[1].trim();
        String startStr = startHour + ":" + startMin;
        String[] strEndArray = new SimpleDateFormat("HH:mm:ss").format(endDate).split(":");
        String endHour = strEndArray[0].trim();
        String endMin = strEndArray[1].trim();
        String endStr = endHour + ":" + endMin;
        return startStr + "-" + endStr;
    }

    private List<String> getLunIdsByPo(List<ProtectObject> ProtectObjects) {
        ProtectObject po = ProtectObjects.get(0);
        ArrayList<String> lunIds = new ArrayList<String>();
        if (po.getProps().size() == 0) {
            String moUuId = po.getMoUuid();
            List lunList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getSrcLunByReplicasionUuid(moUuId);
            if (VerifyUtil.isEmpty((Collection)lunList)) {
                LOG.error((Object)"Not find Luns by moUuId: %s", new Object[]{moUuId});
                throw new LegoCheckedException(1073947394L);
            }
            lunList.forEach(lun -> lunIds.add(lun.getLunId()));
        } else {
            String lunId = (String)po.getProps().get("lunId");
            LOG.info((Object)"Get lunId: %s", new Object[]{lunId});
            lunIds.add(lunId);
        }
        return lunIds;
    }

    private List<String> getNasIdsByPo(List<ProtectObject> protectObjects) {
        ProtectObject po = protectObjects.get(0);
        ArrayList<String> nasIds = new ArrayList<String>();
        String lunId = (String)po.getProps().get("nasFsId");
        LOG.info((Object)"Get NasId: %s", new Object[]{lunId});
        nasIds.add(lunId);
        return nasIds;
    }

    private List<StorageLinkPort> getStorageLinkPorts(String providerDevSn, List<String> resourceIds, int poType) {
        int resourceType = poType == 14 ? DrmEnumDefine.ResourceTypeE.NAS.getValue() : DrmEnumDefine.ResourceTypeE.LUN.getValue();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairs = storageService.getReplicationPairsByResourceIds(providerDevSn, resourceIds, false, Integer.valueOf(resourceType));
        if (CollectionUtils.isEmpty((Collection)pairs)) {
            LOG.info((Object)"Not find pairs, try primary!");
            pairs = storageService.getReplicationPairsByResourceIds(providerDevSn, resourceIds, true, Integer.valueOf(resourceType));
        }
        ReplicationPair pair = (ReplicationPair)pairs.get(0);
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(providerDevSn);
        String srcDevSn = pair.getSrcDevSN();
        return mgr.getStorageLinkPortsByRemoteSn(providerDevSn, srcDevSn);
    }

    protected List<ProtectLocationPath> initLocalProtectLocationPath(ProtectGroup protectGroup) {
        List storageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfoList)) {
            return new ArrayList<ProtectLocationPath>();
        }
        ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)storageInfoList.iterator().next();
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List lunList = service.getStorageResourceByWwn(new String[]{info.getLunWWN()});
        ArrayList<ProtectLocationPath> localProtectionPathList = new ArrayList<ProtectLocationPath>();
        int index = 1;
        for (StorageResource storageResource : lunList) {
            ProtectLocationPath path = new ProtectLocationPath();
            path.setProtectedSiteId(protectGroup.getProductSiteId());
            path.setRecoverySiteId(protectGroup.getProductSiteId());
            int protectionLocation = DrmEnumDefine.ProtectLocation.A_A.getValue();
            if (index == 2) {
                protectionLocation = DrmEnumDefine.ProtectLocation.B_B.getValue();
            }
            path = this.buildProtectionPath(storageResource.getDevSn(), storageResource.getDevSn(), protectionLocation);
            localProtectionPathList.add(path);
            ++index;
        }
        return localProtectionPathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateProtectGroupBasicInfo(ProtectGroup protectGroup, Boolean isFromMachine) {
        ProtectGroupUtil.getInstance().validateProtectGroupObj(protectGroup);
        if (!this.checkGroupNameForUpdate(protectGroup.getUuid(), protectGroup.getName())) {
            LOG.error((Object)"Failed to update protectGroup because of duplicate group name.");
            throw new LegoCheckedException(1073947392L);
        }
        ProtectGroup oldPg = this.getProtectGroupBasicInfo(protectGroup.getUuid(), false);
        if (null == oldPg) {
            LOG.error((Object)"Failed to update protectGroup because the oldPg is null.");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkOptStatus(ProtectGroupHelper.ProtectGroupOpt.MOFIFY.getStatus(), oldPg.getStatus());
        if (!oldPg.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", oldPg.getUuid());
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("pgId", oldPg.getUuid());
            obj.put("uuid", oldPg.getUuid());
            obj.put("name", protectGroup.getName());
            obj.put("description", protectGroup.getDescription());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(oldPg.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", JSONObject.fromObject(obj).toString(), uriVariables, HttpMethod.PUT);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(oldPg.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    LOG.error((Object)"Old pgId: %s", new Object[]{oldPg.getUuid()});
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                LOG.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ");
            }
        }
        Object object = THREAD_LOCK;
        synchronized (object) {
            UpdateProtectGroupInfoTask task = new UpdateProtectGroupInfoTask((IProtectGroupBaseService)this, protectGroup);
            if (!oldPg.isPrimary() && isFromMachine.booleanValue()) {
                task.doWork();
                return -1L;
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    public long deleteProtectGroup(String protectGroupId, Boolean isFromMachine) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            LOG.error((Object)"Cannot get protectGroup");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DELETE, protectGroup);
        boolean isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByAllRp(protectGroupId);
        if (isUsedProtectGroupByRp) {
            LOG.error((Object)"ProtectGroup(%s) is used by RecoveryPlan.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948160L);
        }
        if (!protectGroup.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", protectGroup.getUuid());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(protectGroup.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", null, uriVariables, HttpMethod.DELETE);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(protectGroup.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    LOG.error((Object)"PgId: %s", new Object[]{protectGroup.getUuid()});
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                LOG.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ");
            }
        }
        DeleteProtectGroupTask task = new DeleteProtectGroupTask((IProtectGroupBaseService)this, protectGroup);
        if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
            task.setTimeout(2147483);
        }
        if (!protectGroup.isPrimary() && isFromMachine.booleanValue()) {
            task.doWork();
            return -1L;
        }
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public long exportProtectGroupByType(User user, int poType, Locale locale, boolean isExportChecked) {
        if (isExportChecked) {
            ExportProtectGroupBackTask task = new ExportProtectGroupBackTask(user, poType, locale);
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        List pgList = this.getProtectGroupByType(poType, user.getUserId(), false);
        CommUtil.checkObjectExists((Object[])new Object[]{pgList});
        ArrayList<ProtectGroup> tobeRemove = new ArrayList<ProtectGroup>();
        for (ProtectGroup protectgroup : pgList) {
            if (protectgroup.isPrimary()) continue;
            tobeRemove.add(protectgroup);
        }
        pgList.removeAll(tobeRemove);
        if (!VerifyUtil.isEmpty(tobeRemove) && VerifyUtil.isEmpty((Collection)pgList)) {
            LOG.warn((Object)"protectgroups is empty", 90160758786989L);
            throw new LegoCheckedException(1073948198L);
        }
        return 0L;
    }

    public long addProtectObjects(String protectGroupId, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            LOG.error((Object)"Failed to add ProtectObjects because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectObjectQuantity(protectObjectSet.size());
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ADD, protectGroup);
            ProtectGroupHelper.getInstance().checkAddOrRemovePoIsAvailable(protectGroup);
            HashSet logs = new HashSet(protectGroup.getPgHistoryLogs());
            ProtectGroup tempProtectGroup = (ProtectGroup)protectGroup.clone();
            tempProtectGroup.setPolist(new HashSet<ProtectObject>(protectObjectSet));
            tempProtectGroup.setOwnerId(protectObjectSet.iterator().next().getOwnerId());
            this.updateProtectObjectProperties(tempProtectGroup);
            tempProtectGroup.getPolist().addAll(protectGroup.getPolist());
            this.checkProtectObjectsInProtectGroup(tempProtectGroup);
            protectGroup.setPgHistoryLogs(logs);
            ProtectGroupHelper.getInstance().validateProtectGroupParameter(protectGroup, false);
            AddProtectObjectsBackTask task = new AddProtectObjectsBackTask(this, protectGroup, protectObjectSet);
            if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)"Error to clone ProtectGroup", (Throwable)e);
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (LegoCheckedException e1) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw e1;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public List<ProtectGroupLogDetail> queryRunningHistoryLog(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryPgRunningHistoryLog(protectGroupId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus status, String ... protectGroupIds) {
        boolean bl;
        String currentPgId = "";
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                PolicyTemplate policyTemplate;
                String protectGroupId;
                currentPgId = protectGroupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                session.beginTransaction();
                String sql = "UPDATE ti_protectgroup SET STATUS=:pgStatus WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("pgStatus", status.getStatus());
                query.setString("pgid", protectGroupId);
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 != updateResult) {
                    LOG.error((Object)"Update protectGroup status failed!");
                    throw new LegoCheckedException(-1L);
                }
                if (status.getStatus() == DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus()) {
                    this.protectionTaskService.deleteTasks(protectGroupId);
                    this.deleteSyncRateTask(protectGroupId);
                    continue;
                }
                if (status.getStatus() != DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() || VerifyUtil.isEmpty((Map)(policyTemplate = protectGroup.getTemplate()).getProps())) continue;
                List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)policyTemplate);
                this.getConfigSyncRateService().updateSyncRateTask(protectGroupId, pgsrps);
                this.getConfigSyncRateService().runAtOnce(protectGroup, pgsrps, false);
            }
            bl = true;
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Failed to update status of protectgroup(%s).", new Object[]{le, currentPgId});
                throw le;
                catch (DataAccessException e) {
                    DBOperationUtil.rollbackSession(session);
                    LOG.error((Object)"failed to update status of protectgroup(%s).", new Object[]{e, currentPgId});
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    public boolean lockProtectGroup(String ... protectGroupIds) {
        String protectGroupId = "";
        try {
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String groupId;
                protectGroupId = groupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                if (DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus() == protectGroup.getStatus()) {
                    LOG.debug((Object)"No need lock pg:%s", new Object[]{protectGroup.getName()});
                    continue;
                }
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.LOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 10);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.pauseTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
                protectGroup.setLockTime(Long.valueOf(new Date().getTime()));
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectGroup(%s) is failed to lock.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to lock."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        return true;
    }

    public boolean unlockProtectGroup(String ... protectGroupIds) {
        String protectGroupId = "";
        try {
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String groupId;
                protectGroupId = groupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UNLOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 11);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.resumeTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
                protectGroup.setLockTime(null);
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"the protectGroup(%s) is failed to unlock.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to unlock."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disableProtectGroup(String protectGroupId) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DISABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 8);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.pauseTasks(protectGroupId);
            this.deleteSyncRateTask(protectGroupId);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus());
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectGroup(%s) is failed to disable.", new Object[]{le, protectGroupId});
            this.protectionTaskService.resumeTasks(protectGroupId);
            throw le;
        }
        catch (Exception e) {
            this.protectionTaskService.resumeTasks(protectGroupId);
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to disable."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableProtectGroup(String protectGroupId) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ENABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 9);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.resumeTasks(protectGroupId);
            this.resumeSyncRateTask(protectGroup);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectgroup(%s) is failed to enable.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to enable."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    public long updateProtectGroupTemplate(String protectGroupId, Map<String, String> policyTemplateProps) {
        if (protectGroupId == null || VerifyUtil.isEmpty(policyTemplateProps)) {
            LOG.error((Object)"Param is error: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = ProtectGroupBaseServiceImpl.queryPolicyTemplateByProtectGroup((String)protectGroupId);
        Map props = template.getProps();
        props.putAll(policyTemplateProps);
        ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).filterSensitiveParam(template);
        return this.updateProtectGroupTemplate(protectGroupId, template);
    }

    private int getPoType(List<ProtectObject> pos) {
        int poType = pos.get(0).getPoType();
        if (poType == 101) {
            return 14;
        }
        if (poType == 99) {
            return 11;
        }
        return poType;
    }

    public List<ProtectObject> getProtectObjectListByRealMoUUID(List<String> moUuIds) {
        if (VerifyUtil.isEmpty(moUuIds)) {
            LOG.error((Object)"Failed to getProtectObjectListByMoUUID because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupHelper.getInstance().getProtectObjectListByRealMoUUID(moUuIds);
    }

    public List<DiskInfo> queryDiskInfo(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            LOG.error((Object)"getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)("ProtectGroup(" + protectGroup.getUuid() + ") not exist"), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryDiskInfo(protectGroup);
    }

    public List<DiskInfo> queryDiskInfo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)"Do getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, List<ProtectObject>> storagePoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, ProtectObjectStorageInfo> poStorageMap = new HashMap<String, ProtectObjectStorageInfo>();
        HashMap<String, List<RelicaStorageInfo>> storageReplicaMap = new HashMap<String, List<RelicaStorageInfo>>();
        HashMap<String, StorageResource> storageResourceMap = new HashMap<String, StorageResource>();
        this.getStorageMap(protectGroup, storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap);
        ArrayList<DiskInfo> diskInfos = new ArrayList<DiskInfo>();
        this.getDiskInfoFromPo(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
        this.getDiskInfoFromReplica(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
        this.checkLunToBeExpand(diskInfos);
        ArrayList storagePairs = new ArrayList();
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            List pairs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class);
            storagePairs.addAll(pairs);
        }
        HashMap<String, String> poolIdAndNameInfoMap = new HashMap<String, String>();
        List storagePoolInfos = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePoolInfos)) {
            for (StoragePool pool : storagePoolInfos) {
                poolIdAndNameInfoMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameInfoMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        diskInfos.stream().forEach(diskInfo -> {
            String poolId = diskInfo.getPoolId();
            if (null == poolId) {
                return;
            }
            String poolName = (String)poolIdAndNameInfoMap.get(CommUtil.combineString((String[])new String[]{diskInfo.getDevSn(), poolId}));
            if (null != poolName) {
                diskInfo.setPoolName(poolName);
            }
            this.setRecoveryPools((Map<String, String>)poolIdAndNameInfoMap, (DiskInfo)diskInfo, storagePairs, diskInfo.getDevSn(), diskInfo.getPoolId());
        });
        if (LOG.isDebugEnabled()) {
            ProtectGroupBaseServiceImpl.logDiskInfo((String)protectGroup.getName(), diskInfos);
        }
        return diskInfos;
    }

    private void setRecoveryPools(Map<String, String> poolIdAndNameMap, DiskInfo diskInfo, List<StoragePair> storagePairs, String devSn, String poolId) {
        if (VerifyUtil.isEmpty(storagePairs)) {
            return;
        }
        List recoveryStoragePairs = storagePairs.stream().filter(pair -> pair.getSrcDevSN().equals(devSn)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(recoveryStoragePairs)) {
            return;
        }
        for (StoragePair pair2 : recoveryStoragePairs) {
            Map storagePools = pair2.getStoragePools();
            String recoveryPoolId = (String)storagePools.get(poolId);
            if (VerifyUtil.isEmpty((String)recoveryPoolId)) {
                LOG.error((Object)("can not find recoveryPoolId for:" + poolId));
                continue;
            }
            DiskStoragePool diskStoragePool = new DiskStoragePool();
            diskStoragePool.setDevSn(pair2.getTgtDevSN());
            diskStoragePool.setPoolId(recoveryPoolId);
            diskStoragePool.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{diskStoragePool.getDevSn(), diskStoragePool.getPoolId()})));
            if (null != diskInfo.getRecoveryPools()) {
                diskInfo.getRecoveryPools().add(diskStoragePool);
            } else {
                diskInfo.setRecoveryPools(Arrays.asList(diskStoragePool));
            }
            this.setRecoveryPools(poolIdAndNameMap, diskInfo, storagePairs, diskStoragePool.getDevSn(), diskStoragePool.getPoolId());
        }
    }

    private void checkLunToBeExpand(List<DiskInfo> diskInfos) {
        HashMap lunInfo = new HashMap();
        diskInfos.forEach(diskInfo -> diskInfo.getSubDiskInfo().forEach(diskInfo1 -> {
            if (lunInfo.containsKey(diskInfo1.getDevSn())) {
                ((List)lunInfo.get(diskInfo1.getDevSn())).add(diskInfo1.getResourceId());
            } else {
                ArrayList<String> lunId = new ArrayList<String>();
                lunId.add(diskInfo1.getResourceId());
                lunInfo.put(diskInfo1.getDevSn(), lunId);
            }
        }));
        ArrayList lunList = new ArrayList();
        for (Map.Entry entry : lunInfo.entrySet()) {
            String devSn = (String)entry.getKey();
            List targetLuns = (List)entry.getValue();
            LOG.info((Object)String.format("query lun info devSn: %s and targetLuns : %s", devSn, targetLuns.toString()));
            List lunLists = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, targetLuns, Lun.class);
            if (lunLists.isEmpty()) continue;
            lunList.addAll(lunLists);
        }
        diskInfos.stream().filter(diskInfo -> DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())).forEach(diskInfo -> this.checkLunToBeExpandForDiskInfo(lunList, (DiskInfo)diskInfo));
    }

    private void checkLunToBeExpandForDiskInfo(List<Lun> lunList, DiskInfo diskInfo) {
        diskInfo.getSubDiskInfo().forEach(subDiskInfo -> this.checkLunToBeExpandForSubDiskInfos(lunList, diskInfo, (SubDiskInfo)subDiskInfo));
    }

    private void checkLunToBeExpandForSubDiskInfos(List<Lun> lunList, DiskInfo diskInfo, SubDiskInfo subDiskInfo) {
        lunList.forEach(lun -> this.checkLunToBeExpandForSubDiskInfo(diskInfo, subDiskInfo, (Lun)lun));
    }

    private void checkLunToBeExpandForSubDiskInfo(DiskInfo diskInfo, SubDiskInfo subDiskInfo, Lun lun) {
        if (lun.getDevSn().equals(subDiskInfo.getDevSn()) && lun.getResourceId().equals(subDiskInfo.getResourceId()) && lun.getTotalCapacity() < (double)diskInfo.getCapacity().longValue()) {
            LOG.info((Object)("Src lun id : " + diskInfo.getResourceId() + " capacity : " + diskInfo.getCapacity() + " and targetLun id : " + lun.getResourceId() + " capacity :" + lun.getTotalCapacity()));
            subDiskInfo.setCapacity(Long.valueOf(lun.getTotalCapacity().longValue()));
            subDiskInfo.setName(lun.getName());
            diskInfo.setStatus(DiskProtectStatusEnum.EXPANDED.getStatus());
        }
    }

    private void getDiskInfoFromReplica(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<RelicaStorageInfo>> entry : storageReplicaMap.entrySet()) {
            ProtectObjectStorageInfo poStorageInfo;
            String key = entry.getKey();
            if (storagePoMap.containsKey(key)) continue;
            String devSn = key.split("-")[0];
            String resourceId = key.split("-")[1];
            String deviceName = "--";
            String poolId = "--";
            String poolName = "--";
            StorageResource storageResource = storageResourceMap.get(key);
            if (null != storageResource && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                poolName = lun.getStoragePoolName();
            }
            if (null != (poStorageInfo = poStorageMap.get(key))) {
                deviceName = poStorageInfo.getDeviceName();
            }
            List<RelicaStorageInfo> list = entry.getValue();
            ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
            HashSet<String> poMoUuidSet = new HashSet<String>();
            DiskInfo diskInfo = new DiskInfo();
            for (RelicaStorageInfo relicaStorageInfo : list) {
                if (null == relicaStorageInfo.getPoReplica() || null == relicaStorageInfo.getPoReplica().getProtectObject()) {
                    LOG.error((Object)("can not find protectobject for:" + relicaStorageInfo.toJson().toString()));
                    continue;
                }
                ProtectObject po = relicaStorageInfo.getPoReplica().getProtectObject();
                if (poMoUuidSet.contains(po.getMoUuid())) continue;
                poMoUuidSet.add(po.getMoUuid());
                protectObjects.add(po);
            }
            String status = DiskProtectStatusEnum.REMOVED.getStatus();
            diskInfo.setDevSn(devSn);
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setProtectObjects(protectObjects);
            diskInfos.add(diskInfo);
        }
    }

    private void getDiskInfoFromPo(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<ProtectObject>> entry : storagePoMap.entrySet()) {
            ProtectObjectStorageInfo poStorageInfo;
            String key = entry.getKey();
            DiskInfo diskInfo = new DiskInfo();
            String devSn = key.split("-")[0];
            String resourceId = key.split("-")[1];
            String deviceName = "--";
            String poolId = "--";
            String poolName = "--";
            Long capacity = 0L;
            StorageResource storageResource = storageResourceMap.get(key);
            if (null != storageResource && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                capacity = lun.getTotalCapacity().longValue();
                poolName = lun.getStoragePoolName();
            }
            if (null != (poStorageInfo = poStorageMap.get(key))) {
                deviceName = poStorageInfo.getDeviceName();
            }
            String status = DiskProtectStatusEnum.PROTECTED.getStatus();
            if (!storageReplicaMap.containsKey(key)) {
                status = DiskProtectStatusEnum.UNPROTECTED.getStatus();
            } else {
                storageReplicaMap.get(key).forEach(relicaStorageInfo -> {
                    SubDiskInfo subDiskInfo = new SubDiskInfo();
                    subDiskInfo.setResourceId(relicaStorageInfo.getStorageId());
                    subDiskInfo.setDevSn(relicaStorageInfo.getStorageProviderSN());
                    diskInfo.getSubDiskInfo().add(subDiskInfo);
                });
            }
            diskInfo.setDevSn(devSn);
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setCapacity(capacity);
            diskInfo.setProtectObjects(entry.getValue());
            diskInfos.add(diskInfo);
        }
    }

    private void getStorageMap(ProtectGroup protectGroup, Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap) {
        HashMap deviceStorageMap = new HashMap();
        Set polist = protectGroup.getPolist();
        for (ProtectObject protectObject : polist) {
            Set set = protectObject.getUsedStorageResourceSet();
            for (Object poStorageInfo : set) {
                if (VerifyUtil.isEmpty((String)poStorageInfo.getResourceProviderSN()) || VerifyUtil.isEmpty((String)poStorageInfo.getResourceId())) continue;
                String key = CommUtil.combineString((String[])new String[]{poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId()});
                CommUtil.addToMap(storagePoMap, (String)key, (Object)protectObject);
                poStorageMap.put(key, (ProtectObjectStorageInfo)poStorageInfo);
                CommUtil.addToMap(deviceStorageMap, (String)poStorageInfo.getResourceProviderSN(), (Object)poStorageInfo.getResourceId());
            }
        }
        Set replicaList = protectGroup.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set replicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : replicas) {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo storageInfo : storageInfos) {
                    String key = CommUtil.combineString((String[])new String[]{storageInfo.getSrcStorageProviderSN(), storageInfo.getSrcStorageId()});
                    CommUtil.addToMap(storageReplicaMap, (String)key, (Object)storageInfo);
                    CommUtil.addToMap(deviceStorageMap, (String)storageInfo.getSrcStorageProviderSN(), (Object)storageInfo.getSrcStorageId());
                }
            }
        }
        for (Map.Entry entry : deviceStorageMap.entrySet()) {
            String deviceSn = (String)entry.getKey();
            List idList = (List)entry.getValue();
            List storageRes = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(deviceSn, idList, DrmEnumDefine.ResourceTypeE.LUN);
            for (StorageResource storageResource : storageRes) {
                storageResourceMap.put(CommUtil.combineString((String[])new String[]{deviceSn, storageResource.getResourceId()}), storageResource);
            }
        }
    }
}

