/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;

public class ProtectGroupSynchronizer {
    private static final Log logger = LogFactory.getInstance(ProtectGroupServiceImpl.class);
    private static final ProtectGroupSynchronizer INSTANCE = new ProtectGroupSynchronizer();

    private ProtectGroupSynchronizer() {
    }

    public static ProtectGroupSynchronizer getInstance() {
        return INSTANCE;
    }

    public String protectGroupInvokeMethod(Site site, String url, String message, Map<String, ?> uriVariables, HttpMethod method, String errorInfo) {
        RestClient client = SiteUtil.initClient((Site)site);
        try {
            String response = client.invoke(url, message, uriVariables, method);
            return response;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)this.getErrorMsg(site, errorInfo), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)this.getErrorMsg(site, errorInfo), (long)1073947440L, (String[])new String[0], (Log)logger);
            return null;
        }
    }

    private String getErrorMsg(Site site, String errorInfo) {
        String errorMsg = VerifyUtil.isEmpty((String)errorInfo) ? "sync to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error" : errorInfo;
        return errorMsg;
    }
}

