/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.subscriber;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.subscriber.AbstractExecuteSuccessSubscriber;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackupSubscriber
extends AbstractExecuteSuccessSubscriber {
    private static final Log logger = LogFactory.getInstance(BackupSubscriber.class);
    private static final int WAIT_TIME_PER_PERIOD = 1000;
    private static final int MAX_RETRY_COUNT = 5;

    public BackupSubscriber(IMessageCenter messageCenter) {
        messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    @Override
    protected void handleProtectGroup(ProtectGroup protectGroup, Map<String, Object> parameter) {
        ProtectGroupReplica replica = protectGroup.getLatestRepica();
        logger.info((Object)("replica type is" + replica.getType()));
        if (!replica.isStorageReplicationReplica()) {
            return;
        }
        if (null == parameter) {
            parameter = new HashMap<String, Object>();
        }
        if (this.isSyncAfterSyncEnabled(parameter)) {
            return;
        }
        parameter.put("REPLICA_TIMESTANP", replica.getTimeStamp());
        Integer protectedType = ProtectionJobExtendUtil.getInstance().getBackupTypeExcuteSync(parameter);
        List<Schedule> schedules = this.getSchedules(protectGroup.getTemplate(), protectedType, replica.getProtectLocation());
        StringBuilder sb = new StringBuilder();
        for (Schedule schedule : schedules) {
            logger.info((Object)("excute schedule:" + schedule.getScheduleId()));
            IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
            long taskId = service.runTask(protectGroup.getUuid(), schedule.getScheduleId(), parameter);
            sb.append(taskId).append(",");
        }
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa && !VerifyUtil.isEmpty((String)sb.toString())) {
            int length = sb.length();
            String tasks = sb.substring(0, length - 1);
            this.setTaskLinkForVasa(tasks, parameter);
        }
    }

    private void setTaskLinkForVasa(String tasks, Map<String, Object> parameter) {
        if (!VerifyUtil.isEmpty(parameter) && parameter.containsKey("MESSAGE_EXCUTE_LATEST_TASK_ID")) {
            Long taskId = (Long)parameter.get("MESSAGE_EXCUTE_LATEST_TASK_ID");
            IBackTaskService backTaskService = BackTaskHandler.getInstance().getBackTaskService();
            BackTask firstTask = this.waitTaskFinish(taskId);
            firstTask.setTaskLink(tasks);
            backTaskService.updateTask(firstTask);
            logger.info((Object)("setTaskLinkForVasa first task id:" + firstTask.getTaskId() + " set tasklink:" + tasks));
        }
    }

    private BackTask waitTaskFinish(Long taskId) {
        BackTask firstTask;
        IBackTaskService backTaskService = BackTaskHandler.getInstance().getBackTaskService();
        int retryCount = 0;
        try {
            while ((firstTask = backTaskService.readTask(taskId.longValue())).getTaskResult() == CommonConstant.BACKTASK_RESULT_PROCESS) {
                Thread.sleep(1000L);
                if (++retryCount <= 5) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"sleep is interrupt for waitTaskFinish");
            throw new LegoCheckedException(-1L);
        }
        logger.info((Object)("waitTaskFinish retryCount:" + retryCount + " taskResult:" + firstTask.getTaskResult()));
        return firstTask;
    }

    private List<Schedule> getSchedules(PolicyTemplate template, Integer protectedType, int location) {
        ArrayList<Schedule> list = new ArrayList<Schedule>();
        for (Schedule schedule : template.getSchedules()) {
            if (schedule.getProtectLocation() != location || schedule.getProtectedType() == -1 || schedule.isEnable() == null || !schedule.isEnable().booleanValue()) continue;
            if (null == protectedType) {
                if (!ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType())) continue;
                list.add(schedule);
                continue;
            }
            if (schedule.getProtectedType() != protectedType.intValue()) continue;
            list.add(schedule);
        }
        return list;
    }
}

