/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailTaskManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.replica.retention.impl.AbstractReplicaRetentionHandler;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class AntiBlackmailReplicaRetentionHandler
extends AbstractReplicaRetentionHandler {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailReplicaRetentionHandler.class);
    private static final Set<Integer> ANTI_BLACKMAIL_TEMPLATE_TYPE_SET = ImmutableSet.of((Object)46);
    private IReplicaService replicaService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeStrategy(ProtectGroup protectGroup) {
        if (protectGroup.getReplicaList().stream().noneMatch(ProtectGroupReplica::isStorageSnapshotReplica)) {
            LOGGER.debug((Object)"No replicas found in pg(name: %s).", new Object[]{protectGroup.getName()});
            return true;
        }
        LOGGER.info((Object)"Lock replicas for retention, pg name: %s.", new Object[]{protectGroup.getName()});
        Set<String> lockedReplicaIdSet = AntiBlackmailResourceLockUtil.lockReplicasInPg(protectGroup);
        try {
            ProtectGroup newProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
            newProtectGroup.getReplicaList().removeIf(replica -> !lockedReplicaIdSet.contains(replica.getId()));
            this.retentionReplicas(newProtectGroup);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)"Unlock replicas for retention, pg name: %s.", new Object[]{protectGroup.getName()});
            AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
            throw throwable;
        }
        LOGGER.info((Object)"Unlock replicas for retention, pg name: %s.", new Object[]{protectGroup.getName()});
        AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
        return true;
    }

    private void retentionReplicas(ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            LOGGER.debug((Object)"No replicas found in pg(name: %s).", new Object[]{pg.getName()});
            return;
        }
        this.syncSnapshotReplicaData(pg);
        if (this.isPMTaskToThreshold(pg.getPoProviderSN())) {
            return;
        }
        List<ProtectGroupReplica> toDeleteReplicas = this.calculateDeletingReplicas(pg);
        this.deleteReplicas(toDeleteReplicas, pg);
    }

    @Override
    public Set<String> getUsedReplicaIds(ProtectGroup pg) {
        Set replicaList = pg.getReplicaList();
        Set<String> usedReplicaIds = replicaList.stream().filter(replica -> AntiBlackMailConstant.REPLICA_DETECTION_RUNNING_STATUS_SET.contains(replica.getDetectionStatus())).map(ProtectGroupReplica::getId).collect(Collectors.toSet());
        usedReplicaIds.addAll(super.getUsedReplicaIds(pg));
        return usedReplicaIds;
    }

    @Override
    protected List<ProtectGroupReplica> getToDeleteReplicas(RetentionPolicy strategy, Schedule schedule, Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Integer differ) {
        int protectedType = schedule.getProtectedType();
        if (protectedType == ScheduleProtectedType.NAS_AIRGAP_ANTI_BLACKMAIL_SNAPSHOT.getValue()) {
            return this.getToDeleteNormalReplicas(strategy, schedule, replicas, usedReplicaIds, differ);
        }
        if (protectedType == ScheduleProtectedType.NAS_AIRGAP_ANTI_BLACKMAIL_SECURE_SNAPSHOT.getValue()) {
            return this.getToDeleteSecureReplicas(replicas, usedReplicaIds, schedule);
        }
        LOGGER.error((Object)"The policy template type doesn't match: %s.", new Object[]{String.valueOf(schedule.getPolicyTemplate().getType())});
        return new ArrayList<ProtectGroupReplica>();
    }

    @Override
    protected List<ProtectGroupReplica> handleExceedLimitReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> exceedLimitReplicas, List<ProtectGroupReplica> allReplicas) {
        ProtectGroupReplica retentionReplica = null;
        for (int i = allReplicas.size() - 1; i >= 0; --i) {
            if (allReplicas.get(i).getDetectionStatus() != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue()) continue;
            retentionReplica = allReplicas.get(i);
            break;
        }
        if (!VerifyUtil.isEmpty(retentionReplica)) {
            exceedLimitReplicas.remove(retentionReplica);
        }
        return super.handleExceedLimitReplicas(strategy, exceedLimitReplicas, allReplicas);
    }

    @Override
    protected List<ProtectGroupReplica> getToDeleteSecureReplicas(Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Schedule schedule) {
        ProtectGroupReplica latestUninfectedReplica = null;
        HashSet<ProtectGroupReplica> expiredReplicas = new HashSet<ProtectGroupReplica>();
        long currentTime = System.currentTimeMillis();
        for (ProtectGroupReplica replica : replicas) {
            if (!replica.isStorageSnapshotReplica() || replica.getType() == 11 && AntiBlackMailConstant.REPLICA_DETECTION_RUNNING_STATUS_SET.contains(replica.getDetectionStatus())) continue;
            long expiredTime = Long.parseLong(replica.getDeadlineTimeStamp());
            if (replica.getDetectionStatus() == AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue() && (latestUninfectedReplica == null || expiredTime > Long.parseLong(latestUninfectedReplica.getDeadlineTimeStamp()))) {
                latestUninfectedReplica = replica;
            }
            if (expiredTime > currentTime) continue;
            expiredReplicas.add(replica);
        }
        if (!VerifyUtil.isEmpty(latestUninfectedReplica)) {
            LOGGER.info((Object)"The latest uninfected replica of protect group(name: %s) is %s.", new Object[]{latestUninfectedReplica.getPg().getName(), latestUninfectedReplica.getName()});
            expiredReplicas.remove(latestUninfectedReplica);
        }
        ArrayList<ProtectGroupReplica> toDeleteReplicaList = new ArrayList<ProtectGroupReplica>(expiredReplicas);
        this.handleUsedReplicas(usedReplicaIds, toDeleteReplicaList);
        return toDeleteReplicaList;
    }

    public boolean checkReplicaStrategy(ProtectGroup pg) {
        int type = Optional.ofNullable(pg).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(-1);
        if (!ANTI_BLACKMAIL_TEMPLATE_TYPE_SET.contains(type)) {
            LOGGER.info((Object)"Template type not support: %s", new Object[]{String.valueOf(type)});
            return false;
        }
        return true;
    }

    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup protectGroup, int i, Integer integer, Integer integer1) {
        throw new UnsupportedOperationException();
    }

    private void syncSnapshotReplicaData(ProtectGroup protectGroup) {
        String devSn = protectGroup.getPoProviderSN();
        IStorageSnapshotScheduleManager snapshotManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, ScheduleProtectedType.SNAPSHOT.getValue());
        if (VerifyUtil.isEmpty((Object)snapshotManager)) {
            LOGGER.error((Object)"Obtain snapshot schedule manager error.");
            throw new LegoCheckedException(2117645L);
        }
        HashSet<String> storageSnapshotIds = new HashSet<String>();
        protectGroup.getTemplate().getSchedules().forEach(schedule -> {
            Set snapshotIds = snapshotManager.getProtectGroupSnapshotIds(protectGroup, devSn, schedule);
            if (!VerifyUtil.isEmpty((Collection)snapshotIds)) {
                storageSnapshotIds.addAll(snapshotIds);
            }
        });
        Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap = AntiBlackmailUtil.queryPgAntiBlackmailSnapshot(protectGroup, storageSnapshotIds);
        Set<String> currentPoIdSet = protectGroup.getPolist().stream().map(DRMObject::getUuid).collect(Collectors.toSet());
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (!replica.isStorageSnapshotReplica()) continue;
            if (!replicaSnapshotsMap.containsKey(replica.getId())) {
                AntiBlackmailUtil.dealNonExistentReplica(replica, currentPoIdSet, this.replicaService);
                continue;
            }
            AntiBlackmailUtil.refreshSinglePgReplica(replica, replicaSnapshotsMap, currentPoIdSet);
        }
    }

    private boolean isPMTaskToThreshold(String devSn) {
        AntiBlackmailPlatform platform = AntiBlackmailUtil.addAntiBlackMailPlatform(devSn);
        if (VerifyUtil.isEmpty((Object)platform)) {
            LOGGER.error((Object)"Can't find antiBlackmail platform info, dev sn: %s.", new Object[]{devSn});
            return true;
        }
        int thresholdNum = platform.getNodeNum() * 230;
        LOGGER.debug((Object)"Running task threshold: %s.", new Object[]{String.valueOf(thresholdNum)});
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(devSn);
        int runningTaskNum = taskManager.queryRunningTaskNum(devSn);
        LOGGER.debug((Object)"Running task num: %s.", new Object[]{String.valueOf(runningTaskNum)});
        if (runningTaskNum >= thresholdNum) {
            LOGGER.error((Object)"Running task num(%s) already arrived the threshold(%s).", new Object[]{runningTaskNum, thresholdNum});
            return true;
        }
        return false;
    }

    private List<ProtectGroupReplica> calculateDeletingReplicas(ProtectGroup protectGroup) {
        ArrayList<ProtectGroupReplica> toDeleteReplicas = new ArrayList<ProtectGroupReplica>();
        Set<String> usedReplicaIds = this.getUsedReplicaIds(protectGroup);
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            List<ProtectGroupReplica> tmpDelete;
            schedule.setPolicyTemplate(protectGroup.getTemplate());
            RetentionPolicy strategy = schedule.getRetentionPolicy();
            if (VerifyUtil.isEmpty((Object)strategy) || CollectionUtils.isEmpty(tmpDelete = this.getToDeleteReplicas(strategy, schedule, protectGroup.getReplicaList(), usedReplicaIds, null))) continue;
            toDeleteReplicas.addAll(tmpDelete);
        }
        return toDeleteReplicas;
    }

    @Override
    public void deleteReplicas(List<ProtectGroupReplica> toDeleteReplicas, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(toDeleteReplicas)) {
            LOGGER.error((Object)"No replicas need to delete.");
            return;
        }
        String devSn = pg.getPoProviderSN();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(devSn);
        for (ProtectGroupReplica toDeleteReplica : toDeleteReplicas) {
            this.deleteSingleReplica(toDeleteReplica, snapshotManager, devSn);
            if (!this.isPMTaskToThreshold(pg.getPoProviderSN())) continue;
            LOGGER.error((Object)"Stop delete replica for too many tasks.");
            return;
        }
    }

    private void deleteSingleReplica(ProtectGroupReplica replica, IAntiBlackmailSnapshotManager snapshotManager, String devSn) {
        LOGGER.info((Object)"Start to delete replica(name: %s).", new Object[]{replica.getName()});
        Set replicas = replica.getReplicas();
        Iterator iterator = replicas.iterator();
        boolean isSuccess = true;
        ArrayList<String> successIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)iterator.next();
            Optional storageInfoOptional = protectObjectReplica.getStorageInfos().stream().findFirst();
            if (!storageInfoOptional.isPresent()) {
                iterator.remove();
                continue;
            }
            RelicaStorageInfo storageInfo = (RelicaStorageInfo)storageInfoOptional.get();
            String snapshotId = storageInfo.getStorageId().split("@")[1];
            LOGGER.debug((Object)"Start to delete snapshot, snapshot id: %s.", new Object[]{storageInfo.getStorageId()});
            OperationResult operationResult = snapshotManager.deleteSpecificSnapshot(devSn, snapshotId);
            if (operationResult.isSuccess()) {
                iterator.remove();
                successIds.add(snapshotId);
                continue;
            }
            LOGGER.error((Object)"Deleting snapshot failed, error code: %s.", new Object[]{operationResult.getErrorCode()});
            isSuccess = false;
            break;
        }
        if (!VerifyUtil.isEmpty(successIds)) {
            AntiBlackmailUtil.buildBackTaskAndAddToCache(devSn, replica, successIds, false);
        }
        if (!isSuccess) {
            LOGGER.error((Object)"Exception encountered while deleting replica(name: %s).", new Object[]{replica.getName()});
            replica.setStatus(DrmEnumDefine.ReplicaStatus.ERROR_STATUS.getValue());
            this.replicaService.saveOrUpdateReplica(replica);
            return;
        }
        this.replicaService.deleteProtectGroupReplicaById(replica.getId());
        LOGGER.info((Object)"Delete replica(name: %s, id: %s) successfully.", new Object[]{replica.getName(), replica.getId()});
    }

    public void setReplicaService(IReplicaService replicaService) {
        this.replicaService = replicaService;
    }
}

