/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.template.service.PolicyTemplateFilterCallable;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class PolicyTemplateTools {
    private static final Log logger = LogFactory.getInstance(PolicyTemplateTools.class);
    private static PolicyTemplateTools instance = new PolicyTemplateTools();
    private static List<Integer> ingoreLocationTypeList = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_SYNC.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.VIRTUAL_REPLICATION_GATEWAY.getValue(), PolicyTemplateType.PolicyTemplateE.NAS_SNAPSHOT.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_CLONE.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_SYNC.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SYNC_REPLICATION.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_SYNC_HYPER_METRO.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_ASYNC_HYPER_METRO_RING.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_HYPERMETRO.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_VHA.getValue(), PolicyTemplateType.PolicyTemplateE.FUSIONSTORAGE_REPLICA_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING.getValue());
    private static List<Integer> taskNotimeoutTypeList = Arrays.asList(PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_SYNC.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_HYPERMETRO.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_VHA.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_ASYNC_HYPER_METRO_RING.getValue(), PolicyTemplateType.PolicyTemplateE.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING.getValue());

    public static PolicyTemplateTools getInstance() {
        return instance;
    }

    public String generateSnapshotName(String lunId) {
        String tmpName = new StringBuffer().append("RD").append("-").append(lunId).append("-").append(System.currentTimeMillis()).toString();
        return tmpName.length() > 31 ? tmpName.substring(0, 31) : tmpName;
    }

    public void checkSchedule(Schedule schedule) {
        if (1 == schedule.getScheduleMode()) {
            return;
        }
        int type = schedule.getPeriodType();
        int gap = schedule.getPeriodInterval();
        switch (type) {
            case 0: {
                this.checkBetween(gap, 5, 59);
                break;
            }
            case 1: {
                this.checkBetween(gap, 1, 23);
                break;
            }
            case 2: {
                this.checkBetween(gap, 1, 31);
                break;
            }
            case 4: {
                String[] dayOfMonth;
                String daysOfMonth = schedule.getDaysOfMonth();
                if (daysOfMonth.equalsIgnoreCase("L")) break;
                for (String day : dayOfMonth = daysOfMonth.split(",")) {
                    gap = NumberUtil.convertToInteger((Object)day);
                    this.checkBetween(gap, 1, 31);
                }
                break;
            }
        }
        this.checkGap(schedule.getStartTime(), schedule.getEndTime());
        this.checkAvaiGap(schedule.getScheduleRanges());
    }

    private void checkBetween(int val, int min, int max) {
        if (val < min || val > max) {
            logger.error((Object)("val:" + val + ", min:" + min + ", max:" + max), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkGap(String start, String end) {
        if (!(VerifyUtil.isEmpty((String)start) || VerifyUtil.isEmpty((String)end) || new Date(NumberUtil.convertToLong((Object)start)).before(new Date(NumberUtil.convertToLong((Object)end))))) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkAvaiGap(Set<ScheduleRangeTime> ranges) {
        for (ScheduleRangeTime srt : ranges) {
            if (VerifyUtil.isEmpty((Object)srt.getStartTime()) || VerifyUtil.isEmpty((Object)srt.getEndTime())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (srt.getStartTime().before(srt.getEndTime())) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<PolicyTemplate> filterAvaiableTemplate(List<ProtectObject> poList, List<PolicyTemplate> policyTemplates) {
        CountDownLatch latch = new CountDownLatch(policyTemplates.size());
        ArrayList<Future> futures = new ArrayList<Future>();
        for (PolicyTemplate policyTemplate : policyTemplates) {
            Future future = FixedProtectionThreadPool.submit((FixedProtectionThreadPool.FixedProtectionThreadPoolEnum)FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.POLICY_TEMPLATE_EXECUTOR, (Callable)new PolicyTemplateFilterCallable(poList, policyTemplate, latch));
            futures.add(future);
        }
        ArrayList<PolicyTemplate> result = new ArrayList<PolicyTemplate>();
        try {
            latch.await();
            for (Future future : futures) {
                result.add((PolicyTemplate)future.get());
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"get policy template error", (Throwable)interruptedException, 90160758786989L);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"get policy template error", (Throwable)executionException, 90160758786989L);
        }
        return result;
    }

    public boolean ingoreLocationType(int type) {
        return ingoreLocationTypeList.contains(type);
    }

    public boolean checkScheduleName(String scheduleName) {
        return !VerifyUtil.isEmpty((String)scheduleName) && scheduleName.contains(";") && scheduleName.split(";").length == 2;
    }

    public boolean isNotimeout(int type) {
        return taskNotimeoutTypeList.contains(type);
    }

    public boolean isHyperMetroTemplate(ProtectGroup pg) {
        return 25 == pg.getTemplate().getType() || this.isCshaCsdrWithinRegionRecovery(pg);
    }

    public boolean isCshaCsdrWithinRegionRecovery(ProtectGroup pg) {
        if (null != pg && !VerifyUtil.isEmpty((String)pg.getProperty("RECOVERY_REGION_TYPE"))) {
            return 37 == pg.getTemplate().getType() && "REGION_TYPE_WITHIN".equals(pg.getProperty("RECOVERY_REGION_TYPE"));
        }
        return false;
    }

    public boolean isCshaCsdrBetweenRegionRecovery(ProtectGroup pg) {
        if (null != pg && !VerifyUtil.isEmpty((String)pg.getProperty("RECOVERY_REGION_TYPE"))) {
            return 37 == pg.getTemplate().getType() && "REGION_TYPE_BETWEEN".equals(pg.getProperty("RECOVERY_REGION_TYPE"));
        }
        return false;
    }
}

